
/*---------------------------------------------------------------
  SQL DB BACKUP 02.06.2025 00:09 
  HOST: localhost
  DATABASE: asbk
  TABLES: *
  ---------------------------------------------------------------*/

/*---------------------------------------------------------------
  TABLE: `berita`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `berita`;
CREATE TABLE `berita` (
  `id_berita` int(10) NOT NULL AUTO_INCREMENT,
  `id_mapel` int(10) NOT NULL,
  `sesi` varchar(10) NOT NULL,
  `ruang` varchar(20) NOT NULL,
  `jenis` varchar(30) NOT NULL,
  `ikut` varchar(10) DEFAULT NULL,
  `susulan` varchar(10) DEFAULT NULL,
  `no_susulan` text DEFAULT NULL,
  `mulai` varchar(10) DEFAULT NULL,
  `selesai` varchar(10) DEFAULT NULL,
  `nama_proktor` varchar(50) DEFAULT NULL,
  `nip_proktor` varchar(50) DEFAULT NULL,
  `nama_pengawas` varchar(50) DEFAULT NULL,
  `nip_pengawas` varchar(50) DEFAULT NULL,
  `catatan` text DEFAULT NULL,
  `tgl_ujian` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_berita`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `file_pendukung`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `file_pendukung`;
CREATE TABLE `file_pendukung` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_mapel` int(11) DEFAULT 0,
  `nama_file` varchar(50) DEFAULT NULL,
  `status_file` int(1) DEFAULT NULL,
  PRIMARY KEY (`id_file`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
INSERT INTO `file_pendukung` VALUES   ('1','1','1550.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('2','1','7904.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('3','1','3811.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('4','1','9923.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('5','1','7549.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('6','1','7050.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('7','1','2742.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('8','1','4758.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('9','1','3014.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('10','1','8621.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('11','1','1660.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('12','1','9877.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('13','1','8124.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('14','1','4683.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('15','1','8131.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('16','1','3834.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('17','1','3775.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('18','1','3063.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('19','2','5162.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('20','2','6919.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('21','2','6026.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('22','2','6644.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('23','2','1439.jpeg',NULL);
INSERT INTO `file_pendukung` VALUES ('24','2','1840.jpeg',NULL);

/*---------------------------------------------------------------
  TABLE: `jawaban`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jawaban`;
CREATE TABLE `jawaban` (
  `id_jawaban` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `id_mapel` int(11) NOT NULL,
  `id_soal` int(11) NOT NULL,
  `id_ujian` int(11) NOT NULL,
  `jawaban` text DEFAULT NULL,
  `jawabx` char(1) DEFAULT NULL,
  `jenis` int(1) NOT NULL,
  `esai` text DEFAULT NULL,
  `nilai_esai` int(5) NOT NULL DEFAULT 0,
  `ragu` int(1) NOT NULL DEFAULT 0,
  `jawabmulti` text DEFAULT NULL,
  `jawabbs` text DEFAULT NULL,
  `jawaburut` text DEFAULT NULL,
  `bs1` varchar(5) DEFAULT NULL,
  `bs2` varchar(5) DEFAULT NULL,
  `bs3` varchar(5) DEFAULT NULL,
  `bs4` varchar(5) DEFAULT NULL,
  `bs5` varchar(5) DEFAULT NULL,
  `urut1` text DEFAULT NULL,
  `urut2` text DEFAULT NULL,
  `urut3` text DEFAULT NULL,
  `urut4` text DEFAULT NULL,
  `urut5` text DEFAULT NULL,
  PRIMARY KEY (`id_jawaban`)
) ENGINE=InnoDB AUTO_INCREMENT=70430 DEFAULT CHARSET=latin1;
INSERT INTO `jawaban` VALUES   ('3','0','0','0','0',NULL,NULL,'5',NULL,'0','0',NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `jawaban` VALUES ('51','0','0','0','0',NULL,NULL,'3',NULL,'0','0','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `jawaban` VALUES ('49927','281','1','68','29',NULL,NULL,'2','kata ga','0','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `jawaban` VALUES ('62976','429','14','130','36',NULL,NULL,'2','riba','0','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

/*---------------------------------------------------------------
  TABLE: `jawaban_pindah`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jawaban_pindah`;
CREATE TABLE `jawaban_pindah` (
  `id_jawaban` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `id_mapel` int(11) NOT NULL,
  `id_soal` int(11) NOT NULL,
  `id_ujian` int(11) NOT NULL,
  `jawaban` text DEFAULT NULL,
  `jawabx` char(1) DEFAULT NULL,
  `jenis` int(1) NOT NULL,
  `esai` text DEFAULT NULL,
  `nilai_esai` int(5) NOT NULL DEFAULT 0,
  `ragu` int(1) NOT NULL DEFAULT 0,
  `jawabmulti` text DEFAULT NULL,
  `jawabbs` text DEFAULT NULL,
  `jawaburut` text DEFAULT NULL,
  `bs1` varchar(5) DEFAULT NULL,
  `bs2` varchar(5) DEFAULT NULL,
  `bs3` varchar(5) DEFAULT NULL,
  `bs4` varchar(5) DEFAULT NULL,
  `bs5` varchar(5) DEFAULT NULL,
  `urut1` text DEFAULT NULL,
  `urut2` text DEFAULT NULL,
  `urut3` text DEFAULT NULL,
  `urut4` text DEFAULT NULL,
  `urut5` text DEFAULT NULL,
  PRIMARY KEY (`id_jawaban`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `jawaban_tugas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jawaban_tugas`;
CREATE TABLE `jawaban_tugas` (
  `id_jawaban` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) DEFAULT NULL,
  `id_tugas` int(11) DEFAULT NULL,
  `jawaban` longtext DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `tgl_dikerjakan` datetime DEFAULT NULL,
  `tgl_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `nilai` varchar(5) DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  PRIMARY KEY (`id_jawaban`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*---------------------------------------------------------------
  TABLE: `jenis`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jenis`;
CREATE TABLE `jenis` (
  `id_jenis` varchar(30) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_jenis`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `jenis` VALUES   ('ASAG','Asessmen Sumatif Akhir Genap','aktif');

/*---------------------------------------------------------------
  TABLE: `jodoh`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jodoh`;
CREATE TABLE `jodoh` (
  `id_jawaban` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) DEFAULT NULL,
  `id_mapel` int(11) NOT NULL DEFAULT 0,
  `id_soal` int(11) NOT NULL DEFAULT 0,
  `id_ujian` int(11) NOT NULL DEFAULT 0,
  `jenis` varchar(50) DEFAULT NULL,
  `jawaburut` text DEFAULT NULL,
  PRIMARY KEY (`id_jawaban`)
) ENGINE=InnoDB AUTO_INCREMENT=55571 DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `jurusan`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `jurusan`;
CREATE TABLE `jurusan` (
  `jurusan_id` varchar(25) NOT NULL,
  `nama_jurusan_sp` varchar(100) DEFAULT NULL,
  `kurikulum` varchar(120) DEFAULT NULL,
  `jurusan_sp_id` varchar(50) DEFAULT NULL,
  `kurikulum_id` varchar(20) DEFAULT NULL,
  `sekolah_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`jurusan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*---------------------------------------------------------------
  TABLE: `kelas`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `kelas`;
CREATE TABLE `kelas` (
  `id_kelas` varchar(11) NOT NULL,
  `level` varchar(20) NOT NULL,
  `nama` varchar(30) NOT NULL,
  `rombongan_belajar_id` varchar(50) DEFAULT NULL,
  `semester_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_kelas`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `kelas` VALUES   ('VII-1','VII','VII-1',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-2','VII','VII-2',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-3','VII','VII-3',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-4','VII','VII-4',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-5','VII','VII-5',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-6','VII','VII-6',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-7','VII','VII-7',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-8','VII','VII-8',NULL,NULL);
INSERT INTO `kelas` VALUES ('VII-9','VII','VII-9',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-1','VIII','VIII-1',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-2','VIII','VIII-2',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-3','VIII','VIII-3',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-4','VIII','VIII-4',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-5','VIII','VIII-5',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-6','VIII','VIII-6',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-7','VIII','VIII-7',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-8','VIII','VIII-8',NULL,NULL);
INSERT INTO `kelas` VALUES ('VIII-9','VIII','VIII-9',NULL,NULL);

/*---------------------------------------------------------------
  TABLE: `level`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `level`;
CREATE TABLE `level` (
  `kode_level` varchar(5) NOT NULL,
  `keterangan` varchar(50) NOT NULL,
  `rombongan_belajar_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`kode_level`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `level` VALUES   ('VII','VII',NULL);
INSERT INTO `level` VALUES ('VIII','VIII',NULL);

/*---------------------------------------------------------------
  TABLE: `log`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `log`;
CREATE TABLE `log` (
  `id_log` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `text` varchar(20) NOT NULL,
  `date` varchar(20) NOT NULL,
  PRIMARY KEY (`id_log`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*---------------------------------------------------------------
  TABLE: `mapel`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `mapel`;
CREATE TABLE `mapel` (
  `id_mapel` int(11) NOT NULL AUTO_INCREMENT,
  `kode` varchar(255) NOT NULL DEFAULT '0',
  `idpk` varchar(255) DEFAULT NULL,
  `idguru` varchar(3) DEFAULT NULL,
  `nama` varchar(50) DEFAULT NULL,
  `jml_soal` int(5) NOT NULL DEFAULT 0,
  `jml_esai` int(5) NOT NULL DEFAULT 0,
  `tampil_pg` int(5) NOT NULL DEFAULT 0,
  `tampil_esai` int(5) NOT NULL DEFAULT 0,
  `bobot_pg` int(5) NOT NULL DEFAULT 0,
  `bobot_esai` int(5) NOT NULL DEFAULT 0,
  `level` varchar(5) DEFAULT NULL,
  `opsi` int(1) NOT NULL DEFAULT 0,
  `kelas` varchar(255) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(2) DEFAULT NULL,
  `kkm` int(3) DEFAULT NULL,
  `soal_agama` varchar(50) DEFAULT NULL,
  `jml_multi` int(11) NOT NULL DEFAULT 0,
  `jml_bs` int(11) NOT NULL DEFAULT 0,
  `jml_urut` int(11) NOT NULL DEFAULT 0,
  `tampil_multi` int(11) NOT NULL DEFAULT 0,
  `tampil_bs` int(11) NOT NULL DEFAULT 0,
  `tampil_urut` int(11) NOT NULL DEFAULT 0,
  `bobot_multi` int(11) NOT NULL DEFAULT 0,
  `bobot_bs` int(11) NOT NULL DEFAULT 0,
  `bobot_urut` int(11) NOT NULL DEFAULT 0,
  `groupsoal` varchar(50) DEFAULT NULL,
  `pembahasan` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_mapel`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
INSERT INTO `mapel` VALUES   ('1','B.INDO7','a:1:{i:0;s:5:\"semua\";}','360','B.INDO','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 12:06:35','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('2','B.INDO8','a:1:{i:0;s:5:\"semua\";}','355','B.INDO','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:44:25','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('3','B.ING7','a:1:{i:0;s:5:\"semua\";}','361','B.ING','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:45:11','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('4','B.ING8','a:1:{i:0;s:5:\"semua\";}','365','B.ING','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:45:53','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('5','IPA7','a:1:{i:0;s:5:\"semua\";}','373','IPA','8','4','8','4','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 14:08:33','1',NULL,'','4','0','4','4','0','4','10','0','10','Numerasi','0');
INSERT INTO `mapel` VALUES ('6','IPA8','a:1:{i:0;s:5:\"semua\";}','374','IPA','6','4','6','4','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:47:07','1',NULL,'','4','0','2','4','0','2','10','0','10','Numerasi','0');
INSERT INTO `mapel` VALUES ('7','IPS7','a:1:{i:0;s:5:\"semua\";}','376','IPS','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:47:50','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('8','IPS8','a:1:{i:0;s:5:\"semua\";}','380','IPS','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:49:23','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('9','TIK7','a:1:{i:0;s:5:\"semua\";}','389','TIK','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:56:03','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('10','TIK8','a:1:{i:0;s:5:\"semua\";}','390','TIK','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:56:23','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('11','MTK7','a:1:{i:0;s:5:\"semua\";}','370','MTK','8','4','8','4','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:49:56','1',NULL,'','4','0','4','4','0','4','10','0','10','Numerasi','0');
INSERT INTO `mapel` VALUES ('12','MTK8','a:1:{i:0;s:5:\"semua\";}','368','MTK','8','4','8','4','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:50:30','1',NULL,'','4','0','4','4','0','4','10','0','10','Numerasi','0');
INSERT INTO `mapel` VALUES ('13','PAI7','a:1:{i:0;s:5:\"semua\";}','348','PAI','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:50:58','1',NULL,'ISLAM','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('14','PAI8','a:1:{i:0;s:5:\"semua\";}','347','PAI','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:51:19','1',NULL,'ISLAM','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('15','PJOK7','a:1:{i:0;s:5:\"semua\";}','382','PJOK','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 12:55:46','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('16','PJOK8','a:1:{i:0;s:5:\"semua\";}','383','PJOK','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 12:36:03','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('17','PPKn7','a:1:{i:0;s:5:\"semua\";}','352','PPKN','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:40:28','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('18','PPKn8','a:1:{i:0;s:5:\"semua\";}','351','PPKN','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:42:41','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('19','PRKY7','a:1:{i:0;s:5:\"semua\";}','387','PRKY','10','10','10','10','70','10','VII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:54:37','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');
INSERT INTO `mapel` VALUES ('20','SENBUD8','a:1:{i:0;s:5:\"semua\";}','385','SENBUD','10','10','10','10','70','10','VIII','4','a:1:{i:0;s:5:\"semua\";}','2025-05-24 10:55:06','1',NULL,'','5','0','5','5','0','5','10','0','10','Literasi','0');

/*---------------------------------------------------------------
  TABLE: `mata_pelajaran`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `mata_pelajaran`;
CREATE TABLE `mata_pelajaran` (
  `kode_mapel` varchar(20) NOT NULL,
  `nama_mapel` varchar(50) NOT NULL,
  `mata_pelajaran_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`kode_mapel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `mata_pelajaran` VALUES   ('B.INDO','BAHASA INDONESIA',NULL);
INSERT INTO `mata_pelajaran` VALUES ('B.ING','BAHASA INGGRIS',NULL);
INSERT INTO `mata_pelajaran` VALUES ('IPA','ILMU PENGETAHUAN ALAM',NULL);
INSERT INTO `mata_pelajaran` VALUES ('IPS','ILMU PENGETAHUAN SOSIAL',NULL);
INSERT INTO `mata_pelajaran` VALUES ('MTK','MATEMATIKA',NULL);
INSERT INTO `mata_pelajaran` VALUES ('PAI','PENDIDIKAN AGAMA ISLAM',NULL);
INSERT INTO `mata_pelajaran` VALUES ('PJOK','PENDIDIKAN JASMANI, OLAHRAGA DAN KESEHATAN',NULL);
INSERT INTO `mata_pelajaran` VALUES ('PPKN','PENDIDIKAN PANCASILA DAN KEWARGANEGARAAN',NULL);
INSERT INTO `mata_pelajaran` VALUES ('PRKY','PRAKARYA',NULL);
INSERT INTO `mata_pelajaran` VALUES ('SENBUD','SENI BUDAYA',NULL);
INSERT INTO `mata_pelajaran` VALUES ('TIK','INFORMATIKA',NULL);

/*---------------------------------------------------------------
  TABLE: `materi`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `materi`;
CREATE TABLE `materi` (
  `id_materi` int(255) NOT NULL AUTO_INCREMENT,
  `id_guru` int(255) NOT NULL DEFAULT 0,
  `kelas` text NOT NULL,
  `mapel` varchar(255) NOT NULL,
  `judul` varchar(50) NOT NULL,
  `materi` longtext DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `tgl_mulai` datetime NOT NULL,
  `youtube` varchar(255) DEFAULT NULL,
  `tgl` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_materi`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
INSERT INTO `materi` VALUES   ('12','1','a:1:{i:0;s:5:\"semua\";}','COVID','COVID SUDAH USAI','<p>CONTOH MATERI</p>',NULL,'2020-07-05 21:00:00','https://www.youtube.com/watch?v=0-mwwfaSD44','2020-07-05 21:10:16',NULL);
INSERT INTO `materi` VALUES ('13','1','a:1:{i:0;s:5:\"semua\";}','COVID','CONTOH LAGI','<p><iframe src=\"https://www.youtube.com/embed/0-mwwfaSD44\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>\r\n<p><a href=\"https://www.youtube.com/watch?v=0-mwwfaSD44\" target=\"_blank\" rel=\"noopener\">TONTON VIDEO</a></p>',NULL,'2020-07-05 21:00:00','','2020-07-05 21:14:56',NULL);

/*---------------------------------------------------------------
  TABLE: `menu`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `id_menu` int(11) NOT NULL AUTO_INCREMENT,
  `ujian` int(11) DEFAULT NULL,
  `ulangi` int(11) DEFAULT NULL,
  `kirim` int(11) DEFAULT NULL,
  `tarik` int(11) DEFAULT NULL,
  `soal` varchar(50) DEFAULT NULL,
  `pindah` int(11) NOT NULL,
  PRIMARY KEY (`id_menu`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
INSERT INTO `menu` VALUES   ('1','1','0','1','0','1','1');

/*---------------------------------------------------------------
  TABLE: `nilai`
  ---------------------------------------------------------------*/
DROP TABLE IF EXISTS `nilai`;
CREATE TABLE `nilai` (
  `id_nilai` int(11) NOT NULL AUTO_INCREMENT,
  `id_ujian` int(11) NOT NULL,
  `id_mapel` int(11) NOT NULL,
  `id_siswa` int(11) NOT NULL,
  `kode_ujian` varchar(30) DEFAULT NULL,
  `ujian_mulai` varchar(20) DEFAULT NULL,
  `ujian_berlangsung` varchar(20) DEFAULT NULL,
  `ujian_selesai` varchar(20) DEFAULT NULL,
  `jml_benar` int(10) DEFAULT NULL,
  `jml_salah` int(10) DEFAULT NULL,
  `nilai_esai` varchar(10) DEFAULT NULL,
  `skor` text DEFAULT NULL,
  `total` varchar(255) DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `ipaddress` varchar(20) DEFAULT NULL,
  `hasil` int(2) NOT NULL DEFAULT 0,
  `jawaban` text DEFAULT NULL,
  `jawaban_esai` longtext DEFAULT NULL,
  `nilai_esai2` text DEFAULT NULL,
  `online` int(1) NOT NULL DEFAULT 0,
  `id_soal` longtext DEFAULT NULL,
  `id_opsi` longtext DEFAULT NULL,
  `id_esai` text DEFAULT NULL,
  `blok` int(1) NOT NULL DEFAULT 0,
  `benar_esai` int(11) NOT NULL DEFAULT 0,
  `benar_multi` int(11) NOT NULL DEFAULT 0,
  `benar_bs` int(11) NOT NULL DEFAULT 0,
  `benar_urut` int(11) NOT NULL DEFAULT 0,
  `salah_esai` int(11) NOT NULL DEFAULT 0,
  `salah_multi` int(11) NOT NULL DEFAULT 0,
  `salah_bs` int(11) NOT NULL DEFAULT 0,
  `salah_urut` int(11) NOT NULL DEFAULT 0,
  `skor_esai` text DEFAULT NULL,
  `skor_multi` text DEFAULT NULL,
  `skor_bs` text DEFAULT NULL,
  `skor_urut` text DEFAULT NULL,
  `jawaban_multi` text DEFAULT NULL,
  `jawaban_bs` text DEFAULT NULL,
  `jawaban_urut` text DEFAULT NULL,
  PRIMARY KEY (`id_nilai`)
) ENGINE=InnoDB AUTO_INCREMENT=2370 DEFAULT CHARSET=latin1;
INSERT INTO `nilai` VALUES   ('24','1','17','21','ASAG','2025-05-26 07:46:33','2025-05-26 08:31:10','2025-05-26 08:31:20','7','3',NULL,'49','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:5:\"musik\";i:437;s:4:\"suku\";i:438;s:5:\"fisik\";i:439;s:6:\"pantai\";i:440;s:9:\"permainan\";i:441;s:9:\"kerjasama\";i:442;s:11:\"kebersamaan\";i:443;s:6:\"sosial\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, D\";i:141;s:4:\"A, B\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, C, D\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('25','1','17','12','ASAG','2025-05-26 07:46:43','2025-05-26 08:31:42','2025-05-26 08:31:55','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:5:\"musik\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:6:\"partai\";i:440;s:9:\"permainan\";i:441;s:12:\"gotongroyong\";i:442;s:11:\"kebersamaan\";i:443;s:6:\"sosial\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:4:\"B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, B, C\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('26','1','17','30','ASAG','2025-05-26 07:47:18','2025-05-26 08:31:53','2025-05-26 08:32:02','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:15:\"lagutradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"kesadarandiri\";i:443;s:8:\"olahhati\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('27','1','17','22','ASAG','2025-05-26 07:47:33','2025-05-26 08:32:53','2025-05-26 08:32:55','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:15:\"lagutradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"kesadarandiri\";i:443;s:8:\"olahhati\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','1','8','1','0','4','2','8','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, B, D\";i:147;s:7:\"C, B, A\";i:431;s:7:\"C, B, A\";i:432;s:7:\"B, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('28','1','17','23','ASAG','2025-05-26 07:48:00','2025-05-26 08:27:04','2025-05-26 08:31:35','8','2',NULL,'56','65',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:6:\"daerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:6:\"mainan\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:6:\"sosial\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','3','3','0','0','7','2','0','5','3','6','','0','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"B, C, D, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('29','1','17','37','ASAG','2025-05-26 07:48:04','2025-05-26 08:28:54','2025-05-26 08:30:46','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:5:\"fisik\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:8:\"menolong\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:10:\"A, B, C, D\";i:9;s:4:\"A, B\";i:141;s:4:\"A, C\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('30','1','17','31','ASAG','2025-05-26 07:48:07','2025-05-26 08:32:40','2025-05-26 08:31:45','6','4',NULL,'42','56',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:5:\"musik\";i:437;s:6:\"budaya\";i:438;s:6:\"gender\";i:439;s:5:\"hutan\";i:440;s:17:\"permainannasional\";i:441;s:9:\"kewajiban\";i:442;s:11:\"kebersamaan\";i:443;s:9:\"komutatif\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','5','10','3','0','0','0','4','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, C, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('31','1','17','5','ASAG','2025-05-26 07:48:07','2025-05-26 08:20:01','2025-05-26 08:32:38','10','0',NULL,'70','84',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:10:\"kerja sama\";i:442;s:18:\"sikaptanggungjawab\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','4','0','2','8','1','0','3','2','8','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:7:\"B, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('32','1','17','47','ASAG','2025-05-26 07:48:07','2025-05-26 08:30:06','2025-05-26 08:30:50','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"keberagamansuku\";i:436;s:6:\"budaya\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:19:\"permainantradisonal\";i:441;s:12:\"gotongroyong\";i:442;s:11:\"keberagaman\";i:443;s:7:\"pribadi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('33','1','17','32','ASAG','2025-05-26 07:48:08','2025-05-26 08:32:43','2025-05-26 08:31:46','7','3',NULL,'49','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"jender\";i:435;s:4:\"suku\";i:436;s:6:\"daerah\";i:437;s:4:\"suku\";i:438;s:6:\"jender\";i:439;s:0:\"\";i:440;s:18:\"mainantradisoilnal\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"masyarakat\";i:443;s:6:\"tenaga\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"A\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('34','1','17','13','ASAG','2025-05-26 07:48:11','2025-05-26 08:25:59','2025-05-26 08:31:58','5','5',NULL,'35','47',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:16:\"priadanperempuan\";i:435;s:8:\"individu\";i:436;s:12:\"acehproduksi\";i:437;s:6:\"sosial\";i:438;s:5:\"islam\";i:439;s:9:\"oranglain\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:9:\"kewajiban\";i:443;s:4:\"baik\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','0','5','0','1','10','0','0','4','0','10','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"A, D, C, B\";i:431;s:7:\"C, A, D\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('35','1','17','14','ASAG','2025-05-26 07:48:15','2025-05-26 08:29:53','2025-05-26 08:33:33','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:13:\"kesenianlokal\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:14:\"permainanlokal\";i:441;s:12:\"gotongroyong\";i:442;s:17:\"konflikdankerjaan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"D, A, C, B\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('36','1','17','57','ASAG','2025-05-26 07:48:15','2025-05-26 08:29:53','2025-05-26 08:31:51','9','1',NULL,'63','84',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:22:\"kekurangansatusamalain\";i:443;s:6:\"sosial\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,438,441,443,435,439,442,434,440,436,437,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('37','1','17','6','ASAG','2025-05-26 07:48:16','2025-05-26 08:33:21','2025-05-26 08:33:34','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:9:\"persatuan\";i:443;s:9:\"persatuan\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:4;N;i:9;s:1:\"B\";i:141;N;i:142;s:1:\"C\";i:145;N;}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('38','1','17','43','ASAG','2025-05-26 07:48:25','2025-05-26 08:28:15','2025-05-26 08:30:46','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:24:\"masyarakat              \";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('39','1','17','15','ASAG','2025-05-26 07:48:29','2025-05-26 08:29:36','2025-05-26 08:31:47','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:6:\"empati\";i:443;s:13:\"bantumembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"A, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('40','1','17','38','ASAG','2025-05-26 07:48:30','2025-05-26 08:31:08','2025-05-26 08:31:33','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:14:\"permainanlokal\";i:441;s:13:\"tanggungjawab\";i:442;s:6:\"tujuan\";i:443;s:9:\"komutatif\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:1:\"B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('41','1','17','24','ASAG','2025-05-26 07:48:30','2025-05-26 08:28:04','2025-05-26 08:32:05','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"D\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"tarianadat\";i:437;s:5:\"agama\";i:438;s:6:\"gender\";i:439;s:6:\"sosial\";i:440;s:13:\"permainanadat\";i:441;s:12:\"gotongroyong\";i:442;s:11:\"keberagaman\";i:443;s:17:\"keberagamangender\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('42','1','17','4','ASAG','2025-05-26 07:48:32','2025-05-26 08:31:33','2025-05-26 08:31:53','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"pesisirpantai\";i:440;s:9:\"perbedaan\";i:441;s:12:\"gotongroyong\";i:442;s:7:\"masalah\";i:443;s:12:\"kekuluargaan\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('43','1','17','10','ASAG','2025-05-26 07:48:34','2025-05-26 08:31:29','2025-05-26 08:32:11','8','2',NULL,'56','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:8:\"golongan\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"tanggungjawab\";i:443;s:8:\"keluarga\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('44','1','17','19','ASAG','2025-05-26 07:48:35','2025-05-26 08:33:14','2025-05-26 08:33:21','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:8:\"golongan\";i:436;s:8:\"laguadat\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:21:\"orangfisikyangberbeda\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:15:\"rasakebersamaan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('45','1','17','45','ASAG','2025-05-26 07:48:35','2025-05-26 08:28:28','2025-05-26 08:31:52','8','2',NULL,'56','76',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:8:\"disiplin\";i:442;s:9:\"etoskerja\";i:443;s:14:\"salingmenolong\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,438,441,443,435,439,442,434,440,436,437,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('46','1','17','36','ASAG','2025-05-26 07:48:36','2025-05-26 08:30:41','2025-05-26 08:30:59','9','1',NULL,'63','82',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:6:\"budaya\";i:437;s:6:\"sosial\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:7:\"positif\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','5','0','4','9','0','0','1','1','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('47','1','17','39','ASAG','2025-05-26 07:48:38','2025-05-26 08:26:34','2025-05-26 08:31:05','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:6:\"mainan\";i:441;s:9:\"kerjasama\";i:442;s:18:\"orangyangkesusahan\";i:443;s:9:\"komutatif\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:4:\"B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('48','1','17','53','ASAG','2025-05-26 07:48:39','2025-05-26 08:27:00','2025-05-26 08:31:00','8','2',NULL,'56','76',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:5:\"fisik\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:12:\"kekeluargaan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('49','1','17','20','ASAG','2025-05-26 07:48:39','2025-05-26 08:29:40','2025-05-26 08:31:00','9','1',NULL,'63','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:11:\"keberagaman\";i:436;s:9:\"bernyanyi\";i:437;s:5:\"agama\";i:438;s:13:\"ciriseseorang\";i:439;s:5:\"rumah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"kesulitan\";i:443;s:8:\"membantu\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,438,441,443,435,439,442,434,440,436,437,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"C, A, B, D\";i:431;s:7:\"C, A, D\";i:432;s:10:\"B, D, C, A\";i:433;s:7:\"D, C, A\";}');
INSERT INTO `nilai` VALUES ('50','1','17','56','ASAG','2025-05-26 07:48:41','2025-05-26 08:29:17','2025-05-26 08:31:02','8','2',NULL,'56','78',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:15:\"keberagamansuku\";i:436;s:14:\"lagutradisonal\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:22:\"kekurangansatusamalain\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','5','0','5','8','0','0','0','2','10','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('51','1','17','28','ASAG','2025-05-26 07:48:43','2025-05-26 08:31:24','2025-05-26 08:32:03','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:7:\"sejarah\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:13:\"suatukelompok\";i:443;s:9:\"toleransi\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('52','1','17','29','ASAG','2025-05-26 07:48:44','2025-05-26 08:28:28','2025-05-26 08:31:18','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:9:\"toleransi\";i:438;s:3:\"ras\";i:439;s:7:\"sekitar\";i:440;s:19:\"permainantradisonal\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:9:\"toleransi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','1','9','1','0','4','1','8','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"D, A, C, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('53','1','17','40','ASAG','2025-05-26 07:48:53','2025-05-26 08:27:38','2025-05-26 08:31:11','9','1',NULL,'63','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:7:\"masalah\";i:443;s:9:\"etoskerja\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, D, B, C\";i:432;s:10:\"C, B, D, A\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('54','1','17','58','ASAG','2025-05-26 07:49:03','2025-05-26 08:30:19','2025-05-26 08:32:05','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:19:\"dilingkungansekolah\";i:442;s:9:\"persatuan\";i:443;s:10:\"kerjafisik\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('55','1','17','48','ASAG','2025-05-26 07:49:04','2025-05-26 08:32:25','2025-05-26 08:32:35','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:20:\"persatuandankesatuan\";i:443;s:22:\"dilingkunganmasyarakat\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:10:\"A, B, C, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('56','1','17','1','ASAG','2025-05-26 07:49:14','2025-05-26 08:34:23','2025-05-26 08:34:32','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"musikkal\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:24:\"daratanpesisirpegunungan\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"keberagaman\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:1:\"D\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('57','1','17','46','ASAG','2025-05-26 07:49:14','2025-05-26 08:32:12','2025-05-26 08:33:17','10','0',NULL,'70','82',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:8:\"lakilaki\";i:435;s:6:\"daerah\";i:436;s:4:\"jawa\";i:437;s:4:\"suku\";i:438;s:5:\"fisik\";i:439;s:5:\"papua\";i:440;s:9:\"permainan\";i:441;s:4:\"baik\";i:442;s:12:\"gotongroyong\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','4','10','3','0','1','0','4','','8','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('58','1','17','26','ASAG','2025-05-26 07:49:17','2025-05-26 08:12:33','2025-05-26 08:11:05','7','3',NULL,'49','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"rasdansuku\";i:436;s:11:\"seni/tarian\";i:437;s:16:\"sukurasdanbudaya\";i:438;s:4:\"suku\";i:439;s:7:\"daratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:33:\"rasakehormatandansalingmenghargai\";i:443;s:7:\"positif\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,443,442,441,440,439,438,437,436,435,434,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"D, B, A, C\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"A, C, B, D\";i:433;s:7:\"D, B, C\";}');
INSERT INTO `nilai` VALUES ('59','1','17','55','ASAG','2025-05-26 07:49:17','2025-05-26 09:09:46','2025-05-26 09:09:51','0','10',NULL,'0','0',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"X\";i:2;s:1:\"X\";i:3;s:1:\"X\";i:5;s:1:\"X\";i:6;s:1:\"X\";i:7;s:1:\"X\";i:8;s:1:\"X\";i:10;s:1:\"X\";i:143;s:1:\"X\";i:144;s:1:\"X\";}','a:10:{i:434;s:11:\"Tidak Diisi\";i:435;s:11:\"Tidak Diisi\";i:436;s:11:\"Tidak Diisi\";i:437;s:11:\"Tidak Diisi\";i:438;s:11:\"Tidak Diisi\";i:439;s:11:\"Tidak Diisi\";i:440;s:11:\"Tidak Diisi\";i:441;s:11:\"Tidak Diisi\";i:442;s:11:\"Tidak Diisi\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;N;i:9;N;i:141;N;i:142;N;i:145;N;}','a:0:{}','a:5:{i:146;N;i:147;N;i:431;N;i:432;N;i:433;N;}');
INSERT INTO `nilai` VALUES ('60','1','17','18','ASAG','2025-05-26 07:49:22','2025-05-26 08:27:41','2025-05-26 08:33:36','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"wilayah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"kepedulian\";i:443;s:14:\"salingmenolong\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,438,441,443,435,439,442,434,440,436,437,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('61','1','17','27','ASAG','2025-05-26 07:49:27','2025-05-26 08:28:34','2025-05-26 08:34:05','10','0',NULL,'70','86',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:13:\"antargolongan\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:14:\"pesisirdaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:6:\"tujuan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('62','1','17','44','ASAG','2025-05-26 07:49:34','2025-05-26 08:30:34','2025-05-26 08:29:56','10','0',NULL,'70','82',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:4:\"alam\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"persatuan\";i:442;s:8:\"kesatuan\";i:443;s:9:\"toleransi\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, B, D\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('63','1','17','35','ASAG','2025-05-26 07:49:56','2025-05-26 08:29:14','2025-05-26 08:32:34','8','2',NULL,'56','76',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:14:\"tujuanyangsama\";i:443;s:12:\"gotongroyong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('64','1','17','51','ASAG','2025-05-26 07:50:25','2025-05-26 08:29:41','2025-05-26 08:31:15','8','2',NULL,'56','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:9:\"keinginan\";i:443;s:7:\"positif\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:1:\"B\";i:141;s:4:\"A, D\";i:142;s:1:\"C\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"A, B, C, D\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('65','1','17','11','ASAG','2025-05-26 07:50:26','2025-05-26 08:35:18','2025-05-26 08:35:31','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"kebudayaan\";i:436;s:8:\"kesenian\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:7:\"daratan\";i:440;s:4:\"aceh\";i:441;s:6:\"sosial\";i:442;s:8:\"kesatuan\";i:443;s:8:\"membantu\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:7:\"B, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('66','1','17','34','ASAG','2025-05-26 07:50:28','2025-05-26 08:29:59','2025-05-26 08:32:30','8','2',NULL,'56','63',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:5:\"fisik\";i:439;s:43:\"pesisirpantaipegununganperkotaandanpedesaan\";i:440;s:10:\"permainan \";i:441;s:12:\"gotongroyong\";i:442;s:14:\"tujuanyangsama\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,437,436,440,434,442,439,435,443,441,438,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"A, B, C, D\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('67','1','17','41','ASAG','2025-05-26 07:50:32','2025-05-26 08:26:17','2025-05-26 08:31:52','9','1',NULL,'63','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"salingmembantu\";i:443;s:19:\"linkunganmasyarakat\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,443,442,441,440,439,438,437,436,435,434,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"A, C\";i:141;s:4:\"A, B\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('68','1','17','52','ASAG','2025-05-26 07:50:47','2025-05-26 08:33:56','2025-05-26 08:34:12','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:4:\"suku\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:6:\"gender\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:35:\"kerjayangdilakukansecarabersamasama\";i:443;s:8:\"baikhati\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','1','5','0','2','9','0','0','3','1','10','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('69','1','17','50','ASAG','2025-05-26 07:51:03','2025-05-26 08:28:58','2025-05-26 08:32:38','7','3',NULL,'49','65',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:8:\"keunikan\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:18:\"perairandandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:18:\"nilainasionalismme\";i:443;s:6:\"empati\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,437,436,440,434,442,439,435,443,441,438,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('70','1','17','3','ASAG','2025-05-26 07:51:06','2025-05-26 08:33:53','2025-05-26 08:34:47','10','0',NULL,'70','84',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"sosialisme\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"daratan\";i:440;s:9:\"permainan\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"kerjasama\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:4;s:1:\"B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('71','1','17','9','ASAG','2025-05-26 07:51:14','2025-05-26 08:31:36','2025-05-26 08:36:15','10','0',NULL,'70','82',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"keberamanbudaya\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"floradanfauna\";i:440;s:20:\"permainantradisional\";i:441;s:33:\"tangggungjawabdilingkungansekolah\";i:442;s:21:\"pekerjaancepatselesai\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('72','1','17','49','ASAG','2025-05-26 07:51:15','2025-05-26 08:34:36','2025-05-26 08:35:16','10','0',NULL,'70','80',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:14:\"pesisirdaratan\";i:440;s:9:\"permainan\";i:441;s:9:\"kerjasama\";i:442;s:6:\"tujuan\";i:443;s:10:\"masyarakat\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','2','4','0','0','8','1','0','5','2','8','','0','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, D, C\";i:147;s:10:\"A, D, B, C\";i:431;s:10:\"D, B, A, C\";i:432;s:10:\"A, C, B, D\";i:433;s:10:\"A, C, D, B\";}');
INSERT INTO `nilai` VALUES ('73','1','17','33','ASAG','2025-05-26 07:51:23','2025-05-26 08:31:20','2025-05-26 08:33:23','9','1',NULL,'63','78',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:11:\"budayalokal\";i:436;s:8:\"kesenian\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"perpecahan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:4;s:7:\"A, C, D\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('74','1','17','25','ASAG','2025-05-26 07:51:49','2025-05-26 08:31:02','2025-05-26 08:33:35','7','3',NULL,'49','62',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:7:\"manusia\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kewajiban\";i:442;s:9:\"toleransi\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','5','0','1','9','0','0','4','1','10','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"D, C, B, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('75','1','17','42','ASAG','2025-05-26 07:51:59','2025-05-26 08:22:51','2025-05-26 08:31:24','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:20:\"persatuandankesatuan\";i:443;s:22:\"dilingkunganmasyarakat\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('76','1','17','17','ASAG','2025-05-26 07:52:13','2025-05-26 08:37:24','2025-05-26 08:37:32','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:11:\"Tidak Diisi\";i:435;s:11:\"Tidak Diisi\";i:436;s:6:\"sosial\";i:437;s:9:\"indonesia\";i:438;s:11:\"Tidak Diisi\";i:439;s:11:\"Tidak Diisi\";i:440;s:18:\"permainanjamandulu\";i:441;s:11:\"Tidak Diisi\";i:442;s:9:\"kejorokan\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,437,436,440,434,442,439,435,443,441,438,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;N;i:142;N;i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('77','1','17','8','ASAG','2025-05-26 07:53:20','2025-05-26 08:35:32','2025-05-26 08:35:52','9','1',NULL,'63','72',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"kepercayaan\";i:436;s:10:\"lagudaerah\";i:437;s:13:\"antargolongan\";i:438;s:3:\"ras\";i:439;s:23:\"pesisirpantaidandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"kepedulian\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,443,442,441,440,439,438,437,436,435,434,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:4;s:7:\"B, C, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('78','1','17','7','ASAG','2025-05-26 07:53:22','2025-05-26 08:33:31','2025-05-26 08:33:20','9','1',NULL,'63','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:10:\"sukubudaya\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:9:\"permainan\";i:441;s:11:\"bekerjasama\";i:442;s:9:\"toleransi\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('79','1','17','54','ASAG','2025-05-26 07:53:39','2025-05-26 08:28:50','2025-05-26 08:32:32','10','0',NULL,'70','86',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"kesulitan\";i:443;s:6:\"positf\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,443,442,441,440,439,438,437,436,435,434,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('80','1','17','16','ASAG','2025-05-26 07:53:40','2025-05-26 08:33:34','2025-05-26 08:33:42','4','6',NULL,'28','36',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"D\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:10:\"khasdaerah\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:4:\"khas\";i:438;s:4:\"suku\";i:439;s:7:\"sendiri\";i:440;s:8:\"sulawesi\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"keragaman\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','3','0','1','10','2','0','4','0','6','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('81','1','17','2','ASAG','2025-05-26 08:00:11','2025-05-26 08:28:50','2025-05-26 08:29:22','10','0',NULL,'70','89',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"kesetaraan gender\";i:435;s:7:\"tradisi\";i:436;s:11:\"lagu daerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:21:\"pesisir dan perkotaan\";i:440;s:21:\"permainan tradisional\";i:441;s:13:\"gotong royong\";i:442;s:9:\"persatuan\";i:443;s:10:\"masyarakat\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','5','2','0','5','5','3','0','0','5','4','','10','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('82','2','15','37','ASAG','2025-05-26 08:34:56','2025-05-26 08:53:25','2025-05-26 09:05:14','5','5',NULL,'35','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:7:\"A, B, D\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('83','2','15','35','ASAG','2025-05-26 08:34:57','2025-05-26 08:56:04','2025-05-26 09:05:12','7','3',NULL,'49','66',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:5:\"fisik\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('84','2','15','36','ASAG','2025-05-26 08:34:57','2025-05-26 09:04:50','2025-05-26 09:05:37','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','3','1','0','5','7','4','0','0','3','2','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('85','2','15','32','ASAG','2025-05-26 08:34:58','2025-05-26 09:02:27','2025-05-26 09:05:13','4','6',NULL,'28','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"D\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"irama\";i:423;s:6:\"erobix\";i:424;s:6:\"tinggi\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:3:\"6/8\";i:428;s:6:\"erobix\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','2','0','0','1','8','5','0','4','2','0','','2','a:5:{i:411;s:1:\"A\";i:412;s:1:\"D\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, A, D\";i:417;s:10:\"D, B, A, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:7:\"A, D, B\";}');
INSERT INTO `nilai` VALUES ('86','2','15','48','ASAG','2025-05-26 08:35:00','2025-05-26 09:08:28','2025-05-26 09:08:34','5','5',NULL,'35','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:1:\"6\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('87','2','15','46','ASAG','2025-05-26 08:35:00','2025-05-26 09:08:39','2025-05-26 09:08:54','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:12:\"keseimbangan\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:3:\"sel\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:7:\"gerakan\";i:429;s:5:\"kanan\";i:430;s:10:\"lingkungan\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:416;s:7:\"B, C, A\";i:417;s:10:\"D, A, B, C\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('88','2','15','53','ASAG','2025-05-26 08:35:01','2025-05-26 08:53:15','2025-05-26 09:05:11','6','4',NULL,'42','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:11:\"senam irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('89','2','15','29','ASAG','2025-05-26 08:35:04','2025-05-26 09:06:40','2025-05-26 09:06:45','4','6',NULL,'28','38',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"rill\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"lingkungan\";i:426;s:6:\"hormon\";i:427;s:1:\"8\";i:428;s:6:\"erobik\";i:429;s:8:\"belakang\";i:430;s:4:\"stik\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"D\";i:413;s:4:\"B, D\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('90','2','15','28','ASAG','2025-05-26 08:35:03','2025-05-26 09:06:24','2025-05-26 09:06:27','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:54:\"pegangtulangkeringdengankeduatanganmenujuposisijongkok\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:10:\"lingkungan\";i:426;s:6:\"hormon\";i:427;s:1:\"8\";i:428;s:7:\"latihan\";i:429;s:4:\"kiri\";i:430;s:28:\"tidakmemakaialatlatihanfisik\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','0','1','0','5','10','4','0','0','0','2','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('91','2','15','31','ASAG','2025-05-26 08:35:04','2025-05-26 09:00:35','2025-05-26 09:05:21','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:11:\"senamlantai\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:3:\"6-8\";i:428;s:12:\"latihanbadan\";i:429;s:5:\"kanan\";i:430;s:7:\"tongkat\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('92','2','15','41','ASAG','2025-05-26 08:35:04','2025-05-26 08:58:19','2025-05-26 09:05:16','4','6',NULL,'28','42',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:6:\"lambat\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,430,429,428,427,426,425,424,423,422,421,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('93','2','15','5','ASAG','2025-05-26 08:35:04','2025-05-26 08:59:31','2025-05-26 09:05:10','6','4',NULL,'42','59',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:9:\"mendorong\";i:423;s:8:\"berirama\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"lingkungan\";i:426;s:4:\"besi\";i:427;s:1:\"8\";i:428;s:6:\"ritmik\";i:429;s:5:\"kanan\";i:430;s:7:\"gerakan\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,430,429,428,427,426,425,424,423,422,421,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('94','2','15','2','ASAG','2025-05-26 08:35:06','2025-05-26 09:03:34','2025-05-26 09:05:39','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:5:\"duduk\";i:423;s:5:\"ritme\";i:424;s:4:\"gizi\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:3:\"6-8\";i:428;s:6:\"ritmik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, C\";i:414;s:1:\"B\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, C, B\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('95','2','15','39','ASAG','2025-05-26 08:35:07','2025-05-26 09:05:07','2025-05-26 09:05:17','4','6',NULL,'28','49',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"pemanasan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:4:\"A, D\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('96','2','15','27','ASAG','2025-05-26 08:35:07','2025-05-26 08:49:18','2025-05-26 09:05:13','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:7:\"aerobik\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','3','1','0','5','7','4','0','0','3','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"A, B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('97','2','15','20','ASAG','2025-05-26 08:35:10','2025-05-26 09:08:43','2025-05-26 09:09:15','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"akhir\";i:423;s:6:\"ritmik\";i:424;s:6:\"tinggi\";i:425;s:10:\"lingkungan\";i:426;s:6:\"hormon\";i:427;s:1:\"8\";i:428;s:5:\"salto\";i:429;s:7:\"samping\";i:430;s:5:\"tubuh\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"B, C, D\";i:414;s:7:\"A, B, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('98','2','15','24','ASAG','2025-05-26 08:35:11','2025-05-26 09:02:34','2025-05-26 09:05:09','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:10:\"lingkungan\";i:426;s:8:\"antibodi\";i:427;s:1:\"6\";i:428;s:6:\"ritmik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','2','0','0','4','8','5','0','1','2','0','','8','a:5:{i:411;s:1:\"A\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('99','2','15','10','ASAG','2025-05-26 08:35:11','2025-05-26 09:08:27','2025-05-26 09:08:30','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:8:\"kekuatan\";i:426;s:6:\"hormon\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','3','8','5','0','2','2','0','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"A, D, B, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('100','2','15','55','ASAG','2025-05-26 08:35:11','2025-05-26 09:09:32','2025-05-26 09:08:17','6','4',NULL,'42','61',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:3:\"sel\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('101','2','15','45','ASAG','2025-05-26 08:35:11','2025-05-26 09:02:44','2025-05-26 09:05:15','5','5',NULL,'35','50',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','1','0','5','7','4','0','0','3','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('102','2','15','30','ASAG','2025-05-26 08:35:12','2025-05-26 09:03:48','2025-05-26 09:05:12','3','7',NULL,'21','38',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:7:\"aerobic\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"berguling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('103','2','15','12','ASAG','2025-05-26 08:35:13','2025-05-26 09:08:59','2025-05-26 09:09:05','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:7:\"berdiri\";i:422;s:5:\"kanan\";i:423;s:9:\"heeltouch\";i:424;s:2:\"45\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, C\";i:414;s:4:\"B, C\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('104','2','15','19','ASAG','2025-05-26 08:35:13','2025-05-26 09:10:20','2025-05-26 09:10:25','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"akhir\";i:423;s:6:\"ricmic\";i:424;s:5:\"badan\";i:425;s:8:\"kekuatan\";i:426;s:6:\"hormon\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:7:\"A, B, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('105','2','15','51','ASAG','2025-05-26 08:35:15','2025-05-26 09:04:34','2025-05-26 09:05:38','8','2',NULL,'56','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','3','1','0','1','7','4','0','4','3','2','','2','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, C, D\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"A, B, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('106','2','15','4','ASAG','2025-05-26 08:35:16','2025-05-26 09:09:12','2025-05-26 09:09:16','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:5:\"kanan\";i:423;s:5:\"irama\";i:424;s:2:\"45\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','2','1','0','4','8','4','0','1','2','2','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('107','2','15','42','ASAG','2025-05-26 08:35:16','2025-05-26 09:05:09','2025-05-26 09:05:14','6','4',NULL,'42','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:1:\"6\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','4','8','5','0','1','2','0','','8','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, B\";i:413;s:1:\"B\";i:414;s:1:\"D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('108','2','15','57','ASAG','2025-05-26 08:35:17','2025-05-26 08:55:37','2025-05-26 09:05:07','6','4',NULL,'42','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"olahtubuh\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('109','2','15','43','ASAG','2025-05-26 08:35:17','2025-05-26 08:54:57','2025-05-26 09:20:45','0','10',NULL,'0','0',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"X\";i:402;s:1:\"X\";i:403;s:1:\"X\";i:404;s:1:\"X\";i:405;s:1:\"X\";i:406;s:1:\"X\";i:407;s:1:\"X\";i:408;s:1:\"X\";i:409;s:1:\"X\";i:410;s:1:\"X\";}','a:10:{i:421;s:11:\"Tidak Diisi\";i:422;s:11:\"Tidak Diisi\";i:423;s:11:\"Tidak Diisi\";i:424;s:11:\"Tidak Diisi\";i:425;s:11:\"Tidak Diisi\";i:426;s:11:\"Tidak Diisi\";i:427;s:11:\"Tidak Diisi\";i:428;s:11:\"Tidak Diisi\";i:429;s:11:\"Tidak Diisi\";i:430;s:11:\"Tidak Diisi\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;N;i:412;N;i:413;N;i:414;N;i:415;N;}','a:0:{}','a:5:{i:416;N;i:417;N;i:418;N;i:419;N;i:420;N;}');
INSERT INTO `nilai` VALUES ('110','2','15','47','ASAG','2025-05-26 08:35:18','2025-05-26 09:04:55','2025-05-26 09:05:19','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:6:\"matras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,430,429,428,427,426,425,424,423,422,421,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','3','0','0','4','7','5','0','1','3','0','','8','a:5:{i:411;s:1:\"C\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('111','2','15','21','ASAG','2025-05-26 08:35:20','2025-05-26 09:08:53','2025-05-26 09:08:58','8','2',NULL,'56','65',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"roling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:4:\"otot\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:7:\"jasmani\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"B, A, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"D, C, B, A\";i:420;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('112','2','15','44','ASAG','2025-05-26 08:35:20','2025-05-26 09:02:43','2025-05-26 09:05:19','5','5',NULL,'35','48',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:8:\"roldepan\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:2:\"18\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','1','0','4','7','4','0','1','3','2','','8','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:7:\"A, C, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, C, D, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('113','2','15','40','ASAG','2025-05-26 08:35:20','2025-05-26 08:55:42','2025-05-26 09:05:16','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:5:\"duduk\";i:423;s:5:\"irama\";i:424;s:4:\"gizi\";i:425;s:8:\"gangguan\";i:426;s:7:\"protein\";i:427;s:1:\"5\";i:428;s:9:\"pelatihan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:7:\"A, B, D\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('114','2','15','22','ASAG','2025-05-26 08:35:20','2025-05-26 09:12:00','2025-05-26 09:12:05','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"D\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:6:\"ritmic\";i:424;s:7:\"zatsisa\";i:425;s:7:\"protein\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:6:\"tarian\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,430,429,428,427,426,425,424,423,422,421,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','2','0','1','8','3','0','4','2','4','','2','a:5:{i:411;s:4:\"A, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"B, C, D\";i:417;s:0:\"\";i:418;s:4:\"B, C\";i:419;s:10:\"A, B, C, D\";i:420;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('115','2','15','26','ASAG','2025-05-26 08:35:21','2025-05-26 08:52:12','2025-05-26 08:52:38','6','4',NULL,'42','50',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"C\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"C\";}','a:10:{i:421;s:17:\"gerakan berguling\";i:422;s:5:\"salam\";i:423;s:6:\"tarian\";i:424;s:10:\"kecerdasan\";i:425;s:7:\"latihan\";i:426;s:8:\"zat besi\";i:427;s:9:\"7/8/9 jam\";i:428;s:15:\"senam kebugaran\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,430,429,428,427,426,425,424,423,422,421,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"A, C\";i:414;s:4:\"B, C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"A, B, D, C\";}');
INSERT INTO `nilai` VALUES ('116','2','15','38','ASAG','2025-05-26 08:35:22','2025-05-26 09:07:01','2025-05-26 09:07:05','9','1',NULL,'63','76',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:8:\"berirama\";i:424;s:4:\"anak\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:5:\"kanan\";i:430;s:4:\"pita\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('117','2','15','14','ASAG','2025-05-26 08:35:22','2025-05-26 09:06:49','2025-05-26 09:07:09','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"badan\";i:424;s:6:\"tinggi\";i:425;s:9:\"kesehatan\";i:426;s:9:\"antibiodi\";i:427;s:1:\"8\";i:428;s:6:\"ritmix\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('118','2','15','23','ASAG','2025-05-26 08:35:23','2025-05-26 08:58:28','2025-05-26 09:05:13','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:6:\"tarian\";i:429;s:5:\"kanan\";i:430;s:5:\"stick\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('119','2','15','58','ASAG','2025-05-26 08:35:24','2025-05-26 09:02:55','2025-05-26 09:05:32','8','2',NULL,'56','75',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:3:\"sel\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"tambling\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('120','2','15','7','ASAG','2025-05-26 08:35:28','2025-05-26 09:09:07','2025-05-26 09:07:35','2','8',NULL,'14','27',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:17:\"menundukkankepala\";i:423;s:7:\"aerobik\";i:424;s:4:\"gizi\";i:425;s:6:\"faktor\";i:426;s:7:\"physium\";i:427;s:1:\"8\";i:428;s:6:\"ritmix\";i:429;s:6:\"lantai\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('121','2','15','15','ASAG','2025-05-26 08:35:28','2025-05-26 09:07:23','2025-05-26 09:07:26','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"lingkungan\";i:426;s:8:\"antibodi\";i:427;s:1:\"8\";i:428;s:6:\"ritmix\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','3','2','0','3','7','3','0','2','3','4','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('122','2','15','13','ASAG','2025-05-26 08:35:29','2025-05-26 09:10:41','2025-05-26 09:11:03','2','8',NULL,'14','19',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:10:\"rolkedepan\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:14:\"kekurangangizi\";i:425;s:11:\"mentallemah\";i:426;s:8:\"seltelur\";i:427;s:4:\"8jam\";i:428;s:10:\"senamirama\";i:429;s:13:\"sampingmatras\";i:430;s:10:\"senammusik\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, C, B\";i:417;s:10:\"D, C, B, A\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('123','2','15','52','ASAG','2025-05-26 08:35:36','2025-05-26 09:03:33','2025-05-26 09:05:23','4','6',NULL,'28','42',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"handstand\";i:422;s:8:\"henstand\";i:423;s:5:\"irama\";i:424;s:7:\"masanya\";i:425;s:6:\"tinggi\";i:426;s:5:\"tubuh\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:4:\"bahu\";i:430;s:5:\"musik\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','0','2','0','5','10','3','0','0','0','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('124','2','15','56','ASAG','2025-05-26 08:35:40','2025-05-26 08:59:49','2025-05-26 09:05:07','7','3',NULL,'49','67',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:28:\"meluruskankeduatangankedepan\";i:423;s:10:\"senamirama\";i:424;s:4:\"gizi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:6:\"sprint\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('125','2','15','18','ASAG','2025-05-26 08:35:42','2025-05-26 09:00:47','2025-05-26 09:05:10','4','6',NULL,'28','38',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:18:\"merentangkantangan\";i:423;s:7:\"aerobik\";i:424;s:4:\"otak\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:4:\"yoga\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('126','2','15','34','ASAG','2025-05-26 08:35:43','2025-05-26 08:56:07','2025-05-26 09:05:42','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','4','2','0','1','6','3','0','4','4','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"C\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, C, D\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"A, B, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('127','2','15','49','ASAG','2025-05-26 08:35:50','2025-05-26 09:06:10','2025-05-26 09:06:36','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','3','0','0','3','7','5','0','2','3','0','','6','a:5:{i:411;s:1:\"C\";i:412;s:1:\"D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"D, C, B, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('128','2','15','33','ASAG','2025-05-26 08:35:53','2025-05-26 09:06:02','2025-05-26 09:06:20','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:12:\"keseimbangan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','1','0','4','7','4','0','1','3','2','','8','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('129','2','15','1','ASAG','2025-05-26 08:35:53','2025-05-26 09:09:14','2025-05-26 09:09:28','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:5:\"lilin\";i:422;s:5:\"duduk\";i:423;s:6:\"lantai\";i:424;s:4:\"baik\";i:425;s:7:\"jasmani\";i:426;s:7:\"zatsisa\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, D, C\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('130','2','15','50','ASAG','2025-05-26 08:35:53','2025-05-26 09:01:10','2025-05-26 09:05:38','5','5',NULL,'35','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:5:\"badan\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('131','2','15','6','ASAG','2025-05-26 08:35:56','2025-05-26 09:10:20','2025-05-26 09:10:50','5','5',NULL,'35','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:10:\"senamirama\";i:424;s:5:\"tubuh\";i:425;s:10:\"lingkungan\";i:426;s:9:\"antibiodi\";i:427;s:1:\"9\";i:428;s:6:\"ritmik\";i:429;s:5:\"kanan\";i:430;s:19:\"senam seperti lilin\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('132','2','15','25','ASAG','2025-05-26 08:35:56','2025-05-26 09:08:41','2025-05-26 09:09:17','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:10:\"lingkungan\";i:426;s:5:\"telur\";i:427;s:1:\"8\";i:428;s:12:\"keseimbangan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('133','2','15','3','ASAG','2025-05-26 08:36:02','2025-05-26 08:59:44','2025-05-26 09:06:10','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:5:\"badan\";i:426;s:5:\"darah\";i:427;s:1:\"8\";i:428;s:12:\"keseimbangan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('134','2','15','54','ASAG','2025-05-26 08:36:03','2025-05-26 08:56:57','2025-05-26 09:05:13','6','4',NULL,'42','56',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:7:\"kondisi\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"C\";i:413;s:4:\"A, B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('135','2','15','11','ASAG','2025-05-26 08:36:04','2025-05-26 09:05:29','2025-05-26 09:06:07','6','4',NULL,'42','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:9:\"menyentuh\";i:423;s:6:\"lantai\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:3:\"6-8\";i:428;s:12:\"keseimbangan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,430,429,428,427,426,425,424,423,422,421,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('136','2','15','16','ASAG','2025-05-26 08:36:06','2025-05-26 09:00:55','2025-05-26 09:05:12','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:12:\"keseimbangan\";i:423;s:6:\"lantai\";i:424;s:10:\"kecerdasan\";i:425;s:7:\"manusia\";i:426;s:4:\"cair\";i:427;s:2:\"10\";i:428;s:13:\"senamberirama\";i:429;s:5:\"kanan\";i:430;s:5:\"musik\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, B\";i:413;s:1:\"A\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('137','2','15','8','ASAG','2025-05-26 08:36:08','2025-05-26 09:07:04','2025-05-26 09:07:24','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:6:\"tarian\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:9:\"kesehatan\";i:427;s:4:\"8-12\";i:428;s:10:\"kelenturan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('138','2','15','9','ASAG','2025-05-26 08:36:45','2025-05-26 09:00:25','2025-05-26 09:05:16','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:25:\"duduktanganmenyentuhlutut\";i:423;s:10:\"senamirama\";i:424;s:11:\"tinggibadan\";i:425;s:8:\"kekuatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"senamotot\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:1:\"B\";i:412;s:1:\"B\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('139','2','15','17','ASAG','2025-05-26 08:38:45','2025-05-26 09:06:51','2025-05-26 09:07:31','3','7',NULL,'21','26',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:5:\"lilin\";i:423;s:6:\"matras\";i:424;s:6:\"tinggi\";i:425;s:4:\"anak\";i:426;s:4:\"sisa\";i:427;s:4:\"5jam\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"C, B, D, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('140','3','17','89','ASAG','2025-05-26 09:23:14','2025-05-26 09:51:06','2025-05-26 09:51:32','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"keragaman\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:34:\"daratandanlautansertafloradanfauna\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:36:\"kekurangandankelebihansetiapindividu\";i:443;s:9:\"kerjasama\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"A, B\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('141','3','17','94','ASAG','2025-05-26 09:25:35','2025-05-26 10:02:21','2025-05-26 10:06:11','10','0',NULL,'70','86',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:8:\"laguaceh\";i:437;s:6:\"budaya\";i:438;s:4:\"suku\";i:439;s:13:\"floradanfauna\";i:440;s:7:\"tradisi\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,443,442,441,440,439,438,437,436,435,434,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','4','0','4','10','1','0','1','0','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('142','3','17','95','ASAG','2025-05-26 09:25:58','2025-05-26 10:04:59','2025-05-26 10:06:25','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:28:\"kelaminwanitakelaminlakilaki\";i:435;s:23:\"mengejekkebudayaanorang\";i:436;s:6:\"sosial\";i:437;s:6:\"bangsa\";i:438;s:12:\"adatatausuku\";i:439;s:16:\"kawasanyangramah\";i:440;s:9:\"permainan\";i:441;s:8:\"haksiswa\";i:442;s:10:\"gotoroyong\";i:443;s:31:\"membantutetanggaacarapernikahan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','1','0','2','10','4','0','3','0','2','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, B, D\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, B, C\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('143','3','17','104','ASAG','2025-05-26 09:26:10','2025-05-26 10:03:02','2025-05-26 10:07:35','7','3',NULL,'49','63',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:7:\"konflik\";i:436;s:8:\"nasional\";i:437;s:17:\"bhenikatunggalika\";i:438;s:3:\"ras\";i:439;s:15:\"lingkunganrumah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"tanggungjawab\";i:443;s:6:\"sosial\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,437,436,440,434,442,439,435,443,441,438,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('144','3','17','72','ASAG','2025-05-26 09:26:18','2025-05-26 10:05:49','2025-05-26 10:06:37','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"C\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"adat\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:7:\"daratan\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:6:\"masala\";i:443;s:8:\"kebaikan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('145','3','17','77','ASAG','2025-05-26 09:26:19','2025-05-26 09:59:40','2025-05-26 10:07:07','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"suku\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:4:\"suku\";i:441;s:13:\"tamggungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:6:\"sosial\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','3','1','0','2','7','4','0','3','3','2','','4','a:5:{i:4;s:4:\"B, C\";i:9;s:1:\"B\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('146','3','17','100','ASAG','2025-05-26 09:26:19','2025-05-26 10:10:48','2025-05-26 10:11:21','10','0',NULL,'70','91',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:15:\"keragamangender\";i:435;s:16:\"keberagaman suku\";i:436;s:6:\"daerah\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:23:\"lingkungantidakbernyawa\";i:440;s:20:\"permainantradisional\";i:441;s:15:\"bergotongroyong\";i:442;s:20:\"perilakugotongroyong\";i:443;s:10:\"masyarakat\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','5','0','5','9','0','0','0','1','10','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('147','3','17','73','ASAG','2025-05-26 09:26:20','2025-05-26 10:07:04','2025-05-26 10:07:34','8','2',NULL,'56','67',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"adat\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:7:\"daratan\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:7:\"masalah\";i:443;s:8:\"kebaikan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, B, A, D\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('148','3','17','97','ASAG','2025-05-26 09:26:21','2025-05-26 10:06:56','2025-05-26 10:07:21','5','5',NULL,'35','39',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"D\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"toleransi\";i:436;s:9:\"persatuan\";i:437;s:4:\"suku\";i:438;s:4:\"suku\";i:439;s:9:\"perkotaan\";i:440;s:15:\"daerahindonesia\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"keyakinan\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, B, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, C, A\";i:147;s:10:\"A, C, B, D\";i:431;s:10:\"A, B, D, C\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('149','3','17','60','ASAG','2025-05-26 09:26:21','2025-05-26 10:05:11','2025-05-26 10:06:55','9','1',NULL,'63','81',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:11:\"keberagaman\";i:443;s:8:\"olahhati\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,437,436,440,434,442,439,435,443,441,438,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('150','3','17','80','ASAG','2025-05-26 09:26:21','2025-05-26 10:06:54','2025-05-26 10:06:59','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:10:\"cowokcewek\";i:435;s:5:\"lokal\";i:436;s:4:\"aceh\";i:437;s:7:\"sekitar\";i:438;s:7:\"manusia\";i:439;s:7:\"manusia\";i:440;s:22:\"permainanteradisisonal\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"masyarakat\";i:443;s:9:\"persatuan\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','0','1','0','2','10','4','0','3','0','2','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, C, D\";i:141;s:4:\"A, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:10:\"A, D, B, C\";i:431;s:10:\"A, D, B, C\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('151','3','17','69','ASAG','2025-05-26 09:26:22','2025-05-26 10:05:37','2025-05-26 10:06:59','10','0',NULL,'70','92',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"seni\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:14:\"tujuanyangsama\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,443,442,441,440,439,438,437,436,435,434,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','5','0','5','8','0','0','0','2','10','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('152','3','17','81','ASAG','2025-05-26 09:26:22','2025-05-26 10:00:46','2025-05-26 10:06:02','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"daratan\";i:440;s:9:\"permainan\";i:441;s:9:\"kerjasama\";i:442;s:5:\"tugas\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('153','3','17','59','ASAG','2025-05-26 09:26:22','2025-05-26 10:08:59','2025-05-26 10:09:04','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('154','3','17','79','ASAG','2025-05-26 09:26:22','2025-05-26 10:08:02','2025-05-26 10:08:24','5','5',NULL,'35','35',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:28:\"salingmenghargaibudayasesama\";i:435;s:30:\"bahasadankebudayaanyangberbeda\";i:436;s:15:\"sosialindonesia\";i:437;s:23:\"persatuandankeberagaman\";i:438;s:17:\"budayamasigmasing\";i:439;s:20:\"keberagamandansosial\";i:440;s:20:\"permainantradisional\";i:441;s:20:\"kebaikandankewajiban\";i:442;s:21:\"kebudayandankeindahan\";i:443;s:24:\"baikdankeberagamansosial\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, C\";i:141;s:4:\"A, C\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"B, C, D, A\";i:431;s:4:\"A, B\";i:432;s:10:\"A, B, D, C\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('155','3','17','90','ASAG','2025-05-26 09:26:23','2025-05-26 10:11:27','2025-05-26 10:11:45','5','5',NULL,'35','39',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:19:\"masyarakatnttdanntb\";i:436;s:4:\"aceh\";i:437;s:17:\"keberagamangender\";i:438;s:18:\"keberagamankelamin\";i:439;s:9:\"indonesia\";i:440;s:14:\"zaman ke zaman\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"peristiwa\";i:443;s:4:\"baik\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;N;i:147;N;i:431;N;i:432;s:4:\"B, C\";i:433;N;}');
INSERT INTO `nilai` VALUES ('156','3','17','63','ASAG','2025-05-26 09:26:23','2025-05-26 10:06:52','2025-05-26 10:08:15','6','4',NULL,'42','50',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:11:\"kemanusiaan\";i:435;s:3:\"ras\";i:436;s:6:\"sosial\";i:437;s:10:\"sukubangsa\";i:438;s:11:\"kemanusiaan\";i:439;s:6:\"daerah\";i:440;s:20:\"permainantradisional\";i:441;s:11:\"keberagaman\";i:442;s:11:\"kemanusiaan\";i:443;s:4:\"baik\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:4:\"A, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('157','3','17','62','ASAG','2025-05-26 09:26:24','2025-05-26 10:07:04','2025-05-26 10:07:43','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"seni\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"daratandanpesisir\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:14:\"salingmembantu\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('158','3','17','64','ASAG','2025-05-26 09:26:24','2025-05-26 10:09:56','2025-05-26 10:10:38','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:11:\"kemanusiaan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('159','3','17','86','ASAG','2025-05-26 09:26:25','2025-05-26 10:11:07','2025-05-26 10:11:44','6','4',NULL,'42','47',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"D\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:20:\"rasatauantargolongan\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:20:\"rasatauantargolongan\";i:439;s:6:\"budaya\";i:440;s:7:\"tradisi\";i:441;s:13:\"tanggungjawab\";i:442;s:17:\"keberagamanbudaya\";i:443;s:15:\"lingkunganfisik\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, C, A\";i:147;s:7:\"D, B, C\";i:431;s:10:\"B, C, A, D\";i:432;s:7:\"B, C, D\";i:433;s:1:\"C\";}');
INSERT INTO `nilai` VALUES ('160','3','17','71','ASAG','2025-05-26 09:26:25','2025-05-26 10:02:00','2025-05-26 10:05:52','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:3:\"ras\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:17:\"rasatanggungjawab\";i:443;s:12:\"sukamembantu\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, B, C\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('161','3','17','70','ASAG','2025-05-26 09:26:25','2025-05-26 10:04:11','2025-05-26 10:05:59','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:6:\"budaya\";i:439;s:17:\"pesisirdandaratan\";i:440;s:17:\"mainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"etoskerja\";i:443;s:6:\"sosial\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('162','3','17','113','ASAG','2025-05-26 09:26:26','2025-05-26 10:03:54','2025-05-26 10:06:50','8','2',NULL,'56','72',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:13:\"floradanfauna\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:16:\"lingkungansosial\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('163','3','17','105','ASAG','2025-05-26 09:26:26','2025-05-26 10:10:51','2025-05-26 10:11:50','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:13:\"budayasendiri\";i:436;s:5:\"musik\";i:437;s:6:\"sosial\";i:438;s:3:\"ras\";i:439;s:20:\"sekitartempattinggal\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"parsatuandankesatuan\";i:443;s:8:\"baikhati\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','1','9','1','0','4','1','8','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, C, A\";i:433;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('164','3','17','98','ASAG','2025-05-26 09:26:26','2025-05-26 10:05:34','2025-05-26 10:06:40','9','1',NULL,'63','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"kepercyaan\";i:436;s:6:\"menari\";i:437;s:5:\"agama\";i:438;s:9:\"keturunan\";i:439;s:11:\"budayalokal\";i:440;s:6:\"budaya\";i:441;s:9:\"kerjasama\";i:442;s:18:\"rasatolongmenolong\";i:443;s:14:\"menolongsesama\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,443,442,441,440,439,438,437,436,435,434,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:7:\"B, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('165','3','17','87','ASAG','2025-05-26 09:26:27','2025-05-26 10:00:43','2025-05-26 10:07:24','4','6',NULL,'28','32',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"wanita\";i:435;s:8:\"sulawesi\";i:436;s:6:\"sosial\";i:437;s:6:\"sosial\";i:438;s:9:\"palembang\";i:439;s:7:\"situasi\";i:440;s:4:\"aceh\";i:441;s:7:\"sendiri\";i:442;s:11:\"adanyakerja\";i:443;s:20:\"membersihkanrumahnya\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, B, C\";i:147;s:10:\"A, C, B, D\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('166','3','17','115','ASAG','2025-05-26 09:26:28','2025-05-26 10:06:01','2025-05-26 10:06:29','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:10:\"masyarakat\";i:435;s:9:\"perbedaan\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:20:\"persatuandankesatuan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('167','3','17','106','ASAG','2025-05-26 09:26:28','2025-05-26 10:02:41','2025-05-26 10:03:02','9','1',NULL,'63','78',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:7:\"manusia\";i:440;s:20:\"permainantradisional\";i:441;s:15:\"bertangungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"B, C, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"B, C, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('168','3','17','114','ASAG','2025-05-26 09:26:29','2025-05-26 10:08:39','2025-05-26 10:09:10','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:13:\"antargolongan\";i:436;s:12:\"tradisilokal\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"floradanfauna\";i:440;s:12:\"tradisilokal\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:8:\"kesatuan\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('169','3','17','68','ASAG','2025-05-26 09:26:29','2025-05-26 10:07:24','2025-05-26 10:07:41','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:9:\"perbedaan\";i:436;s:5:\"musik\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:4:\"aceh\";i:441;s:4:\"baik\";i:442;s:9:\"kewajiban\";i:443;s:6:\"sosial\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('170','3','17','110','ASAG','2025-05-26 09:26:30','2025-05-26 10:03:24','2025-05-26 10:04:09','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:15:\"keragamangender\";i:435;s:3:\"ras\";i:436;s:10:\"lagudaerah\";i:437;s:14:\"keragamanagama\";i:438;s:12:\"keragamanras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:15:\"keragamanbudaya\";i:441;s:9:\"kewajiban\";i:442;s:15:\"rasakebersamaan\";i:443;s:15:\"rasakebersamaan\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','0','3','0','5','10','2','0','0','0','6','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('171','3','17','78','ASAG','2025-05-26 09:26:30','2025-05-26 10:09:56','2025-05-26 10:10:22','5','5',NULL,'35','48',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"laguaceh\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:9:\"permainan\";i:441;s:11:\"kebersamaan\";i:442;s:23:\"kebersamaandankeyakinan\";i:443;s:16:\"lingkungansosial\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','1','4','0','2','9','1','0','3','1','8','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"A\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, B, C\";i:147;s:10:\"A, D, B, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('172','3','17','96','ASAG','2025-05-26 09:26:31','2025-05-26 10:07:06','2025-05-26 10:08:32','4','6',NULL,'28','30',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"D\";i:144;s:1:\"C\";}','a:10:{i:434;s:31:\"merupakanyangberagamansukudaera\";i:435;s:19:\"perbedaansukudaerah\";i:436;s:11:\"acehselatan\";i:437;s:46:\"masyarakatyangdiakuiolehseluruhdaerahkeragaman\";i:438;s:12:\"sukuataujawa\";i:439;s:18:\"daerahsumatrabarat\";i:440;s:17:\"permainananakanak\";i:441;s:10:\"kebersihan\";i:442;s:18:\"persatuankerayatan\";i:443;s:23:\"membantudangotongroyong\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:1:\"D\";i:9;s:1:\"B\";i:141;s:1:\"B\";i:142;s:1:\"A\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, A, C, B\";}');
INSERT INTO `nilai` VALUES ('173','3','17','88','ASAG','2025-05-26 09:26:32','2025-05-26 10:09:59','2025-05-26 10:11:50','9','1',NULL,'63','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:13:\"antargolongan\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tujuanyangsama\";i:443;s:14:\"salingmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"A, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, D, A, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('174','3','17','61','ASAG','2025-05-26 09:26:32','2025-05-26 10:05:04','2025-05-26 10:06:56','9','1',NULL,'63','78',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"situslokal\";i:436;s:15:\"lagutradisional\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"perbedaan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('175','3','17','91','ASAG','2025-05-26 09:26:33','2025-05-26 10:04:52','2025-05-26 10:06:54','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:14:\"daratanpesisir\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:11:\"kekompakkan\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,438,441,443,435,439,442,434,440,436,437,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('176','3','17','108','ASAG','2025-05-26 09:26:34','2025-05-26 09:48:45','2025-05-26 09:51:06','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"tempattinggal\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"kesadaran\";i:443;s:9:\"komukatif\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('177','3','17','101','ASAG','2025-05-26 09:26:35','2025-05-26 10:10:55','2025-05-26 10:11:02','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:15:\"lagutradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:23:\"lingkunganfloradanfauna\";i:440;s:20:\"permainantradisional\";i:441;s:5:\"jujur\";i:442;s:30:\"sesuatuyangberketujuanyangsama\";i:443;s:23:\"kerjasamasalingmembantu\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','2','0','0','3','8','5','0','2','2','0','','6','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"A\";i:142;s:1:\"C\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('178','3','17','83','ASAG','2025-05-26 09:26:35','2025-05-26 09:59:58','2025-05-26 10:08:03','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:9:\"toleransi\";i:435;s:9:\"toleransi\";i:436;s:5:\"musik\";i:437;s:6:\"budaya\";i:438;s:5:\"papua\";i:439;s:5:\"hidup\";i:440;s:9:\"permainan\";i:441;s:4:\"baik\";i:442;s:16:\"binekatunggalika\";i:443;s:8:\"membantu\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','0','4','0','3','10','1','0','2','0','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('179','3','17','82','ASAG','2025-05-26 09:26:35','2025-05-26 10:04:06','2025-05-26 10:06:45','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"perbedaan\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"B, C\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('180','3','17','67','ASAG','2025-05-26 09:26:37','2025-05-26 10:06:15','2025-05-26 10:08:49','4','6',NULL,'28','30',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"C\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:3:\"ras\";i:436;s:4:\"aceh\";i:437;s:4:\"aceh\";i:438;s:15:\"keberagamatubuh\";i:439;s:6:\"daerah\";i:440;s:13:\"permainanadat\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:12:\"bersihbersih\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,437,436,440,434,442,439,435,443,441,438,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:7:\"B, C, D\";i:142;s:7:\"A, B, C\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, D, C\";i:147;s:10:\"D, C, A, B\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"D, C, B, A\";i:433;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('181','3','17','74','ASAG','2025-05-26 09:26:38','2025-05-26 10:11:45','2025-05-26 10:11:58','6','4',NULL,'42','52',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:10:\"pernikahan\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:9:\"kerjasama\";i:438;s:6:\"jender\";i:439;s:6:\"bersih\";i:440;s:9:\"permainan\";i:441;s:7:\"mandiri\";i:442;s:8:\"kesatuan\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','4','0','1','10','1','0','4','0','8','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"B, C, D, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('182','3','17','75','ASAG','2025-05-26 09:26:39','2025-05-26 10:08:16','2025-05-26 10:08:36','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:8:\"kebudaya\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:5:\"hutan\";i:440;s:11:\"kebersamaan\";i:441;s:11:\"tanggujawab\";i:442;s:11:\"kebersamaan\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('183','3','17','112','ASAG','2025-05-26 09:26:40','2025-05-26 10:05:48','2025-05-26 10:06:17','6','4',NULL,'42','44',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"D\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:16:\"lakidanperempuan\";i:435;s:9:\"toleransi\";i:436;s:4:\"aceh\";i:437;s:6:\"budaya\";i:438;s:5:\"tubuh\";i:439;s:11:\"llingkungan\";i:440;s:11:\"mainanjadul\";i:441;s:9:\"kewajiban\";i:442;s:11:\"keberagaman\";i:443;s:13:\"tanggungjawab\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:7:\"D, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('184','3','17','92','ASAG','2025-05-26 09:26:42','2025-05-26 10:08:36','2025-05-26 10:09:42','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"C\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"disekolah\";i:442;s:9:\"perbedaan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('185','3','17','66','ASAG','2025-05-26 09:26:45','2025-05-26 10:07:28','2025-05-26 10:08:49','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:6:\"tarian\";i:437;s:6:\"sosial\";i:438;s:4:\"suku\";i:439;s:7:\"pesisir\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:11:\"keberagaman\";i:443;s:11:\"keberagaman\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','4','10','3','0','1','0','4','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, D\";i:141;s:7:\"A, C, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('186','3','17','84','ASAG','2025-05-26 09:26:46','2025-05-26 10:05:04','2025-05-26 10:07:35','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:7:\"sombong\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"toleransi\";i:443;s:11:\"bekerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, B, C\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('187','3','17','109','ASAG','2025-05-26 09:26:48','2025-05-26 10:03:46','2025-05-26 10:04:09','8','2',NULL,'56','69',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"keberagamansuku\";i:436;s:4:\"lagu\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:15:\"rasakebersamaan\";i:443;s:6:\"sosial\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('188','3','17','107','ASAG','2025-05-26 09:26:49','2025-05-26 10:01:26','2025-05-26 10:01:43','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:4:\"suku\";i:435;s:14:\"bedasukudanras\";i:436;s:13:\"acaraadataceh\";i:437;s:37:\"masyarakatmemilikikeberagamanyangsama\";i:438;s:10:\"sukubangsa\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainanzamandahulu\";i:441;s:20:\"yangbertanggungjawab\";i:442;s:19:\"gotongroyongbersama\";i:443;s:18:\"tidakbermasyarakat\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,437,436,440,434,442,439,435,443,441,438,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','3','0','2','10','2','0','3','0','6','','4','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"A, C, B, D\";i:431;s:10:\"B, A, D, C\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('189','3','17','85','ASAG','2025-05-26 09:26:55','2025-05-26 10:12:06','2025-05-26 10:12:18','0','10',NULL,'0','0',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"X\";i:2;s:1:\"X\";i:3;s:1:\"X\";i:5;s:1:\"X\";i:6;s:1:\"X\";i:7;s:1:\"X\";i:8;s:1:\"X\";i:10;s:1:\"X\";i:143;s:1:\"X\";i:144;s:1:\"X\";}','a:10:{i:434;s:11:\"Tidak Diisi\";i:435;s:11:\"Tidak Diisi\";i:436;s:11:\"Tidak Diisi\";i:437;s:11:\"Tidak Diisi\";i:438;s:11:\"Tidak Diisi\";i:439;s:11:\"Tidak Diisi\";i:440;s:11:\"Tidak Diisi\";i:441;s:11:\"Tidak Diisi\";i:442;s:11:\"Tidak Diisi\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;N;i:9;N;i:141;N;i:142;N;i:145;N;}','a:0:{}','a:5:{i:146;N;i:147;N;i:431;N;i:432;N;i:433;N;}');
INSERT INTO `nilai` VALUES ('190','3','17','116','ASAG','2025-05-26 09:26:58','2025-05-26 10:01:31','2025-05-26 10:07:11','7','3',NULL,'49','52',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"B\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:10:\"sukudaerah\";i:435;s:17:\"berbedadenganlain\";i:436;s:9:\"lagumusik\";i:437;s:20:\"sukubangsasukudaerah\";i:438;s:23:\"sukudaerahtempattinggal\";i:439;s:9:\"berbahaya\";i:440;s:9:\"permainan\";i:441;s:16:\"bertanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:6:\"sosial\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,437,436,440,434,442,439,435,443,441,438,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, B, D\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('191','3','17','93','ASAG','2025-05-26 09:26:59','2025-05-26 10:08:58','2025-05-26 10:09:12','5','5',NULL,'35','42',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"budaya\";i:435;s:7:\"sombong\";i:436;s:4:\"aceh\";i:437;s:13:\"masing-masing\";i:438;s:13:\"masing-masing\";i:439;s:19:\"pesisir dan daratan\";i:440;s:9:\"permainan\";i:441;s:14:\"tanggung jawab\";i:442;s:12:\"gotongroyong\";i:443;s:15:\"saling membantu\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"A, D\";i:141;s:4:\"B, D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('192','3','17','99','ASAG','2025-05-26 09:27:53','2025-05-26 09:57:35','2025-05-26 10:07:31','9','1',NULL,'63','84',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"fauna\";i:437;s:5:\"agama\";i:438;s:13:\"antargolongan\";i:439;s:13:\"tidakbernyawa\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:12:\"gotongroyong\";i:443;s:5:\"wajib\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','5','0','5','9','0','0','0','1','10','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('193','3','17','111','ASAG','2025-05-26 09:28:35','2025-05-26 09:59:51','2025-05-26 10:00:13','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"A\";}','a:10:{i:434;s:4:\"suku\";i:435;s:11:\"adatdansuku\";i:436;s:4:\"aceh\";i:437;s:12:\"masingmasing\";i:438;s:6:\"hayati\";i:439;s:26:\"lingkunganyangkitatinggali\";i:440;s:10:\"petakumpet\";i:441;s:9:\"kewajiban\";i:442;s:21:\"kelingkunganyangdamai\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:7:\"A, B, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"D, A, B, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('194','3','17','102','ASAG','2025-05-26 09:29:19','2025-05-26 10:05:01','2025-05-26 10:09:44','8','2',NULL,'56','68',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:7:\"gender \";i:435;s:11:\"antarbudaya\";i:436;s:13:\"floradanfauna\";i:437;s:10:\"antaragama\";i:438;s:10:\"antarfisik\";i:439;s:16:\"lingkungansosial\";i:440;s:20:\"permainantradisional\";i:441;s:16:\"patuhdandisiplin\";i:442;s:16:\"lingkungansosial\";i:443;s:14:\"salingmembantu\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('195','3','17','76','ASAG','2025-05-26 09:30:45','2025-05-26 10:16:44','2025-05-26 10:16:47','1','9',NULL,'7','7',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"B\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"D\";i:10;s:1:\"B\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:12:\"anaklakilaki\";i:435;s:25:\"masyarakataadabedaadangak\";i:436;s:38:\"bungongjeupamerupakansalahsatudariaceh\";i:437;s:15:\"mengotongroyong\";i:438;s:16:\"keberagamantubuh\";i:439;s:4:\"aceh\";i:440;s:16:\"permainandaherah\";i:441;s:15:\"kebersihankelas\";i:442;s:12:\"gotongroyong\";i:443;s:8:\"yangbaik\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;N;i:9;N;i:141;N;i:142;N;i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;N;i:147;N;i:431;N;i:432;N;i:433;N;}');
INSERT INTO `nilai` VALUES ('196','3','17','65','ASAG','2025-05-26 09:32:42','2025-05-26 10:12:02','2025-05-26 10:13:11','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:16:\"lingkungansosial\";i:436;s:6:\"budaya\";i:437;s:6:\"sosial\";i:438;s:3:\"ras\";i:439;s:6:\"budaya\";i:440;s:14:\"linkunganfisik\";i:441;s:6:\"sosial\";i:442;s:8:\"kesatuan\";i:443;s:11:\"keberagaman\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"B, C, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('197','3','17','103','ASAG','2025-05-26 09:32:43','2025-05-26 10:13:57','2025-05-26 10:14:10','7','3',NULL,'49','63',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:15:\"perbedaangender\";i:435;s:8:\"bajuadat\";i:436;s:4:\"aceh\";i:437;s:6:\"sosial\";i:438;s:6:\"daerah\";i:439;s:7:\"sekitar\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:15:\"rasakepercayaan\";i:443;s:10:\"masyarakat\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','4','0','3','10','1','0','2','0','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('198','4','15','60','ASAG','2025-05-26 10:16:29','2025-05-26 10:42:39','2025-05-26 10:45:32','7','3',NULL,'49','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:12:\"keseimbangan\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"headstand\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('199','4','15','93','ASAG','2025-05-26 10:16:33','2025-05-26 10:45:27','2025-05-26 10:45:52','4','6',NULL,'28','36',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"penutup\";i:423;s:10:\"senamirama\";i:424;s:5:\"badan\";i:425;s:6:\"faktor\";i:426;s:3:\"sel\";i:427;s:1:\"9\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:5:\"musik\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','4','10','5','0','1','0','0','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('200','4','15','74','ASAG','2025-05-26 10:16:35','2025-05-26 10:47:35','2025-05-26 10:47:41','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:2:\"ya\";i:423;s:6:\"lantai\";i:424;s:5:\"betul\";i:425;s:8:\"pengaruh\";i:426;s:7:\"jasmani\";i:427;s:2:\"10\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:4:\"stik\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"C, D\";i:413;s:7:\"A, B, C\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"C, A, D, B\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"C, A, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('201','4','15','80','ASAG','2025-05-26 10:16:36','2025-05-26 10:45:00','2025-05-26 10:45:19','4','6',NULL,'28','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:10:\"saltodepan\";i:422;s:5:\"tidur\";i:423;s:9:\"senampagi\";i:424;s:17:\"kekuranganprotein\";i:425;s:7:\"manusia\";i:426;s:11:\"ketarikurat\";i:427;s:1:\"7\";i:428;s:8:\"olahraga\";i:429;s:12:\"kiridankanan\";i:430;s:8:\"manteras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;s:1:\"D\";i:412;s:7:\"A, B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"C, B, A, D\";i:420;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('202','4','15','77','ASAG','2025-05-26 10:16:37','2025-05-26 10:44:39','2025-05-26 10:45:38','2','8',NULL,'14','22',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:5:\"sikap\";i:426;s:9:\"kesehatan\";i:427;s:2:\"10\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:5:\"musik\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','0','0','0','4','10','5','0','1','0','0','','8','a:5:{i:411;s:4:\"A, C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('203','4','15','70','ASAG','2025-05-26 10:16:38','2025-05-26 10:44:04','2025-05-26 10:45:39','3','7',NULL,'21','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:9:\"berbaring\";i:423;s:5:\"irama\";i:424;s:9:\"puberitas\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:6:\"lantai\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,430,429,428,427,426,425,424,423,422,421,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('204','4','15','87','ASAG','2025-05-26 10:16:38','2025-05-26 10:40:54','2025-05-26 10:45:30','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"D\";i:409;s:1:\"D\";i:410;s:1:\"D\";}','a:10:{i:421;s:12:\"gerakanjalan\";i:422;s:13:\"gerakanguling\";i:423;s:7:\"pianika\";i:424;s:6:\"kasipa\";i:425;s:2:\"15\";i:426;s:12:\"zatperalitan\";i:427;s:1:\"9\";i:428;s:11:\"senamsosial\";i:429;s:5:\"kanan\";i:430;s:9:\"alatpiano\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','0','3','0','1','10','2','0','4','0','6','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, D, C\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"C, B, A, D\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('205','4','15','59','ASAG','2025-05-26 10:16:43','2025-05-26 10:47:20','2025-05-26 10:47:24','7','3',NULL,'49','65',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:32:\"memeluklututhinggakembalijongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:26:\"senamyangmenggunakanmatras\";i:429;s:7:\"pinggir\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('206','4','15','113','ASAG','2025-05-26 10:16:45','2025-05-26 10:36:51','2025-05-26 10:45:34','5','5',NULL,'35','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:9:\"kesehatan\";i:426;s:4:\"besi\";i:427;s:1:\"8\";i:428;s:7:\"gerakan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, D, C, B\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('207','4','15','62','ASAG','2025-05-26 10:16:46','2025-05-26 10:38:21','2025-05-26 10:45:55','5','5',NULL,'35','56',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:6:\"remaja\";i:425;s:7:\"keadaan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"akrobatik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('208','4','15','71','ASAG','2025-05-26 10:16:47','2025-05-26 10:42:44','2025-05-26 10:45:18','3','7',NULL,'21','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"D\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:7:\"pikiran\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:3:\"per\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, C, B, A\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('209','4','15','67','ASAG','2025-05-26 10:16:47','2025-05-26 10:46:33','2025-05-26 10:46:59','1','9',NULL,'7','7',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"matras\";i:422;s:7:\"berdiri\";i:423;s:11:\"senamlantai\";i:424;s:2:\"45\";i:425;s:9:\"pemanasan\";i:426;s:7:\"zatpjok\";i:427;s:1:\"9\";i:428;s:13:\"gerakanlantai\";i:429;s:7:\"jongkot\";i:430;s:13:\"gerakanlantai\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"B, C, D\";i:414;s:7:\"A, C, D\";i:415;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, C, B, A\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('210','4','15','91','ASAG','2025-05-26 10:16:48','2025-05-26 10:35:17','2025-05-26 10:45:27','6','4',NULL,'42','62',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:3:\"rol\";i:422;s:14:\"gulingbelakang\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:9:\"handstand\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('211','4','15','108','ASAG','2025-05-26 10:16:48','2025-05-26 10:35:56','2025-05-26 10:41:18','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:8:\"kekuatan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('212','4','15','95','ASAG','2025-05-26 10:16:48','2025-05-26 10:45:14','2025-05-26 10:46:08','4','6',NULL,'28','38',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:7:\"berdiri\";i:423;s:16:\"senammentaripagi\";i:424;s:23:\"energiataupertumbuhanya\";i:425;s:5:\"orang\";i:426;s:18:\"zatmemasukiintisel\";i:427;s:1:\"6\";i:428;s:9:\"ratohjaro\";i:429;s:12:\"kanandankiri\";i:430;s:6:\"piring\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,426,422,427,424,429,425,421,423,430,428,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','0','1','0','4','10','4','0','1','0','2','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, C\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('213','4','15','66','ASAG','2025-05-26 10:16:49','2025-05-26 10:46:14','2025-05-26 10:46:50','2','8',NULL,'14','21',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:9:\"rangkaian\";i:423;s:6:\"lantai\";i:424;s:5:\"fokus\";i:425;s:4:\"pola\";i:426;s:3:\"sel\";i:427;s:1:\"9\";i:428;s:5:\"senam\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('214','4','15','69','ASAG','2025-05-26 10:16:49','2025-05-26 10:46:12','2025-05-26 10:46:22','3','7',NULL,'21','41',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:9:\"kesehatan\";i:426;s:7:\"kalsium\";i:427;s:1:\"7\";i:428;s:9:\"handstand\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('215','4','15','64','ASAG','2025-05-26 10:16:51','2025-05-26 10:43:35','2025-05-26 10:45:30','7','3',NULL,'49','70',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:6:\"guling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('216','4','15','72','ASAG','2025-05-26 10:16:52','2025-05-26 10:41:48','2025-05-26 10:45:15','1','9',NULL,'7','19',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:8:\"terduduk\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:11:\"gulingdepan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('217','4','15','106','ASAG','2025-05-26 10:16:54','2025-05-26 10:40:07','2025-05-26 10:45:18','2','8',NULL,'14','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:8:\"kekuatan\";i:426;s:10:\"putihtelur\";i:427;s:1:\"8\";i:428;s:9:\"akrobatik\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"A, B, D, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('218','4','15','84','ASAG','2025-05-26 10:16:54','2025-05-26 10:45:19','2025-05-26 10:45:35','4','6',NULL,'28','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:11:\"pertumbuhan\";i:426;s:6:\"cairan\";i:427;s:1:\"7\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('219','4','15','90','ASAG','2025-05-26 10:16:55','2025-05-26 10:50:57','2025-05-26 10:51:22','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:11:\"senamguling\";i:422;s:5:\"senam\";i:423;s:9:\"senampagi\";i:424;s:5:\"badan\";i:425;s:2:\"hp\";i:426;s:5:\"perut\";i:427;s:1:\"2\";i:428;s:10:\"sikaplilin\";i:429;s:4:\"kiri\";i:430;s:9:\"headstand\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"A\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, D, C, B\";i:418;s:10:\"D, B, A, C\";i:419;s:4:\"B, C\";i:420;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('220','4','15','101','ASAG','2025-05-26 10:16:56','2025-05-26 10:45:12','2025-05-26 10:45:56','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:5:\"duduk\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesadaran\";i:426;s:10:\"zatprotein\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,430,429,428,427,426,425,424,423,422,421,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:1:\"B\";i:412;s:4:\"B, D\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"D, C, B, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('221','4','15','86','ASAG','2025-05-26 10:16:57','2025-05-26 10:45:26','2025-05-26 10:46:17','2','8',NULL,'14','19',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"bebas\";i:424;s:4:\"anak\";i:425;s:5:\"fisik\";i:426;s:6:\"putler\";i:427;s:1:\"9\";i:428;s:6:\"rileks\";i:429;s:7:\"samping\";i:430;s:7:\"penutup\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,428,430,423,421,425,429,424,427,422,426,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, D\";i:413;s:4:\"B, D\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"B, A, D\";i:417;s:10:\"A, B, C, D\";i:418;s:1:\"D\";i:419;s:1:\"C\";i:420;s:1:\"B\";}');
INSERT INTO `nilai` VALUES ('222','4','15','100','ASAG','2025-05-26 10:16:59','2025-05-26 10:48:56','2025-05-26 10:49:17','6','4',NULL,'42','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('223','4','15','94','ASAG','2025-05-26 10:16:59','2025-05-26 10:37:13','2025-05-26 10:45:37','5','5',NULL,'35','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"rebahan\";i:423;s:6:\"lantai\";i:424;s:7:\"protein\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, A, D\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('224','4','15','109','ASAG','2025-05-26 10:17:01','2025-05-26 10:40:25','2025-05-26 10:45:25','5','5',NULL,'35','48',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:10:\"kecerdasan\";i:425;s:8:\"kekuatan\";i:426;s:7:\"zatbesi\";i:427;s:5:\"10jam\";i:428;s:11:\"senammatras\";i:429;s:14:\"belakangmatras\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','3','0','0','5','7','5','0','0','3','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('225','4','15','92','ASAG','2025-05-26 10:17:01','2025-05-26 10:49:00','2025-05-26 10:49:09','5','5',NULL,'35','53',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:6:\"jonkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:6:\"faktor\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:7:\"rolling\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('226','4','15','73','ASAG','2025-05-26 10:17:01','2025-05-26 10:40:11','2025-05-26 10:41:15','3','7',NULL,'21','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','0','0','4','8','5','0','1','2','0','','8','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('227','4','15','89','ASAG','2025-05-26 10:17:02','2025-05-26 10:42:01','2025-05-26 10:45:20','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:4:\"daya\";i:426;s:4:\"besi\";i:427;s:2:\"10\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('228','4','15','104','ASAG','2025-05-26 10:17:03','2025-05-26 10:45:16','2025-05-26 10:45:36','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:7:\"kondisi\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('229','4','15','61','ASAG','2025-05-26 10:17:05','2025-05-26 10:44:37','2025-05-26 10:46:01','9','1',NULL,'63','81',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"sikapguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:10:\"kecerdasan\";i:426;s:7:\"protein\";i:427;s:3:\"7-8\";i:428;s:9:\"headstand\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','4','2','0','5','6','3','0','0','4','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('230','4','15','103','ASAG','2025-05-26 10:17:11','2025-05-26 10:40:13','2025-05-26 10:46:19','1','9',NULL,'7','26',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:6:\"stmina\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:7:\"berdiri\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('231','4','15','68','ASAG','2025-05-26 10:17:11','2025-05-26 10:48:31','2025-05-26 10:48:36','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"D\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:0:\"\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:9:\"kesehatan\";i:426;s:26:\"positif                   \";i:427;s:1:\"9\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:5:\"musik\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','0','2','0','4','10','3','0','1','0','4','','8','a:5:{i:411;s:4:\"A, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('232','4','15','97','ASAG','2025-05-26 10:17:12','2025-05-26 10:45:52','2025-05-26 10:46:21','3','7',NULL,'21','23',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:7:\"jongkok\";i:422;s:1:\"4\";i:423;s:11:\"senamlantai\";i:424;s:4:\"cape\";i:425;s:12:\"sosial fisik\";i:426;s:6:\"zatair\";i:427;s:5:\"11jam\";i:428;s:11:\"senamlantai\";i:429;s:8:\"belakang\";i:430;s:5:\"sipap\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"A, B, C\";i:414;s:7:\"A, B, C\";i:415;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, A, C\";i:417;s:7:\"B, D, A\";i:418;s:7:\"D, A, B\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('233','4','15','96','ASAG','2025-05-26 10:17:15','2025-05-26 10:37:59','2025-05-26 10:39:16','2','8',NULL,'14','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:33:\"untukmenjagakeseimbanganjaraklari\";i:422;s:23:\"senamlantaiatauhanstend\";i:423;s:14:\"senamanaksehat\";i:424;s:17:\"maksimalkesehatan\";i:425;s:18:\"mengikutilombalari\";i:426;s:26:\"ygdisecarapembangunzatinti\";i:427;s:5:\"10jam\";i:428;s:26:\"keseimbangandayatahantubuh\";i:429;s:7:\"2matras\";i:430;s:24:\"untukmenjagakeseimbangan\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:1:\"C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:4:\"B, A\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('234','4','15','78','ASAG','2025-05-26 10:17:18','2025-05-26 10:45:55','2025-05-26 10:46:28','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"tangan\";i:424;s:5:\"badan\";i:425;s:5:\"tubuh\";i:426;s:4:\"otot\";i:427;s:1:\"8\";i:428;s:6:\"guling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,430,429,428,427,426,425,424,423,422,421,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"C, A, B, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('235','4','15','82','ASAG','2025-05-26 10:17:19','2025-05-26 10:45:28','2025-05-26 10:45:37','2','8',NULL,'14','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:3:\"sel\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamfisik\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','3','4','0','5','7','1','0','0','3','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"B, D\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('236','4','15','102','ASAG','2025-05-26 10:17:20','2025-05-26 10:43:59','2025-05-26 10:45:19','5','5',NULL,'35','49',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:10:\"pendaratan\";i:423;s:10:\"senamirama\";i:424;s:5:\"tubuh\";i:425;s:12:\"perkembangan\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:4:\"A, D\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('237','4','15','81','ASAG','2025-05-26 10:17:24','2025-05-26 10:37:13','2025-05-26 10:45:32','3','7',NULL,'21','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:8:\"pubertas\";i:425;s:5:\"badan\";i:426;s:5:\"telor\";i:427;s:1:\"8\";i:428;s:7:\"olaraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('238','4','15','76','ASAG','2025-05-26 10:17:25','2025-05-26 10:57:04','2025-05-26 10:57:47','2','8',NULL,'14','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"matras\";i:422;s:15:\"gerkanbolakbaki\";i:423;s:14:\"spikerlainlain\";i:424;s:5:\"4dan5\";i:425;s:9:\"pemalasan\";i:426;s:7:\"zatpjok\";i:427;s:3:\"510\";i:428;s:13:\"gerakanlantai\";i:429;s:6:\"contoh\";i:430;s:11:\"senamlantai\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:1:\"A\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:7:\"A, B, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, D, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"B, D, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('239','4','15','110','ASAG','2025-05-26 10:17:25','2025-05-26 10:45:37','2025-05-26 10:45:45','5','5',NULL,'35','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:8:\"pubertas\";i:426;s:5:\"darah\";i:427;s:1:\"7\";i:428;s:17:\"senamdiatasmatras\";i:429;s:7:\"pemandu\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,426,422,427,424,429,425,421,423,430,428,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"A\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('240','4','15','88','ASAG','2025-05-26 10:17:29','2025-05-26 10:49:02','2025-05-26 10:49:10','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"gizi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','3','3','0','0','7','2','0','5','3','6','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, C, D\";i:418;s:7:\"D, A, B\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('241','4','15','63','ASAG','2025-05-26 10:17:30','2025-05-26 10:41:20','2025-05-26 10:45:25','5','5',NULL,'35','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"ruling\";i:422;s:16:\"rulingkebelakang\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:5:\"badan\";i:426;s:7:\"zatinti\";i:427;s:2:\"10\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:5:\"senam\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','0','3','0','5','10','2','0','0','0','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('242','4','15','112','ASAG','2025-05-26 10:17:31','2025-05-26 10:43:49','2025-05-26 10:45:22','3','7',NULL,'21','26',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:10:\"rolkedepan\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:11:\"berolahraga\";i:427;s:5:\"9 jam\";i:428;s:17:\"senamdiatasmatras\";i:429;s:11:\"kananmatras\";i:430;s:22:\"senammenggunakanmatras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:1:\"A\";i:412;s:1:\"B\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:7:\"D, B, A\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('243','4','15','85','ASAG','2025-05-26 10:17:32','2025-05-26 10:52:06','2025-05-26 10:53:01','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:14:\"gulingbelakang\";i:422;s:10:\"sikaplilin\";i:423;s:10:\"senamirama\";i:424;s:16:\"kurangnyanutrisi\";i:425;s:9:\"aktivitas\";i:426;s:8:\"zattelur\";i:427;s:4:\"jam9\";i:428;s:31:\"melatihtubuhsupayaotottidakiaku\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"A, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('244','4','15','99','ASAG','2025-05-26 10:17:33','2025-05-26 10:38:05','2025-05-26 10:45:51','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kepintaran\";i:425;s:8:\"kekuatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','1','0','5','7','4','0','0','3','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('245','4','15','107','ASAG','2025-05-26 10:17:34','2025-05-26 10:35:51','2025-05-26 10:45:27','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:11:\"larikedepan\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:5:\"lemah\";i:425;s:7:\"pikiran\";i:426;s:5:\"lemak\";i:427;s:4:\"5jam\";i:428;s:13:\"senamdimatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:411;s:4:\"A, C\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('246','4','15','65','ASAG','2025-05-26 10:17:34','2025-05-26 10:46:26','2025-05-26 10:46:42','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:4:\"anak\";i:425;s:9:\"keaktivan\";i:426;s:7:\"sayuran\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, C, D, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('247','4','15','98','ASAG','2025-05-26 10:17:34','2025-05-26 10:40:28','2025-05-26 10:45:21','2','8',NULL,'14','25',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:14:\"rollingkedepan\";i:422;s:7:\"berdiri\";i:423;s:10:\"senamirama\";i:424;s:5:\"tubuh\";i:425;s:10:\"lingkungan\";i:426;s:5:\"telur\";i:427;s:1:\"8\";i:428;s:10:\"senamfisik\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"D, B, C, A\";i:420;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('248','4','15','115','ASAG','2025-05-26 10:17:37','2025-05-26 10:45:15','2025-05-26 10:45:21','1','9',NULL,'7','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"A\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:7:\"jongkok\";i:422;s:7:\"berdiri\";i:423;s:7:\"praktis\";i:424;s:4:\"gizi\";i:425;s:4:\"gizi\";i:426;s:8:\"zat besi\";i:427;s:1:\"7\";i:428;s:7:\"praktis\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('249','4','15','111','ASAG','2025-05-26 10:17:41','2025-05-26 10:37:14','2025-05-26 10:46:00','2','8',NULL,'14','19',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:15:\"matrasberguling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:14:\"dantidaktinggi\";i:425;s:16:\"danfisikyangkuat\";i:426;s:14:\"tulangbelakang\";i:427;s:1:\"8\";i:428;s:13:\"senamdimatras\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:4:\"A, B\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"B, A, C, D\";i:420;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('250','4','15','105','ASAG','2025-05-26 10:17:41','2025-05-26 10:48:17','2025-05-26 10:48:56','6','4',NULL,'42','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:4:\"mata\";i:425;s:12:\"perkembangan\";i:426;s:13:\"zatputihtelur\";i:427;s:1:\"4\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,430,429,428,427,426,425,424,423,422,421,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('251','4','15','116','ASAG','2025-05-26 10:17:43','2025-05-26 10:45:15','2025-05-26 10:46:21','4','6',NULL,'28','37',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"lurus\";i:423;s:13:\"senamberirama\";i:424;s:5:\"badan\";i:425;s:5:\"fisik\";i:426;s:3:\"zat\";i:427;s:1:\"7\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,428,430,423,421,425,429,424,427,422,426,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"C, A, B, D\";i:420;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('252','4','15','114','ASAG','2025-05-26 10:17:46','2025-05-26 10:47:58','2025-05-26 10:48:01','8','2',NULL,'56','72',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:6:\"cerdas\";i:425;s:8:\"kekuatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:6:\"matras\";i:429;s:5:\"kanan\";i:430;s:20:\"olahragadiatasmatras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('253','4','15','75','ASAG','2025-05-26 10:17:53','2025-05-26 10:45:26','2025-05-26 10:46:14','5','5',NULL,'35','48',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:7:\"tamling\";i:424;s:6:\"dewasa\";i:425;s:5:\"makan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"2\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:1:\"C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:1:\"D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('254','4','15','83','ASAG','2025-05-26 10:17:56','2025-05-26 10:34:00','2025-05-26 10:45:22','1','9',NULL,'7','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"loncat\";i:422;s:7:\"berdiri\";i:423;s:5:\"badan\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:5:\"tubuh\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, D, B, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('255','4','15','79','ASAG','2025-05-26 10:18:25','2025-05-26 10:39:45','2025-05-26 10:45:38','3','7',NULL,'21','21',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:17:\"berdiridanjongkok\";i:423;s:25:\"senamlantaiatausenambiasa\";i:424;s:19:\"mencegahpertumbuhan\";i:425;s:17:\"fisikatauolahraga\";i:426;s:21:\"perbentukanseldaninti\";i:427;s:18:\"hari1sampai2malam9\";i:428;s:18:\"tradisionaldanbaik\";i:429;s:21:\"kananataukiridandepan\";i:430;s:32:\"mengulingmatraskekiriataukekanan\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, C\";i:413;s:4:\"A, D\";i:414;s:4:\"A, B\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, D, A\";i:417;s:10:\"C, B, D, A\";i:418;s:7:\"C, D, A\";i:419;s:1:\"D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('256','5','17','149','ASAG','2025-05-26 11:08:25','2025-05-26 11:12:43','2025-05-26 11:12:49','3','7',NULL,'21','21',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"B\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:4:\"====\";i:435;s:1:\"=\";i:436;s:1:\"-\";i:437;s:1:\"-\";i:438;s:1:\"=\";i:439;s:1:\"=\";i:440;s:9:\"=========\";i:441;s:1:\"=\";i:442;s:1:\"=\";i:443;s:2:\"==\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,437,436,440,434,442,439,435,443,441,438,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"C\";i:142;s:1:\"B\";i:145;s:1:\"B\";}','a:0:{}','a:5:{i:146;s:7:\"B, A, C\";i:147;s:10:\"C, B, A, D\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('257','5','17','127','ASAG','2025-05-26 11:08:32','2025-05-26 11:33:52','2025-05-26 11:37:57','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:25:\"rumahsekolahdanmasyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:36:\"sesuatuyangtidakbisadilakukansendiri\";i:443;s:9:\"kerjasama\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:4:\"C, D\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('258','5','17','160','ASAG','2025-05-26 11:09:24','2025-05-26 11:41:43','2025-05-26 11:44:10','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:15:\"tidakmenghargai\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:5:\"kerja\";i:440;s:17:\"keberagamanbudaya\";i:441;s:9:\"kerjasama\";i:442;s:13:\"tujuanbersama\";i:443;s:12:\"kekeluargaan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('259','5','17','162','ASAG','2025-05-26 11:09:27','2025-05-26 11:44:37','2025-05-26 11:44:47','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:11:\"keberagaman\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"daerah\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tolongmenolong\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:1:\"B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('260','5','17','164','ASAG','2025-05-26 11:09:29','2025-05-26 11:36:40','2025-05-26 11:37:58','7','3',NULL,'49','56',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:3:\"ras\";i:436;s:12:\"tariandaerah\";i:437;s:1:\"6\";i:438;s:3:\"ras\";i:439;s:11:\"keberagaman\";i:440;s:18:\"bermaintradisional\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:5:\"aktif\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, D\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('261','5','17','145','ASAG','2025-05-26 11:09:39','2025-05-26 11:39:57','2025-05-26 11:40:34','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"A\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"atheis\";i:435;s:3:\"ras\";i:436;s:6:\"tarian\";i:437;s:13:\"budayaatauras\";i:438;s:3:\"ras\";i:439;s:10:\"kebudayaan\";i:440;s:20:\"permainantradisional\";i:441;s:35:\"kebersihanataukewajibansiswadikelas\";i:442;s:21:\"kesatuandankekompakan\";i:443;s:11:\"kebersamaan\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:4;s:4:\"A, D\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('262','5','17','134','ASAG','2025-05-26 11:09:40','2025-05-26 11:55:02','2025-05-26 11:55:06','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:5:\"jgkgk\";i:435;s:21:\"perbedaanbudayadanras\";i:436;s:11:\"tradisional\";i:437;s:10:\"sukubangsa\";i:438;s:10:\"sukubangsa\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:8:\"kesatuan\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,438,441,443,435,439,442,434,440,436,437,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','4','0','2','10','1','0','3','0','8','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"D, C, B, A\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('263','5','17','143','ASAG','2025-05-26 11:09:41','2025-05-26 11:44:00','2025-05-26 11:44:07','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:5:\"badui\";i:435;s:3:\"ras\";i:436;s:8:\"tumbuhan\";i:437;s:6:\"budaya\";i:438;s:6:\"daerah\";i:439;s:9:\"indonesia\";i:440;s:12:\"mainandaerah\";i:441;s:9:\"kewajiban\";i:442;s:15:\"suwatukewajiban\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','3','0','1','10','2','0','4','0','6','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"B, C, D\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:7:\"C, A, B\";i:431;s:7:\"A, D, B\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('264','5','17','125','ASAG','2025-05-26 11:09:42','2025-05-26 11:34:36','2025-05-26 11:37:54','8','2',NULL,'56','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:6:\"menari\";i:437;s:4:\"suku\";i:438;s:4:\"suku\";i:439;s:27:\"pesisirdaratandanpegunungan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:12:\"permasalahan\";i:443;s:11:\"bekerjasama\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,437,436,440,434,442,439,435,443,441,438,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"C, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"C, D, A, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('265','5','17','119','ASAG','2025-05-26 11:09:43','2025-05-26 11:34:34','2025-05-26 11:37:59','8','2',NULL,'56','67',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"berbedasuku\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:6:\"budaya\";i:439;s:7:\"sekolah\";i:440;s:21:\"permainantradisioanal\";i:441;s:13:\"tanggungjawab\";i:442;s:5:\"tugas\";i:443;s:9:\"kerjasama\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, C\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, B, D, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, C, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('266','5','17','155','ASAG','2025-05-26 11:09:44','2025-05-26 11:45:08','2025-05-26 11:46:22','8','2',NULL,'56','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:14:\"keragamanagama\";i:438;s:3:\"ras\";i:439;s:8:\"keluarga\";i:440;s:20:\"alatmusiktradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:9:\"keragaman\";i:443;s:5:\"sosia\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,443,442,441,440,439,438,437,436,435,434,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:7:\"D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('267','5','17','156','ASAG','2025-05-26 11:09:44','2025-05-26 11:46:13','2025-05-26 11:46:43','7','3',NULL,'49','56',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:20:\"perempuandanlakilaki\";i:435;s:15:\"keragamanbudaya\";i:436;s:4:\"aceh\";i:437;s:12:\"budayadanras\";i:438;s:3:\"ras\";i:439;s:9:\"indonesia\";i:440;s:11:\"tradisional\";i:441;s:16:\"kewajibansekolah\";i:442;s:12:\"gotongroyong\";i:443;s:8:\"keluarga\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"B, C, D, A\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('268','5','17','153','ASAG','2025-05-26 11:09:45','2025-05-26 11:44:36','2025-05-26 11:45:31','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"kebudayaanlokal\";i:436;s:5:\"musik\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:6:\"pantai\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:19:\"suatutujuanyangsama\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('269','5','17','141','ASAG','2025-05-26 11:09:45','2025-05-26 11:41:05','2025-05-26 11:42:00','8','2',NULL,'56','65',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:10:\"kebudayaan\";i:435;s:11:\"keberagaman\";i:436;s:10:\"lagudaerah\";i:437;s:15:\"yangberbedabeda\";i:438;s:3:\"ras\";i:439;s:12:\"wargasekitar\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:7:\"pribadi\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,437,436,440,434,442,439,435,443,441,438,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','0','9','1','0','5','1','8','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, C, D\";i:147;s:10:\"D, C, B, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"A, D, C, B\";}');
INSERT INTO `nilai` VALUES ('270','5','17','158','ASAG','2025-05-26 11:09:45','2025-05-26 11:45:54','2025-05-26 11:46:34','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:6:\"daerah\";i:437;s:9:\"keagamaan\";i:438;s:12:\"nasionalisme\";i:439;s:10:\"lingkungan\";i:440;s:15:\"permainanbudaya\";i:441;s:9:\"kerjasama\";i:442;s:7:\"konflik\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','5','0','0','10','0','0','5','0','10','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"B, C, D, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"C, D, B, A\";i:433;s:7:\"D, A, B\";}');
INSERT INTO `nilai` VALUES ('271','5','17','148','ASAG','2025-05-26 11:09:46','2025-05-26 11:50:28','2025-05-26 11:50:36','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:11:\"keberagaman\";i:438;s:14:\"keberagamanras\";i:439;s:27:\"lingkungantempatkitatinggal\";i:440;s:21:\"permainantradiosional\";i:441;s:12:\"tangungjawab\";i:442;s:10:\"kepedulian\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','3','0','2','10','2','0','3','0','6','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, B, D\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('272','5','17','140','ASAG','2025-05-26 11:09:51','2025-05-26 11:41:26','2025-05-26 11:43:44','9','1',NULL,'63','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:13:\"floradanfauna\";i:435;s:3:\"ras\";i:436;s:12:\"musikdannari\";i:437;s:15:\"yangberbedabeda\";i:438;s:4:\"suku\";i:439;s:14:\"keberagamanras\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:9:\"kesulitan\";i:443;s:9:\"toleransi\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','0','0','0','4','10','5','0','1','0','0','','8','a:5:{i:4;s:1:\"C\";i:9;s:1:\"C\";i:141;s:1:\"A\";i:142;s:1:\"B\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('273','5','17','131','ASAG','2025-05-26 11:10:01','2025-05-26 11:51:54','2025-05-26 11:52:21','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:13:\"priadanwanita\";i:435;s:13:\"perbedaansuku\";i:436;s:4:\"seni\";i:437;s:6:\"daerah\";i:438;s:4:\"suku\";i:439;s:4:\"suku\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kewajiban\";i:442;s:9:\"toleransi\";i:443;s:8:\"kerjasam\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('274','5','17','157','ASAG','2025-05-26 11:10:02','2025-05-26 11:37:27','2025-05-26 11:41:23','8','2',NULL,'56','66',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:5:\"flora\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:7:\"sekitar\";i:440;s:15:\"permainandaerah\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"persatuan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','1','0','4','10','4','0','1','0','2','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('275','5','17','165','ASAG','2025-05-26 11:10:02','2025-05-26 11:48:51','2025-05-26 11:49:24','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:9:\"toleransi\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:6:\"budaya\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"kebudayaaan\";i:443;s:23:\"tanggungjawabmasyarakat\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"B, C, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:7:\"B, A, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('276','5','17','166','ASAG','2025-05-26 11:10:04','2025-05-26 11:40:08','2025-05-26 11:41:09','8','2',NULL,'56','67',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"keberagamansuku\";i:436;s:8:\"tumbuhan\";i:437;s:5:\"agama\";i:438;s:19:\"rasdanantargolongan\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:4;s:4:\"A, C\";i:9;s:1:\"B\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('277','5','17','121','ASAG','2025-05-26 11:10:06','2025-05-26 11:42:29','2025-05-26 11:44:08','9','1',NULL,'63','67',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:18:\"keberagamangender \";i:435;s:5:\"suku \";i:436;s:5:\"alam \";i:437;s:6:\"agama \";i:438;s:4:\"ras \";i:439;s:8:\"sekitar \";i:440;s:21:\"permainantradisional \";i:441;s:13:\"gotongroyong \";i:442;s:10:\"kesulitan \";i:443;s:11:\"kedaerahan \";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:10:\"A, B, C, D\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:7:\"C, B, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('278','5','17','122','ASAG','2025-05-26 11:10:21','2025-05-26 11:43:41','2025-05-26 11:44:41','7','3',NULL,'49','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"A\";}','a:10:{i:434;s:14:\"daerahatausuku\";i:435;s:10:\"sukudanras\";i:436;s:6:\"sosial\";i:437;s:6:\"budaya\";i:438;s:4:\"suku\";i:439;s:13:\"disekitarkita\";i:440;s:9:\"permainan\";i:441;s:8:\"disiplin\";i:442;s:12:\"kedisiplinan\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:1:\"A\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"A, B, D, C\";i:431;s:7:\"C, A, B\";i:432;s:10:\"A, C, B, D\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('279','5','17','129','ASAG','2025-05-26 11:10:22','2025-05-26 11:46:58','2025-05-26 11:48:44','5','5',NULL,'35','39',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:12:\"tradisilokal\";i:436;s:13:\"tariandanlagu\";i:437;s:18:\"keberagamanbudaya \";i:438;s:14:\"keberagamanras\";i:439;s:17:\"yangtidakbernyawa\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:19:\"kesadaranmasyarakat\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"A, B\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('280','5','17','135','ASAG','2025-05-26 11:10:24','2025-05-26 11:40:44','2025-05-26 11:42:09','3','7',NULL,'21','27',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:57:\"jeniskelaminlakilakidanperempuansangatberbedajeniskelamin\";i:435;s:75:\"kebudayaanmasyarakatmembedakanbudayalaindanbedabedaprovinsilainsamayanglain\";i:436;s:4:\"aceh\";i:437;s:4:\"aceh\";i:438;s:9:\"indonesia\";i:439;s:9:\"indonesia\";i:440;s:9:\"permainan\";i:441;s:11:\"dirisendiri\";i:442;s:10:\"masyarakat\";i:443;s:12:\"salingsesama\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','0','3','0','0','10','2','0','5','0','6','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, B\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:7:\"A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:7:\"B, D, C\";i:433;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('281','5','17','173','ASAG','2025-05-26 11:10:24','2025-05-26 11:50:36','2025-05-26 11:51:28','3','7',NULL,'21','26',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:3:\"ras\";i:435;s:14:\"antar golongan\";i:436;s:4:\"aceh\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:8:\"pesisir \";i:440;s:11:\"keberagaman\";i:441;s:14:\"tanggung jawab\";i:442;s:45:\"mempererat persatuan dan kesatuan masyarakat \";i:443;s:9:\"toleransi\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"C, A, B, D\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('282','5','17','159','ASAG','2025-05-26 11:10:27','2025-05-26 11:53:09','2025-05-26 11:53:58','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"sukuadatistiadat\";i:435;s:26:\"sangatmencintaikeberagaman\";i:436;s:8:\"provinsi\";i:437;s:6:\"kompak\";i:438;s:6:\"daerah\";i:439;s:13:\"floradanfauna\";i:440;s:20:\"permainantradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:23:\"semboyanbangsaindonesia\";i:443;s:16:\"salingmenghargai\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,438,441,443,435,439,442,434,440,436,437,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:7:\"B, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('283','5','17','136','ASAG','2025-05-26 11:10:27','2025-05-26 11:33:54','2025-05-26 11:38:07','7','3',NULL,'49','63',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:5:\"egois\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisikdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:21:\"penggelompokanmanusia\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:1:\"A\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('284','5','17','120','ASAG','2025-05-26 11:10:28','2025-05-26 11:49:09','2025-05-26 11:50:17','8','2',NULL,'56','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:4:\"suku\";i:436;s:6:\"floura\";i:437;s:10:\"masyarakat\";i:438;s:12:\"turunmenurun\";i:439;s:12:\"yangbernyawa\";i:440;s:20:\"permainantradisional\";i:441;s:18:\"tanggungjawabsiswa\";i:442;s:9:\"persatuan\";i:443;s:18:\"lingkungankeluarga\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,443,442,441,440,439,438,437,436,435,434,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, C, D\";i:142;s:7:\"A, C, D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, C, A\";i:147;s:10:\"A, B, C, D\";i:431;s:7:\"B, C, A\";i:432;s:10:\"D, B, C, A\";i:433;s:7:\"A, B, C\";}');
INSERT INTO `nilai` VALUES ('285','5','17','142','ASAG','2025-05-26 11:10:28','2025-05-26 11:41:33','2025-05-26 11:42:34','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:4:\"seni\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('286','5','17','130','ASAG','2025-05-26 11:10:32','2025-05-26 11:40:17','2025-05-26 11:43:32','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:10:\"senibudaya\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:7:\"sekolah\";i:440;s:9:\"permainan\";i:441;s:12:\"gotongroyong\";i:442;s:7:\"kemauan\";i:443;s:4:\"baik\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','0','1','0','5','10','4','0','0','0','2','','10','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"A, B\";i:141;s:4:\"A, B\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('287','5','17','124','ASAG','2025-05-26 11:10:34','2025-05-26 11:36:00','2025-05-26 11:38:11','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"perbedaanbudaya\";i:436;s:5:\"flora\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:9:\"indonesia\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:8:\"kesatuan\";i:443;s:11:\"bersamasama\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:7:\"A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:7:\"C, A, D\";i:432;s:7:\"B, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('288','5','17','150','ASAG','2025-05-26 11:10:37','2025-05-26 11:44:11','2025-05-26 11:44:42','4','6',NULL,'28','36',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"keberagamanjenis\";i:435;s:3:\"ras\";i:436;s:5:\"musik\";i:437;s:4:\"suku\";i:438;s:6:\"budaya\";i:439;s:7:\"sekitar\";i:440;s:17:\"mainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:20:\"persatuandankesatuan\";i:443;s:13:\"membantukawan\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:4;s:7:\"A, C, D\";i:9;s:7:\"A, C, D\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"D, B, C, A\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('289','5','17','144','ASAG','2025-05-26 11:10:37','2025-05-26 11:43:27','2025-05-26 11:44:08','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:3:\"ras\";i:435;s:4:\"suku\";i:436;s:5:\"bunga\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"datarantinggi\";i:440;s:20:\"permainansuatudaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"kerjakelompok\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','2','0','1','8','3','0','4','2','4','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('290','5','17','126','ASAG','2025-05-26 11:10:38','2025-05-26 11:35:08','2025-05-26 11:38:03','7','3',NULL,'49','66',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:11:\"daratlautan\";i:440;s:21:\"permainan tradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:19:\"persamaan keinginan\";i:443;s:11:\"bersamasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('291','5','17','169','ASAG','2025-05-26 11:10:38','2025-05-26 11:36:12','2025-05-26 11:37:52','9','1',NULL,'63','80',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:13:\"antargolongan\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:19:\"permasalahanyangada\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','4','9','1','0','1','1','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('292','5','17','123','ASAG','2025-05-26 11:10:43','2025-05-26 11:41:49','2025-05-26 11:41:54','9','1',NULL,'63','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"floradanfauna\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:8:\"kesatuan\";i:443;s:10:\"masyarakat\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('293','5','17','171','ASAG','2025-05-26 11:10:43','2025-05-26 11:40:56','2025-05-26 11:41:48','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:15:\"rasjeniskelamin\";i:435;s:20:\"rasbudayayangberbeda\";i:436;s:6:\"nyanyi\";i:437;s:5:\"agama\";i:438;s:12:\"mahklukhidup\";i:439;s:7:\"manusia\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:29:\"halyangharusdikerjakanbersama\";i:443;s:4:\"baik\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, C, D\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"A, B, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('294','5','17','170','ASAG','2025-05-26 11:10:44','2025-05-26 11:36:35','2025-05-26 11:38:19','4','6',NULL,'28','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"B\";i:143;s:1:\"A\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"florafauna\";i:437;s:15:\"yangberbedabeda\";i:438;s:3:\"ras\";i:439;s:7:\"sekolah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"tanggungjawab\";i:443;s:10:\"rendahhati\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('295','5','17','151','ASAG','2025-05-26 11:10:53','2025-05-26 11:44:28','2025-05-26 11:45:25','6','4',NULL,'42','48',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:26:\"adanyaperempuandanlakilaki\";i:435;s:27:\"mempunyaikebudayaaansendiri\";i:436;s:6:\"sosial\";i:437;s:18:\"supayaadakeyakinan\";i:438;s:16:\"keberagamantubuh\";i:439;s:6:\"daerah\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:15:\"kerusakandaerah\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','1','10','3','0','4','0','4','','2','a:5:{i:4;s:1:\"D\";i:9;s:1:\"A\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('296','5','17','161','ASAG','2025-05-26 11:11:15','2025-05-26 11:45:15','2025-05-26 11:45:21','6','4',NULL,'42','45',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:6:\"sosial\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"tangungjawab\";i:442;s:13:\"tujuanbersama\";i:443;s:10:\"keluargaan\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:7:\"A, B, D\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"D, C, B, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('297','5','17','152','ASAG','2025-05-26 11:11:24','2025-05-26 11:49:45','2025-05-26 11:50:40','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:10:\"cewekcowok\";i:435;s:11:\"sukuatauras\";i:436;s:4:\"lagu\";i:437;s:4:\"suku\";i:438;s:4:\"suku\";i:439;s:6:\"daerah\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','2','0','3','10','3','0','2','0','4','','6','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('298','5','17','168','ASAG','2025-05-26 11:11:26','2025-05-26 11:42:22','2025-05-26 11:42:29','5','5',NULL,'35','47',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"C\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:8:\"bedasuku\";i:435;s:3:\"ras\";i:436;s:6:\"nyanyi\";i:437;s:11:\"kepercayaan\";i:438;s:3:\"ras\";i:439;s:5:\"barat\";i:440;s:9:\"keragaman\";i:441;s:6:\"sosial\";i:442;s:12:\"gotongroyong\";i:443;s:6:\"sosial\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','1','0','4','8','4','0','1','2','2','','8','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, C, D\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('299','5','17','138','ASAG','2025-05-26 11:11:28','2025-05-26 11:48:50','2025-05-26 11:49:26','9','1',NULL,'63','67',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:11:\"budayalokal\";i:435;s:15:\"lingkungasosial\";i:436;s:10:\"budayaaceh\";i:437;s:6:\"budaya\";i:438;s:15:\"lingkunganfisik\";i:439;s:10:\"budayaaceh\";i:440;s:14:\"permainanlokal\";i:441;s:4:\"baik\";i:442;s:16:\"lingkungansosial\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, D\";i:141;s:1:\"D\";i:142;s:4:\"B, C\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('300','5','17','137','ASAG','2025-05-26 11:11:53','2025-05-26 11:47:10','2025-05-26 11:47:18','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"perbedaangolongan\";i:435;s:21:\"adatkebudayaansendiri\";i:436;s:10:\"lagudaerah\";i:437;s:14:\"keberagamanras\";i:438;s:3:\"ras\";i:439;s:10:\"rumahsakit\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:11:\"bekerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"A, B\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"D, B, A, C\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('301','5','17','139','ASAG','2025-05-26 11:12:14','2025-05-26 11:46:53','2025-05-26 11:48:36','8','2',NULL,'56','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:11:\"budayalokal\";i:435;s:4:\"bali\";i:436;s:6:\"tarian\";i:437;s:5:\"lokal\";i:438;s:5:\"tubuh\";i:439;s:6:\"bangsa\";i:440;s:17:\"mainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"kekompakan\";i:443;s:6:\"rewamg\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"B, A, C, D\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"D, A, B, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('302','5','17','128','ASAG','2025-05-26 11:12:19','2025-05-26 11:47:36','2025-05-26 11:50:18','8','2',NULL,'56','60',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"perbedaan\";i:436;s:5:\"flora\";i:437;s:9:\"keyakinan\";i:438;s:5:\"fisik\";i:439;s:5:\"fisik\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:5:\"tugas\";i:443;s:8:\"menolong\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,438,441,443,435,439,442,434,440,436,437,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:7:\"A, C, D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:1:\"A\";i:147;s:4:\"C, D\";i:431;s:10:\"C, A, B, D\";i:432;s:1:\"A\";i:433;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('303','5','17','132','ASAG','2025-05-26 11:12:26','2025-05-26 11:40:42','2025-05-26 11:42:09','9','1',NULL,'63','77',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"keberagamansuku\";i:436;s:5:\"flora\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"keberagamanras\";i:439;s:16:\"daratandanlautan\";i:440;s:17:\"keberagamanbudaya\";i:441;s:9:\"kerjasama\";i:442;s:25:\"sikapsalingtolongmenolong\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','0','4','0','3','10','1','0','2','0','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('304','5','17','167','ASAG','2025-05-26 11:12:26','2025-05-26 11:52:53','2025-05-26 11:52:57','7','3',NULL,'49','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:0:\"\";i:435;s:16:\"salingmenghargai\";i:436;s:8:\"nyanyian\";i:437;s:10:\"kepercayan\";i:438;s:3:\"ras\";i:439;s:10:\"kebersihan\";i:440;s:9:\"permainan\";i:441;s:11:\"bekerjasama\";i:442;s:14:\"salingmembantu\";i:443;s:8:\"membantu\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, C, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:7:\"B, D, C\";i:431;s:10:\"A, C, D, B\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('305','5','17','146','ASAG','2025-05-26 11:12:35','2025-05-26 11:51:58','2025-05-26 11:52:50','5','5',NULL,'35','44',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:18:\"perbedaan golongan\";i:435;s:4:\"suku\";i:436;s:10:\"daerahaceh\";i:437;s:5:\"agama\";i:438;s:16:\"keberagamanfisik\";i:439;s:17:\"pesisirdandaratan\";i:440;s:9:\"permainan\";i:441;s:12:\"gotongroyong\";i:442;s:13:\"tujuanbersama\";i:443;s:20:\"kesatuandanpersatuan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, B, A, D\";i:432;s:7:\"B, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('306','5','17','118','ASAG','2025-05-26 11:12:56','2025-05-26 11:36:48','2025-05-26 11:38:05','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:16:\"lingkungansosial\";i:436;s:10:\"budayaalam\";i:437;s:10:\"sukudanras\";i:438;s:6:\"gender\";i:439;s:7:\"manusia\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:8:\"kesatuan\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,437,436,440,434,442,439,435,443,441,438,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','4','0','1','10','1','0','4','0','8','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('307','5','17','163','ASAG','2025-05-26 11:13:14','2025-05-26 11:55:13','2025-05-26 11:55:19','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:15:\"perbedaanbudaya\";i:436;s:5:\"flora\";i:437;s:16:\"keberagamanagama\";i:438;s:3:\"ras\";i:439;s:6:\"pantai\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:11:\"keberagaman\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:4;s:4:\"C, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:7:\"B, D, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('308','5','17','154','ASAG','2025-05-26 11:13:22','2025-05-26 11:49:54','2025-05-26 11:50:30','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:18:\"daerahmasingmasing\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:11:\"bersamasama\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kerjasama\";i:442;s:11:\"kebersamaan\";i:443;s:15:\"saling menolong\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,443,442,441,440,439,438,437,436,435,434,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"C, D, A, B\";i:431;s:10:\"A, B, D, C\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('309','5','17','133','ASAG','2025-05-26 11:13:46','2025-05-26 11:55:11','2025-05-26 11:55:17','3','7',NULL,'21','21',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"B\";i:5;s:1:\"B\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"A\";i:144;s:1:\"A\";}','a:10:{i:434;s:5:\"cewek\";i:435;s:13:\"berbeda beda \";i:436;s:4:\"aceh\";i:437;s:21:\"kebersihan lingkungan\";i:438;s:5:\"tubuh\";i:439;s:5:\"tubuh\";i:440;s:8:\"olahraga\";i:441;s:4:\"adap\";i:442;s:26:\"karna ada orang yang bantu\";i:443;s:37:\"yang bersifat baik untuk membantu nya\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:1:\"B\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:1:\"D\";i:147;s:1:\"A\";i:431;s:1:\"B\";i:432;s:1:\"B\";i:433;s:1:\"B\";}');
INSERT INTO `nilai` VALUES ('310','5','17','172','ASAG','2025-05-26 11:14:42','2025-05-26 11:41:45','2025-05-26 11:42:56','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kerjasama\";i:442;s:14:\"ketergantungan\";i:443;s:9:\"manusiawi\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('311','5','17','117','ASAG','2025-05-26 11:31:03','2025-05-26 11:58:35','2025-05-26 12:00:20','3','7',NULL,'21','25',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"B\";i:5;s:1:\"C\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"A\";i:144;s:1:\"D\";}','a:10:{i:434;s:4:\"laki\";i:435;s:4:\"lahu\";i:436;s:7:\"bayuace\";i:437;s:7:\"bayuace\";i:438;s:6:\"meliha\";i:439;s:5:\"fisik\";i:440;s:5:\"petak\";i:441;s:6:\"belaya\";i:442;s:3:\"air\";i:443;s:4:\"baik\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:1:\"B\";i:9;s:7:\"A, B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:7:\"A, D, C\";i:147;s:7:\"C, A, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('312','5','17','174','ASAG','2025-05-26 11:31:34','2025-05-26 11:51:28','2025-05-26 11:51:58','5','5',NULL,'35','42',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"perbedaan\";i:436;s:10:\"lagudaerah\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:15:\"pesisir/daratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:13:\"tanggungjawab\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"A, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:4:\"A, C\";i:431;s:4:\"B, D\";i:432;s:7:\"A, C, D\";i:433;s:4:\"C, B\";}');
INSERT INTO `nilai` VALUES ('313','5','17','147','ASAG','2025-05-26 11:32:11','2025-05-26 12:01:30','2025-05-26 12:01:33','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:21:\"keberagamanlingkungan\";i:435;s:23:\"mementingkandirisendiri\";i:436;s:4:\"aceh\";i:437;s:17:\"salingbekerjasama\";i:438;s:14:\"keberagamanras\";i:439;s:12:\"perbedaanras\";i:440;s:18:\"permainanjamandulu\";i:441;s:15:\"bertangungjawab\";i:442;s:23:\"kerjasamasalingmembantu\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','3','0','0','10','2','0','5','0','6','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"C\";i:142;s:1:\"C\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, C, D\";i:147;s:10:\"D, C, A, B\";i:431;s:10:\"A, B, D, C\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('314','6','15','164','ASAG','2025-05-26 11:38:36','2025-05-26 12:05:42','2025-05-26 12:06:01','4','6',NULL,'28','37',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:14:\"meluruskankaki\";i:423;s:4:\"yoga\";i:424;s:7:\"jasmani\";i:425;s:3:\"zat\";i:426;s:5:\"tubuh\";i:427;s:2:\"10\";i:428;s:8:\"senamskj\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:411;s:4:\"B, D\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('315','6','15','169','ASAG','2025-05-26 11:38:40','2025-05-26 12:05:12','2025-05-26 12:05:44','6','4',NULL,'42','59',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:11:\"pendinginan\";i:423;s:6:\"lantai\";i:424;s:6:\"remaja\";i:425;s:9:\"perubahan\";i:426;s:3:\"gas\";i:427;s:1:\"6\";i:428;s:8:\"tumbling\";i:429;s:5:\"kanan\";i:430;s:7:\"tongkat\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,426,422,427,424,429,425,421,423,430,428,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('316','6','15','127','ASAG','2025-05-26 11:38:43','2025-05-26 12:00:46','2025-05-26 12:01:30','5','5',NULL,'35','49',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:5:\"tubuh\";i:425;s:8:\"kegiatan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:1:\"C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"B, A, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('317','6','15','118','ASAG','2025-05-26 11:38:43','2025-05-26 12:01:08','2025-05-26 12:01:31','6','4',NULL,'42','61',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:8:\"olahraga\";i:426;s:4:\"besi\";i:427;s:1:\"9\";i:428;s:10:\"peregangan\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,430,429,428,427,426,425,424,423,422,421,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('318','6','15','126','ASAG','2025-05-26 11:38:43','2025-05-26 11:57:33','2025-05-26 12:00:44','6','4',NULL,'42','56',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:8:\"kekuatan\";i:426;s:8:\"zat besi\";i:427;s:1:\"8\";i:428;s:10:\"peregangan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:1:\"D\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('319','6','15','125','ASAG','2025-05-26 11:38:47','2025-05-26 11:57:15','2025-05-26 12:00:37','6','4',NULL,'42','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"rebah\";i:423;s:11:\"senamlantai\";i:424;s:5:\"tubuh\";i:425;s:5:\"saraf\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:26:\"senamyangdilakukandilantai\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','4','10','4','0','1','0','2','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('320','6','15','124','ASAG','2025-05-26 11:38:47','2025-05-26 12:06:04','2025-05-26 12:06:09','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"gizi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','3','3','0','1','7','2','0','4','3','6','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"B, A, D, C\";i:418;s:7:\"D, A, C\";i:419;s:7:\"B, D, C\";i:420;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('321','6','15','119','ASAG','2025-05-26 11:38:53','2025-05-26 12:00:04','2025-05-26 12:00:46','3','7',NULL,'21','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:7:\"jongkok\";i:423;s:10:\"senammusik\";i:424;s:5:\"badan\";i:425;s:8:\"kekuatan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"7\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('322','6','15','170','ASAG','2025-05-26 11:38:53','2025-05-26 12:04:35','2025-05-26 12:05:43','2','8',NULL,'14','21',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"telur\";i:425;s:5:\"tubuh\";i:426;s:10:\"zatprotein\";i:427;s:1:\"6\";i:428;s:10:\"senamirama\";i:429;s:7:\"sampimg\";i:430;s:6:\"lantai\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, D, C, B\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('323','6','15','166','ASAG','2025-05-26 11:41:59','2025-05-26 12:07:22','2025-05-26 12:08:29','3','7',NULL,'21','37',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:12:\"luruskedepan\";i:423;s:13:\"senamberirama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:8:\"seltelur\";i:427;s:1:\"6\";i:428;s:8:\"tumbling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('324','6','15','123','ASAG','2025-05-26 11:42:08','2025-05-26 12:04:47','2025-05-26 12:04:52','4','6',NULL,'28','38',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:18:\"pegangtulangkering\";i:423;s:5:\"irama\";i:424;s:7:\"nutrisi\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:0:\"\";i:428;s:24:\"senamygdilakukandimatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('325','6','15','171','ASAG','2025-05-26 11:42:10','2025-05-26 12:06:51','2025-05-26 12:07:19','3','7',NULL,'21','36',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:10:\"rolkedepan\";i:422;s:7:\"jongkok\";i:423;s:11:\"senamlantai\";i:424;s:8:\"anakanak\";i:425;s:7:\"protein\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:22:\"senammenggunakanmatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','3','1','0','5','7','4','0','0','3','2','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"B, C, D\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('326','6','15','168','ASAG','2025-05-26 11:42:42','2025-05-26 12:08:45','2025-05-26 12:08:54','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:5:\"fisik\";i:426;s:12:\"keseimbangan\";i:427;s:1:\"6\";i:428;s:8:\"tumbling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','3','2','0','2','7','3','0','3','3','4','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, D, C\";i:419;s:10:\"B, D, A, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('327','6','15','141','ASAG','2025-05-26 11:42:47','2025-05-26 12:06:41','2025-05-26 12:06:58','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:9:\"berbaring\";i:423;s:10:\"senamceria\";i:424;s:5:\"fisik\";i:425;s:23:\"kekuatanmentaldansosial\";i:426;s:8:\"zataktif\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:8:\"balakang\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,430,429,428,427,426,425,424,423,422,421,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, A, C, D\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('328','6','15','142','ASAG','2025-05-26 11:42:58','2025-05-26 12:05:45','2025-05-26 12:06:08','5','5',NULL,'35','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otot\";i:425;s:7:\"tekanan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('329','6','15','132','ASAG','2025-05-26 11:43:10','2025-05-26 12:02:46','2025-05-26 12:03:46','6','4',NULL,'42','57',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','3','2','0','4','7','3','0','1','3','4','','8','a:5:{i:411;s:4:\"A, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, C, A, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('330','6','15','172','ASAG','2025-05-26 11:43:13','2025-05-26 12:03:34','2025-05-26 12:04:31','7','3',NULL,'49','62',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:13:\"senamberirama\";i:424;s:5:\"badan\";i:425;s:9:\"linkungan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:12:\"kiridankanan\";i:430;s:11:\"senammatras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"B\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('331','6','15','157','ASAG','2025-05-26 11:43:31','2025-05-26 12:07:48','2025-05-26 12:07:56','1','9',NULL,'7','24',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"tetap\";i:423;s:6:\"lantai\";i:424;s:5:\"tubuh\";i:425;s:11:\"lingkungan \";i:426;s:7:\"vitamin\";i:427;s:2:\"10\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:7:\"mantras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,430,429,428,427,426,425,424,423,422,421,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','4','0','4','9','1','0','1','1','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('332','6','15','136','ASAG','2025-05-26 11:43:55','2025-05-26 12:06:19','2025-05-26 12:06:38','6','4',NULL,'42','57',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:5:\"duduk\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:5:\"sikap\";i:429;s:4:\"kiri\";i:430;s:27:\"yangmenguatkanototdantulang\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:1:\"A\";i:414;s:4:\"A, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('333','6','15','135','ASAG','2025-05-26 11:43:56','2025-05-26 12:11:04','2025-05-26 12:11:37','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"D\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:28:\" gerakanyangdiawalisikapawal\";i:422;s:15:\"gulingkebelakng\";i:423;s:10:\"senamsehat\";i:424;s:26:\"mengganggupertenaanmanusia\";i:425;s:7:\"manusia\";i:426;s:10:\" indonesia\";i:427;s:2:\"10\";i:428;s:14:\"senamanaksehat\";i:429;s:17:\" gulingkebelakang\";i:430;s:16:\"senammentaripagi\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, D, C\";i:417;s:7:\"B, C, A\";i:418;s:10:\"A, C, B, D\";i:419;s:10:\"B, A, C, D\";i:420;s:10:\"A, B, D, C\";}');
INSERT INTO `nilai` VALUES ('334','6','15','160','ASAG','2025-05-26 11:44:24','2025-05-26 12:09:30','2025-05-26 12:10:40','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"lurus\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:8:\"belakang\";i:430;s:7:\"mantras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:1:\"C\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"C, B, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('335','6','15','140','ASAG','2025-05-26 11:44:24','2025-05-26 12:06:06','2025-05-26 12:06:10','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:12:\"lantaiguling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:4:\"masa\";i:425;s:10:\"lingkungan\";i:426;s:8:\"pubertas\";i:427;s:1:\"8\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"A, D, C\";i:418;s:7:\"D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:7:\"C, D, A\";}');
INSERT INTO `nilai` VALUES ('336','6','15','144','ASAG','2025-05-26 11:44:26','2025-05-26 12:13:17','2025-05-26 12:13:47','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:12:\"rollingdepan\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:4:\"otot\";i:425;s:4:\"otot\";i:426;s:13:\"zatputihtelur\";i:427;s:1:\"9\";i:428;s:9:\"kebugaran\";i:429;s:4:\"kiri\";i:430;s:6:\"martas\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,426,422,427,424,429,425,421,423,430,428,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','4','0','1','9','1','0','4','1','8','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('337','6','15','121','ASAG','2025-05-26 11:44:28','2025-05-26 12:07:57','2025-05-26 12:08:02','8','2',NULL,'56','68',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:10:\"berbaring \";i:423;s:6:\"irama \";i:424;s:9:\"dayatahan\";i:425;s:8:\"kondisi \";i:426;s:7:\"zatbesi\";i:427;s:1:\"7\";i:428;s:5:\"yoga \";i:429;s:6:\"kanan \";i:430;s:7:\"matras \";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','0','1','0','5','10','4','0','0','0','2','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('338','6','15','130','ASAG','2025-05-26 11:44:29','2025-05-26 11:58:03','2025-05-26 11:58:34','2','8',NULL,'14','27',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:12:\"startjongkok\";i:422;s:11:\"gulingdepan\";i:423;s:7:\"aerobik\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:4:\"1jam\";i:428;s:7:\"aerobik\";i:429;s:10:\"kirimatras\";i:430;s:5:\"radio\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','5','9','4','0','0','1','2','','10','a:5:{i:411;s:4:\"B, D\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('339','6','15','143','ASAG','2025-05-26 11:44:57','2025-05-26 12:12:33','2025-05-26 12:12:57','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:4:\"anak\";i:425;s:4:\"mani\";i:426;s:4:\"mani\";i:427;s:1:\"9\";i:428;s:6:\"matras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, C, A, D\";i:419;s:7:\"C, B, A\";i:420;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('340','6','15','150','ASAG','2025-05-26 11:45:01','2025-05-26 12:12:32','2025-05-26 12:12:48','6','4',NULL,'42','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:21:\"bergulingluruskedepan\";i:422;s:7:\"jongkok\";i:423;s:13:\"senamberirama\";i:424;s:4:\"otot\";i:425;s:9:\"kesehatan\";i:426;s:6:\"energi\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:5:\"kanan\";i:430;s:11:\"senammatras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:411;s:7:\"B, C, D\";i:412;s:1:\"B\";i:413;s:4:\"B, C\";i:414;s:7:\"A, B, C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"B, D, C, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('341','6','15','145','ASAG','2025-05-26 11:45:02','2025-05-26 12:08:10','2025-05-26 12:08:41','3','7',NULL,'21','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:13:\"senamberirama\";i:424;s:4:\"gizi\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"vitamin\";i:427;s:16:\"tidurminimal8jam\";i:428;s:7:\"latihan\";i:429;s:5:\"kanan\";i:430;s:24:\"matrassepertigulingdepan\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','0','2','0','5','10','3','0','0','0','4','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:1:\"D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('342','6','15','122','ASAG','2025-05-26 11:45:03','2025-05-26 12:11:31','2025-05-26 12:11:55','4','6',NULL,'28','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:4:\"gizi\";i:427;s:5:\"10jam\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:7:\"D, B, A\";i:419;s:7:\"C, A, D\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('343','6','15','162','ASAG','2025-05-26 11:45:34','2025-05-26 12:11:32','2025-05-26 12:11:58','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"gizi\";i:425;s:7:\"kondisi\";i:426;s:7:\"protein\";i:427;s:1:\"7\";i:428;s:11:\"senammatras\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:411;s:7:\"B, C, D\";i:412;s:7:\"A, B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('344','6','15','161','ASAG','2025-05-26 11:45:43','2025-05-26 12:12:05','2025-05-26 12:12:28','3','7',NULL,'21','22',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"lurus\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:8:\"belakang\";i:430;s:7:\"mantras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,426,422,427,424,429,425,421,423,430,428,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"D, C, B, A\";i:418;s:10:\"C, B, A, D\";i:419;s:10:\"C, B, D, A\";i:420;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('345','6','15','151','ASAG','2025-05-26 11:45:57','2025-05-26 12:07:31','2025-05-26 12:08:00','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:13:\"starjarakjauh\";i:422;s:12:\"gulingguling\";i:423;s:11:\"senamlantai\";i:424;s:15:\"badancepatcapek\";i:425;s:11:\"dirisendiri\";i:426;s:8:\"zattelur\";i:427;s:4:\"8jam\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:1:\"A\";i:414;s:1:\"D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"C, A, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('346','6','15','153','ASAG','2025-05-26 11:46:26','2025-05-26 12:13:23','2025-05-26 12:13:43','7','3',NULL,'49','63',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:9:\"kesehatan\";i:426;s:10:\"putihtelur\";i:427;s:1:\"9\";i:428;s:9:\"kebugaran\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,426,422,427,424,429,425,421,423,430,428,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, C, D\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"A, B, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('347','6','15','158','ASAG','2025-05-26 11:46:58','2025-05-26 12:11:07','2025-05-26 12:11:27','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:6:\"guling\";i:423;s:10:\"senamsemen\";i:424;s:11:\"tinggibadan\";i:425;s:9:\"kesehatan\";i:426;s:8:\"zatdarah\";i:427;s:1:\"9\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"B, D\";i:414;s:1:\"A\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('348','6','15','156','ASAG','2025-05-26 11:47:02','2025-05-26 12:14:14','2025-05-26 12:14:27','3','7',NULL,'21','23',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:12:\"lantaiguling\";i:422;s:7:\"kedepan\";i:423;s:11:\"senamlantai\";i:424;s:9:\"bukbertas\";i:425;s:7:\"pikiran\";i:426;s:8:\"zat cair\";i:427;s:4:\"2213\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:10:\"senamirama\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, C, D\";i:417;s:10:\"B, A, C, D\";i:418;s:7:\"D, B, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('349','6','15','155','ASAG','2025-05-26 11:47:09','2025-05-26 12:11:32','2025-05-26 12:11:53','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:7:\"pikiran\";i:426;s:13:\"seldarahputih\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"C\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('350','6','15','137','ASAG','2025-05-26 11:47:38','2025-05-26 12:08:34','2025-05-26 12:08:58','5','5',NULL,'35','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"A\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"rolldepan\";i:422;s:12:\"rollbelakang\";i:423;s:10:\"senamirama\";i:424;s:10:\"tidaksehat\";i:425;s:18:\"padausiasebelumnya\";i:426;s:13:\"zatputihtelur\";i:427;s:1:\"8\";i:428;s:9:\"rolldepan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"C\";i:413;s:1:\"B\";i:414;s:1:\"D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('351','6','15','149','ASAG','2025-05-26 11:48:05','2025-05-26 12:00:43','2025-05-26 12:00:11','2','8',NULL,'14','15',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"D\";i:410;s:1:\"A\";}','a:10:{i:421;s:8:\"hhhhhuku\";i:422;s:5:\"tidur\";i:423;s:1:\"-\";i:424;s:1:\"-\";i:425;s:1:\"-\";i:426;s:1:\"-\";i:427;s:1:\"5\";i:428;s:2:\"sy\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,430,429,428,427,426,425,424,423,422,421,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, C\";i:413;s:4:\"A, D\";i:414;s:4:\"A, B\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"D, B, A, C\";i:418;s:10:\"A, D, C, B\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('352','6','15','129','ASAG','2025-05-26 11:49:06','2025-05-26 12:10:11','2025-05-26 12:10:45','3','7',NULL,'21','24',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:7:\"gerakan\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:8:\"pubertas\";i:425;s:9:\"kesehatan\";i:426;s:3:\"zat\";i:427;s:7:\"singkat\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,428,430,423,421,425,429,424,427,422,426,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"C\";i:414;s:4:\"A, D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, D, C\";i:417;s:10:\"B, C, A, D\";i:418;s:10:\"D, C, B, A\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('353','6','15','139','ASAG','2025-05-26 11:49:11','2025-05-26 12:07:16','2025-05-26 12:07:23','2','8',NULL,'14','14',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:12:\"starmelayang\";i:422;s:8:\"langsung\";i:423;s:12:\"senampinggul\";i:424;s:5:\"tubuh\";i:425;s:5:\"tubuh\";i:426;s:11:\"pertumbuhan\";i:427;s:7:\"awaljam\";i:428;s:9:\"kesehatan\";i:429;s:10:\"starguling\";i:430;s:4:\"yoga\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;s:1:\"A\";i:412;s:1:\"A\";i:413;s:4:\"A, B\";i:414;s:1:\"C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"C, B, A, D\";i:417;s:10:\"A, C, B, D\";i:418;s:10:\"A, C, D, B\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('354','6','15','138','ASAG','2025-05-26 11:49:47','2025-05-26 12:07:12','2025-05-26 12:07:42','4','6',NULL,'28','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"C\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:5:\"sehat\";i:423;s:11:\"senamlantai\";i:424;s:5:\"sehat\";i:425;s:8:\"olahraga\";i:426;s:3:\"zat\";i:427;s:13:\"biargangantuk\";i:428;s:8:\"olahraga\";i:429;s:4:\"baik\";i:430;s:6:\" badan\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','3','10','5','0','2','0','0','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"C, B, A, D\";i:420;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('355','6','15','165','ASAG','2025-05-26 11:49:56','2025-05-26 12:10:43','2025-05-26 12:10:59','2','8',NULL,'14','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:6:\"guling\";i:423;s:11:\"senamlantai\";i:424;s:7:\"jasmani\";i:425;s:3:\"sel\";i:426;s:9:\"istirahat\";i:427;s:1:\"6\";i:428;s:3:\"psk\";i:429;s:5:\"kanan\";i:430;s:5:\"irama\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('356','6','15','120','ASAG','2025-05-26 11:50:48','2025-05-26 12:07:38','2025-05-26 12:08:32','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"D\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:9:\"jongkok  \";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:6:\"remaja\";i:426;s:5:\"tubuh\";i:427;s:2:\"10\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"D\";i:413;s:1:\"A\";i:414;s:1:\"C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"C, D, A, B\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('357','6','15','148','ASAG','2025-05-26 11:50:49','2025-05-26 12:11:53','2025-05-26 12:11:57','5','5',NULL,'35','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"C\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:5:\"tubuh\";i:425;s:9:\"keteguhan\";i:426;s:14:\"zatpertumbuhan\";i:427;s:4:\"6jam\";i:428;s:11:\"senamlantai\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','3','8','5','0','2','2','0','','6','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('358','6','15','152','ASAG','2025-05-26 11:50:57','2025-05-26 12:15:16','2025-05-26 12:15:41','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"lari\";i:422;s:5:\"senam\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"tubuh\";i:426;s:10:\"putihtelur\";i:427;s:1:\"9\";i:428;s:10:\"kebungaran\";i:429;s:5:\"kanan\";i:430;s:9:\"headstand\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,430,429,428,427,426,425,424,423,422,421,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','5','10','4','0','0','0','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, C, D\";i:413;s:4:\"A, C\";i:414;s:4:\"B, D\";i:415;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('359','6','15','128','ASAG','2025-05-26 11:51:01','2025-05-26 12:10:51','2025-05-26 12:11:19','4','6',NULL,'28','30',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"makanan\";i:427;s:2:\"10\";i:428;s:9:\"aktivitas\";i:429;s:7:\"sampimg\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:411;s:1:\"B\";i:412;s:1:\"D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, C\";i:417;s:7:\"A, D, C\";i:418;s:1:\"A\";i:419;s:4:\"B, C\";i:420;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('360','6','15','154','ASAG','2025-05-26 11:51:07','2025-05-26 12:13:08','2025-05-26 12:13:50','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:3:\"rol\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:6:\"remaja\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:11:\"senamsantai\";i:429;s:5:\"kanan\";i:430;s:7:\"mantras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"B, A, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('361','6','15','173','ASAG','2025-05-26 11:51:54','2025-05-26 12:11:47','2025-05-26 12:12:06','4','6',NULL,'28','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:15:\"guling ke depan\";i:422;s:9:\"telentang\";i:423;s:11:\"senam bebas\";i:424;s:7:\"manusia\";i:425;s:7:\"manusia\";i:426;s:7:\"makanan\";i:427;s:2:\"12\";i:428;s:11:\"senam bebas\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:4:\"B, C\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"B, A, C, D\";i:417;s:10:\"B, A, C, D\";i:418;s:7:\"D, B, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, A, C, B\";}');
INSERT INTO `nilai` VALUES ('362','6','15','174','ASAG','2025-05-26 11:52:10','2025-05-26 12:13:13','2025-05-26 12:13:17','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:1:\"2\";i:422;s:9:\"rangkain3\";i:423;s:8:\"berirama\";i:424;s:9:\"kesehatan\";i:425;s:9:\"kesehatan\";i:426;s:7:\"zatcair\";i:427;s:2:\"10\";i:428;s:9:\"senamroll\";i:429;s:9:\"disamping\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,428,430,423,421,425,429,424,427,422,426,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"C, B, A, D\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"B, A, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('363','6','15','131','ASAG','2025-05-26 11:52:42','2025-05-26 12:09:38','2025-05-26 12:09:43','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"musik\";i:424;s:4:\"otot\";i:425;s:11:\"pertumbuhan\";i:426;s:8:\"zattelur\";i:427;s:4:\"8jam\";i:428;s:7:\"olahrga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','3','8','5','0','2','2','0','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"B, C, D\";i:414;s:1:\"D\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('364','6','15','167','ASAG','2025-05-26 11:53:11','2025-05-26 12:12:29','2025-05-26 12:12:32','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:11:\"senamlantai\";i:424;s:5:\"badan\";i:425;s:5:\"badan\";i:426;s:4:\"otot\";i:427;s:1:\"7\";i:428;s:13:\"senamdilantai\";i:429;s:8:\"membantu\";i:430;s:13:\"senamdilantai\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('365','6','15','146','ASAG','2025-05-26 11:53:32','2025-05-26 12:13:43','2025-05-26 12:14:07','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:5:\"start\";i:422;s:10:\"sikaplilin\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:2:\"11\";i:428;s:40:\"senamyangdilakukandiataslantaiataumatras\";i:429;s:7:\"samping\";i:430;s:63:\"matrassenamlantaiadalahsenamyangdilakukandiataslantaiataumatras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"A, B, D\";i:417;s:10:\"A, B, D, C\";i:418;s:4:\"B, C\";i:419;s:7:\"A, B, C\";i:420;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('366','6','15','159','ASAG','2025-05-26 11:54:34','2025-05-26 12:12:48','2025-05-26 12:13:04','3','7',NULL,'21','25',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"D\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:16:\"gulingkebelakang\";i:422;s:7:\"berdiri\";i:423;s:13:\"senamberirama\";i:424;s:4:\"anak\";i:425;s:9:\"perasaaan\";i:426;s:10:\"putihtelur\";i:427;s:1:\"1\";i:428;s:4:\"yoga\";i:429;s:5:\"sudut\";i:430;s:11:\"kayupanjang\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:411;s:4:\"A, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:1:\"B\";i:417;s:10:\"A, D, C, B\";i:418;s:7:\"D, B, A\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('367','6','15','163','ASAG','2025-05-26 11:55:33','2025-05-26 12:15:47','2025-05-26 12:15:51','2','8',NULL,'14','27',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"rool\";i:422;s:8:\"belakang\";i:423;s:6:\"lantai\";i:424;s:4:\"otak\";i:425;s:9:\"puberitas\";i:426;s:0:\"\";i:427;s:1:\"8\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('368','6','15','133','ASAG','2025-05-26 11:55:54','2025-05-26 12:18:17','2025-05-26 12:18:23','2','8',NULL,'14','14',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"pus ap\";i:422;s:10:\"sikap baik\";i:423;s:12:\"senam lantai\";i:424;s:42:\"memakan goreng gorengan itu kuramg bergizi\";i:425;s:15:\"14tahun ke atas\";i:426;s:15:\"makanan sayuran\";i:427;s:6:\"jam 10\";i:428;s:8:\"olahraga\";i:429;s:8:\"olahraga\";i:430;s:12:\"senam lantai\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:411;s:1:\"A\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:4:\"B, D\";i:417;s:7:\"C, D, A\";i:418;s:4:\"B, D\";i:419;s:7:\"A, C, D\";i:420;s:4:\"A, B\";}');
INSERT INTO `nilai` VALUES ('369','6','15','134','ASAG','2025-05-26 11:56:28','2025-05-26 12:14:42','2025-05-26 12:15:01','2','8',NULL,'14','15',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:5:\"lfjgj\";i:425;s:4:\"jhgf\";i:426;s:3:\"ffg\";i:427;s:4:\"5jam\";i:428;s:5:\"senam\";i:429;s:13:\"sampingmatras\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"C, D\";i:413;s:7:\"B, C, D\";i:414;s:4:\"A, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, A, D\";i:417;s:4:\"B, C\";i:418;s:4:\"A, D\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('370','7','17','211','ASAG','2025-05-26 12:26:46','2025-05-26 13:00:00','2025-05-26 13:00:06','10','0',NULL,'70','85',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:12:\"adatistiadat\";i:436;s:5:\"flora\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:7:\"sekitar\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"B, C, D\";i:141;s:7:\"A, B, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('371','7','17','188','ASAG','2025-05-26 12:26:47','2025-05-26 12:52:36','2025-05-26 12:53:18','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:4:\"suku\";i:437;s:10:\"adanyasuku\";i:438;s:14:\"keberagamanras\";i:439;s:37:\"kawasankebersamaantanpamemandangfisik\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:12:\"gotongroyong\";i:443;s:7:\"positif\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,443,442,441,440,439,438,437,436,435,434,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:4;s:4:\"B, C\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:7:\"B, C, D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('372','7','17','192','ASAG','2025-05-26 12:26:48','2025-05-26 12:40:23','2025-05-26 12:41:11','8','2',NULL,'56','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:18:\"keberagaman gender\";i:435;s:14:\"suku pedalaman\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:5:\"rumah\";i:440;s:20:\"pemainan tradisional\";i:441;s:13:\"tangung jawab\";i:442;s:9:\"kerukunan\";i:443;s:9:\"kerjasama\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:4;s:7:\"A, C, D\";i:9;s:4:\"A, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('373','7','17','229','ASAG','2025-05-26 12:26:48','2025-05-26 12:47:25','2025-05-26 12:49:21','9','1',NULL,'63','82',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:16:\"rasantargolongan\";i:439;s:17:\"daratandanpesisir\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:13:\"rasapersatuan\";i:443;s:10:\"masyarakat\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','1','5','0','4','9','0','0','1','1','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('374','7','17','232','ASAG','2025-05-26 12:26:50','2025-05-26 12:44:50','2025-05-26 12:45:36','8','2',NULL,'56','65',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:8:\"kebiasan\";i:436;s:5:\"musik\";i:437;s:15:\"yangberbedabeda\";i:438;s:3:\"ras\";i:439;s:33:\"yangbanyakorangataukawankawankita\";i:440;s:11:\"mainanlokal\";i:441;s:13:\"tanggungjawab\";i:442;s:8:\"kelompok\";i:443;s:11:\"bersamasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:7:\"C, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('375','7','17','209','ASAG','2025-05-26 12:27:02','2025-05-26 13:05:09','2025-05-26 13:05:38','4','6',NULL,'28','38',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"B\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"C\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:9:\"perbedaan\";i:435;s:11:\"keberagaman\";i:436;s:4:\"aceh\";i:437;s:18:\"keberagamansendiri\";i:438;s:6:\"daerah\";i:439;s:16:\"kawasanperkotaan\";i:440;s:8:\"darijawa\";i:441;s:11:\"tanggujawab\";i:442;s:9:\"persatuan\";i:443;s:17:\"gotongroyongfisik\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,443,442,441,440,439,438,437,436,435,434,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','0','3','0','2','10','2','0','3','0','6','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, D, A\";i:147;s:0:\"\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('376','7','17','189','ASAG','2025-05-26 12:27:05','2025-05-26 12:56:52','2025-05-26 12:58:09','8','2',NULL,'56','60',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"kebudayaan\";i:436;s:5:\"flora\";i:437;s:6:\"budaya\";i:438;s:6:\"gender\";i:439;s:7:\"sekitar\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:14:\"salingmembantu\";i:443;s:8:\"menolong\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,438,441,443,435,439,442,434,440,436,437,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:1:\"C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:7:\"B, A, C\";i:431;s:10:\"B, A, D, C\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('377','7','17','198','ASAG','2025-05-26 12:27:06','2025-05-26 12:55:32','2025-05-26 12:55:42','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:15:\"keberagamgender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:13:\"lagudantarian\";i:437;s:5:\"agama\";i:438;s:10:\"sukudanras\";i:439;s:6:\"budaya\";i:440;s:20:\"permainantradisional\";i:441;s:15:\"bergotongroyong\";i:442;s:8:\"pendapat\";i:443;s:5:\"fisik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:1:\"B\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:7:\"D, C, A\";i:147;s:10:\"C, D, A, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('378','7','17','205','ASAG','2025-05-26 12:27:09','2025-05-26 12:53:24','2025-05-26 12:56:11','4','6',NULL,'28','32',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:5:\"fisik\";i:435;s:11:\"kebhinekaan\";i:436;s:4:\"aceh\";i:437;s:6:\"budaya\";i:438;s:4:\"suku\";i:439;s:15:\"keberagamansuku\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:10:\"kepudulian\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,437,436,440,434,442,439,435,443,441,438,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"B, A, D, C\";i:431;s:1:\"A\";i:432;s:4:\"D, C\";i:433;s:7:\"D, C, B\";}');
INSERT INTO `nilai` VALUES ('379','7','17','181','ASAG','2025-05-26 12:27:13','2025-05-26 12:44:09','2025-05-26 12:45:03','8','2',NULL,'56','62',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"tidakpeduli\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:9:\"khebineka\";i:443;s:22:\"dilingkunganmasyarakat\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('380','7','17','177','ASAG','2025-05-26 12:27:17','2025-05-26 12:51:15','2025-05-26 12:52:15','8','2',NULL,'56','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:4:\"suku\";i:435;s:6:\"budaya\";i:436;s:4:\"aceh\";i:437;s:5:\"islam\";i:438;s:3:\"ras\";i:439;s:20:\"lingkunganmasyarakat\";i:440;s:15:\"budayaindonesia\";i:441;s:11:\"tanggujawab\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"salingmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:7:\"C, A, B\";i:147;s:7:\"D, A, C\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('381','7','17','201','ASAG','2025-05-26 12:27:24','2025-05-26 13:03:37','2025-05-26 13:04:48','8','2',NULL,'56','68',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:4:\"tari\";i:437;s:6:\"budaya\";i:438;s:6:\"gender\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:13:\"rasapersatuan\";i:443;s:5:\"agama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','4','0','2','10','1','0','3','0','8','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('382','7','17','215','ASAG','2025-05-26 12:27:30','2025-05-26 13:08:25','2025-05-26 13:08:32','5','5',NULL,'35','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:8:\"sukuadat\";i:436;s:5:\"flora\";i:437;s:8:\"sukuadat\";i:438;s:4:\"suku\";i:439;s:7:\"daratan\";i:440;s:20:\"permainantradisional\";i:441;s:6:\"aturan\";i:442;s:12:\"rasakesatuan\";i:443;s:11:\"keperdulian\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','4','0','3','10','1','0','2','0','8','','6','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:7:\"B, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('383','7','17','221','ASAG','2025-05-26 12:27:31','2025-05-26 13:02:49','2025-05-26 13:03:01','8','2',NULL,'56','76',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:25:\"sukuyangdiciptakansendiri\";i:436;s:16:\"musiktradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:8:\"disiplin\";i:442;s:9:\"persatuan\";i:443;s:6:\"budaya\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('384','7','17','226','ASAG','2025-05-26 12:27:34','2025-05-26 13:00:00','2025-05-26 13:00:35','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:18:\"keberagaman gender\";i:435;s:14:\"individualisme\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:14:\"keberagamanras\";i:439;s:8:\"keluarga\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:14:\"salingmenolong\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:7:\"A, B, D\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:7:\"C, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('385','7','17','175','ASAG','2025-05-26 12:27:43','2025-05-26 12:52:20','2025-05-26 12:52:54','3','7',NULL,'21','27',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:13:\"suku dan adat\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:19:\"adat mereka sendiri\";i:438;s:9:\"suku adat\";i:439;s:5:\"hewan\";i:440;s:17:\"permainan tradisi\";i:441;s:10:\"kerja sama\";i:442;s:15:\"saling membantu\";i:443;s:8:\"membantu\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','2','0','1','10','3','0','4','0','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, B, D\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('386','7','17','183','ASAG','2025-05-26 12:27:46','2025-05-26 12:50:59','2025-05-26 12:51:05','9','1',NULL,'63','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"adat\";i:436;s:5:\"lokal\";i:437;s:10:\"sukudanras\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:19:\"permainatradisional\";i:441;s:12:\"tangungjawab\";i:442;s:9:\"persatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:7:\"A, D, B\";i:147;s:4:\"C, D\";i:431;s:4:\"A, B\";i:432;s:1:\"A\";i:433;s:7:\"D, C, A\";}');
INSERT INTO `nilai` VALUES ('387','7','17','200','ASAG','2025-05-26 12:27:59','2025-05-26 12:43:44','2025-05-26 12:48:13','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:10:\"taridaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:9:\"perbedaan\";i:443;s:4:\"baik\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('388','7','17','185','ASAG','2025-05-26 12:27:59','2025-05-26 12:55:01','2025-05-26 12:55:06','7','3',NULL,'49','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:16:\"perbedaankelamin\";i:435;s:24:\"perbedaanantarasukujenis\";i:436;s:22:\"perbedaansukudandaerah\";i:437;s:24:\"agamadanadatmasingmasing\";i:438;s:16:\"keberagamanfisik\";i:439;s:11:\"antardaerah\";i:440;s:7:\"bermain\";i:441;s:36:\"persatuankesatuandilingkungansekolah\";i:442;s:9:\"persatuan\";i:443;s:20:\"salingtolongmenolong\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:10:\"A, B, C, D\";i:9;s:10:\"A, B, C, D\";i:141;s:10:\"A, B, C, D\";i:142;s:10:\"A, B, C, D\";i:145;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, B, A, D\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('389','7','17','195','ASAG','2025-05-26 12:28:01','2025-05-26 12:54:58','2025-05-26 12:56:01','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:12:\"perbedaanras\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:23:\"pesisirdandatarantinggi\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:23:\"interaksiterhadapsesama\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, D\";i:141;s:4:\"B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('390','7','17','206','ASAG','2025-05-26 12:28:01','2025-05-26 12:54:31','2025-05-26 12:54:37','9','1',NULL,'63','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:11:\"antargender\";i:435;s:10:\"bedabudaya\";i:436;s:4:\"seni\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:8:\"dispilin\";i:442;s:14:\"tujuanyangsama\";i:443;s:10:\"masyarakat\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,438,441,443,435,439,442,434,440,436,437,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"A, B, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('391','7','17','224','ASAG','2025-05-26 12:28:06','2025-05-26 12:48:47','2025-05-26 12:49:51','8','2',NULL,'56','72',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:16:\"musiktradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:13:\"tempattinggal\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:9:\"kerjasama\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,443,442,441,440,439,438,437,436,435,434,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:7:\"B, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('392','7','17','196','ASAG','2025-05-26 12:28:24','2025-05-26 13:01:59','2025-05-26 13:02:21','8','2',NULL,'56','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:6:\"musik \";i:437;s:6:\"agama \";i:438;s:10:\"cirifisik \";i:439;s:16:\"cirifisikmanusia\";i:440;s:7:\"budaya \";i:441;s:16:\"bertanggungjawab\";i:442;s:33:\"pekerjaanyangmembutuhkanoranglain\";i:443;s:13:\"bermusyawarah\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"A\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, B, D\";i:147;s:10:\"C, A, D, B\";i:431;s:4:\"D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('393','7','17','182','ASAG','2025-05-26 12:28:28','2025-05-26 12:52:27','2025-05-26 12:52:41','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:11:\"keberagaman\";i:436;s:5:\"flora\";i:437;s:16:\"keberagamanagama\";i:438;s:13:\"antargolongan\";i:439;s:18:\"pesisirataudaratan\";i:440;s:20:\"keberagamanpermainan\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"masyarakat\";i:443;s:13:\"bermasyarakat\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','3','0','2','10','2','0','3','0','6','','4','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, D, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"C, B, D, A\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('394','7','17','218','ASAG','2025-05-26 12:28:43','2025-05-26 12:49:56','2025-05-26 12:51:20','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberegamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:11:\"musikdaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','4','0','5','8','1','0','0','2','8','','10','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('395','7','17','190','ASAG','2025-05-26 12:28:43','2025-05-26 13:01:32','2025-05-26 13:01:38','7','3',NULL,'49','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamanbudaya\";i:435;s:11:\"keberagaman\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:15:\"keberagamansuku\";i:439;s:7:\"sekitar\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"kekompakan\";i:443;s:7:\"positif\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"B, A, C, D\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('396','7','17','228','ASAG','2025-05-26 12:28:46','2025-05-26 12:50:15','2025-05-26 12:50:53','9','1',NULL,'63','76',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:15:\"lagutradisional\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tujuanyangsama\";i:443;s:6:\"sosial\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','3','0','0','5','7','5','0','0','3','0','','10','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"B\";i:142;s:1:\"C\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('397','7','17','212','ASAG','2025-05-26 12:28:51','2025-05-26 13:02:41','2025-05-26 13:03:26','3','7',NULL,'21','23',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:4:\"ciri\";i:435;s:15:\"tidakmenghargai\";i:436;s:4:\"tari\";i:437;s:13:\"rassukubudaya\";i:438;s:14:\"ciricirmanusia\";i:439;s:7:\"pesisir\";i:440;s:0:\"\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"masyarakat\";i:443;s:18:\"membantumasyarakat\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,438,441,443,435,439,442,434,440,436,437,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:4;s:4:\"C, D\";i:9;s:4:\"A, D\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"A, D, C, B\";i:431;s:7:\"C, B, D\";i:432;s:4:\"A, B\";i:433;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('398','7','17','208','ASAG','2025-05-26 12:28:58','2025-05-26 13:04:49','2025-05-26 13:06:00','5','5',NULL,'35','35',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:32:\"lakibergotongroyongwanitamemasak\";i:435;s:15:\"perbedaanbudaya\";i:436;s:12:\"teradidional\";i:437;s:20:\"keberagamanindonesia\";i:438;s:10:\"bedanegara\";i:439;s:6:\"budaya\";i:440;s:5:\"papua\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"adakekurangang\";i:443;s:26:\"salingmembantusatusamalain\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:1:\"D\";i:9;s:1:\"B\";i:141;s:1:\"B\";i:142;s:1:\"C\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, D, C\";i:147;s:10:\"A, B, C, D\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"A, D, C, B\";}');
INSERT INTO `nilai` VALUES ('399','7','17','199','ASAG','2025-05-26 12:29:01','2025-05-26 12:47:32','2025-05-26 12:48:28','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"sukubangsa\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tujuanyangsama\";i:443;s:5:\"aktif\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('400','7','17','231','ASAG','2025-05-26 12:29:03','2025-05-26 12:54:50','2025-05-26 12:55:21','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:14:\"sukuataubudaya\";i:436;s:13:\"laguataumusik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:31:\"lingkunganataudaerahsekitarkita\";i:440;s:20:\"permainantradisional\";i:441;s:34:\"kerjasamamengikutiperaturansekolah\";i:442;s:83:\"pekerjaanyangtidakbisadiselesaikansendiriatausesuatuyangmembutuhkanbantuanoranglain\";i:443;s:9:\"kerjasama\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,443,442,441,440,439,438,437,436,435,434,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('401','7','17','213','ASAG','2025-05-26 12:29:13','2025-05-26 13:10:34','2025-05-26 13:10:39','7','3',NULL,'49','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:3:\"ras\";i:435;s:20:\"kepercayaanseseorang\";i:436;s:10:\"tarianaceh\";i:437;s:20:\"kepercayaanseseorang\";i:438;s:3:\"ras\";i:439;s:6:\"daerah\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:13:\"gotongroyong \";i:443;s:9:\"persatuan\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:1:\"B\";i:141;s:4:\"B, C\";i:142;s:4:\"C, D\";i:145;s:4:\"B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:7:\"B, D, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('402','7','17','186','ASAG','2025-05-26 12:29:33','2025-05-26 13:11:10','2025-05-26 13:14:18','4','6',NULL,'28','28',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"B\";}','a:10:{i:434;s:15:\"wanitaatauperia\";i:435;s:16:\"berbedabedaagama\";i:436;s:4:\"aceh\";i:437;s:62:\"berbedaagamayangmemukikanyakinatautidakkepadaagamamasingmasing\";i:438;s:16:\"berbedabedawarna\";i:439;s:9:\"masarakat\";i:440;s:9:\"anakkecil\";i:441;s:15:\"tugasseharihari\";i:442;s:9:\"masarakat\";i:443;s:21:\"baikdlambergotoroyong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:1:\"B\";i:9;s:1:\"A\";i:141;s:1:\"A\";i:142;s:1:\"B\";i:145;s:1:\"B\";}','a:0:{}','a:5:{i:146;s:10:\"C, B, D, A\";i:147;s:10:\"B, C, A, D\";i:431;s:10:\"B, A, C, D\";i:432;s:10:\"B, C, D, A\";i:433;s:7:\"C, B, D\";}');
INSERT INTO `nilai` VALUES ('403','7','17','217','ASAG','2025-05-26 12:29:37','2025-05-26 13:03:46','2025-05-26 13:04:48','8','2',NULL,'56','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:4:\"tari\";i:437;s:6:\"budaya\";i:438;s:6:\"gender\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:13:\"rasapersatuan\";i:443;s:5:\"agama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','4','0','0','10','1','0','5','0','8','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"B, C, A, D\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"C, D, A, B\";i:433;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('404','7','17','178','ASAG','2025-05-26 12:29:39','2025-05-26 12:53:57','2025-05-26 12:55:22','5','5',NULL,'35','38',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:18:\"keberagaman gender\";i:435;s:12:\"budaya iokal\";i:436;s:6:\"tarian\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:29:\"kawasan yang adil dan tentram\";i:440;s:21:\"permainan tradisional\";i:441;s:13:\"tangung jawab\";i:442;s:22:\"persatuan dan kesatuan\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','3','0','0','0','7','5','0','5','3','0','','0','a:5:{i:4;s:1:\"D\";i:9;s:1:\"C\";i:141;s:1:\"D\";i:142;s:1:\"C\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:4:\"C, D\";i:147;s:7:\"A, B, C\";i:431;s:4:\"C, B\";i:432;s:1:\"A\";i:433;s:7:\"C, B, A\";}');
INSERT INTO `nilai` VALUES ('405','7','17','202','ASAG','2025-05-26 12:29:40','2025-05-26 12:56:32','2025-05-26 12:57:52','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:30:\"berbedapendapatdenganoranglain\";i:436;s:5:\"flora\";i:437;s:17:\"keberagamanbudaya\";i:438;s:6:\"gender\";i:439;s:22:\"perdekatandenganpantai\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:17:\"rasatanggungjawab\";i:443;s:10:\"kekompakan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, B\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:7:\"C, D, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('406','7','17','216','ASAG','2025-05-26 12:29:42','2025-05-26 12:56:53','2025-05-26 12:57:13','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:19:\"pesisir dan daratan\";i:440;s:9:\"permainan\";i:441;s:13:\"gotong royong\";i:442;s:9:\"persatuan\";i:443;s:8:\"menolong\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,434,435,436,437,438,439,440,441,442,443,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','4','3','0','2','6','2','0','3','4','6','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('407','7','17','207','ASAG','2025-05-26 12:29:43','2025-05-26 12:56:52','2025-05-26 12:58:43','6','4',NULL,'42','48',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"sekitar\";i:440;s:9:\"permainan\";i:441;s:18:\"kewajibandisekolah\";i:442;s:20:\"persatuandankesatuan\";i:443;s:26:\"toleransidansalingmembantu\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,443,442,441,440,439,438,437,436,435,434,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:4;s:1:\"A\";i:9;s:1:\"A\";i:141;s:1:\"B\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:7:\"A, C, D\";i:433;s:7:\"D, C, A\";}');
INSERT INTO `nilai` VALUES ('408','7','17','223','ASAG','2025-05-26 12:29:43','2025-05-26 12:56:38','2025-05-26 12:56:46','7','3',NULL,'49','56',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:4:\"lagu\";i:437;s:17:\"keberagamanbudaya\";i:438;s:3:\"ras\";i:439;s:10:\"pemerintah\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"rasapeduli\";i:443;s:7:\"natural\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"B, D\";}','a:0:{}','a:5:{i:146;s:7:\"A, B, D\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('409','7','17','220','ASAG','2025-05-26 12:29:43','2025-05-26 13:14:00','2025-05-26 13:15:04','0','10',NULL,'0','0',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"X\";i:2;s:1:\"X\";i:3;s:1:\"X\";i:5;s:1:\"X\";i:6;s:1:\"X\";i:7;s:1:\"X\";i:8;s:1:\"X\";i:10;s:1:\"X\";i:143;s:1:\"X\";i:144;s:1:\"X\";}','a:10:{i:434;s:11:\"Tidak Diisi\";i:435;s:11:\"Tidak Diisi\";i:436;s:11:\"Tidak Diisi\";i:437;s:11:\"Tidak Diisi\";i:438;s:11:\"Tidak Diisi\";i:439;s:11:\"Tidak Diisi\";i:440;s:11:\"Tidak Diisi\";i:441;s:11:\"Tidak Diisi\";i:442;s:11:\"Tidak Diisi\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;N;i:9;N;i:141;N;i:142;N;i:145;N;}','a:0:{}','a:5:{i:146;N;i:147;N;i:431;N;i:432;N;i:433;N;}');
INSERT INTO `nilai` VALUES ('410','7','17','225','ASAG','2025-05-26 12:29:44','2025-05-26 13:01:52','2025-05-26 13:02:48','7','3',NULL,'49','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:23:\"kepercayaanmasingmasing\";i:436;s:4:\"aceh\";i:437;s:14:\"salingmemahami\";i:438;s:6:\"budaya\";i:439;s:8:\"kesatuan\";i:440;s:15:\"permainanbudaya\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:20:\"membantusatusamalain\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:1:\"A\";i:9;s:1:\"C\";i:141;s:1:\"D\";i:142;s:1:\"B\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:7:\"C, A, B\";i:431;s:7:\"D, C, A\";i:432;s:7:\"B, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('411','7','17','197','ASAG','2025-05-26 12:29:46','2025-05-26 12:54:57','2025-05-26 12:55:21','7','3',NULL,'49','69',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"flora\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:49:\"lingkungan yang mencangkup kawasan tempat tinggal\";i:440;s:21:\"permainan tradisional\";i:441;s:13:\"gotong royong\";i:442;s:28:\"karena adanya tujuan bersama\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,443,442,441,440,439,438,437,436,435,434,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','4','3','0','5','6','2','0','0','4','6','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:10:\"A, B, C, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('412','7','17','230','ASAG','2025-05-26 12:29:47','2025-05-26 12:50:33','2025-05-26 12:51:07','10','0',NULL,'70','81',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:17:\"sukuadatdanbudaya\";i:438;s:3:\"ras\";i:439;s:23:\"daratandantempattinggal\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"tangungjawab\";i:442;s:21:\"apersatuandankesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','10,3,6,144,7,8,143,1,2,5,437,436,440,434,442,439,435,443,441,438,142,9,141,145,4,433,147,431,432,146,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:4;s:10:\"A, B, C, D\";i:9;s:10:\"A, B, C, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, B, D\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('413','7','17','179','ASAG','2025-05-26 12:29:48','2025-05-26 12:48:04','2025-05-26 12:48:10','10','0',NULL,'70','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangander\";i:435;s:15:\"perbedaanbudaya\";i:436;s:8:\"kesenian\";i:437;s:15:\"yangberbedabeda\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:20:\"persatuandankesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"C, D\";i:141;s:4:\"C, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('414','7','17','194','ASAG','2025-05-26 12:29:49','2025-05-26 12:53:55','2025-05-26 12:54:53','7','3',NULL,'49','55',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:11:\"keberagaman\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:17:\"permainannasional\";i:441;s:13:\"tanggungjawab\";i:442;s:16:\"lingkungansosial\";i:443;s:4:\"satu\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"C\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('415','7','17','187','ASAG','2025-05-26 12:29:50','2025-05-26 12:49:31','2025-05-26 12:49:42','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:13:\"antargolongan\";i:436;s:8:\"kesenian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:19:\"permainantradisonal\";i:441;s:14:\"tolongmenolong\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"D, C, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('416','7','17','176','ASAG','2025-05-26 12:29:55','2025-05-26 12:51:28','2025-05-26 12:51:56','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:11:\"suku budaya\";i:436;s:10:\"perkawinan\";i:437;s:17:\"yang berbeda-beda\";i:438;s:10:\"kebudayaan\";i:439;s:11:\"yang bersih\";i:440;s:21:\"permainan tradisional\";i:441;s:13:\"gotong royong\";i:442;s:9:\"persatuan\";i:443;s:4:\"baik\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:4;s:1:\"B\";i:9;s:4:\"B, C\";i:141;s:1:\"C\";i:142;s:1:\"D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:0:\"\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('417','7','17','203','ASAG','2025-05-26 12:30:03','2025-05-26 13:04:50','2025-05-26 13:07:31','6','4',NULL,'42','48',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:28:\"keberagamanwanitadanlakisama\";i:435;s:16:\"tidakmenghargai \";i:436;s:4:\"aceh\";i:437;s:4:\"suku\";i:438;s:6:\"gender\";i:439;s:10:\"lingkungan\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tolongmenolong\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','0','0','3','10','5','0','2','0','0','','6','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"C\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:7:\"B, A, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('418','7','17','222','ASAG','2025-05-26 12:30:17','2025-05-26 12:46:51','2025-05-26 12:47:44','8','2',NULL,'56','72',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"kebhinekaan\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:16:\"bertanggungjawab\";i:442;s:10:\"hiduprukun\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,438,441,443,435,439,442,434,440,436,437,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('419','7','17','210','ASAG','2025-05-26 12:30:24','2025-05-26 12:56:58','2025-05-26 12:57:45','7','3',NULL,'49','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:6:\"budaya\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:21:\"permainan tradisional\";i:441;s:14:\"tanggung jawab\";i:442;s:7:\"kemauan\";i:443;s:11:\"tidak wajib\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,438,441,443,435,439,442,434,440,436,437,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"A, B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"A, B, C, D\";i:431;s:7:\"C, A, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('420','7','17','204','ASAG','2025-05-26 12:30:35','2025-05-26 12:56:39','2025-05-26 12:57:01','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"sekitar\";i:440;s:20:\"permainantradisyonal\";i:441;s:12:\"gotongroyong\";i:442;s:4:\"suku\";i:443;s:10:\"kepedulian\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:7:\"C, A, B\";i:147;s:4:\"C, B\";i:431;s:10:\"C, A, D, B\";i:432;s:4:\"A, C\";i:433;s:4:\"B, A\";}');
INSERT INTO `nilai` VALUES ('421','7','17','227','ASAG','2025-05-26 12:30:43','2025-05-26 13:03:38','2025-05-26 13:04:53','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"keragaman gender\";i:435;s:25:\"perbedaan budaya dan adat\";i:436;s:11:\"lagu daerah\";i:437;s:31:\"keragaman agama dan kepercayaan\";i:438;s:12:\"ras dan suku\";i:439;s:31:\"kawasan lingkungan sekitar kita\";i:440;s:21:\"permainan tradisional\";i:441;s:11:\"kerja sama \";i:442;s:40:\"tujuan yang sama dalam hal gotong royong\";i:443;s:35:\"kerja sama di lingkungan masyarakar\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('422','7','17','191','ASAG','2025-05-26 12:30:55','2025-05-26 13:02:41','2025-05-26 13:04:40','6','4',NULL,'42','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:88:\"disebutdenganperbedaanlakisamaperempuiyalahmisalmatakakidanlainlaindantidakmempunyaimata\";i:435;s:22:\"disebutdenganrasbudaya\";i:436;s:12:\"dibidangaceh\";i:437;s:17:\"keberagamangender\";i:438;s:18:\"keragamannegararas\";i:439;s:39:\"kawasanygmemilikirumputpohonygbergoyang\";i:440;s:25:\"permainandarisukumanasaja\";i:441;s:32:\"ygbaiksupayakelasnyamerasabersih\";i:442;s:18:\"adanyagotongroyong\";i:443;s:27:\"kerjasamamendekorpernikahan\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:7:\"B, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, C, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('423','7','17','184','ASAG','2025-05-26 12:32:12','2025-05-26 13:11:07','2025-05-26 13:12:07','8','2',NULL,'56','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:12:\"perbedaanras\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:9:\"permainan\";i:441;s:12:\"gotongroyong\";i:442;s:20:\"persatuandankesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('424','7','17','180','ASAG','2025-05-26 12:34:03','2025-05-26 12:56:20','2025-05-26 12:56:34','9','1',NULL,'63','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:54:\"perbedaanmelaluijeniskelaminantaralakilakidanperempuan\";i:435;s:15:\"keberagamansuku\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:9:\"persatuan\";i:443;s:11:\"kebersamaan\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('425','7','17','193','ASAG','2025-05-26 12:35:18','2025-05-26 12:50:19','2025-05-26 12:51:04','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:15:\"keragamangender\";i:435;s:4:\"suku\";i:436;s:12:\"tariandaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:60:\"daerahfisikadalahdaerahyangmemyangkutdaerahpesisirdandaratan\";i:440;s:33:\"permainantradisionaldisuatudaerah\";i:441;s:22:\"tanggungjawabpadasiswa\";i:442;s:66:\"pekerjaanyangsamadengankerjasamakitadapatmempermudahsuatupekerjaan\";i:443;s:20:\"antarasesamatetangga\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,434,435,436,437,438,439,440,441,442,443,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','5','0','2','8','0','0','3','2','10','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, D, C\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('426','7','17','214','ASAG','2025-05-26 12:35:45','2025-05-26 12:57:36','2025-05-26 12:59:28','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:18:\"keberagaman gender\";i:435;s:38:\"semua budaya tidak ada yang membedakan\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:9:\"terpencil\";i:440;s:9:\"permainan\";i:441;s:14:\"tanggung jawab\";i:442;s:9:\"persatuan\";i:443;s:8:\"membantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','3','3','0','3','7','2','0','2','3','6','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, B, D\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('427','8','15','232','ASAG','2025-05-26 12:45:46','2025-05-26 13:08:01','2025-05-26 13:08:12','1','9',NULL,'7','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"gulingrol\";i:422;s:7:\"tiduran\";i:423;s:8:\"berirama\";i:424;s:5:\"gerak\";i:425;s:5:\"tubuh\";i:426;s:7:\"zatbesi\";i:427;s:4:\"2jam\";i:428;s:13:\"senamberirama\";i:429;s:9:\"kanankiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','4','9','5','0','1','1','0','','8','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('428','8','15','181','ASAG','2025-05-26 12:48:09','2025-05-26 13:07:28','2025-05-26 13:08:10','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"B\";i:410;s:1:\"C\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:8:\"olahraga\";i:425;s:4:\"otot\";i:426;s:5:\"tubuh\";i:427;s:1:\"9\";i:428;s:26:\"senamyangmenggunakanmatras\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"B, D\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, A, B, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('429','8','15','192','ASAG','2025-05-26 12:48:16','2025-05-26 13:30:28','2025-05-26 13:05:34','5','5',NULL,'35','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:7:\"jasmani\";i:425;s:7:\"kondisi\";i:426;s:7:\"kalsium\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('430','8','15','200','ASAG','2025-05-26 12:48:24','2025-05-26 13:09:11','2025-05-26 13:10:34','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:8:\"serangan\";i:426;s:7:\"protein\";i:427;s:1:\"6\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','3','2','0','4','7','3','0','1','3','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"A, B, D, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('431','8','15','222','ASAG','2025-05-26 12:48:26','2025-05-26 13:09:26','2025-05-26 13:09:54','3','7',NULL,'21','36',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:11:\"pertumbuhan\";i:426;s:3:\"sel\";i:427;s:1:\"8\";i:428;s:7:\"gerakan\";i:429;s:4:\"kiri\";i:430;s:7:\"gerakan\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('432','8','15','179','ASAG','2025-05-26 12:48:47','2025-05-26 13:12:10','2025-05-26 13:15:35','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:8:\"kekuatan\";i:425;s:9:\"kesehatan\";i:426;s:4:\"besi\";i:427;s:8:\"sembilan\";i:428;s:6:\"giring\";i:429;s:5:\"kanan\";i:430;s:42:\"matrassenamyangdilakukandilantaiataumatras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,430,429,428,427,426,425,424,423,422,421,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('433','8','15','199','ASAG','2025-05-26 12:48:55','2025-05-26 13:16:24','2025-05-26 13:16:30','6','4',NULL,'42','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:10:\"berjongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:9:\"kesehatan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"9\";i:428;s:9:\"senamyoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,428,430,423,421,425,429,424,427,422,426,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('434','8','15','229','ASAG','2025-05-26 12:49:51','2025-05-26 13:12:43','2025-05-26 13:13:24','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:7:\"pikiran\";i:426;s:7:\"protein\";i:427;s:7:\"delapan\";i:428;s:10:\"peragangan\";i:429;s:5:\"ujung\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, A, C, B\";i:419;s:7:\"A, B, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('435','8','15','224','ASAG','2025-05-26 12:50:08','2025-05-26 13:14:59','2025-05-26 13:15:30','5','5',NULL,'35','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:9:\"telentang\";i:423;s:6:\"taktik\";i:424;s:5:\"tubuh\";i:425;s:4:\"olah\";i:426;s:3:\"zat\";i:427;s:1:\"8\";i:428;s:6:\"taktik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('436','8','15','187','ASAG','2025-05-26 12:50:09','2025-05-26 13:17:49','2025-05-26 13:17:58','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kebutuhan\";i:426;s:7:\"zatbesi\";i:427;s:3:\"8-9\";i:428;s:12:\"senamjasmani\";i:429;s:5:\"kanan\";i:430;s:21:\"yangmenggunakanmatras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:1:\"C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('437','8','15','228','ASAG','2025-05-26 12:51:08','2025-05-26 13:13:27','2025-05-26 13:14:35','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"ritmik\";i:424;s:9:\"kesehatan\";i:425;s:5:\"fisik\";i:426;s:4:\"otak\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:5:\"ujung\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','2','0','5','7','3','0','0','3','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('438','8','15','183','ASAG','2025-05-26 12:51:38','2025-05-26 13:14:27','2025-05-26 13:14:47','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:10:\"terlentang\";i:423;s:5:\"irama\";i:424;s:4:\"enam\";i:425;s:11:\"pertumbuhan\";i:426;s:4:\"besi\";i:427;s:7:\"delapan\";i:428;s:25:\"senamyangmengunakanmatras\";i:429;s:12:\"kanandankiri\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:4:\"D, B\";i:417;s:4:\"D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('439','8','15','193','ASAG','2025-05-26 12:51:39','2025-05-26 13:20:21','2025-05-26 13:20:44','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:22:\"senamiramadiatasmatras\";i:422;s:22:\"sikapawalgulingkedepan\";i:423;s:6:\"lantai\";i:424;s:11:\"nutrisianak\";i:425;s:9:\"kesehatan\";i:426;s:11:\"pertumbuhan\";i:427;s:4:\"8jam\";i:428;s:6:\"matras\";i:429;s:7:\"didepan\";i:430;s:26:\"senamyangmenggunakanmatras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"C, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"D, B, C, A\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('440','8','15','218','ASAG','2025-05-26 12:51:40','2025-05-26 13:14:06','2025-05-26 13:14:29','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:7:\"rietmix\";i:424;s:10:\"kecerdasan\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:9:\"pelatihan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','1','0','3','7','4','0','2','3','2','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('441','8','15','230','ASAG','2025-05-26 12:51:47','2025-05-26 13:15:08','2025-05-26 13:15:52','5','5',NULL,'35','44',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:9:\"berbaring\";i:423;s:5:\"irama\";i:424;s:7:\"jasmani\";i:425;s:10:\"lingkungan\";i:426;s:7:\"kalsium\";i:427;s:1:\"8\";i:428;s:26:\"senamyangmenggunakanmatras\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','4','9','5','0','1','1','0','','8','a:5:{i:411;s:7:\"A, B, C\";i:412;s:1:\"D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, C, D, A\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('442','8','15','176','ASAG','2025-05-26 12:52:08','2025-05-26 13:17:09','2025-05-26 13:17:37','0','10',NULL,'0','2',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"matras\";i:422;s:6:\"lantai\";i:423;s:8:\"berirama\";i:424;s:6:\"tumbuh\";i:425;s:9:\"kesehatan\";i:426;s:4:\"cair\";i:427;s:4:\"hari\";i:428;s:8:\"olahraga\";i:429;s:6:\"bagian\";i:430;s:11:\"senam irama\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:1:\"A\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"C, B, A, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, D, C, A\";i:420;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('443','8','15','177','ASAG','2025-05-26 12:52:32','2025-05-26 13:11:36','2025-05-26 13:12:21','2','8',NULL,'14','21',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:8:\"belakang\";i:423;s:5:\"senam\";i:424;s:4:\"anak\";i:425;s:5:\"senam\";i:426;s:4:\"otot\";i:427;s:1:\"9\";i:428;s:6:\"tarian\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:1:\"A\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"A, B, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('444','8','15','182','ASAG','2025-05-26 12:53:18','2025-05-26 13:21:15','2025-05-26 13:21:19','6','4',NULL,'42','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:9:\"kesehatan\";i:425;s:9:\"kesehatan\";i:426;s:4:\"besi\";i:427;s:7:\"delapan\";i:428;s:4:\"yoga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, A, C\";i:417;s:10:\"B, C, D, A\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('445','8','15','175','ASAG','2025-05-26 12:53:20','2025-05-26 13:25:33','2025-05-26 13:25:57','5','5',NULL,'35','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:42:\"salto depan atau disebut juga guling depan\";i:422;s:26:\"jongkok menghadap ke depan\";i:423;s:11:\"senam benda\";i:424;s:28:\"kurangnya pertumbuhan tinggi\";i:425;s:4:\"umur\";i:426;s:22:\"adalah zat pertumbuhan\";i:427;s:30:\"jam 9 atau  jam 10 waktu tidur\";i:428;s:12:\"senam matras\";i:429;s:24:\"berada di belakang kawan\";i:430;s:18:\"menggunakan matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"C, B, A, D\";i:420;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('446','8','15','188','ASAG','2025-05-26 12:53:39','2025-05-26 13:12:36','2025-05-26 13:12:57','3','7',NULL,'21','30',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:0:\"\";i:423;s:11:\"senamlantai\";i:424;s:6:\"lambat\";i:425;s:5:\"fisik\";i:426;s:0:\"\";i:427;s:9:\"yangtepat\";i:428;s:15:\"olahragajasmani\";i:429;s:6:\"matras\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','1','0','0','4','9','5','0','1','1','0','','8','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('447','8','15','206','ASAG','2025-05-26 12:55:03','2025-05-26 13:19:09','2025-05-26 13:19:39','6','4',NULL,'42','58',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:5:\"retme\";i:424;s:11:\"kecerdasaan\";i:425;s:8:\"pubertas\";i:426;s:7:\"protein\";i:427;s:8:\"sembilan\";i:428;s:4:\"pola\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,428,430,423,421,425,429,424,427,422,426,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"C, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('448','8','15','194','ASAG','2025-05-26 12:55:08','2025-05-26 13:24:41','2025-05-26 13:25:08','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"D\";i:410;s:1:\"A\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:9:\"berbaring\";i:423;s:10:\"senamirama\";i:424;s:11:\"tinggibadan\";i:425;s:5:\"tubuh\";i:426;s:8:\"seldarah\";i:427;s:1:\"5\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, D, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"D, B, C, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('449','8','15','185','ASAG','2025-05-26 12:55:19','2025-05-26 13:12:42','2025-05-26 13:13:33','2','8',NULL,'14','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"roling\";i:422;s:12:\"berdirilurus\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:7:\"kekutan\";i:426;s:7:\"bakteri\";i:427;s:5:\"12jam\";i:428;s:9:\"aktivitas\";i:429;s:5:\"kanan\";i:430;s:4:\"lagu\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:7:\"A, B, D\";i:412;s:4:\"C, D\";i:413;s:4:\"A, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:7:\"B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:4:\"B, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('450','8','15','197','ASAG','2025-05-26 12:55:39','2025-05-26 13:14:25','2025-05-26 13:14:55','6','4',NULL,'42','56',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"calsium\";i:427;s:8:\"sembilan\";i:428;s:7:\"aerobik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"D\";i:413;s:4:\"B, D\";i:414;s:4:\"A, B\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('451','8','15','178','ASAG','2025-05-26 12:55:43','2025-05-26 13:29:49','2025-05-26 13:30:32','2','8',NULL,'14','17',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:8:\"ke bawah\";i:422;s:21:\"kaki menyentuh matras\";i:423;s:4:\"bskj\";i:424;s:5:\"badan\";i:425;s:5:\"badan\";i:426;s:11:\"pertumbuhan\";i:427;s:8:\"enam jam\";i:428;s:11:\"senam irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:411;s:1:\"B\";i:412;s:1:\"D\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"C, D, B, A\";i:418;s:7:\"D, B, A\";i:419;s:10:\"D, B, C, A\";i:420;s:7:\"D, B, C\";}');
INSERT INTO `nilai` VALUES ('452','8','15','231','ASAG','2025-05-26 12:55:48','2025-05-26 13:20:48','2025-05-26 13:21:13','2','8',NULL,'14','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"lilin\";i:423;s:5:\"irama\";i:424;s:6:\"tulang\";i:425;s:9:\"kesehatan\";i:426;s:5:\"darah\";i:427;s:5:\"siang\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:7:\"tongkat\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','0','2','0','5','10','3','0','0','0','4','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('453','8','15','198','ASAG','2025-05-26 12:55:58','2025-05-26 13:17:24','2025-05-26 13:18:18','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:8:\"kekuatan\";i:426;s:5:\"darah\";i:427;s:1:\"7\";i:428;s:5:\"senam\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','3','0','0','5','7','5','0','0','3','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"A\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('454','8','15','205','ASAG','2025-05-26 12:56:35','2025-05-26 13:25:18','2025-05-26 13:25:23','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:6:\"mental\";i:425;s:8:\"kekuatan\";i:426;s:7:\"jasmani\";i:427;s:1:\"7\";i:428;s:7:\"gerakan\";i:429;s:5:\"kanan\";i:430;s:5:\"musik\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,428,430,423,421,425,429,424,427,422,426,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','4','10','4','0','1','0','2','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('455','8','15','180','ASAG','2025-05-26 12:56:48','2025-05-26 13:30:46','2025-05-26 13:31:04','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:10:\"berjongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:9:\"kesehatan\";i:426;s:5:\"besi \";i:427;s:1:\"1\";i:428;s:5:\"irama\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"B, D\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:7:\"B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('456','8','15','195','ASAG','2025-05-26 12:56:51','2025-05-26 13:22:00','2025-05-26 13:22:24','4','6',NULL,'28','42',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:6:\"tulang\";i:425;s:9:\"kesehatan\";i:426;s:7:\"kalsium\";i:427;s:8:\"sembilan\";i:428;s:3:\"skj\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('457','8','15','204','ASAG','2025-05-26 12:57:18','2025-05-26 13:28:10','2025-05-26 13:28:15','3','7',NULL,'21','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:15:\"menyentuhmatras\";i:423;s:10:\"senamirama\";i:424;s:4:\"anak\";i:425;s:8:\"kekuatan\";i:426;s:7:\"protein\";i:427;s:4:\"jam8\";i:428;s:7:\"gerakan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','1','0','4','8','4','0','1','2','2','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('458','8','15','223','ASAG','2025-05-26 12:57:27','2025-05-26 13:18:39','2025-05-26 13:18:44','3','7',NULL,'21','26',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:7:\"berdiri\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:13:\"senamberirama\";i:429;s:8:\"punggung\";i:430;s:6:\"olahop\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:1:\"C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"A, B, D, C\";i:419;s:1:\"C\";i:420;s:4:\"C, D\";}');
INSERT INTO `nilai` VALUES ('459','8','15','216','ASAG','2025-05-26 12:57:49','2025-05-26 13:33:45','2025-05-26 13:33:54','2','8',NULL,'14','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:9:\"headstand\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:11:\"peningkatan\";i:426;s:7:\"protein\";i:427;s:2:\"10\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','4','3','0','5','6','2','0','0','4','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('460','8','15','202','ASAG','2025-05-26 12:58:05','2025-05-26 13:18:53','2025-05-26 13:19:26','3','7',NULL,'21','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"badan\";i:425;s:5:\"fisik\";i:426;s:5:\"saraf\";i:427;s:2:\"10\";i:428;s:9:\"pemanasan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, D\";i:414;s:1:\"C\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, A, D\";i:417;s:10:\"B, A, D, C\";i:418;s:7:\"D, B, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('461','8','15','210','ASAG','2025-05-26 12:58:29','2025-05-26 13:24:47','2025-05-26 13:25:30','6','4',NULL,'42','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"tidur\";i:423;s:6:\"lantai\";i:424;s:4:\"otot\";i:425;s:4:\"otak\";i:426;s:4:\"otot\";i:427;s:10:\"7 sampai 8\";i:428;s:5:\"irama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:7:\"B, C, D\";i:412;s:7:\"A, B, D\";i:413;s:7:\"A, B, D\";i:414;s:7:\"A, B, D\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('462','8','15','189','ASAG','2025-05-26 12:58:29','2025-05-26 13:21:04','2025-05-26 13:21:39','4','6',NULL,'28','37',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"lari\";i:422;s:8:\"belakang\";i:423;s:6:\"lantai\";i:424;s:4:\"otak\";i:425;s:7:\"manusia\";i:426;s:5:\"tubuh\";i:427;s:1:\"8\";i:428;s:6:\"matras\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:1:\"C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, C, B, A\";i:419;s:10:\"D, B, A, C\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('463','8','15','207','ASAG','2025-05-26 12:58:59','2025-05-26 13:21:50','2025-05-26 13:22:24','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:19:\"bergulingdanberdiri\";i:423;s:10:\"senamirama\";i:424;s:7:\"jasmani\";i:425;s:8:\"kekuatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senamsehat\";i:429;s:5:\"kanan\";i:430;s:10:\"musiksenam\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','3','9','5','0','2','1','0','','6','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:4:\"D, A\";i:417;s:10:\"A, C, B, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('464','8','15','214','ASAG','2025-05-26 12:59:47','2025-05-26 13:21:37','2025-05-26 13:21:42','3','7',NULL,'21','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:6:\"matras\";i:423;s:5:\"lilin\";i:424;s:10:\"kecerdasan\";i:425;s:9:\"kesehatan\";i:426;s:8:\"zat besi\";i:427;s:1:\"6\";i:428;s:6:\"matras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"B, D\";i:412;s:4:\"A, C\";i:413;s:4:\"B, D\";i:414;s:4:\"B, C\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('465','8','15','211','ASAG','2025-05-26 13:00:31','2025-05-26 13:25:24','2025-05-26 13:25:31','8','2',NULL,'56','75',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:7:\"kondisi\";i:426;s:7:\"protein\";i:427;s:1:\"9\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('466','8','15','226','ASAG','2025-05-26 13:00:50','2025-05-26 13:29:15','2025-05-26 13:29:42','3','7',NULL,'21','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"ritmik\";i:424;s:11:\"kercerdasan\";i:425;s:10:\"lingkungan\";i:426;s:7:\"vitamin\";i:427;s:1:\"3\";i:428;s:9:\"pemanasan\";i:429;s:4:\"kiri\";i:430;s:5:\"musik\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('467','8','15','190','ASAG','2025-05-26 13:02:03','2025-05-26 13:24:28','2025-05-26 13:25:15','5','5',NULL,'35','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:1:\"8\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:3:\"gym\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','3','3','0','5','7','2','0','0','3','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('468','8','15','196','ASAG','2025-05-26 13:02:37','2025-05-26 13:26:55','2025-05-26 13:27:01','4','6',NULL,'28','41',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:5:\"duduk\";i:423;s:6:\"lantai\";i:424;s:6:\"badan \";i:425;s:9:\"kesehatan\";i:426;s:5:\"telur\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:5:\"kiri \";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:4:\"B, D\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:7:\"C, A, B\";}');
INSERT INTO `nilai` VALUES ('469','8','15','225','ASAG','2025-05-26 13:03:15','2025-05-26 13:32:27','2025-05-26 13:32:52','5','5',NULL,'35','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:14:\"rollingkedepan\";i:422;s:10:\"sikaplilin\";i:423;s:6:\"litmit\";i:424;s:13:\"kurangprotein\";i:425;s:5:\"sehat\";i:426;s:12:\"tubuhdanotot\";i:427;s:2:\"10\";i:428;s:10:\"senamtubuh\";i:429;s:7:\"sampimg\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,426,422,427,424,429,425,421,423,430,428,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, C, B\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, A, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('470','8','15','221','ASAG','2025-05-26 13:03:33','2025-05-26 13:25:38','2025-05-26 13:26:03','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:8:\"gangguan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"peregangan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,426,422,427,424,429,425,421,423,430,428,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','3','0','0','5','7','5','0','0','3','0','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('471','8','15','212','ASAG','2025-05-26 13:03:49','2025-05-26 13:22:55','2025-05-26 13:23:02','2','8',NULL,'14','20',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:8:\"kambling\";i:423;s:8:\"kambling\";i:424;s:8:\"kambling\";i:425;s:10:\"kecerdasan\";i:426;s:0:\"\";i:427;s:1:\"8\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:4:\"kaki\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','0','3','0','0','10','2','0','5','0','6','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:1:\"C\";i:418;s:4:\"B, C\";i:419;s:7:\"A, C, D\";i:420;s:4:\"D, C\";}');
INSERT INTO `nilai` VALUES ('472','8','15','201','ASAG','2025-05-26 13:05:06','2025-05-26 13:29:31','2025-05-26 13:29:49','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"tidur\";i:423;s:6:\"lantai\";i:424;s:4:\"otot\";i:425;s:11:\"pertumbuhan\";i:426;s:4:\"otot\";i:427;s:1:\"9\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, B\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('473','8','15','217','ASAG','2025-05-26 13:05:26','2025-05-26 13:32:05','2025-05-26 13:32:26','4','6',NULL,'28','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"tidur\";i:423;s:6:\"salman\";i:424;s:5:\"tubuh\";i:425;s:11:\"pertumbuhan\";i:426;s:4:\"otot\";i:427;s:1:\"9\";i:428;s:5:\"irama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:7:\"A, B, C\";i:417;s:10:\"A, C, D, B\";i:418;s:10:\"A, B, C, D\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('474','8','15','227','ASAG','2025-05-26 13:05:35','2025-05-26 13:30:47','2025-05-26 13:31:44','2','8',NULL,'14','24',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:10:\"kecerdasan\";i:425;s:8:\"revolusi\";i:426;s:7:\"kolagen\";i:427;s:1:\"7\";i:428;s:10:\"senamirama\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','2','1','0','3','8','4','0','2','2','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:7:\"A, B, D\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:4:\"B, C\";i:418;s:7:\"B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('475','8','15','191','ASAG','2025-05-26 13:05:41','2025-05-26 13:30:21','2025-05-26 13:30:49','5','5',NULL,'35','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:7:\"jongkok\";i:423;s:11:\"senamlantai\";i:424;s:14:\"kekurangangizi\";i:425;s:24:\"kelelahanmentaldansosial\";i:426;s:23:\"membangunnutrisipenting\";i:427;s:4:\"6jam\";i:428;s:46:\"disebutdengansanamygbersamaandenganaluranmusic\";i:429;s:18:\"sebelahkananmatras\";i:430;s:9:\"alatmusic\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,428,430,423,421,425,429,424,427,422,426,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"C, D\";i:413;s:1:\"B\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('476','8','15','208','ASAG','2025-05-26 13:06:12','2025-05-26 13:23:38','2025-05-26 13:24:03','1','9',NULL,'7','10',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:10:\"mengguling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:18:\"kurangbaikuntukank\";i:425;s:2:\"10\";i:426;s:11:\"banguntidur\";i:427;s:5:\"jam10\";i:428;s:9:\"ototbadan\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:10:\"A, B, C, D\";i:417;s:10:\"D, A, C, B\";i:418;s:10:\"D, C, B, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('477','8','15','209','ASAG','2025-05-26 13:06:25','2025-05-26 13:22:15','2025-05-26 13:22:59','2','8',NULL,'14','22',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"senam\";i:423;s:12:\"senanglantai\";i:424;s:14:\"kurangmaksimal\";i:425;s:8:\"sosialsi\";i:426;s:4:\"otot\";i:427;s:5:\"jam10\";i:428;s:11:\"senamguling\";i:429;s:12:\"sebelahkanan\";i:430;s:18:\"senamgulingkedepan\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, C\";i:413;s:4:\"A, C\";i:414;s:4:\"A, D\";i:415;s:4:\"B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:7:\"A, B, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('478','8','15','203','ASAG','2025-05-26 13:07:59','2025-05-26 13:35:57','2025-05-26 13:36:01','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:8:\"pubertas\";i:425;s:4:\"kuat\";i:426;s:3:\"sel\";i:427;s:5:\"cepat\";i:428;s:5:\"senam\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:0:\"\";i:419;s:10:\"A, B, D, C\";i:420;s:7:\"C, D, B\";}');
INSERT INTO `nilai` VALUES ('479','8','15','215','ASAG','2025-05-26 13:09:00','2025-05-26 13:31:10','2025-05-26 13:31:28','4','6',NULL,'28','39',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:14:\"jongkokkedepan\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:17:\"pengembangantubuh\";i:425;s:7:\"pikiran\";i:426;s:7:\"protein\";i:427;s:4:\"8jam\";i:428;s:10:\"peregangan\";i:429;s:11:\"depanmatras\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','3','2','0','2','7','3','0','3','3','4','','4','a:5:{i:411;s:4:\"C, D\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, A, B, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('480','8','15','213','ASAG','2025-05-26 13:11:51','2025-05-26 13:32:38','2025-05-26 13:32:41','1','9',NULL,'7','15',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:5:\"fisik\";i:425;s:8:\"serangan\";i:426;s:7:\"ptotein\";i:427;s:1:\"7\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,428,430,423,421,425,429,424,427,422,426,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, C\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('481','8','15','184','ASAG','2025-05-26 13:13:11','2025-05-26 13:37:40','2025-05-26 13:38:17','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"senam\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:10:\"lingkungan\";i:426;s:11:\"pertumbuhan\";i:427;s:2:\"19\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:411;s:4:\"B, D\";i:412;s:4:\"B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('482','8','15','186','ASAG','2025-05-26 13:14:37','2025-05-26 13:38:18','2025-05-26 13:38:21','3','7',NULL,'21','23',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:1:\"w\";i:422;s:1:\"r\";i:423;s:1:\"s\";i:424;s:1:\"f\";i:425;s:4:\"1518\";i:426;s:1:\"d\";i:427;s:2:\"12\";i:428;s:7:\"yasmani\";i:429;s:26:\"menglihatcontohygdilakukan\";i:430;s:10:\"karpetbusa\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,430,429,428,427,426,425,424,423,422,421,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:1:\"A\";i:412;s:1:\"D\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:1:\"B\";}','a:0:{}','a:5:{i:416;s:10:\"B, A, C, D\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"C, B, A, D\";i:419;s:10:\"C, B, D, A\";i:420;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('483','8','15','220','ASAG','2025-05-26 13:16:21','2025-05-26 13:38:35','2025-05-26 13:38:42','3','7',NULL,'21','25',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"D\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:2:\"ke\";i:422;s:15:\"senam berguling\";i:423;s:11:\"senam irama\";i:424;s:3:\"zat\";i:425;s:11:\"mental anak\";i:426;s:3:\"zat\";i:427;s:6:\"12 jam\";i:428;s:12:\"senam litmit\";i:429;s:5:\"kasur\";i:430;s:5:\"senam\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, D, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, C, D, A\";i:419;s:10:\"C, A, D, B\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('484','9','17','289','ASAG','2025-05-26 14:18:27','2025-05-26 14:53:54','2025-05-26 14:54:09','6','4',NULL,'42','48',NULL,'180.242.20.39','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:15:\"keragamanbudaya\";i:435;s:14:\"masyarakataceh\";i:436;s:6:\"sosial\";i:437;s:22:\"keberagamantradishonal\";i:438;s:17:\"keberagamansosial\";i:439;s:11:\"kawasanluar\";i:440;s:11:\"tradishonal\";i:441;s:12:\"gotongroyong\";i:442;s:20:\"karnaadanyakeragaman\";i:443;s:4:\"baik\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','1','0','2','10','4','0','3','0','2','','4','a:5:{i:4;s:4:\"B, D\";i:9;s:4:\"A, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, B, C, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('485','9','17','291','ASAG','2025-05-26 14:18:45','2025-05-26 14:46:36','2025-05-26 14:47:12','9','1',NULL,'63','80',NULL,'180.242.20.39','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:15:\"berbedapendapat\";i:436;s:20:\"kesenian/kelestarian\";i:437;s:5:\"agama\";i:438;s:9:\"ras/fisik\";i:439;s:33:\"sesuatuyangberadadisekitarmanusia\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','1','5','0','3','9','0','0','2','1','10','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('486','9','17','287','ASAG','2025-05-26 14:19:00','2025-05-26 14:47:43','2025-05-26 14:48:02','8','2',NULL,'56','63',NULL,'180.242.20.39','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"jender\";i:435;s:10:\"budayaluar\";i:436;s:8:\"kesenian\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:17:\"tempattinggalkita\";i:440;s:20:\"permainantradisional\";i:441;s:21:\"tanggujawbdirisendiri\";i:442;s:31:\"tugasbersamasepertigotongroyong\";i:443;s:7:\"bersama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:4:\"C, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:7:\"A, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('487','9','17','292','ASAG','2025-05-26 14:19:09','2025-05-26 14:46:52','2025-05-26 14:47:16','8','2',NULL,'56','69',NULL,'180.242.20.39','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:21:\"perbedaandalamginetik\";i:435;s:30:\"masihmemilikitradisitersendiri\";i:436;s:4:\"tari\";i:437;s:15:\"agamasukudanras\";i:438;s:7:\"ginetik\";i:439;s:56:\"kawasanyangberperanmenggunakanfisikcontohrumahkelembapan\";i:440;s:20:\"permainantradisional\";i:441;s:18:\"gotongroyongsesama\";i:442;s:36:\"membutuhkanbantuansesamamahluksosial\";i:443;s:6:\"sosial\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('488','9','17','285','ASAG','2025-05-26 14:20:19','2025-05-26 14:53:58','2025-05-26 14:54:23','3','7',NULL,'21','21',NULL,'180.242.20.39','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"D\";i:10;s:1:\"A\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"budaya\";i:435;s:17:\"budayakitasendiri\";i:436;s:4:\"aceh\";i:437;s:15:\"masyaratsendiri\";i:438;s:11:\"organtumbuh\";i:439;s:12:\"jawasurabaya\";i:440;s:17:\"permainankhasaceh\";i:441;s:22:\"menjagakebersihankelas\";i:442;s:10:\"masyarakat\";i:443;s:27:\"sangatbagusmembantutetangga\";}',NULL,'0','7,5,6,8,143,2,1,3,10,144,434,435,436,437,438,439,440,441,442,443,141,4,9,145,142,146,433,432,147,431,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:7:\"B, C, D\";i:142;s:7:\"B, C, D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"A, B, D, C\";}');
INSERT INTO `nilai` VALUES ('489','9','17','279','ASAG','2025-05-26 14:20:33','2025-05-26 14:45:50','2025-05-26 14:47:24','8','2',NULL,'56','69',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:24:\"kebudayaanacehataupunras\";i:437;s:20:\"persatuandankesatuan\";i:438;s:3:\"ras\";i:439;s:27:\"kawasanyangadadisekitarkita\";i:440;s:52:\"permainantradisionalyangseringdimainkanolehanak-anak\";i:441;s:22:\"kerjasama/gotongroyong\";i:442;s:55:\"persatuandankesatuandanjugakarenamemilikitujuanyangsama\";i:443;s:9:\"kerjasama\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,437,436,440,434,442,439,435,443,441,438,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('490','9','17','273','ASAG','2025-05-26 14:20:34','2025-05-26 15:01:02','2025-05-26 15:01:05','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:21:\"perbedaanjeniskelamin\";i:435;s:6:\"budaya\";i:436;s:5:\"bunga\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"satutujuan\";i:443;s:12:\"kekeluargaan\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('491','9','17','259','ASAG','2025-05-26 14:20:36','2025-05-26 14:58:47','2025-05-26 15:03:05','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"aceh\";i:436;s:4:\"aceh\";i:437;s:10:\"agamaislam\";i:438;s:3:\"ras\";i:439;s:7:\"daratan\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:8:\"menolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, D\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('492','9','17','277','ASAG','2025-05-26 14:20:35','2025-05-26 14:59:36','2025-05-26 15:01:08','7','3',NULL,'49','57',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"suku/budaya\";i:436;s:4:\"aceh\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"sendiri\";i:440;s:10:\"permainnan\";i:441;s:9:\"kerjasama\";i:442;s:12:\"gotongroyong\";i:443;s:26:\"agarmempereratkekeluargaan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,437,436,440,434,442,439,435,443,441,438,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:4;s:1:\"C\";i:9;s:1:\"C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, C, D\";i:147;s:10:\"B, A, C, D\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('493','9','17','274','ASAG','2025-05-26 14:20:35','2025-05-26 14:59:30','2025-05-26 15:01:34','7','3',NULL,'49','62',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:6:\"sosial\";i:436;s:6:\"tarian\";i:437;s:15:\"yangberbedabeda\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:13:\"permainanaceh\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','1','4','0','2','9','1','0','3','1','8','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"C, D, B, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('494','9','17','233','ASAG','2025-05-26 14:20:36','2025-05-26 14:58:34','2025-05-26 14:59:23','6','4',NULL,'42','48',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:3:\"ras\";i:436;s:4:\"tari\";i:437;s:6:\"budaya\";i:438;s:3:\"ras\";i:439;s:7:\"sumatra\";i:440;s:18:\"permaiantradisonal\";i:441;s:13:\"tanggungjawab\";i:442;s:16:\"lingkungansosial\";i:443;s:6:\"sosial\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:4:\"A, B\";i:147;s:0:\"\";i:431;s:0:\"\";i:432;s:4:\"B, D\";i:433;s:0:\"\";}');
INSERT INTO `nilai` VALUES ('495','9','17','275','ASAG','2025-05-26 14:20:37','2025-05-26 14:57:50','2025-05-26 15:01:24','7','3',NULL,'49','51',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"perbedaankelamin\";i:435;s:11:\"ygtidakadil\";i:436;s:11:\"keberagaman\";i:437;s:6:\"daerah\";i:438;s:4:\"aceh\";i:439;s:14:\"florandanfauna\";i:440;s:15:\"permainandaerah\";i:441;s:12:\"tangungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:4:\"B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, D, C\";i:147;s:10:\"C, B, A, D\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"C, B, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('496','9','17','265','ASAG','2025-05-26 14:20:37','2025-05-26 14:55:53','2025-05-26 15:01:37','8','2',NULL,'56','66',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:3:\"ras\";i:435;s:4:\"suku\";i:436;s:4:\"tari\";i:437;s:15:\"yangberbedabeda\";i:438;s:4:\"suku\";i:439;s:6:\"sosial\";i:440;s:6:\"mainan\";i:441;s:9:\"kerjasama\";i:442;s:12:\"orangsekitar\";i:443;s:10:\"masyarakat\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','0','3','0','2','10','2','0','3','0','6','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, C, A\";i:147;s:7:\"C, A, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('497','9','17','243','ASAG','2025-05-26 14:20:37','2025-05-26 15:01:07','2025-05-26 15:01:28','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"C\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:18:\"budayamasingmasing\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:12:\"perselisihan\";i:443;s:6:\"sosial\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"D, A, C, B\";i:431;s:10:\"A, B, C, D\";i:432;s:7:\"B, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('498','9','17','240','ASAG','2025-05-26 14:20:37','2025-05-26 15:01:29','2025-05-26 15:01:52','4','6',NULL,'28','36',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"B\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:6:\"tarian\";i:437;s:6:\"budaya\";i:438;s:16:\"keberagamantubuh\";i:439;s:7:\"sekitar\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"rasaapreasiasi\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,437,436,440,434,442,439,435,443,441,438,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:7:\"A, B, D\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('499','9','17','283','ASAG','2025-05-26 14:20:40','2025-05-26 14:50:51','2025-05-26 15:01:09','8','2',NULL,'56','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:7:\"tanaman\";i:437;s:9:\"toleransi\";i:438;s:3:\"ras\";i:439;s:6:\"budaya\";i:440;s:15:\"permainandaerah\";i:441;s:12:\"gotongroyong\";i:442;s:10:\"satutujuan\";i:443;s:10:\"masyarakat\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('500','9','17','282','ASAG','2025-05-26 14:20:40','2025-05-26 14:53:42','2025-05-26 15:01:20','6','4',NULL,'42','52',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"D\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:23:\"budayayangberbedaagama \";i:435;s:36:\"tridakpeduliterhadapbudayaoranglain \";i:436;s:11:\"tarianaceh \";i:437;s:27:\"salingmembantusatusamalain \";i:438;s:32:\"fisikyangdirupaikeberagamanfisik\";i:439;s:32:\"fisikyangmerupakankawasanmanusia\";i:440;s:13:\"permainanaceh\";i:441;s:9:\"kewajiban\";i:442;s:12:\"gotongroyong\";i:443;s:35:\"membantuagarmempereratkekeluargaan \";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','5','0','0','10','0','0','5','0','10','','0','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('501','9','17','294','ASAG','2025-05-26 14:20:42','2025-05-26 15:03:03','2025-05-26 15:03:14','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:25:\"disebutgenderjeniskelamin\";i:435;s:15:\"agamayangdianut\";i:436;s:22:\"acehataudibidangsosial\";i:437;s:30:\"yaituagamakebudayandiindonesia\";i:438;s:26:\"manusiasebagaimakhlukhidup\";i:439;s:57:\"sekitarankitayangtidakbernyawamisalnyaairataubendalainnya\";i:440;s:49:\"permainantradisionalyaitupermainantradisionalaceh\";i:441;s:26:\"tanggungjawabseorangsisawa\";i:442;s:53:\"gotongroyongkarenaadanyagotongkerjaanbisacepatselesai\";i:443;s:73:\"baikdankitasalingmenghormatisesamamanusiadansalingmenghargaisesamamanusia\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,443,442,441,440,439,438,437,436,435,434,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, B, D\";i:147;s:10:\"C, B, A, D\";i:431;s:4:\"D, B\";i:432;s:4:\"D, A\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('502','9','17','272','ASAG','2025-05-26 14:20:49','2025-05-26 14:54:53','2025-05-26 14:59:36','5','5',NULL,'35','36',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"B\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:5:\"agama\";i:438;s:9:\"mongoloid\";i:439;s:9:\"suhurumah\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kerjasama\";i:442;s:8:\"kelompok\";i:443;s:10:\"masyarakat\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:4;s:4:\"A, C\";i:9;s:4:\"A, B\";i:141;s:4:\"B, D\";i:142;s:4:\"A, B\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, B, D, A\";i:431;s:10:\"B, A, C, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('503','9','17','254','ASAG','2025-05-26 14:21:36','2025-05-26 14:58:55','2025-05-26 15:01:10','5','5',NULL,'35','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"C\";i:143;s:1:\"D\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"seni\";i:437;s:4:\"suku\";i:438;s:3:\"ras\";i:439;s:13:\"tempattinggal\";i:440;s:19:\"permainantradisonal\";i:441;s:12:\"gotongroyong\";i:442;s:13:\"tanggungjawab\";i:443;s:6:\"sosial\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,443,442,441,440,439,438,437,436,435,434,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('504','9','17','276','ASAG','2025-05-26 14:21:36','2025-05-26 14:46:55','2025-05-26 14:47:57','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:12:\"budaya lokal\";i:435;s:11:\"budayalokal\";i:436;s:11:\"tarianlokal\";i:437;s:15:\"sukudiindonesia\";i:438;s:3:\"ras\";i:439;s:13:\"yangtidakaman\";i:440;s:19:\"permainantradisonal\";i:441;s:11:\"dirisendiri\";i:442;s:28:\"kerjasamaterhadapsesamawarga\";i:443;s:7:\"positif\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, D\";i:141;s:1:\"B\";i:142;s:10:\"A, B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"B, D, C, A\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('505','9','17','237','ASAG','2025-05-26 14:21:37','2025-05-26 15:01:01','2025-05-26 15:01:09','10','0',NULL,'70','86',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:14:\"masyarakatluar\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:14:\"permainanlokal\";i:441;s:9:\"kerjasama\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,437,436,440,434,442,439,435,443,441,438,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:4:\"B, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('506','9','17','239','ASAG','2025-05-26 14:21:37','2025-05-26 14:47:37','2025-05-26 14:47:51','8','2',NULL,'56','71',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"persatuan\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:4:\"suku\";i:439;s:5:\"tubuh\";i:440;s:11:\"keberagaman\";i:441;s:13:\"tanggungjawab\";i:442;s:9:\"persatuan\";i:443;s:14:\"tolongmenolong\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"B, C, D\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('507','9','17','278','ASAG','2025-05-26 14:21:37','2025-05-26 14:48:16','2025-05-26 14:50:21','8','2',NULL,'56','65',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:14:\"salingmembantu\";i:435;s:15:\"rasbahasadaerah\";i:436;s:19:\"kemusikanlagudaerah\";i:437;s:23:\"kebudayaandannormaagama\";i:438;s:3:\"ras\";i:439;s:5:\"papua\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kerjasama\";i:442;s:8:\"kesatuan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, B\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"B, D, A, C\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('508','9','17','270','ASAG','2025-05-26 14:21:37','2025-05-26 14:55:43','2025-05-26 15:01:08','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"D\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:6:\"budaya\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"daerah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:9:\"kerjasama\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"D, B, A, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('509','9','17','261','ASAG','2025-05-26 14:21:38','2025-05-26 14:54:12','2025-05-26 15:01:20','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:15:\"keberagamgender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:16:\"keberagamanagama\";i:438;s:14:\"rasdangolongan\";i:439;s:17:\"pesisirdandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:11:\"kebersamaan\";i:443;s:11:\"kebersamaan\";}',NULL,'0','7,10,6,143,2,8,1,5,3,144,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,146,433,147,432,431,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"B, C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('510','9','17','253','ASAG','2025-05-26 14:21:38','2025-05-26 14:52:56','2025-05-26 15:01:22','9','1',NULL,'63','75',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:15:\"permainandaerah\";i:441;s:12:\"gotongroyong\";i:442;s:16:\"keinginanbersama\";i:443;s:19:\"lingkungamasyarakat\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','2','4','0','1','8','1','0','4','2','8','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"D, B, C, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('511','9','17','257','ASAG','2025-05-26 14:21:38','2025-05-26 14:58:15','2025-05-26 14:58:18','9','1',NULL,'63','70',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:37:\"jangan salahkan faham ku kinii tertuj\";i:435;s:4:\"suku\";i:436;s:4:\"aceh\";i:437;s:12:\"yangsempurna\";i:438;s:3:\"ras\";i:439;s:6:\"sosial\";i:440;s:17:\"mainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:16:\"lingkungansosial\";i:443;s:11:\"sosialisasi\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"B, C, D\";i:141;s:7:\"A, C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('512','9','17','249','ASAG','2025-05-26 14:21:39','2025-05-26 15:04:32','2025-05-26 15:04:56','5','5',NULL,'35','37',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"B\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"C\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:27:\"berbedabahasadanketrampilan\";i:436;s:22:\"dibidangkebudayaanaceh\";i:437;s:26:\"mengikutipemerintahsendiri\";i:438;s:19:\"berbedanyaketurunan\";i:439;s:26:\"kwasanlingkunganmanyarakat\";i:440;s:19:\"permainantradisonal\";i:441;s:25:\"perilakutanggungseseorang\";i:442;s:12:\"bantuanwarga\";i:443;s:11:\"keberagaman\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"B\";i:142;s:4:\"C, D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:1:\"C\";i:431;s:10:\"C, D, B, A\";i:432;s:1:\"C\";i:433;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('513','9','17','258','ASAG','2025-05-26 14:21:39','2025-05-26 14:59:40','2025-05-26 15:01:22','7','3',NULL,'49','55',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:15:\"ras dang gender\";i:435;s:17:\"multikulturalisme\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:6:\"gender\";i:439;s:6:\"sosial\";i:440;s:22:\"permainan teradisional\";i:441;s:13:\"gotong royong\";i:442;s:18:\"keberagaman sosial\";i:443;s:15:\"tolong menolong\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:4;s:1:\"A\";i:9;s:1:\"C\";i:141;s:7:\"A, B, D\";i:142;s:1:\"D\";i:145;s:1:\"D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"D, B, A, C\";i:431;s:7:\"B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('514','9','17','241','ASAG','2025-05-26 14:21:39','2025-05-26 14:58:50','2025-05-26 15:01:07','7','3',NULL,'49','66',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"D\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:6:\"budaya\";i:436;s:4:\"tari\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:6:\"daerah\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:11:\"kebersamaan\";i:443;s:6:\"sosial\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','3','3','0','4','7','2','0','1','3','6','','8','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('515','9','17','245','ASAG','2025-05-26 14:21:39','2025-05-26 15:00:21','2025-05-26 15:01:09','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"A\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:3:\"ras\";i:435;s:12:\"ruanglingkup\";i:436;s:5:\"musik\";i:437;s:5:\"sifat\";i:438;s:3:\"ras\";i:439;s:7:\"mandiri\";i:440;s:14:\"permainanlokal\";i:441;s:9:\"kewajiban\";i:442;s:11:\"sifattolong\";i:443;s:6:\"sosial\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,437,436,440,434,442,439,435,443,441,438,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, D\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"B, A, D, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('516','9','17','248','ASAG','2025-05-26 14:21:39','2025-05-26 14:55:32','2025-05-26 15:01:07','9','1',NULL,'63','81',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:19:\"masyarakatpedalaman\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"daratandanpesisir\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tujuanyangsama\";i:443;s:12:\"ketetanggaan\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('517','9','17','255','ASAG','2025-05-26 14:21:40','2025-05-26 14:57:30','2025-05-26 14:57:37','7','3',NULL,'49','54',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"kesetaraangender\";i:435;s:4:\"suku\";i:436;s:4:\"seni\";i:437;s:8:\"yangbeda\";i:438;s:3:\"ras\";i:439;s:7:\"daratan\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"menjagakelas\";i:442;s:20:\"persatuandankesatuan\";i:443;s:8:\"kesosial\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,434,435,436,437,438,439,440,441,442,443,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:10:\"A, B, C, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, A, B\";i:147;s:10:\"B, C, D, A\";i:431;s:10:\"A, C, B, D\";i:432;s:10:\"B, C, A, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('518','9','17','250','ASAG','2025-05-26 14:21:40','2025-05-26 15:00:12','2025-05-26 15:01:23','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"B\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:13:\"berbedabudaya\";i:436;s:10:\"masyarakat\";i:437;s:12:\"masingmasing\";i:438;s:3:\"ras\";i:439;s:4:\"laut\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kewajiban\";i:442;s:9:\"persatuan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, B\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, C, A\";i:147;s:10:\"A, B, D, C\";i:431;s:10:\"B, D, C, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('519','9','17','244','ASAG','2025-05-26 14:21:41','2025-05-26 14:53:09','2025-05-26 15:02:50','7','3',NULL,'49','64',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:19:\"tarianataubernyanyi\";i:437;s:23:\"keagamaandankeberagaman\";i:438;s:3:\"ras\";i:439;s:9:\"kesehatan\";i:440;s:9:\"permainan\";i:441;s:12:\"berkewajiban\";i:442;s:20:\"rasabertanggungjawab\";i:443;s:4:\"baik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,438,441,443,435,439,442,434,440,436,437,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','5','0','2','9','0','0','3','1','10','','4','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, D, B, A\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, B, D, C\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('520','9','17','246','ASAG','2025-05-26 14:21:41','2025-05-26 15:02:08','2025-05-26 15:02:26','9','1',NULL,'63','68',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:16:\"kesetaraangender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:9:\"kerjasama\";i:442;s:10:\"kekompakan\";i:443;s:6:\"sosial\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:4;s:4:\"A, D\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"A, C\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:10:\"D, C, A, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, C, D, A\";i:433;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('521','9','17','262','ASAG','2025-05-26 14:21:41','2025-05-26 14:51:19','2025-05-26 15:01:16','8','2',NULL,'56','74',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:3:\"ras\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandataran\";i:440;s:17:\"mainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:8:\"kesatuan\";i:443;s:9:\"persatuan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('522','9','17','286','ASAG','2025-05-26 14:21:41','2025-05-26 14:51:58','2025-05-26 15:01:22','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"A\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:17:\"perempuanlakilaki\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:6:\"budaya\";i:438;s:6:\"budaya\";i:439;s:8:\"keluarga\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:9:\"persatuan\";i:443;s:6:\"sosial\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:1:\"D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:10:\"D, A, B, C\";i:431;s:10:\"B, C, D, A\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('523','9','17','238','ASAG','2025-05-26 14:21:42','2025-05-26 15:01:08','2025-05-26 15:01:24','10','0',NULL,'70','88',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:9:\"senimusik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"pesisir\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:25:\"inginmempercepatpekerjaan\";i:443;s:14:\"salingmembantu\";}',NULL,'0','144,143,10,8,7,6,5,3,2,1,434,435,436,437,438,439,440,441,442,443,145,142,141,9,4,433,432,431,147,146,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('524','9','17','284','ASAG','2025-05-26 14:21:41','2025-05-26 14:53:59','2025-05-26 15:01:29','10','0',NULL,'70','84',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"jender\";i:435;s:15:\"tidakmenghargai\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:14:\"pesisirdaratan\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"keberagaman\";i:443;s:20:\"lingkunganmasyarakat\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"C, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"A, D, B, C\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('525','9','17','247','ASAG','2025-05-26 14:21:42','2025-05-26 14:52:53','2025-05-26 14:53:03','8','2',NULL,'56','66',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:22:\"keberagamanantargender\";i:435;s:15:\"perbedaanbudaya\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainanzamandahulu\";i:441;s:7:\"terpuji\";i:442;s:13:\"kekompakantim\";i:443;s:5:\"mulia\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:4:\"B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, B, A, C\";i:147;s:10:\"D, B, A, C\";i:431;s:10:\"C, B, D, A\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('526','9','17','268','ASAG','2025-05-26 14:21:42','2025-05-26 14:56:15','2025-05-26 15:01:26','6','4',NULL,'42','53',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"genger\";i:435;s:10:\"sukubudaya\";i:436;s:19:\"keseniantradisional\";i:437;s:13:\"keragamansuku\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:20:\"permainantradisional\";i:441;s:12:\"gotongroyong\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"salingmembantu\";}',NULL,'0','3,1,2,8,6,5,10,143,144,7,434,435,436,437,438,439,440,441,442,443,142,4,9,145,141,147,432,431,433,146,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:4;s:4:\"B, C\";i:9;s:7:\"A, B, C\";i:141;s:1:\"D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('527','9','17','236','ASAG','2025-05-26 14:21:43','2025-05-26 15:01:57','2025-05-26 15:02:14','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"lagu\";i:437;s:3:\"ras\";i:438;s:6:\"gender\";i:439;s:6:\"gender\";i:440;s:6:\"acehhh\";i:441;s:13:\"tanggungjawab\";i:442;s:10:\"berdiskusi\";i:443;s:12:\"turuntemurun\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:7:\"A, B, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"B, A, C, D\";i:147;s:7:\"C, A, D\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('528','9','17','234','ASAG','2025-05-26 14:21:43','2025-05-26 15:01:43','2025-05-26 15:01:51','9','1',NULL,'63','83',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:17:\"keberagamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:15:\"permainandaerah\";i:441;s:13:\"tanggungjawab\";i:442;s:12:\"gotongroyong\";i:443;s:14:\"kemasyarakatan\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,434,435,436,437,438,439,440,441,442,443,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('529','9','17','281','ASAG','2025-05-26 14:21:44','2025-05-26 14:51:09','2025-05-26 15:01:10','4','6',NULL,'28','42',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"D\";i:3;s:1:\"A\";i:5;s:1:\"C\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:4:\"seni\";i:437;s:6:\"sosial\";i:438;s:3:\"ras\";i:439;s:11:\"situs lokal\";i:440;s:21:\"permainan tradisional\";i:441;s:9:\"persatuan\";i:442;s:22:\"saling membantu sesama\";i:443;s:10:\"masyarakat\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, A, C, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('530','9','17','252','ASAG','2025-05-26 14:21:44','2025-05-26 14:59:58','2025-05-26 15:01:33','8','2',NULL,'56','62',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:13:\"merusakbudaya\";i:436;s:6:\"daerah\";i:437;s:20:\"persatuandankesatuan\";i:438;s:14:\"keberagamanras\";i:439;s:6:\"gender\";i:440;s:13:\"permainalokal\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','1','0','2','10','4','0','3','0','2','','4','a:5:{i:4;s:4:\"A, C\";i:9;s:7:\"A, C, D\";i:141;s:7:\"A, B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, B, C\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('531','9','17','295','ASAG','2025-05-26 14:21:44','2025-05-26 14:48:33','2025-05-26 14:49:21','7','3',NULL,'49','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"A\";i:5;s:1:\"B\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:23:\"laki laki dan perempuan\";i:435;s:15:\"budaya  sombong\";i:436;s:4:\"aceh\";i:437;s:22:\"persatuan dan kesatuan\";i:438;s:5:\"papua\";i:439;s:10:\"kebudayaan\";i:440;s:18:\"mainan tradisinoal\";i:441;s:16:\"kebersihan kelas\";i:442;s:9:\"persatuan\";i:443;s:8:\"membantu\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:4;s:1:\"B\";i:9;s:1:\"B\";i:141;s:1:\"A\";i:142;s:1:\"B\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"B, C, A, D\";i:147;s:10:\"D, B, A, C\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"A, C, B, D\";i:433;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('532','9','17','235','ASAG','2025-05-26 14:21:44','2025-05-26 14:59:00','2025-05-26 15:01:05','10','0',NULL,'70','90',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:15:\"keragamanbudaya\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"daratandanpesisir\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:20:\"persatuandankesatuan\";i:443;s:20:\"lingkunganmasyarakat\";}',NULL,'0','1,2,5,7,8,143,3,6,144,10,438,441,443,435,439,442,434,440,436,437,4,145,141,9,142,146,432,147,431,433,',NULL,NULL,'0','2','5','0','4','8','0','0','1','2','10','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, C, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('533','9','17','256','ASAG','2025-05-26 14:21:45','2025-05-26 14:55:16','2025-05-26 15:01:10','9','1',NULL,'63','73',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:5:\"musik\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:17:\"pesisirdandaratan\";i:440;s:15:\"permainandaerah\";i:441;s:12:\"gotongroyong\";i:442;s:13:\"tanggungjawab\";i:443;s:13:\"tanggungjawab\";}',NULL,'0','8,144,10,1,2,5,6,7,143,3,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,147,146,433,432,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:4;s:7:\"A, B, D\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, D, C, B\";i:147;s:10:\"B, C, A, D\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"D, A, C, B\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('534','9','17','242','ASAG','2025-05-26 14:21:46','2025-05-26 14:56:31','2025-05-26 15:01:25','6','4',NULL,'42','49',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"D\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:6:\"budaya\";i:439;s:6:\"sosial\";i:440;s:4:\"aceh\";i:441;s:13:\"tanggungjawab\";i:442;s:15:\"rasakemanusiaan\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,144,143,10,5,6,8,2,1,3,443,442,441,440,439,438,437,436,435,434,141,145,9,4,142,146,433,431,432,147,',NULL,NULL,'0','1','1','0','2','9','4','0','3','1','2','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:1:\"D\";i:142;s:1:\"D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"A, C, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('535','9','17','260','ASAG','2025-05-26 14:21:46','2025-05-26 15:01:05','2025-05-26 15:02:04','8','2',NULL,'56','62',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"B\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"berbedasuku\";i:436;s:6:\"daerah\";i:437;s:11:\"keberagaman\";i:438;s:10:\"sukudaerah\";i:439;s:5:\"fiksi\";i:440;s:15:\"permainandaerah\";i:441;s:9:\"kewajiban\";i:442;s:8:\"perilaku\";i:443;s:14:\"salingmembantu\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','2','0','1','10','3','0','4','0','4','','2','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"B, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"D, C, A, B\";i:431;s:10:\"A, C, B, D\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('536','9','17','280','ASAG','2025-05-26 14:21:46','2025-05-26 15:05:03','2025-05-26 15:05:10','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"B\";i:5;s:1:\"B\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"C\";i:10;s:1:\"A\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:21:\"keragaman asal daerah\";i:435;s:19:\"budaya yang berbeda\";i:436;s:15:\"bidang kesosial\";i:437;s:27:\"keragaman keragaman sendiri\";i:438;s:16:\"keragaman budaya\";i:439;s:18:\"kekuwasanan daerah\";i:440;s:9:\"permainan\";i:441;s:15:\"ketanguan kelas\";i:442;s:9:\"kejasmani\";i:443;s:9:\"ke sosila\";}',NULL,'0','144,10,3,1,2,143,8,6,5,7,443,442,441,440,439,438,437,436,435,434,142,145,9,4,141,431,147,432,433,146,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:4;s:1:\"A\";i:9;s:1:\"B\";i:141;s:1:\"B\";i:142;s:1:\"B\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:1:\"B\";i:431;s:1:\"D\";i:432;s:4:\"B, D\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('537','9','17','288','ASAG','2025-05-26 14:21:47','2025-05-26 14:59:20','2025-05-26 15:00:54','5','5',NULL,'35','41',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"B\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:13:\"jenis kelamin\";i:435;s:6:\"budaya\";i:436;s:6:\"sosial\";i:437;s:5:\"islam\";i:438;s:6:\"sosial\";i:439;s:9:\"indonesia\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:17:\"keberagamanbudaya\";i:443;s:8:\"membantu\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,437,436,440,434,442,439,435,443,441,438,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','0','1','0','2','10','4','0','3','0','2','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:1:\"D\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, A, C\";i:147;s:10:\"D, A, B, C\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('538','9','17','293','ASAG','2025-05-26 14:21:53','2025-05-26 14:49:12','2025-05-26 15:01:27','7','3',NULL,'49','55',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:9:\"toleransi\";i:436;s:6:\"sosial\";i:437;s:10:\"sendirinya\";i:438;s:6:\"sosial\";i:439;s:10:\"lingkungan\";i:440;s:22:\"permainaninternasional\";i:441;s:13:\"tanggungjawab\";i:442;s:6:\"sosial\";i:443;s:10:\"kesusilaan\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','0','2','0','1','10','3','0','4','0','4','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:7:\"A, B, C\";i:141;s:7:\"B, C, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, D, B, A\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('539','9','17','290','ASAG','2025-05-26 14:21:53','2025-05-26 14:59:59','2025-05-26 15:01:39','6','4',NULL,'42','46',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"C\";i:6;s:1:\"A\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:10:\"sukubangsa\";i:436;s:6:\"sosial\";i:437;s:12:\"masingmasing\";i:438;s:10:\"sukudanras\";i:439;s:13:\"tempattinggal\";i:440;s:9:\"permainan\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:6:\"ikhlas\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,438,441,443,435,439,442,434,440,436,437,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"B, D, C, A\";i:147;s:10:\"D, B, C, A\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, A, D, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('540','9','17','266','ASAG','2025-05-26 14:21:55','2025-05-26 15:07:09','2025-05-26 15:07:23','4','6',NULL,'28','32',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"C\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"A\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:12:\"jeniskelamin\";i:435;s:6:\"budaya\";i:436;s:6:\"budaya\";i:437;s:6:\"budaya\";i:438;s:6:\"sosial\";i:439;s:11:\"Tidak Diisi\";i:440;s:9:\"permainan\";i:441;s:9:\"kewajiban\";i:442;s:11:\"Tidak Diisi\";i:443;s:11:\"Tidak Diisi\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:4;N;i:9;s:1:\"D\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:1:\"A\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, B, A\";i:147;s:10:\"C, A, D, B\";i:431;N;i:432;N;i:433;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('541','9','17','269','ASAG','2025-05-26 14:22:04','2025-05-26 14:55:59','2025-05-26 15:01:02','9','1',NULL,'63','81',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"C\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:10:\"masyarakat\";i:440;s:16:\"permainantradisi\";i:441;s:13:\"tanggungjawab\";i:442;s:14:\"tujuanyangsama\";i:443;s:10:\"masyarakat\";}',NULL,'0','144,3,5,1,8,2,143,6,10,7,438,441,443,435,439,442,434,440,436,437,141,145,9,4,142,431,432,147,433,146,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:4;s:4:\"B, C\";i:9;s:4:\"B, C\";i:141;s:7:\"A, B, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, D, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('542','9','17','263','ASAG','2025-05-26 14:22:08','2025-05-26 14:48:35','2025-05-26 14:49:14','9','1',NULL,'63','77',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:6:\"tarian\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:16:\"pantaidandaratan\";i:440;s:20:\"permainantradisional\";i:441;s:20:\"kesatuandanpersatuan\";i:442;s:8:\"kesatuan\";i:443;s:9:\"kerjasama\";}',NULL,'0','7,10,3,2,6,1,5,8,144,143,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,146,147,433,432,431,',NULL,NULL,'0','2','5','0','1','8','0','0','4','2','10','','2','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, B, D, C\";i:147;s:10:\"B, C, D, A\";i:431;s:0:\"\";i:432;s:0:\"\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('543','9','17','264','ASAG','2025-05-26 14:22:15','2025-05-26 14:49:47','2025-05-26 15:01:07','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"B\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"A\";i:144;s:1:\"C\";}','a:10:{i:434;s:17:\"keberagamangender\";i:435;s:4:\"suku\";i:436;s:10:\"permusikan\";i:437;s:15:\"sukubudayaagama\";i:438;s:14:\"keberagamanras\";i:439;s:12:\"kawasanfisik\";i:440;s:22:\"permainananakzamandulu\";i:441;s:6:\"tertib\";i:442;s:9:\"bentuktim\";i:443;s:17:\"baikmembantuorang\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,434,435,436,437,438,439,440,441,442,443,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','2','0','4','10','3','0','1','0','4','','8','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"A, B\";i:141;s:4:\"B, D\";i:142;s:7:\"B, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('544','9','17','271','ASAG','2025-05-26 14:22:20','2025-05-26 14:48:10','2025-05-26 15:01:20','6','4',NULL,'42','50',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"D\";i:7;s:1:\"D\";i:8;s:1:\"B\";i:10;s:1:\"B\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:11:\"keberagaman\";i:436;s:15:\"flora dan fauna\";i:437;s:5:\"agama\";i:438;s:5:\"fisik\";i:439;s:10:\"yang indah\";i:440;s:21:\"permainan tradisional\";i:441;s:14:\"tanggung jawab\";i:442;s:13:\"gotong royong\";i:443;s:5:\"fisik\";}',NULL,'0','1,2,3,5,6,7,8,10,143,144,434,435,436,437,438,439,440,441,442,443,4,9,141,142,145,146,147,431,432,433,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:4;s:4:\"A, B\";i:9;s:4:\"A, C\";i:141;s:4:\"B, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, D\";}','a:0:{}','a:5:{i:146;s:10:\"C, A, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, B, A, D\";i:432;s:10:\"B, D, C, A\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('545','9','17','251','ASAG','2025-05-26 14:22:34','2025-05-26 14:50:50','2025-05-26 15:01:20','9','1',NULL,'63','79',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"A\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"B\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"B\";}','a:10:{i:434;s:6:\"gender\";i:435;s:4:\"suku\";i:436;s:10:\"lagudaerah\";i:437;s:5:\"agama\";i:438;s:3:\"ras\";i:439;s:7:\"wilayah\";i:440;s:20:\"permainantradisional\";i:441;s:13:\"tanggungjawab\";i:442;s:11:\"kebersamaan\";i:443;s:5:\"soial\";}',NULL,'0','3,143,7,6,5,2,1,10,144,8,434,435,436,437,438,439,440,441,442,443,141,142,9,145,4,432,433,146,147,431,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:4:\"B, C\";i:141;s:4:\"A, D\";i:142;s:4:\"C, D\";i:145;s:4:\"A, B\";}','a:0:{}','a:5:{i:146;s:10:\"A, C, D, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, D, A, B\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('546','9','17','267','ASAG','2025-05-26 14:29:37','2025-05-26 14:46:33','2025-05-26 14:47:28','7','3',NULL,'49','59',NULL,'180.242.21.245','0','a:10:{i:1;s:1:\"C\";i:2;s:1:\"A\";i:3;s:1:\"C\";i:5;s:1:\"A\";i:6;s:1:\"C\";i:7;s:1:\"C\";i:8;s:1:\"B\";i:10;s:1:\"D\";i:143;s:1:\"B\";i:144;s:1:\"A\";}','a:10:{i:434;s:6:\"gender\";i:435;s:6:\"daerah\";i:436;s:4:\"aceh\";i:437;s:29:\"keberagman saling menghotmati\";i:438;s:19:\"daerah atuapun suku\";i:439;s:15:\"daerah tertentu\";i:440;s:22:\"dari permainana daerah\";i:441;s:9:\"kerjasama\";i:442;s:35:\"sifat saling membantu satu samalain\";i:443;s:25:\"kerjasama saling membantu\";}',NULL,'0','143,144,8,5,1,6,2,3,10,7,443,442,441,440,439,438,437,436,435,434,4,145,9,142,141,431,432,433,147,146,',NULL,NULL,'0','0','2','0','3','10','3','0','2','0','4','','6','a:5:{i:4;s:7:\"A, B, C\";i:9;s:10:\"A, B, C, D\";i:141;s:7:\"A, B, D\";i:142;s:7:\"A, C, D\";i:145;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:146;s:10:\"D, C, A, B\";i:147;s:10:\"C, A, D, B\";i:431;s:10:\"C, A, B, D\";i:432;s:10:\"B, D, A, C\";i:433;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('547','10','15','291','ASAG','2025-05-26 14:47:25','2025-05-26 15:24:18','2025-05-26 15:29:22','6','4',NULL,'42','56',NULL,'180.242.20.39','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:18:\"guling/rolingdepan\";i:422;s:7:\"jongkok\";i:423;s:14:\"iramaataumusik\";i:424;s:5:\"badan\";i:425;s:19:\"pertumbuhan/pikiran\";i:426;s:20:\"zatkimia/pertumbuhan\";i:427;s:4:\"9jam\";i:428;s:15:\"gerakanbertahab\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','1','0','5','8','4','0','0','2','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:7:\"A, C, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('548','10','15','292','ASAG','2025-05-26 14:47:28','2025-05-26 15:29:00','2025-05-26 15:29:29','3','7',NULL,'21','30',NULL,'180.242.20.39','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:25:\"perakhirandarisenamlantai\";i:423;s:10:\"senamirama\";i:424;s:45:\"akanmenjadisedikitlebihlemasdantidakbertenaga\";i:425;s:31:\"seorangremajapadaumur9-17 tahun\";i:426;s:7:\"vitamin\";i:427;s:11:\"6sampai8jam\";i:428;s:8:\"senamsjk\";i:429;s:9:\"pendorong\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','4','9','5','0','1','1','0','','8','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"B, C, D\";i:413;s:7:\"A, B, C\";i:414;s:7:\"A, B, C\";i:415;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('549','10','15','287','ASAG','2025-05-26 14:48:24','2025-05-26 15:28:14','2025-05-26 15:30:12','3','7',NULL,'21','36',NULL,'180.242.20.39','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"B\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:13:\"senamserirama\";i:424;s:10:\"tidakbagus\";i:425;s:11:\"pertumbuhan\";i:426;s:13:\"seldarahmarah\";i:427;s:11:\"5sampai6jam\";i:428;s:13:\"senamberirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('550','10','15','289','ASAG','2025-05-26 14:54:37','2025-05-26 15:29:07','2025-05-26 15:33:18','2','8',NULL,'14','22',NULL,'180.242.20.39','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:7:\"rileaks\";i:423;s:10:\"senamirama\";i:424;s:23:\"badanyangkurangmaksimal\";i:425;s:11:\"pertumbuhan\";i:426;s:7:\"zatcair\";i:427;s:8:\"empatjam\";i:428;s:10:\"senambebas\";i:429;s:11:\"kananmatras\";i:430;s:10:\"tikarsenam\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','0','0','0','4','10','5','0','1','0','0','','8','a:5:{i:411;s:4:\"A, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, C\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('551','10','15','285','ASAG','2025-05-26 14:54:38','2025-05-26 15:26:03','2025-05-26 15:34:05','3','7',NULL,'21','23',NULL,'180.242.20.39','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:9:\"berbaring\";i:423;s:10:\"senambadan\";i:424;s:13:\"kurangbergizi\";i:425;s:11:\"senamlantai\";i:426;s:8:\"zatbiasa\";i:427;s:5:\"10jam\";i:428;s:10:\"senambadan\";i:429;s:5:\"kanan\";i:430;s:16:\"bergulingkedepan\";}',NULL,'0','403,404,405,407,410,409,406,408,401,402,421,422,423,424,425,426,427,428,429,430,414,411,413,412,415,417,418,419,420,416,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:7:\"A, B, D\";i:412;s:7:\"A, B, D\";i:413;s:7:\"A, B, C\";i:414;s:1:\"C\";i:415;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, C, A, D\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('552','10','15','269','ASAG','2025-05-26 15:03:04','2025-05-26 15:24:36','2025-05-26 15:32:04','5','5',NULL,'35','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:8:\"keringat\";i:427;s:1:\"8\";i:428;s:13:\"floorexercise\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,426,422,427,424,429,425,421,423,430,428,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','2','2','0','5','8','3','0','0','2','4','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('553','10','15','273','ASAG','2025-05-26 15:03:05','2025-05-26 15:27:46','2025-05-26 15:31:59','7','3',NULL,'49','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:6:\"tinggi\";i:425;s:5:\"fisik\";i:426;s:11:\"karbohidrat\";i:427;s:5:\"6dan8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','1','0','4','9','4','0','1','1','2','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:1:\"D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('554','10','15','248','ASAG','2025-05-26 15:03:08','2025-05-26 15:28:27','2025-05-26 15:34:00','7','3',NULL,'49','68',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,408,402,409,410,407,405,406,403,404,421,422,423,424,425,426,427,428,429,430,415,412,411,413,414,417,416,418,419,420,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('555','10','15','241','ASAG','2025-05-26 15:03:11','2025-05-26 15:38:31','2025-05-26 15:38:38','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:6:\"lantai\";i:424;s:10:\"kurangbaik\";i:425;s:9:\"kesehatan\";i:426;s:10:\"putihtelur\";i:427;s:1:\"8\";i:428;s:14:\"olahragalantai\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','5','9','5','0','0','1','0','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('556','10','15','239','ASAG','2025-05-26 15:03:11','2025-05-26 15:17:29','2025-05-26 15:18:12','5','5',NULL,'35','49',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:13:\"senamberirama\";i:424;s:6:\"tulang\";i:425;s:10:\"lingkungan\";i:426;s:7:\"protein\";i:427;s:5:\"tujuh\";i:428;s:8:\"olahraga\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','2','0','4','8','3','0','1','2','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, A, C, B\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('557','10','15','257','ASAG','2025-05-26 15:03:11','2025-05-26 15:31:40','2025-05-26 15:32:15','6','4',NULL,'42','51',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:15:\"memegangpinggul\";i:423;s:10:\"senamirama\";i:424;s:4:\"gizi\";i:425;s:8:\"kekuatan\";i:426;s:6:\"energi\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"C, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('558','10','15','264','ASAG','2025-05-26 15:03:11','2025-05-26 15:24:32','2025-05-26 15:32:16','7','3',NULL,'49','61',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"rollkedepan\";i:422;s:13:\"gulingkedepan\";i:423;s:5:\"irama\";i:424;s:25:\"anakberusia6sampai14tahun\";i:425;s:16:\"gizikeseimbangan\";i:426;s:14:\"zatpertumbuhan\";i:427;s:12:\"6sampai10jam\";i:428;s:8:\"olahraga\";i:429;s:15:\"kirisudutmatras\";i:430;s:7:\"barbell\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','0','1','0','5','10','4','0','0','0','2','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, B\";i:415;s:4:\"A, B\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('559','10','15','255','ASAG','2025-05-26 15:03:11','2025-05-26 15:32:41','2025-05-26 15:32:47','7','3',NULL,'49','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"C\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:7:\"berdiri\";i:423;s:11:\"senamlantai\";i:424;s:16:\"menjagapolamakan\";i:425;s:1:\"9\";i:426;s:7:\"zatbesi\";i:427;s:13:\"padamalamjam9\";i:428;s:11:\"senamlantai\";i:429;s:3:\"iya\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:4:\"C, D\";i:412;s:1:\"A\";i:413;s:1:\"B\";i:414;s:1:\"B\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"D, B, C, A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('560','10','15','267','ASAG','2025-05-26 15:03:11','2025-05-26 15:21:28','2025-05-26 15:23:30','4','6',NULL,'28','37',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:6:\"lantai\";i:424;s:10:\"tidak baik\";i:425;s:8:\"pubertas\";i:426;s:7:\"protein\";i:427;s:1:\"6\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:5:\"tubuh\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('561','10','15','237','ASAG','2025-05-26 15:03:12','2025-05-26 15:36:21','2025-05-26 15:36:24','4','6',NULL,'28','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"B\";i:404;s:1:\"D\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:11:\"tinggibadan\";i:425;s:8:\"perilaku\";i:426;s:8:\"zat besi\";i:427;s:2:\"10\";i:428;s:14:\"olahragalantai\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,430,429,428,427,426,425,424,423,422,421,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('562','10','15','274','ASAG','2025-05-26 15:03:12','2025-05-26 15:17:20','2025-05-26 15:32:10','5','5',NULL,'35','54',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:4:\"6-14\";i:425;s:5:\"fisik\";i:426;s:11:\"selpembantu\";i:427;s:3:\"6-8\";i:428;s:10:\"senambiasa\";i:429;s:13:\"kananataukiri\";i:430;s:6:\"matras\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','1','4','0','5','9','1','0','0','1','8','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('563','10','15','243','ASAG','2025-05-26 15:03:12','2025-05-26 15:34:20','2025-05-26 15:34:28','3','7',NULL,'21','36',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"B\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"B\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:9:\"kesehatan\";i:425;s:7:\"keadaan\";i:426;s:8:\"seltelur\";i:427;s:1:\"9\";i:428;s:11:\"senammatras\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,430,429,428,427,426,425,424,423,422,421,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:4:\"A, D\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('564','10','15','270','ASAG','2025-05-26 15:03:13','2025-05-26 15:20:41','2025-05-26 15:21:36','6','4',NULL,'42','60',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"D\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:5:\"tubuh\";i:425;s:9:\"kesehatan\";i:426;s:7:\"zatbesi\";i:427;s:7:\"sepuluh\";i:428;s:8:\"olahraga\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, A, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('565','10','15','283','ASAG','2025-05-26 15:03:14','2025-05-26 15:23:43','2025-05-26 15:32:10','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:10:\"berjongkok\";i:423;s:12:\"senambeirama\";i:424;s:5:\"tubuh\";i:425;s:5:\"fisik\";i:426;s:11:\"karbohidrat\";i:427;s:1:\"8\";i:428;s:12:\"senambeirama\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:4:\"A, B\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('566','10','15','268','ASAG','2025-05-26 15:03:14','2025-05-26 15:32:09','2025-05-26 15:32:18','6','4',NULL,'42','55',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:4:\"roll\";i:422;s:9:\"berguling\";i:423;s:11:\"senamlantai\";i:424;s:4:\"6-14\";i:425;s:7:\"protein\";i:426;s:13:\"zatputihtelur\";i:427;s:1:\"8\";i:428;s:12:\"keseimbangan\";i:429;s:6:\"ujung \";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,428,430,423,421,425,429,424,427,422,426,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"A\";i:414;s:4:\"A, D\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('567','10','15','254','ASAG','2025-05-26 15:03:14','2025-05-26 15:25:51','2025-05-26 15:31:59','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"C\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"A\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:7:\"berdiri\";i:423;s:8:\"berirama\";i:424;s:5:\"badan\";i:425;s:5:\"tubuh\";i:426;s:8:\"perotein\";i:427;s:1:\"8\";i:428;s:11:\"senammatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, C\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, A, C, D\";i:417;s:10:\"B, D, C, A\";i:418;s:10:\"B, C, A, D\";i:419;s:10:\"A, B, C, D\";i:420;s:7:\"A, D, C\";}');
INSERT INTO `nilai` VALUES ('568','10','15','251','ASAG','2025-05-26 15:03:15','2025-05-26 15:25:34','2025-05-26 15:32:04','5','5',NULL,'35','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:5:\"duduk\";i:423;s:5:\"irama\";i:424;s:4:\"otot\";i:425;s:7:\"keadaan\";i:426;s:4:\"besi\";i:427;s:1:\"8\";i:428;s:6:\"guling\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('569','10','15','275','ASAG','2025-05-26 15:03:15','2025-05-26 15:29:33','2025-05-26 15:32:03','4','6',NULL,'28','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"D\";i:408;s:1:\"A\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"matras\";i:422;s:11:\"melatihotot\";i:423;s:6:\"lantai\";i:424;s:16:\"dgnkesemimbangan\";i:425;s:13:\"tubuhpubertas\";i:426;s:10:\"otottangan\";i:427;s:11:\"6sampai5jam\";i:428;s:17:\"senamdiatasmatras\";i:429;s:11:\"ujungmatras\";i:430;s:18:\"senamygmelatihotot\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, C\";i:413;s:7:\"A, B, C\";i:414;s:4:\"B, D\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:7:\"D, A, C\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"A, B, D, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('570','10','15','258','ASAG','2025-05-26 15:03:15','2025-05-26 15:33:06','2025-05-26 15:33:27','2','8',NULL,'14','20',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:6:\"lompat\";i:422;s:7:\"berdiri\";i:423;s:11:\"senam badan\";i:424;s:5:\"badan\";i:425;s:11:\"pertumbuhan\";i:426;s:11:\"zat makanan\";i:427;s:2:\"12\";i:428;s:12:\"guling depan\";i:429;s:9:\"belakang \";i:430;s:7:\"materas\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','0','0','0','3','10','5','0','2','0','0','','6','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('571','10','15','262','ASAG','2025-05-26 15:03:15','2025-05-26 15:19:59','2025-05-26 15:32:23','3','7',NULL,'21','30',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:5:\"duduk\";i:423;s:11:\"senamlantai\";i:424;s:5:\"tubuh\";i:425;s:8:\"revolusi\";i:426;s:4:\"skip\";i:427;s:1:\"6\";i:428;s:10:\"senamirama\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:7:\"B, A, C\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('572','10','15','265','ASAG','2025-05-26 15:03:15','2025-05-26 15:31:08','2025-05-26 15:32:30','6','4',NULL,'42','47',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:10:\"lingkungan\";i:426;s:3:\"zat\";i:427;s:8:\"5sampai9\";i:428;s:13:\"senamdilantai\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('573','10','15','245','ASAG','2025-05-26 15:03:16','2025-05-26 15:32:16','2025-05-26 15:32:29','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"A\";}','a:10:{i:421;s:5:\"duduk\";i:422;s:7:\"berdiri\";i:423;s:11:\"senamlantai\";i:424;s:3:\"sel\";i:425;s:11:\"pertumbuhan\";i:426;s:5:\"tubuh\";i:427;s:7:\"belajar\";i:428;s:11:\"senamlantai\";i:429;s:5:\"kanan\";i:430;s:5:\"setik\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,426,422,427,424,429,425,421,423,430,428,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"A, D, C, B\";i:417;s:10:\"C, A, D, B\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('574','10','15','260','ASAG','2025-05-26 15:03:16','2025-05-26 15:21:18','2025-05-26 15:32:25','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"C\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"berdiri\";i:423;s:6:\"matras\";i:424;s:7:\"minimal\";i:425;s:5:\"fisik\";i:426;s:11:\"pertumbuhan\";i:427;s:2:\"14\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, D\";i:413;s:4:\"A, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, D, A, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('575','10','15','250','ASAG','2025-05-26 15:03:16','2025-05-26 15:33:35','2025-05-26 15:33:50','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:13:\"senamberirama\";i:424;s:3:\"nya\";i:425;s:10:\"keberanian\";i:426;s:7:\"kalsium\";i:427;s:1:\"8\";i:428;s:17:\"senamdiataslantai\";i:429;s:4:\"kiri\";i:430;s:17:\"senamdiataslantai\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"C, A, D, B\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"D, C, B, A\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('576','10','15','278','ASAG','2025-05-26 15:03:17','2025-05-26 15:23:18','2025-05-26 15:23:49','4','6',NULL,'28','35',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"C\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:7:\"berdiri\";i:423;s:10:\"senambadan\";i:424;s:10:\"makansayur\";i:425;s:15:\"mentaldansosial\";i:426;s:12:\"karbrohidrat\";i:427;s:1:\"9\";i:428;s:13:\"senampunggung\";i:429;s:5:\"depan\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','3','0','0','9','2','0','5','1','6','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"B, A, C\";i:417;s:10:\"C, A, B, D\";i:418;s:10:\"B, A, D, C\";i:419;s:10:\"D, B, A, C\";i:420;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('577','10','15','252','ASAG','2025-05-26 15:03:18','2025-05-26 15:30:02','2025-05-26 15:32:05','2','8',NULL,'14','24',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:8:\"jongkong\";i:423;s:6:\"lantai\";i:424;s:9:\"kesehatan\";i:425;s:9:\"kesehatan\";i:426;s:12:\"zatkesehatan\";i:427;s:4:\"9jam\";i:428;s:11:\"senam irama\";i:429;s:11:\"kananmatras\";i:430;s:12:\"seanam irama\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','0','2','0','3','10','3','0','2','0','4','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"B, C, A, D\";i:417;s:0:\"\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('578','10','15','238','ASAG','2025-05-26 15:03:18','2025-05-26 15:36:18','2025-05-26 15:36:25','5','5',NULL,'35','52',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:13:\"senamberirama\";i:424;s:4:\"gizi\";i:425;s:12:\"perkembangan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:14:\"olahragalantai\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:7:\"A, B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('579','10','15','240','ASAG','2025-05-26 15:03:19','2025-05-26 15:39:03','2025-05-26 15:39:05','0','10',NULL,'0','3',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"A\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:7:\"rolling\";i:422;s:7:\"gembira\";i:423;s:5:\"irama\";i:424;s:5:\"gatau\";i:425;s:6:\"mental\";i:426;s:14:\"pembangundarah\";i:427;s:10:\"delapanjam\";i:428;s:20:\"senamyangpakaimatras\";i:429;s:12:\"rollingdepan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:411;s:1:\"C\";i:412;s:1:\"D\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"A, C, B, D\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"B, A, D, C\";i:420;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('580','10','15','261','ASAG','2025-05-26 15:03:21','2025-05-26 15:26:16','2025-05-26 15:31:56','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"D\";i:406;s:1:\"B\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:11:\"senamlantai\";i:424;s:6:\"tinggi\";i:425;s:10:\"lingkungan\";i:426;s:7:\"zatbesi\";i:427;s:2:\"10\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, A, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('581','10','15','259','ASAG','2025-05-26 15:03:23','2025-05-26 15:29:39','2025-05-26 15:32:11','4','6',NULL,'28','40',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"D\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"gulimg\";i:422;s:7:\"jongkok\";i:423;s:4:\"pjok\";i:424;s:4:\"gizi\";i:425;s:8:\"kekuatan\";i:426;s:9:\"pembangun\";i:427;s:2:\"10\";i:428;s:11:\"senammatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','2','0','0','5','8','5','0','0','2','0','','10','a:5:{i:411;s:1:\"A\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"B\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('582','10','15','247','ASAG','2025-05-26 15:03:25','2025-05-26 15:22:09','2025-05-26 15:22:59','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:12:\"berdiritegak\";i:423;s:11:\"senamlantai\";i:424;s:4:\"otot\";i:425;s:11:\"pertumbuhan\";i:426;s:4:\"besi\";i:427;s:4:\"8jam\";i:428;s:45:\"senamyangdilakukandilantaidanberalaskanmatras\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,421,422,423,424,425,426,427,428,429,430,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, C\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, A, B\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"B, C, D, A\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('583','10','15','277','ASAG','2025-05-26 15:03:36','2025-05-26 15:32:23','2025-05-26 15:32:33','2','8',NULL,'14','20',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:12:\"startjongkok\";i:422;s:15:\"salto/berguling\";i:423;s:11:\"senam bebas\";i:424;s:13:\"yang maksimal\";i:425;s:17:\"mental dan sosial\";i:426;s:11:\"zat makanan\";i:427;s:6:\"6/8jam\";i:428;s:11:\"senam irama\";i:429;s:17:\"kanan/kiri matras\";i:430;s:12:\"matras/tikar\";}',NULL,'0','403,404,405,407,410,409,406,408,402,401,421,422,423,424,425,426,427,428,429,430,414,413,412,411,415,416,417,418,420,419,',NULL,NULL,'0','0','0','0','3','10','5','0','2','0','0','','6','a:5:{i:411;s:1:\"B\";i:412;s:1:\"A\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('584','10','15','276','ASAG','2025-05-26 15:03:43','2025-05-26 15:16:40','2025-05-26 15:17:15','1','9',NULL,'7','12',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"B\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:14:\"rollingkedepan\";i:422;s:5:\"lurus\";i:423;s:11:\"senamguling\";i:424;s:5:\"14-18\";i:425;s:10:\"putihtelur\";i:426;s:13:\"zatpertubuhan\";i:427;s:6:\"5-8jam\";i:428;s:9:\"pemanasan\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, D\";i:413;s:7:\"B, C, D\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"C, D, B, A\";i:417;s:10:\"C, A, D, B\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('585','10','15','246','ASAG','2025-05-26 15:03:49','2025-05-26 15:33:54','2025-05-26 15:34:13','2','8',NULL,'14','23',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:5:\"duduk\";i:423;s:8:\"berirama\";i:424;s:4:\"gizi\";i:425;s:8:\"perilaku\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:11:\"senamlantai\";i:429;s:7:\"samping\";i:430;s:6:\"matras\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,421,422,423,424,425,426,427,428,429,430,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:4:\"A, B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"D, B, A, C\";i:420;s:7:\"D, A, C\";}');
INSERT INTO `nilai` VALUES ('586','10','15','282','ASAG','2025-05-26 15:03:50','2025-05-26 15:22:03','2025-05-26 15:32:00','2','8',NULL,'14','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"A\";i:405;s:1:\"D\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:21:\"senamyangdigulingkan \";i:423;s:10:\"senambiasa\";i:424;s:22:\"yaitutumbuhpanjanglama\";i:425;s:14:\"tingginyabadan\";i:426;s:22:\"zatyangmemunuhimakanan\";i:427;s:11:\"6sampai8jam\";i:428;s:14:\"senampemanasan\";i:429;s:11:\"kananmatras\";i:430;s:18:\"musikdanpergerakan\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:411;s:4:\"A, B\";i:412;s:10:\"A, B, C, D\";i:413;s:7:\"A, B, C\";i:414;s:4:\"A, D\";i:415;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"A, D, B, C\";i:417;s:10:\"C, A, B, D\";i:418;s:10:\"A, B, D, C\";i:419;s:10:\"C, B, D, A\";i:420;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('587','10','15','281','ASAG','2025-05-26 15:03:57','2025-05-26 15:23:13','2025-05-26 15:32:05','5','5',NULL,'35','48',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"C\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:9:\"senam skj\";i:424;s:19:\"protein yang kurang\";i:425;s:13:\"perkembangan \";i:426;s:15:\"zat perbentukan\";i:427;s:6:\"8 jam \";i:428;s:12:\"senam matras\";i:429;s:13:\"agar seimbang\";i:430;s:7:\"matras \";}',NULL,'0','401,405,408,406,409,410,402,407,403,404,421,422,423,424,425,426,427,428,429,430,415,413,411,412,414,420,417,416,418,419,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, D\";i:413;s:4:\"A, D\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('588','10','15','256','ASAG','2025-05-26 15:03:57','2025-05-26 15:27:50','2025-05-26 15:32:02','3','7',NULL,'21','34',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"D\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"jongkok\";i:423;s:6:\"lantai\";i:424;s:4:\"gizi\";i:425;s:8:\"kekuatan\";i:426;s:8:\"protein \";i:427;s:1:\"7\";i:428;s:10:\"senamirama\";i:429;s:4:\"kiri\";i:430;s:21:\"dilakukandiatasmatras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"B, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:7:\"D, B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('589','10','15','234','ASAG','2025-05-26 15:03:58','2025-05-26 15:34:16','2025-05-26 15:34:36','4','6',NULL,'28','43',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:5:\"fisik\";i:425;s:12:\"perkembangan\";i:426;s:11:\"membraninti\";i:427;s:1:\"8\";i:428;s:10:\"senamirama\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,428,430,423,421,425,429,424,427,422,426,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','2','0','5','9','3','0','0','1','4','','10','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('590','10','15','284','ASAG','2025-05-26 15:03:58','2025-05-26 15:26:53','2025-05-26 15:32:13','5','5',NULL,'35','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"A\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:5:\"fisik\";i:425;s:5:\"fisik\";i:426;s:11:\"antioksidan\";i:427;s:3:\"6-8\";i:428;s:10:\"senamirama\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','402,401,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,412,413,411,414,416,417,418,419,420,',NULL,NULL,'0','2','0','0','4','8','5','0','1','2','0','','8','a:5:{i:411;s:7:\"A, B, C\";i:412;s:7:\"A, B, D\";i:413;s:7:\"B, C, D\";i:414;s:4:\"B, C\";i:415;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('591','10','15','272','ASAG','2025-05-26 15:03:59','2025-05-26 15:29:46','2025-05-26 15:32:03','2','8',NULL,'14','17',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:10:\"mengguling\";i:422;s:7:\"berdiri\";i:423;s:5:\"irama\";i:424;s:14:\"kekurangangizi\";i:425;s:9:\"kesehatan\";i:426;s:7:\"zatbesi\";i:427;s:1:\"8\";i:428;s:5:\"irama\";i:429;s:11:\"depanmatras\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, C\";i:413;s:4:\"B, C\";i:414;s:1:\"D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, B, C\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"D, C, A, B\";i:420;s:7:\"C, A, B\";}');
INSERT INTO `nilai` VALUES ('592','10','15','263','ASAG','2025-05-26 15:04:01','2025-05-26 15:26:35','2025-05-26 15:32:12','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:17:\"gulingkedepan/rol\";i:422;s:8:\"mendarat\";i:423;s:8:\"berirama\";i:424;s:4:\"gizi\";i:425;s:9:\"kesehatan\";i:426;s:4:\"otot\";i:427;s:1:\"6\";i:428;s:14:\"senam berirama\";i:429;s:7:\"pinggir\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:411;s:7:\"A, B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('593','10','15','295','ASAG','2025-05-26 15:04:03','2025-05-26 15:25:09','2025-05-26 15:32:05','3','7',NULL,'21','24',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"C\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:7:\"guling \";i:422;s:7:\"berdiri\";i:423;s:10:\"anak sehat\";i:424;s:9:\"kesehatan\";i:425;s:10:\"ketumbuhan\";i:426;s:6:\"kepala\";i:427;s:7:\"6 menit\";i:428;s:5:\"lilin\";i:429;s:5:\"kanan\";i:430;s:8:\"kambelit\";}',NULL,'0','410,409,408,407,406,405,404,403,402,401,430,429,428,427,426,425,424,423,422,421,415,414,413,412,411,420,419,418,417,416,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:411;s:1:\"B\";i:412;s:1:\"B\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"C, B, D, A\";i:417;s:10:\"A, C, D, B\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('594','10','15','244','ASAG','2025-05-26 15:04:03','2025-05-26 15:32:48','2025-05-26 15:33:16','4','6',NULL,'28','44',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:16:\"bergulingkedepan\";i:422;s:16:\"bergulingkedepan\";i:423;s:11:\"senamlantai\";i:424;s:9:\"kebugaran\";i:425;s:9:\"kesehatan\";i:426;s:47:\"zatyangmempengaruhipertumbuhandanpembentukansel\";i:427;s:4:\"8jam\";i:428;s:10:\"senamirama\";i:429;s:10:\"kirimatras\";i:430;s:17:\"matrastongkatpita\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','0','3','0','5','10','2','0','0','0','6','','10','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"A\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('595','10','15','242','ASAG','2025-05-26 15:04:06','2025-05-26 15:29:46','2025-05-26 15:32:09','3','7',NULL,'21','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:11:\"senamlantai\";i:422;s:16:\"jongkokarahdepan\";i:423;s:6:\"lantai\";i:424;s:7:\"jasmani\";i:425;s:11:\"pertumbuhan\";i:426;s:13:\"tumbuhkembang\";i:427;s:1:\"9\";i:428;s:9:\"berguling\";i:429;s:8:\"belakang\";i:430;s:1:\" \";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','0','0','0','5','10','5','0','0','0','0','','10','a:5:{i:411;s:1:\"C\";i:412;s:1:\"B\";i:413;s:1:\"B\";i:414;s:1:\"C\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('596','10','15','233','ASAG','2025-05-26 15:04:07','2025-05-26 15:37:15','2025-05-26 15:37:43','3','7',NULL,'21','32',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:3:\"rol\";i:422;s:16:\"manundukankepala\";i:423;s:5:\"irama\";i:424;s:4:\"anak\";i:425;s:5:\"tubuh\";i:426;s:8:\" protein\";i:427;s:1:\"8\";i:428;s:10:\"senamfisik\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:1:\"D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:4:\"B, A\";i:417;s:10:\"B, A, D, C\";i:418;s:4:\"D, C\";i:419;s:1:\"A\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('597','10','15','286','ASAG','2025-05-26 15:04:07','2025-05-26 15:27:45','2025-05-26 15:32:01','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:7:\"berdiri\";i:423;s:10:\"senamirama\";i:424;s:8:\"anakanak\";i:425;s:5:\"fisik\";i:426;s:7:\"protein\";i:427;s:1:\"6\";i:428;s:5:\"senam\";i:429;s:8:\"belakang\";i:430;s:10:\"tangankaki\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,421,422,423,424,425,426,427,428,429,430,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, D\";i:413;s:4:\"C, D\";i:414;s:4:\"A, D\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, B, C\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"D, A, B, C\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('598','10','15','236','ASAG','2025-05-26 15:04:09','2025-05-26 15:34:45','2025-05-26 15:35:16','3','7',NULL,'21','30',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"C\";}','a:10:{i:421;s:5:\"senam\";i:422;s:5:\"senam\";i:423;s:10:\"senamirama\";i:424;s:4:\"6-14\";i:425;s:10:\"berkembang\";i:426;s:15:\"zatputihtrlulur\";i:427;s:2:\"10\";i:428;s:11:\"senamlamtai\";i:429;s:8:\"roldepan\";i:430;s:6:\"matras\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,430,429,428,427,426,425,424,423,422,421,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"B, D\";i:413;s:4:\"A, C\";i:414;s:1:\"B\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, A, B, C\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('599','10','15','294','ASAG','2025-05-26 15:04:09','2025-05-26 15:37:29','2025-05-26 15:38:15','3','7',NULL,'21','29',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:17:\"diluruskankedepan\";i:422;s:34:\"sikapakhirnyamenumpulurusdantertib\";i:423;s:10:\"senamirama\";i:424;s:27:\"pencernanyangkurangmaksimal\";i:425;s:23:\"pubertasmentaldansosial\";i:426;s:34:\"pencernaanatauzatkotordidalamtubuh\";i:427;s:13:\"8jamatau16jam\";i:428;s:77:\"senamyangmemilikikhususbadanataugerakandisebutjugaksenamiramaatausenamlainnya\";i:429;s:10:\"kirimatras\";i:430;s:40:\"matrasatautanahdankayuuntukmenahanmatras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','0','1','0','3','10','4','0','2','0','2','','6','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, C\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"B, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, C, D, A\";i:418;s:10:\"B, A, C, D\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('600','10','15','235','ASAG','2025-05-26 15:04:10','2025-05-26 15:38:16','2025-05-26 15:38:21','4','6',NULL,'28','46',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"B\";i:404;s:1:\"A\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:6:\"guling\";i:422;s:28:\"meluruskankedualengankedepan\";i:423;s:5:\"irama\";i:424;s:5:\"badan\";i:425;s:9:\"kesehatan\";i:426;s:7:\"protein\";i:427;s:1:\"8\";i:428;s:10:\"senambebas\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,426,422,427,424,429,425,421,423,430,428,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('601','10','15','290','ASAG','2025-05-26 15:04:14','2025-05-26 15:36:19','2025-05-26 15:36:44','3','7',NULL,'21','30',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"B\";i:403;s:1:\"D\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:10:\"senamirama\";i:424;s:4:\"anak\";i:425;s:9:\"kekuaatan\";i:426;s:7:\"protein\";i:427;s:8:\"10-12jam\";i:428;s:10:\"senambadan\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','407,401,404,403,409,405,402,408,410,406,421,422,423,424,425,426,427,428,429,430,413,414,411,412,415,416,417,418,419,420,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"C, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, D\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, C, D\";i:418;s:10:\"D, A, B, C\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('602','10','15','293','ASAG','2025-05-26 15:04:21','2025-05-26 15:24:31','2025-05-26 15:32:07','3','7',NULL,'21','31',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"D\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"B\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:9:\"berguling\";i:422;s:7:\"jongkok\";i:423;s:7:\"aerobik\";i:424;s:14:\"6sampai14tahun\";i:425;s:8:\"kekuatan\";i:426;s:8:\"selputih\";i:427;s:11:\"7sampai8jam\";i:428;s:11:\"senamlantai\";i:429;s:4:\"kiri\";i:430;s:6:\"matras\";}',NULL,'0','406,410,408,402,405,409,403,404,401,407,421,422,423,424,425,426,427,428,429,430,415,412,411,414,413,417,418,419,420,416,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, B\";i:413;s:4:\"A, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, C, B, D\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, C, B, D\";i:420;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('603','10','15','288','ASAG','2025-05-26 15:04:25','2025-05-26 15:33:10','2025-05-26 15:33:20','4','6',NULL,'28','33',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"A\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"D\";}','a:10:{i:421;s:11:\"gulingdepan\";i:422;s:7:\"jongkok\";i:423;s:5:\"irama\";i:424;s:4:\"otak\";i:425;s:11:\"pertumbuhan\";i:426;s:3:\"sel\";i:427;s:5:\"10jam\";i:428;s:5:\"senam\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','406,410,402,405,408,409,404,401,403,407,421,422,423,424,425,426,427,428,429,430,413,411,412,414,415,416,418,420,417,419,',NULL,NULL,'0','1','0','0','2','9','5','0','3','1','0','','4','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"B, D, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"B, D, A, C\";i:419;s:10:\"A, C, D, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('604','10','15','279','ASAG','2025-05-26 15:04:37','2025-05-26 15:24:07','2025-05-26 15:32:01','5','5',NULL,'35','44',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"C\";i:409;s:1:\"C\";i:410;s:1:\"D\";}','a:10:{i:421;s:13:\"gulingkedepan\";i:422;s:18:\"jongkoklaluberdiri\";i:423;s:10:\"senamirama\";i:424;s:5:\"badan\";i:425;s:5:\"fisik\";i:426;s:26:\"zatpembangunsel-selditubuh\";i:427;s:3:\"5-8\";i:428;s:10:\"senamfisik\";i:429;s:5:\"kanan\";i:430;s:6:\"matras\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,421,422,423,424,425,426,427,428,429,430,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','1','1','0','3','9','4','0','2','1','2','','6','a:5:{i:411;s:1:\"B\";i:412;s:4:\"A, D\";i:413;s:1:\"B\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, C, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"A, C, D, B\";}');
INSERT INTO `nilai` VALUES ('605','10','15','249','ASAG','2025-05-26 15:05:24','2025-05-26 15:38:33','2025-05-26 15:39:24','3','7',NULL,'21','28',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"D\";i:402;s:1:\"A\";i:403;s:1:\"A\";i:404;s:1:\"B\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"A\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:20:\"gerakangulingkedepan\";i:422;s:39:\"penutupangerakadalahsepertigerkantangan\";i:423;s:13:\"senamberirama\";i:424;s:39:\"sepertikurangtenagadankurangpengetahuan\";i:425;s:9:\"pubrertas\";i:426;s:34:\"selsepertiberoiahragasepertijoging\";i:427;s:14:\"sebaiknyajam10\";i:428;s:26:\"senamyangmemilikiperalatan\";i:429;s:39:\"posisidepankitayangakanditahanolehtemam\";i:430;s:6:\"matras\";}',NULL,'0','401,402,408,406,409,410,407,405,404,403,426,422,427,424,429,425,421,423,430,428,415,411,412,413,414,419,416,417,418,420,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"A, C\";i:413;s:4:\"B, D\";i:414;s:4:\"A, C\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, C, B, A\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, C, A, B\";i:419;s:10:\"A, D, C, B\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('606','10','15','271','ASAG','2025-05-26 15:05:58','2025-05-26 15:23:34','2025-05-26 15:32:08','1','9',NULL,'7','16',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"B\";i:402;s:1:\"D\";i:403;s:1:\"C\";i:404;s:1:\"C\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"D\";i:408;s:1:\"C\";i:409;s:1:\"B\";i:410;s:1:\"B\";}','a:10:{i:421;s:16:\"rolling ke depan\";i:422;s:7:\"jongkok\";i:423;s:8:\"berirama\";i:424;s:5:\"badan\";i:425;s:4:\"gizi\";i:426;s:11:\"karbohidrat\";i:427;s:9:\"6 - 8 jam\";i:428;s:11:\"senam irama\";i:429;s:4:\"kiri\";i:430;s:11:\"radio musik\";}',NULL,'0','401,402,403,404,405,406,407,408,409,410,426,422,427,424,429,425,421,423,430,428,411,412,413,414,415,416,417,418,419,420,',NULL,NULL,'0','1','0','0','4','9','5','0','1','1','0','','8','a:5:{i:411;s:4:\"A, B\";i:412;s:4:\"B, D\";i:413;s:4:\"A, B\";i:414;s:4:\"A, B\";i:415;s:4:\"C, D\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, B, A, C\";i:419;s:10:\"A, B, D, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('607','10','15','280','ASAG','2025-05-26 15:06:17','2025-05-26 15:30:26','2025-05-26 15:32:11','2','8',NULL,'14','18',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"A\";i:404;s:1:\"C\";i:405;s:1:\"A\";i:406;s:1:\"A\";i:407;s:1:\"B\";i:408;s:1:\"B\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:19:\"gerakan senam badan\";i:422;s:22:\"garekan guling kedepan\";i:423;s:10:\"senambadan\";i:424;s:17:\"6 sampai 15 tahun\";i:425;s:14:\"pertumbuhahan \";i:426;s:24:\"zat yang bagus untuk sel\";i:427;s:5:\"8 jam\";i:428;s:11:\"senam badan\";i:429;s:14:\"guiing kemtras\";i:430;s:13:\"waktu berlari\";}',NULL,'0','401,403,407,404,402,405,408,409,406,410,428,430,423,421,425,429,424,427,422,426,415,412,414,411,413,419,417,420,418,416,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"A\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"A, B, C, D\";i:418;s:10:\"D, B, C, A\";i:419;s:4:\"B, C\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('608','10','15','266','ASAG','2025-05-26 15:07:44','2025-05-26 15:42:39','2025-05-26 15:42:48','1','9',NULL,'7','9',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"B\";i:403;s:1:\"C\";i:404;s:1:\"D\";i:405;s:1:\"B\";i:406;s:1:\"C\";i:407;s:1:\"C\";i:408;s:1:\"A\";i:409;s:1:\"A\";i:410;s:1:\"B\";}','a:10:{i:421;s:9:\"ototperut\";i:422;s:8:\"ototkaki\";i:423;s:5:\"irama\";i:424;s:6:\"gataha\";i:425;s:6:\"gatahu\";i:426;s:6:\"gatahu\";i:427;s:6:\"gatahu\";i:428;s:6:\"gatahu\";i:429;s:6:\"gatahu\";i:430;s:6:\"gatahu\";}',NULL,'0','404,403,407,402,410,409,406,408,405,401,421,422,423,424,425,426,427,428,429,430,414,412,411,413,415,416,418,419,417,420,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:411;s:1:\"B\";i:412;s:1:\"C\";i:413;s:1:\"A\";i:414;s:1:\"A\";i:415;s:1:\"C\";}','a:0:{}','a:5:{i:416;s:10:\"C, B, D, A\";i:417;s:10:\"C, A, D, B\";i:418;s:10:\"C, D, B, A\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('609','10','15','253','ASAG','2025-05-26 15:20:55','2025-05-26 15:35:30','2025-05-26 15:36:35','4','6',NULL,'28','45',NULL,'180.242.21.245','0','a:10:{i:401;s:1:\"A\";i:402;s:1:\"D\";i:403;s:1:\"B\";i:404;s:1:\"B\";i:405;s:1:\"B\";i:406;s:1:\"D\";i:407;s:1:\"C\";i:408;s:1:\"C\";i:409;s:1:\"A\";i:410;s:1:\"A\";}','a:10:{i:421;s:4:\"roll\";i:422;s:7:\"rebahan\";i:423;s:5:\"irama\";i:424;s:4:\"baik\";i:425;s:11:\"pertumbuhan\";i:426;s:5:\"enzim\";i:427;s:2:\"16\";i:428;s:21:\"senammengunakanmatras\";i:429;s:8:\"belakang\";i:430;s:6:\"matras\";}',NULL,'0','404,403,406,405,407,410,409,402,408,401,421,422,423,424,425,426,427,428,429,430,414,413,411,412,415,420,416,418,419,417,',NULL,NULL,'0','1','4','0','4','9','1','0','1','1','8','','8','a:5:{i:411;s:4:\"B, C\";i:412;s:4:\"A, D\";i:413;s:4:\"B, C\";i:414;s:4:\"A, D\";i:415;s:4:\"A, C\";}','a:0:{}','a:5:{i:416;s:10:\"D, B, C, A\";i:417;s:10:\"B, A, D, C\";i:418;s:10:\"D, A, C, B\";i:419;s:10:\"A, B, C, D\";i:420;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('610','11','18','306','ASAG','2025-05-27 07:35:24','2025-05-27 08:14:32','2025-05-27 08:15:26','6','4',NULL,'42','43',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:5:\"wawas\";i:179;s:1:\"3\";i:180;s:9:\"baju adat\";i:181;s:12:\"2 kerakyatan\";i:182;s:7:\"karena \";i:183;s:4:\"aceh\";i:184;s:10:\"indonesia \";i:185;s:7:\"dongeng\";i:186;s:5:\"gatau\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,181,184,187,179,185,182,183,180,186,178,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:166;s:7:\"A, B, C\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, B\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, B, C\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('611','11','18','307','ASAG','2025-05-27 07:35:25','2025-05-27 08:16:12','2025-05-27 08:17:56','3','7',NULL,'21','26',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:1:\"1\";i:181;s:14:\"mempertahankan\";i:182;s:12:\" mempertarik\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"musik\";i:186;s:1:\"5\";i:187;s:4:\"asia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, B, C\";i:171;s:7:\"B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:7:\"B, A, C\";i:175;s:7:\"A, C, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('612','11','18','316','ASAG','2025-05-27 07:35:29','2025-05-27 08:15:11','2025-05-27 08:15:27','6','4',NULL,'42','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:5:\"wawas\";i:179;s:2:\"38\";i:180;s:45:\"persatuan indonesia dan kemerdekaan indonesia\";i:181;s:20:\"bermasyarakat makmur\";i:182;s:1:\"p\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:10:\"rumah adat\";i:186;s:18:\"pesatuan indonesia\";i:187;s:26:\"benua asia dan benua eropa\";}',NULL,'0','159,154,152,151,148,156,161,165,162,164,181,184,187,179,185,182,183,180,186,178,171,168,172,166,170,173,175,176,177,174,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('613','11','18','313','ASAG','2025-05-27 07:35:30','2025-05-27 08:20:31','2025-05-27 08:20:48','7','3',NULL,'49','56',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:44:\"terwujudnyapersatuanbangsadankesatuanwilayah\";i:179;s:2:\"29\";i:180;s:13:\"taridanbahasa\";i:181;s:1:\"-\";i:182;s:46:\"karenabudayakitaunikdankayaakannilainilailuhur\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:9:\"bahasanya\";i:186;s:1:\"-\";i:187;s:16:\"asiadanaustralia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,186,180,183,182,185,179,187,184,181,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:166;s:7:\"B, C, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:1:\"A\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, B, C\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('614','11','18','300','ASAG','2025-05-27 07:35:30','2025-05-27 08:20:26','2025-05-27 08:20:49','4','6',NULL,'28','31',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"B\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"A\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:5:\"pulau\";i:179;s:16:\"jawa jokjakarta \";i:180;s:5:\"asia \";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:4:\"aceh\";i:184;s:11:\"Tidak Diisi\";i:185;s:24:\"berbahasa aceh adat aceh\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, D\";i:170;s:1:\"B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, D, A\";i:176;s:10:\"C, B, D, A\";i:177;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('615','11','18','308','ASAG','2025-05-27 07:35:33','2025-05-27 08:20:23','2025-05-27 08:20:47','4','6',NULL,'28','36',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"B\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"34\";i:180;s:36:\"objek kesatuan dan objek kemanusiaan\";i:181;s:11:\"Tidak Diisi\";i:182;s:14:\"sangat penting\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:7:\"mencaeh\";i:186;s:12:\"pemerintahan\";i:187;s:14:\"samudra hindia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','2','3','0','0','8','2','0','5','2','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('616','11','18','319','ASAG','2025-05-27 07:35:36','2025-05-27 08:16:54','2025-05-27 08:17:26','8','2',NULL,'56','60',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:74:\"wawasan dan nusantara di ambil dari nusa dan tara                         \";i:179;s:10:\"4 provinsi\";i:180;s:60:\"mengembangkan nilai leluhur bangsa dan memperteguh jati diri\";i:181;s:30:\"menjaga bangsa agar tetap utuh\";i:182;s:56:\"agar bisa memperkenalkan budaya kita kepada orang banyak\";i:183;s:7:\"tradisi\";i:184;s:10:\"indonesia \";i:185;s:19:\"kearifan seni lokal\";i:186;s:40:\"undang undang nomor 5 tahun 2017 pasal 5\";i:187;s:25:\"geografis dan globalisasi\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:4:\"B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:4:\"B, A\";i:177;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('617','11','18','304','ASAG','2025-05-27 07:35:36','2025-05-27 08:12:56','2025-05-27 08:15:09','5','5',NULL,'35','39',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:16:\"pulau dan lautan\";i:179;s:1:\"9\";i:180;s:22:\"persatuan dan kesatuan\";i:181;s:45:\"mempertahankan budaya dan melestarikan budaya\";i:182;s:18:\"agar tidak memudar\";i:183;s:4:\"aceh\";i:184;s:8:\"malaysia\";i:185;s:4:\"tari\";i:186;s:56:\"undang undang yang membangun kemajuan ekonomi masyarakat\";i:187;s:18:\"asia dan australia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, D, A, B\";i:174;s:7:\"C, B, A\";i:175;s:10:\"A, D, C, B\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('618','11','18','312','ASAG','2025-05-27 07:35:39','2025-05-27 08:13:15','2025-05-27 08:15:06','5','5',NULL,'35','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:10:\"berkembang\";i:179;s:5:\"barat\";i:180;s:9:\"pancasila\";i:181;s:23:\"bersatu untuk indinesia\";i:182;s:44:\"karna kita harus menjaga nilai nilai leluhur\";i:183;s:4:\"aceh\";i:184;s:19:\"menjaga nilai nilai\";i:185;s:27:\"bungong jempa mulai memudar\";i:186;s:28:\"memajukan nilai nilai budaya\";i:187;s:5:\"asia \";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:1:\"A\";i:170;s:1:\"C\";i:171;s:4:\"B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:1:\"B\";i:175;s:1:\"A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('619','11','18','296','ASAG','2025-05-27 07:35:39','2025-05-27 08:16:06','2025-05-27 08:16:20','7','3',NULL,'49','58',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"34\";i:180;s:5:\"bagus\";i:181;s:26:\"menjaga kelestarian budaya\";i:182;s:26:\"agar tidak pudar budayanya\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:8:\"literasi\";i:186;s:13:\"budaya bangsa\";i:187;s:20:\"australia dan afrika\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,186,180,183,182,185,179,187,184,181,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:4:\"B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('620','11','18','315','ASAG','2025-05-27 07:35:39','2025-05-27 08:17:46','2025-05-27 08:17:53','7','3',NULL,'49','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"2 daratan\";i:179;s:2:\"38\";i:180;s:0:\"\";i:181;s:14:\"tidak berpecah\";i:182;s:14:\"memiliki makna\";i:183;s:4:\"aceh\";i:184;s:4:\"bali\";i:185;s:9:\"baju adat\";i:186;s:0:\"\";i:187;s:18:\"asia dan australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:7:\"C, A, B\";i:175;s:10:\"A, B, D, C\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('621','11','18','299','ASAG','2025-05-27 07:35:42','2025-05-27 08:14:56','2025-05-27 08:17:24','5','5',NULL,'35','46',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:10:\"pandanggan\";i:179;s:2:\"54\";i:180;s:19:\"manuskrip fotografi\";i:181;s:9:\"persatuan\";i:182;s:24:\"agar tetap terlestarikan\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:21:\"5 tahun 20017 pasal 5\";i:187;s:14:\"asia australia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','3','3','0','1','7','2','0','4','3','6','','2','a:5:{i:166;s:7:\"B, C, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:4:\"B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('622','11','18','323','ASAG','2025-05-27 07:35:42','2025-05-27 08:18:48','2025-05-27 08:18:59','6','4',NULL,'42','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:4:\"wawa\";i:179;s:2:\"34\";i:180;s:0:\"\";i:181;s:0:\"\";i:182;s:0:\"\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:10:\"rumah adat\";i:186;s:0:\"\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:10:\"A, B, C, D\";i:170;s:7:\"A, B, D\";i:171;s:10:\"A, B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"B, A, D, C\";i:174;s:7:\"B, C, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"A, D, C, B\";}');
INSERT INTO `nilai` VALUES ('623','11','18','322','ASAG','2025-05-27 07:35:43','2025-05-27 08:20:47','2025-05-27 08:20:50','7','3',NULL,'49','53',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:0:\"\";i:179;s:0:\"\";i:180;s:0:\"\";i:181;s:0:\"\";i:182;s:0:\"\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:0:\"\";i:186;s:0:\"\";i:187;s:19:\"asia dan astraulia \";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:0:\"\";i:170;s:1:\"D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:4:\"D, C\";i:174;s:4:\"A, B\";i:175;s:10:\"A, B, C, D\";i:176;s:7:\"A, C, D\";i:177;s:7:\"C, D, B\";}');
INSERT INTO `nilai` VALUES ('624','11','18','325','ASAG','2025-05-27 07:35:45','2025-05-27 08:20:44','2025-05-27 08:21:02','0','10',NULL,'0','0',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"X\";i:151;s:1:\"X\";i:152;s:1:\"X\";i:154;s:1:\"X\";i:156;s:1:\"X\";i:159;s:1:\"X\";i:161;s:1:\"X\";i:162;s:1:\"X\";i:164;s:1:\"X\";i:165;s:1:\"X\";}','a:10:{i:178;s:11:\"Tidak Diisi\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;N;i:168;N;i:170;N;i:171;N;i:172;N;}','a:0:{}','a:5:{i:173;N;i:174;N;i:175;N;i:176;N;i:177;N;}');
INSERT INTO `nilai` VALUES ('625','11','18','352','ASAG','2025-05-27 07:35:46','2025-05-27 08:18:31','2025-05-27 08:18:41','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"tradisi dan manusia\";i:181;s:22:\"persatuan dan kesatuan\";i:182;s:32:\"untuk memperkuat keutuhan bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:4:\"jawa\";i:186;s:4:\"2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','5','2','0','0','5','3','0','5','5','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:0:\"\";i:176;s:10:\"B, A, D, C\";i:177;s:10:\"D, A, C, B\";}');
INSERT INTO `nilai` VALUES ('626','11','18','311','ASAG','2025-05-27 07:35:47','2025-05-27 08:14:41','2025-05-27 08:15:05','7','3',NULL,'49','62',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:3:\"318\";i:180;s:39:\"permainan tradisional dan tradisi lisan\";i:181;s:9:\"persatuan\";i:182;s:17:\"menghargai budaya\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"lawak\";i:186;s:20:\"nomor 5 2017 pasal 5\";i:187;s:17:\"asia dan autralia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','3','0','2','7','2','0','3','3','6','','4','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:7:\"A, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('627','11','18','305','ASAG','2025-05-27 07:35:48','2025-05-27 08:17:11','2025-05-27 08:17:15','5','5',NULL,'35','46',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"C\";i:161;s:1:\"B\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:0:\"\";i:179;s:2:\"16\";i:180;s:1:\"-\";i:181;s:1:\"-\";i:182;s:1:\"-\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"idont\";i:186;s:1:\"-\";i:187;s:14:\"australia asia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,187,186,185,184,183,182,181,180,179,178,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"B, A, D, C\";i:174;s:7:\"B, A, C\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('628','11','18','298','ASAG','2025-05-27 07:35:48','2025-05-27 08:20:22','2025-05-27 08:21:07','4','6',NULL,'28','28',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"C\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:49:\"terwujudnya persatuan bangsa dan kesatuan wilayah\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','154,161,165,156,148,152,164,162,159,151,178,179,180,181,182,183,184,185,186,187,166,168,172,171,170,177,175,176,173,174,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:4:\"A, C\";i:171;s:1:\"B\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, B, D\";i:174;s:10:\"B, C, A, D\";i:175;s:7:\"B, D, A\";i:176;s:7:\"D, A, B\";i:177;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('629','11','18','314','ASAG','2025-05-27 07:35:50','2025-05-27 08:15:55','2025-05-27 08:16:06','7','3',NULL,'49','62',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:15:\"pengetahuan uud\";i:181;s:9:\"persatuan\";i:182;s:21:\"tradisi turun temurun\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:8:\"literasi\";i:186;s:22:\"permainan traadisional\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','3','4','0','1','7','1','0','4','3','8','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('630','11','18','317','ASAG','2025-05-27 07:35:53','2025-05-27 08:20:34','2025-05-27 08:21:14','4','6',NULL,'28','32',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:24:\"wawasan adalah pandangan\";i:179;s:11:\"Tidak Diisi\";i:180;s:33:\"objek persatuan objek kemanusiaan\";i:181;s:50:\"bangsa bangsa  yang menjaga kelestarian budaya nya\";i:182;s:53:\"agar tidak terjadinya pertengkaran antar warga negara\";i:183;s:11:\"budaya aceh\";i:184;s:7:\"mecak e\";i:185;s:25:\"cerpen puisi bahasa aceh \";i:186;s:10:\"pemerintah\";i:187;s:14:\"asia australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"A, B, C, D\";i:177;s:0:\"\";}');
INSERT INTO `nilai` VALUES ('631','11','18','326','ASAG','2025-05-27 07:35:55','2025-05-27 08:14:15','2025-05-27 08:15:31','5','5',NULL,'35','40',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"hati hati\";i:179;s:8:\"berbagai\";i:180;s:10:\"teknologi \";i:181;s:9:\"persatuan\";i:182;s:43:\"agar tidak terjerumus oleh kebudayaan asing\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:6:\"meucae\";i:186;s:12:\"pemerintahan\";i:187;s:14:\"samudra hindia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"B, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('632','11','18','349','ASAG','2025-05-27 07:35:56','2025-05-27 08:16:59','2025-05-27 08:17:23','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:11:\"terwujudnya\";i:179;s:2:\"38\";i:180;s:34:\"negara kesatuan republik indonesia\";i:181;s:35:\"kesatuan dan persatuan suatu bangsa\";i:182;s:52:\"agar generasi baru dapat mengenal budaya bangsa kita\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:13:\"tradisi lisan\";i:186;s:37:\"undang undang no 5 tahun 2017 pasal 5\";i:187;s:18:\"australia dan asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"B, A, C\";i:175;s:7:\"B, C, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('633','11','18','345','ASAG','2025-05-27 07:35:56','2025-05-27 08:15:52','2025-05-27 08:16:02','6','4',NULL,'42','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:51:\"persatuan dan kesatuan dalam segala aspek kehidupan\";i:182;s:95:\"penting bagi masyarakat untuk melestarikan budaya karena identitas nasional dan warisan leluhur\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:17:\"uu no5 tahun 2017\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','6','2','0','1','4','3','0','4','6','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('634','11','18','351','ASAG','2025-05-27 07:35:56','2025-05-27 08:19:19','2025-05-27 08:19:23','4','6',NULL,'28','35',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"D\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:58:\"berasal dari kata yunani yang artinya wawas atau pandangan\";i:179;s:2:\"38\";i:180;s:19:\"tradisi dan manusia\";i:181;s:22:\"persatuan dan kesatuan\";i:182;s:32:\"untuk memperkuat keutuhan bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"nomor 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','5','1','0','0','5','4','0','5','5','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, C, D\";i:171;s:1:\"A\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"D, C, B, A\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"B, D, A, C\";i:176;s:10:\"C, D, A, B\";i:177;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('635','11','18','337','ASAG','2025-05-27 07:35:57','2025-05-27 08:18:14','2025-05-27 08:18:21','7','3',NULL,'49','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:50:\"terwujudnya persatuan bangsa dan persatuan wilayah\";i:179;s:2:\"38\";i:180;s:11:\"kebudayaan \";i:181;s:35:\"persatuan dan kesatuan suatu negara\";i:182;s:48:\"karena supaya di kenal dengan generasi yang baru\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:41:\"tradisi lisan dalam bercerita bahasa aceh\";i:186;s:23:\"uu 5 tahun 2017 pasal 5\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','159,154,152,151,148,156,161,165,162,164,178,179,180,181,182,183,184,185,186,187,171,168,172,166,170,173,175,176,177,174,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:4:\"A, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, C, A\";i:176;s:10:\"C, D, B, A\";i:177;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('636','11','18','301','ASAG','2025-05-27 07:35:58','2025-05-27 08:15:54','2025-05-27 08:17:21','5','5',NULL,'35','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"34 provinsi\";i:180;s:37:\"1 kesatuan bangsa 2 wawasan nusantara\";i:181;s:32:\"agar tidak saling berpecah belah\";i:182;s:37:\"agar tidak pudar dari kalangan bangsa\";i:183;s:4:\"aceh\";i:184;s:9:\"nusantara\";i:185;s:11:\"bahasa adat\";i:186;s:29:\"mengembangkan rasa kebudayaan\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:4:\"A, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, B, D\";i:176;s:10:\"C, D, A, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('637','11','18','320','ASAG','2025-05-27 07:35:59','2025-05-27 08:19:59','2025-05-27 08:20:04','6','4',NULL,'42','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:16:\"kesatuan wilayah\";i:179;s:2:\"32\";i:180;s:17:\"bahasa dari rumah\";i:181;s:9:\"persatuan\";i:182;s:31:\"harus menghargai budaya sendiri\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:5:\"lawak\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"A, C, D\";i:175;s:7:\"B, C, A\";i:176;s:10:\"A, C, B, D\";i:177;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('638','11','18','336','ASAG','2025-05-27 07:35:59','2025-05-27 08:17:17','2025-05-27 08:18:23','8','2',NULL,'56','68',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:51:\"persatuan dan kesatuan dalam segala aspek kehidupan\";i:182;s:34:\"untuk memperkuat keutuhan nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','6','3','0','0','4','2','0','5','6','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"A, C, D, B\";i:175;s:7:\"C, A, D\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('639','11','18','303','ASAG','2025-05-27 07:36:00','2025-05-27 08:15:45','2025-05-27 08:16:52','7','3',NULL,'49','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:8:\"kesatuan\";i:179;s:2:\"34\";i:180;s:40:\"pelestarian budaya dan menghargai budaya\";i:181;s:19:\"bangsa yang bersatu\";i:182;s:25:\"agar budaya tidak memudar\";i:183;s:4:\"aceh\";i:184;s:9:\"indanosia\";i:185;s:8:\"literasi\";i:186;s:18:\"pelestarian budaya\";i:187;s:19:\"autralia dan hindia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:7:\"A, B, C\";i:168;s:7:\"A, B, D\";i:170;s:7:\"B, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, D, A\";i:174;s:7:\"A, B, C\";i:175;s:7:\"C, B, D\";i:176;s:10:\"C, B, D, A\";i:177;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('640','11','18','335','ASAG','2025-05-27 07:36:00','2025-05-27 08:18:50','2025-05-27 08:18:56','6','4',NULL,'42','45',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:10:\"memperluas\";i:179;s:2:\"38\";i:180;s:13:\"mengembangkan\";i:181;s:51:\"kesatuan dan persatuan dalam segala aspek kehidupan\";i:182;s:42:\"supaya budaya tidak punah di dalam bangsa \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:11:\"bahasa aceh\";i:186;s:11:\"pelestarian\";i:187;s:14:\"australia asia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','3','0','0','0','7','5','0','5','3','0','','0','a:5:{i:166;s:1:\"A\";i:168;s:1:\"B\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:7:\"B, C, A\";i:175;s:7:\"A, B, C\";i:176;s:10:\"B, C, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('641','11','18','342','ASAG','2025-05-27 07:36:00','2025-05-27 08:18:15','2025-05-27 08:18:30','6','4',NULL,'42','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:38:\"1memakai produk indonesia 2menghargai \";i:181;s:13:\"satu kesatuan\";i:182;s:25:\"tidak pudar budaya bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:7:\"pasal 5\";i:187;s:18:\"australia dan asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, C, A, D\";i:177;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('642','11','18','309','ASAG','2025-05-27 07:36:01','2025-05-27 08:19:31','2025-05-27 08:19:37','7','3',NULL,'49','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:14:\"lebih memahami\";i:179;s:10:\"jawa barat\";i:180;s:6:\"gaktau\";i:181;s:9:\"ragu ragu\";i:182;s:5:\"wajip\";i:183;s:4:\"aceh\";i:184;s:9:\"nusantara\";i:185;s:11:\"bahasa aceh\";i:186;s:5:\"objek\";i:187;s:28:\"samudrahindia samudrafasivik\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:7:\"A, B, D\";i:170;s:4:\"A, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, A, C\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('643','11','18','302','ASAG','2025-05-27 07:36:03','2025-05-27 08:13:55','2025-05-27 08:16:31','5','5',NULL,'35','40',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"A\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:17:\"perbedaan wawasan\";i:179;s:2:\"38\";i:180;s:23:\"melestarikan dan budaya\";i:181;s:16:\"bangsa yang utuh\";i:182;s:28:\"biar budaya kita tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:27:\"cerita tentang sejarah aceh\";i:186;s:19:\"melestarikan budaya\";i:187;s:34:\"benua laurasia dan benua australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','0','0','1','7','5','0','4','3','0','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:7:\"A, B, D\";i:170;s:4:\"A, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('644','11','18','339','ASAG','2025-05-27 07:36:04','2025-05-27 08:12:49','2025-05-27 08:14:12','6','4',NULL,'42','53',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:1:\"-\";i:181;s:13:\"satu kesatuan\";i:182;s:16:\"karena kita nkri\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"cagok\";i:186;s:19:\"uud no 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','5','2','0','1','5','3','0','4','5','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:4:\"C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"B, C, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('645','11','18','321','ASAG','2025-05-27 07:36:05','2025-05-27 08:20:30','2025-05-27 08:20:46','5','5',NULL,'35','37',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"A\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:10:\"1 wilayah \";i:179;s:2:\"32\";i:180;s:19:\"undang undang dasar\";i:181;s:9:\"persatuan\";i:182;s:28:\"supaya bangsa kita bisa maju\";i:183;s:9:\"dari aceh\";i:184;s:20:\"masyarakat indonesia\";i:185;s:10:\"rumah aceh\";i:186;s:11:\"pelestarian\";i:187;s:19:\"samudra dan selatan\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:1:\"B\";i:171;s:7:\"A, B, D\";i:172;s:0:\"\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"B, A, C, D\";i:176;s:10:\"D, C, A, B\";i:177;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('646','11','18','329','ASAG','2025-05-27 07:36:06','2025-05-27 08:18:33','2025-05-27 08:18:39','3','7',NULL,'21','22',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"B\";i:161;s:1:\"D\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:14:\"satuan wilayah\";i:179;s:2:\"34\";i:180;s:5:\"objek\";i:181;s:9:\"persatuan\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:7:\"bioskop\";i:186;s:11:\"pelestarian\";i:187;s:31:\"benua sanudra dan benua pasifik\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:7:\"B, C, A\";i:174;s:7:\"B, A, C\";i:175;s:10:\"C, D, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('647','11','18','340','ASAG','2025-05-27 07:36:07','2025-05-27 08:13:06','2025-05-27 08:14:23','7','3',NULL,'49','67',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:24:\"wawasan adalah pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:110:\"keutuhan bangsa adalah kesereragaman bangsa dalam menanamkan cinta tanah air dan melestarikan budaya indonesia\";i:182;s:36:\"karena untuk menjaga keutuhan bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:13:\"uud no 5 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','6','4','0','2','4','1','0','3','6','8','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, A, B, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('648','11','18','297','ASAG','2025-05-27 07:36:08','2025-05-27 08:19:50','2025-05-27 08:20:19','5','5',NULL,'35','42',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:5:\"pulau\";i:179;s:2:\"10\";i:180;s:1:\"-\";i:181;s:1:\"-\";i:182;s:1:\"-\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:1:\"-\";i:186;s:1:\"-\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','1','2','0','1','9','3','0','4','1','4','','2','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, D, B, A\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('649','11','18','334','ASAG','2025-05-27 07:36:15','2025-05-27 08:18:06','2025-05-27 08:18:28','5','5',NULL,'35','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:9:\"bismillah\";i:181;s:39:\"tidak adanya perpecahan antar masyarkat\";i:182;s:53:\"agar budaya bangsa tidak pudar seiring barjalan waktu\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:10:\"uu nomor 5\";i:187;s:14:\"asia australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, C\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"B, C, A\";i:175;s:7:\"B, A, C\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('650','11','18','330','ASAG','2025-05-27 07:36:16','2025-05-27 08:13:24','2025-05-27 08:14:04','7','3',NULL,'49','60',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:23:\"persatuan dan kesatuan \";i:182;s:20:\"memperkuat identitas\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:13:\"uud no 5 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','7','2','0','0','3','3','0','5','7','4','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"A, C, B\";i:175;s:7:\"C, B, A\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('651','11','18','333','ASAG','2025-05-27 07:36:19','2025-05-27 08:18:17','2025-05-27 08:18:43','6','4',NULL,'42','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:29:\"kesatuan dan persatuan bangsa\";i:182;s:33:\"agar budaya bangsanya tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:29:\"undang undang no 5 tahun 2017\";i:187;s:18:\"australia dan asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','6','2','0','0','4','3','0','5','6','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:7:\"A, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, D, A\";i:177;s:7:\"C, D, A\";}');
INSERT INTO `nilai` VALUES ('652','11','18','332','ASAG','2025-05-27 07:36:19','2025-05-27 08:16:00','2025-05-27 08:16:15','5','5',NULL,'35','47',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:29:\"kesatuan dan persatuan bangsa\";i:182;s:33:\"agar budaya bangsanya tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:19:\"undang undang no 5 \";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','6','2','0','1','4','3','0','4','6','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"B, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:7:\"A, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('653','11','18','318','ASAG','2025-05-27 07:36:21','2025-05-27 08:21:48','2025-05-27 08:21:52','6','4',NULL,'42','43',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"B\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:21:\"perbedaan kepentingan\";i:179;s:11:\"Tidak Diisi\";i:180;s:9:\"tolensasi\";i:181;s:16:\"kebutuhan bangsa\";i:182;s:16:\"dari nenek luhur\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:13:\"karena orang \";i:186;s:19:\"kemajuan kebudayaan\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, D\";i:170;s:4:\"B, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:7:\"A, C, B\";i:175;s:7:\"A, B, C\";i:176;s:7:\"A, B, C\";i:177;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('654','11','18','346','ASAG','2025-05-27 07:36:21','2025-05-27 08:17:20','2025-05-27 08:17:27','8','2',NULL,'56','66',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:21:\"tradisi dan manuskrip\";i:181;s:22:\"persatuan dan kesatuan\";i:182;s:34:\"untuk memperkuat keutuhan nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','154,161,165,156,148,152,164,162,159,151,178,179,180,181,182,183,184,185,186,187,166,168,172,171,170,177,175,176,173,174,',NULL,NULL,'0','6','2','0','0','4','3','0','5','6','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:4:\"B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('655','11','18','347','ASAG','2025-05-27 07:36:21','2025-05-27 08:16:59','2025-05-27 08:17:22','3','7',NULL,'21','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"D\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"B\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:21:\"tradisi dan manuskrip\";i:181;s:21:\"kesatuan dan kesatuan\";i:182;s:34:\"untuk memperkuat keutuhan nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:19:\"uu no 5 tahun 20017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','6','2','0','1','4','3','0','4','6','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:4:\"B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('656','11','18','310','ASAG','2025-05-27 07:36:22','2025-05-27 08:13:39','2025-05-27 08:15:26','3','7',NULL,'21','26',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"B\";i:151;s:1:\"B\";i:152;s:1:\"A\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"A\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:6:\"negara\";i:179;s:5:\"papua\";i:180;s:42:\"melestarikan budaya melestarikan keragaman\";i:181;s:11:\"kita harus \";i:182;s:39:\"untuk kita bisa lihat lambang negaranya\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:9:\"dongeng  \";i:186;s:33:\"kita harus menjaga satu sama lain\";i:187;s:14:\"asia australia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,187,186,185,184,183,182,181,180,179,178,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, C, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"B, A, C, D\";i:174;s:7:\"A, B, C\";i:175;s:10:\"B, A, C, D\";i:176;s:10:\"A, B, D, C\";i:177;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('657','11','18','343','ASAG','2025-05-27 07:36:28','2025-05-27 08:16:46','2025-05-27 08:18:21','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"B\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:44:\"kesatuan dan persatuan dalam aspek kehidupan\";i:182;s:34:\"untuk memperkuat keutuhan nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"nomor 5 tahun 2017\";i:187;s:14:\"asia australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','6','1','0','0','4','4','0','5','6','2','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, C, B\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"A, C, D, B\";}');
INSERT INTO `nilai` VALUES ('658','11','18','344','ASAG','2025-05-27 07:36:29','2025-05-27 08:18:19','2025-05-27 08:18:35','8','2',NULL,'56','73',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:51:\"kesatuan dan persatuan dalam segala aspek kehidupan\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"nomor 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','7','4','0','1','3','1','0','4','7','8','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('659','11','18','328','ASAG','2025-05-27 07:36:31','2025-05-27 08:14:46','2025-05-27 08:16:04','5','5',NULL,'35','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:6:\"lautan\";i:179;s:1:\"4\";i:180;s:19:\"melestarikan budaya\";i:181;s:9:\"kebutuhan\";i:182;s:41:\"bisa untuk sampai cucu sampai ke cicitnya\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"cagok\";i:186;s:18:\"tentang kebudayaan\";i:187;s:17:\"asia dan tenggara\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"D, C, A, B\";i:174;s:7:\"C, A, B\";i:175;s:10:\"A, C, B, D\";i:176;s:10:\"A, B, D, C\";i:177;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('660','11','18','327','ASAG','2025-05-27 07:36:35','2025-05-27 08:18:12','2025-05-27 08:18:31','6','4',NULL,'42','45',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:12:\"lautan pulau\";i:179;s:17:\"yangakan melimpah\";i:180;s:17:\"kesenian perstuan\";i:181;s:17:\"menghargai rakyat\";i:182;s:18:\"keutuhan persatuan\";i:183;s:4:\"aceh\";i:184;s:9:\"bayuwangi\";i:185;s:11:\"seni budaya\";i:186;s:18:\"peninggalan bangsa\";i:187;s:12:\"afrika india\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, D, A\";i:174;s:7:\"A, C, B\";i:175;s:7:\"B, A, D\";i:176;s:10:\"C, D, A, B\";i:177;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('661','11','18','353','ASAG','2025-05-27 07:36:38','2025-05-27 08:18:17','2025-05-27 08:19:16','8','2',NULL,'56','59',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:136:\"wawasan nusantara adalah konsep yang di kembangkan di indonesia yang menggambarkan kesadaran dan pemahaman untuk keanekan ragaman budaya\";i:179;s:11:\"38 provinsi\";i:180;s:19:\"lisan dan manuskrip\";i:181;s:61:\"menjaga tradisi dan tari supaya keutuhan bangsa tetap terjaga\";i:182;s:55:\"supaya tradisi negara indonesia tidak hilang atau pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:22:\"uud nomor 5 tahun 2017\";i:187;s:18:\"australia dan asia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','0','0','0','7','5','0','5','3','0','','0','a:5:{i:166;s:1:\"A\";i:168;s:1:\"A\";i:170;s:1:\"D\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('662','11','18','331','ASAG','2025-05-27 07:36:41','2025-05-27 08:14:45','2025-05-27 08:15:00','7','3',NULL,'49','62',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"kepulauan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:36:\"kesatuan dan persatuan suatu bangsa \";i:182;s:56:\"agar budaya tersebut tidak punah di kalangan masyarakat \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:32:\"undang undang nomor 5 tahun 2017\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','5','4','0','0','5','1','0','5','5','8','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, D, B\";i:174;s:4:\"C, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('663','11','18','350','ASAG','2025-05-27 07:37:27','2025-05-27 08:17:24','2025-05-27 08:17:42','7','3',NULL,'49','63',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:26:\"tradisilisan dan manuskrip\";i:181;s:27:\"memperkuat identitas bangsa\";i:182;s:17:\"agar tidak punah \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:12:\"udd no5 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','6','3','0','1','4','2','0','4','6','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('664','11','18','324','ASAG','2025-05-27 07:37:41','2025-05-27 08:20:41','2025-05-27 08:20:47','3','7',NULL,'21','23',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"D\";i:161;s:1:\"B\";i:162;s:1:\"A\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:39:\"wawasanadalahmasyarakatyangsalingpeduli\";i:179;s:5:\"aceh \";i:180;s:29:\"masyarakatyangmemajukanbangsa\";i:181;s:31:\"memilikikeutuhanbangsayanghebat\";i:182;s:25:\"karnakitapemilikbudayanya\";i:183;s:5:\"aceh \";i:184;s:18:\"kita harus bangga \";i:185;s:32:\"sudahjarangmelihatseniberrcerita\";i:186;s:24:\"budayayangharuskitarawat\";i:187;s:26:\"benua asia dan asiatengara\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','0','1','0','0','10','4','0','5','0','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"B, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, B, D\";i:174;s:7:\"A, C, B\";i:175;s:7:\"C, A, B\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('665','11','18','348','ASAG','2025-05-27 07:38:15','2025-05-27 08:13:15','2025-05-27 08:15:21','7','3',NULL,'49','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"37\";i:180;s:15:\"musikal pakaian\";i:181;s:10:\"kekompakan\";i:182;s:10:\"tidakpunah\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:8:\"meucagok\";i:186;s:6:\"pasal5\";i:187;s:17:\"eusrtralia hindia\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, D\";i:171;s:1:\"A\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, D, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('666','11','18','338','ASAG','2025-05-27 07:38:37','2025-05-27 08:14:11','2025-05-27 08:14:28','8','2',NULL,'56','67',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"lisan dan manuskrip\";i:181;s:23:\"kesatuan dan persatuan \";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:16:\"uud 1945 pasal 4\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','5','3','0','0','5','2','0','5','5','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, C, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('667','11','18','341','ASAG','2025-05-27 07:38:37','2025-05-27 08:15:23','2025-05-27 08:15:38','6','4',NULL,'42','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:5:\"pulau\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:19:\"bangsa yang bersatu\";i:182;s:49:\"agar pelestarian budayanya tidak pudar atau punah\";i:183;s:4:\"aceh\";i:184;s:4:\"bali\";i:185;s:5:\"cagok\";i:186;s:24:\"uu pasal 32 ayat 1 dan 2\";i:187;s:19:\"asia dan austaralia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','4','4','0','0','6','1','0','5','4','8','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:1:\"A\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, D, A\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, A, B, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('668','12','16','330','ASAG','2025-05-27 08:17:25','2025-05-27 08:44:59','2025-05-27 08:45:16','10','0',NULL,'70','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:9:\"emosional\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','4','4','0','0','6','1','0','5','4','8','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, A, D\";i:53;s:10:\"D, A, B, C\";i:55;s:10:\"A, B, C, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('669','12','16','341','ASAG','2025-05-27 08:17:27','2025-05-27 08:44:53','2025-05-27 08:45:28','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:11:\"irama musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:12:\"pembelajaran\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('670','12','16','296','ASAG','2025-05-27 08:17:31','2025-05-27 08:47:34','2025-05-27 08:47:38','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:33:\"musik yang ceria dan menyemangati\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"pelajaran\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak patuh\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, A, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('671','12','16','316','ASAG','2025-05-27 08:17:31','2025-05-27 08:44:26','2025-05-27 08:45:22','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:18:\"hamil diluar nikah\";i:521;s:11:\"konsentrasi\";i:522;s:7:\"menjaga\";i:523;s:7:\"emosian\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('672','12','16','339','ASAG','2025-05-27 08:17:35','2025-05-27 08:37:37','2025-05-27 08:38:47','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:10:\"peregangan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:7:\"durhaka\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,521,524,516,517,520,525,518,523,519,522,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','1','0','4','7','4','0','1','3','2','','8','a:5:{i:39;s:4:\"C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('673','12','16','340','ASAG','2025-05-27 08:17:35','2025-05-27 08:38:44','2025-05-27 08:45:15','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"irama\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"pembelajaran\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('674','12','16','338','ASAG','2025-05-27 08:17:40','2025-05-27 08:36:50','2025-05-27 08:38:10','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:32:\"7 kebiasaan anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:9:\"emosional\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('675','12','16','331','ASAG','2025-05-27 08:17:41','2025-05-27 08:46:11','2025-05-27 08:46:38','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:6:\" musik\";i:518;s:9:\"kebugaran\";i:519;s:10:\"peregangan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:7:\"trotoar\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('676','12','16','349','ASAG','2025-05-27 08:17:43','2025-05-27 08:45:20','2025-05-27 08:45:28','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"irama\";i:518;s:10:\"kebugaran \";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:9:\"nama baik\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','3','2','0','3','7','3','0','2','3','4','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"A, C\";i:42;s:4:\"A, B\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('677','12','16','347','ASAG','2025-05-27 08:17:44','2025-05-27 08:48:59','2025-05-27 08:49:07','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubungan seks\";i:521;s:16:\"semangat belajar\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:4:\"A, B\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, A, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:7:\"C, A, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('678','12','16','306','ASAG','2025-05-27 08:17:49','2025-05-27 08:44:25','2025-05-27 08:45:18','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:17:\"berhubungan badan\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"lampu merah\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:4:\"B, C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"A, B, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('679','12','16','326','ASAG','2025-05-27 08:17:53','2025-05-27 08:43:28','2025-05-27 08:45:26','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"fisik\";i:522;s:12:\"meningkatkan\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','3','0','4','6','2','0','1','4','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('680','12','16','311','ASAG','2025-05-27 08:17:53','2025-05-27 08:45:32','2025-05-27 08:47:30','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:26:\"menanamkan cinta tanah air\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"membangkang\";i:524;s:4:\"helm\";i:525;s:10:\"bahu jalan\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,521,524,516,517,520,525,518,523,519,522,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('681','12','16','299','ASAG','2025-05-27 08:17:55','2025-05-27 08:44:07','2025-05-27 08:47:02','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:26:\"menanamkan cinta tanah air\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:11:\"konsentrasi\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('682','12','16','303','ASAG','2025-05-27 08:17:58','2025-05-27 08:52:05','2025-05-27 08:52:10','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:12:\"tidak sopan \";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','3','5','0','3','7','0','0','2','3','10','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('683','12','16','312','ASAG','2025-05-27 08:18:00','2025-05-27 08:47:22','2025-05-27 08:47:42','7','3',NULL,'49','59',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"A\";}','a:10:{i:516;s:26:\"senam anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"pemanasan\";i:519;s:9:\"pemanasan\";i:520;s:30:\"terjadinya hamil di luar nikah\";i:521;s:11:\"nilai nilai\";i:522;s:19:\"untuk menjaga diri \";i:523;s:13:\"kayak ank ank\";i:524;s:4:\"helm\";i:525;s:23:\"rambu rambu lalu lintas\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','2','4','0','0','8','1','0','5','2','8','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"A\";}','a:0:{}','a:5:{i:51;s:10:\"D, A, C, B\";i:53;s:10:\"B, A, D, C\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('684','12','16','319','ASAG','2025-05-27 08:18:02','2025-05-27 08:44:53','2025-05-27 08:45:22','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:11:\"bersemangat\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"pembelajaran\";i:522;s:12:\"menjaga diri\";i:523;s:7:\"agresif\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,525,524,523,522,521,520,519,518,517,516,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('685','12','16','345','ASAG','2025-05-27 08:18:08','2025-05-27 08:44:46','2025-05-27 08:45:10','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:10:\"kelentukan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"keterampilan\";i:522;s:7:\"menjaga\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,521,524,516,517,520,525,518,523,519,522,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:7:\"C, A, B\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('686','12','16','328','ASAG','2025-05-27 08:18:09','2025-05-27 08:45:01','2025-05-27 08:45:41','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:4:\"suhu\";i:519;s:9:\"pemanasan\";i:520;s:30:\"biar tidak hamil di luar nikah\";i:521;s:12:\"pembelajaran\";i:522;s:7:\"menjaga\";i:523;s:4:\"baik\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,516,517,518,519,520,521,522,523,524,525,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','2','3','0','5','8','2','0','0','2','6','','10','a:5:{i:39;s:7:\"B, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('687','12','16','304','ASAG','2025-05-27 08:18:11','2025-05-27 08:44:00','2025-05-27 08:45:25','9','1',NULL,'63','75',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"B\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:26:\"senam anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:7:\"gerakan\";i:519;s:9:\"pemanasan\";i:520;s:18:\"hamil diluar nikah\";i:521;s:9:\"keyakinan\";i:522;s:9:\"melindugi\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:7:\"B, D, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('688','12','16','346','ASAG','2025-05-27 08:18:13','2025-05-27 08:49:53','2025-05-27 08:50:04','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:10:\"pemanasan \";i:520;s:16:\"berhubungan seks\";i:521;s:16:\"semangat belajar\";i:522;s:8:\"menjaga \";i:523;s:8:\"melawan \";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,525,524,523,522,521,520,519,518,517,516,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('689','12','16','314','ASAG','2025-05-27 08:18:25','2025-05-27 08:44:19','2025-05-27 08:44:39','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('690','12','16','332','ASAG','2025-05-27 08:18:25','2025-05-27 08:46:56','2025-05-27 08:47:06','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:4:\"suhu\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('691','12','16','307','ASAG','2025-05-27 08:18:26','2025-05-27 08:45:08','2025-05-27 08:46:24','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:7:\"stamina\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:8:\"olahraga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','3','3','0','3','7','2','0','2','3','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, D, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, C, B, A\";}');
INSERT INTO `nilai` VALUES ('692','12','16','301','ASAG','2025-05-27 08:18:28','2025-05-27 08:43:58','2025-05-27 08:44:39','8','2',NULL,'56','71',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:8:\"semangat\";i:519;s:9:\"pemanasan\";i:520;s:18:\"hamil diluar nikah\";i:521;s:22:\"menjelekkan nama siswa\";i:522;s:5:\"norma\";i:523;s:29:\"tidak ada rasa tanggung jawab\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,522,519,523,518,525,520,517,516,524,521,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','1','5','0','2','9','0','0','3','1','10','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:7:\"C, B, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('693','12','16','337','ASAG','2025-05-27 08:18:37','2025-05-27 08:45:15','2025-05-27 08:45:40','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:25:\"aku anak indonesia hebat \";i:517;s:11:\"musik senam\";i:518;s:16:\"kebugaran tubuh \";i:519;s:10:\"pemanasan \";i:520;s:10:\"seks bebas\";i:521;s:9:\"akademik \";i:522;s:13:\"menjaga diri \";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('694','12','16','327','ASAG','2025-05-27 08:18:49','2025-05-27 08:49:03','2025-05-27 08:50:03','9','1',NULL,'63','76',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:22:\"akuanak indonesiahebat\";i:517;s:9:\"permainan\";i:518;s:10:\"keringanan\";i:519;s:9:\"pemanasan\";i:520;s:17:\"hamildi luarnikah\";i:521;s:8:\"perilaku\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak patuh\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','3','5','0','0','7','0','0','5','3','10','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:7:\"B, D, A\";i:53;s:10:\"B, D, C, A\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"A, B, D, C\";}');
INSERT INTO `nilai` VALUES ('695','12','16','315','ASAG','2025-05-27 08:18:54','2025-05-27 08:45:08','2025-05-27 08:45:23','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:22:\"akibat pergaulan bebas\";i:521;s:9:\"pelajaran\";i:522;s:9:\"bela diri\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','5','0','2','7','0','0','3','3','10','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('696','12','16','342','ASAG','2025-05-27 08:18:55','2025-05-27 08:44:50','2025-05-27 08:45:53','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"irama\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"reputasi\";i:522;s:7:\"batasan\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, A, D, B\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('697','12','16','302','ASAG','2025-05-27 08:18:58','2025-05-27 08:45:08','2025-05-27 08:45:58','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:30:\"senam aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:18:\"berfikir yang baik\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('698','12','16','350','ASAG','2025-05-27 08:19:03','2025-05-27 08:44:47','2025-05-27 08:45:40','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:19:\"semangat kebangsaan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"nama baik\";i:522;s:9:\"keimanan \";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('699','12','16','336','ASAG','2025-05-27 08:19:04','2025-05-27 08:47:35','2025-05-27 08:48:17','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubungan seks\";i:521;s:16:\"semangat belajar\";i:522;s:7:\"menjaga\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, A, B, C\";i:53;s:10:\"B, A, C, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('700','12','16','333','ASAG','2025-05-27 08:19:16','2025-05-27 08:46:03','2025-05-27 08:47:02','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:4:\"suhu\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:7:\"C, B, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('701','12','16','344','ASAG','2025-05-27 08:19:17','2025-05-27 08:46:27','2025-05-27 08:46:36','10','0',NULL,'70','93',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"keterampilan\";i:522;s:7:\"menjaga\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','5','5','0','4','5','0','0','1','5','10','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('702','12','16','335','ASAG','2025-05-27 08:19:18','2025-05-27 08:40:31','2025-05-27 08:45:23','9','1',NULL,'63','75',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"kebugaran \";i:519;s:9:\"pemanasan\";i:520;s:8:\"pacaran \";i:521;s:9:\"kemampuan\";i:522;s:5:\"dalam\";i:523;s:8:\"melawan \";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:39;s:4:\"C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('703','12','16','323','ASAG','2025-05-27 08:19:21','2025-05-27 08:45:08','2025-05-27 08:45:36','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:18:\"hamil diluar nikah\";i:521;s:5:\"nilai\";i:522;s:9:\"pemanasan\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"hlem\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"A, C, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('704','12','16','343','ASAG','2025-05-27 08:19:22','2025-05-27 08:48:04','2025-05-27 08:48:11','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','3','5','0','4','7','0','0','1','3','10','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, A, C, D\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('705','12','16','352','ASAG','2025-05-27 08:19:24','2025-05-27 08:45:18','2025-05-27 08:45:23','10','0',NULL,'70','84',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:18:\"kebugaran jasmani \";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubungan seks\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','2','0','3','6','3','0','2','4','4','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, C, D\";i:44;s:7:\"A, B, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, D, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"A, B, D, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('706','12','16','334','ASAG','2025-05-27 08:19:36','2025-05-27 08:45:33','2025-05-27 08:45:56','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"suhu tubuh\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:10:\"mengontrol\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('707','12','16','305','ASAG','2025-05-27 08:19:41','2025-05-27 08:45:07','2025-05-27 08:45:37','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"pertahanan\";i:519;s:9:\"pemanasan\";i:520;s:17:\"berhubungan badan\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:9:\"membantah\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('708','12','16','329','ASAG','2025-05-27 08:19:42','2025-05-27 08:47:21','2025-05-27 08:48:32','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"B\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:5:\" imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:11:\"konsentarsi\";i:522;s:7:\"membela\";i:523;s:5:\"egois\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"B, A, C, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('709','12','16','310','ASAG','2025-05-27 08:19:47','2025-05-27 08:46:26','2025-05-27 08:46:33','8','2',NULL,'56','65',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"C\";}','a:10:{i:516;s:26:\"senam anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:10:\"kebugaran \";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:7:\"pelajar\";i:522;s:4:\"iman\";i:523;s:7:\"melawan\";i:524;s:4:\"hlem\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','3','3','0','0','7','2','0','5','3','6','','0','a:5:{i:39;s:7:\"A, B, C\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, B\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, C, B, D\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"B, A, D, C\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"B, C, A, D\";}');
INSERT INTO `nilai` VALUES ('710','12','16','353','ASAG','2025-05-27 08:19:49','2025-05-27 08:44:33','2025-05-27 08:45:53','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:5:\"fisik\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:10:\"daya ingat\";i:522;s:8:\"keimanan\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:10:\"bahu jalan\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','1','3','0','5','9','2','0','0','1','6','','10','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('711','12','16','309','ASAG','2025-05-27 08:20:01','2025-05-27 08:44:43','2025-05-27 08:46:00','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"B\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:8:\"pemanasa\";i:520;s:20:\"berzina atau pacaran\";i:521;s:5:\"nilai\";i:522;s:4:\"iman\";i:523;s:11:\"tidak sopan\";i:524;s:5:\"helem\";i:525;s:12:\"zebra coroos\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','1','5','0','2','9','0','0','3','1','10','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, A, C\";i:53;s:10:\"D, C, B, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('712','12','16','351','ASAG','2025-05-27 08:20:13','2025-05-27 08:45:42','2025-05-27 08:45:54','9','1',NULL,'63','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"B\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:5:\"fisik\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubungan seks\";i:521;s:5:\"nilai\";i:522;s:8:\"keimanan\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:10:\"bahu jalan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','4','0','2','8','1','0','3','2','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, A, D, C\";i:53;s:10:\"B, C, D, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"A, D, B, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('713','12','16','320','ASAG','2025-05-27 08:20:28','2025-05-27 08:47:56','2025-05-27 08:48:02','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"D\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:32:\"menumbuhkan rasa cinta tanah air\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seax\";i:521;s:5:\"nilai\";i:522;s:4:\"bela\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra crozz\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,522,519,523,518,525,520,517,516,524,521,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, D, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('714','12','16','324','ASAG','2025-05-27 08:21:06','2025-05-27 08:44:59','2025-05-27 08:45:19','8','2',NULL,'56','64',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"B\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:23:\"senamanakindonesiahebat\";i:517;s:22:\"laguanakindonesiahebat\";i:518;s:15:\"kesehatan tubuh\";i:519;s:9:\"pemanasan\";i:520;s:16:\"tidakberduaduaan\";i:521;s:28:\"tidakfokusmengikutipelajaran\";i:522;s:44:\"harusmenjauhdaritemantemanyangpergaulanbebas\";i:523;s:20:\"anakyangsangatbandel\";i:524;s:4:\"hlem\";i:525;s:21:\"membiasakansepertiitu\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,525,524,523,522,521,520,519,518,517,516,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','2','2','0','1','8','3','0','4','2','4','','2','a:5:{i:39;s:7:\"A, B, C\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"B, C, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, D, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"B, A, C, D\";i:56;s:10:\"A, B, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('715','12','16','322','ASAG','2025-05-27 08:21:08','2025-05-27 08:49:38','2025-05-27 08:49:43','10','0',NULL,'70','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:10:\"otot tubuh\";i:519;s:9:\"pemanasan\";i:520;s:11:\"berdekatan \";i:521;s:5:\"nilai\";i:522;s:8:\"menjaga \";i:523;s:5:\"emosi\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','0','8','2','0','5','2','6','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:4:\"A, C\";}','a:0:{}','a:5:{i:51;s:0:\"\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"A, B, C, D\";i:56;s:10:\"A, B, D, C\";i:57;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('716','12','16','313','ASAG','2025-05-27 08:21:10','2025-05-27 08:45:16','2025-05-27 08:45:34','9','1',NULL,'63','73',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:23:\"senamanakindonesiahebat\";i:517;s:21:\"yangceriaatausemangat\";i:518;s:8:\"semangat\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"kemalasan\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidakpatuh\";i:524;s:4:\"helm\";i:525;s:20:\"ramburambulalulintas\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:1:\"C\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('717','12','16','321','ASAG','2025-05-27 08:21:11','2025-05-27 08:52:35','2025-05-27 08:52:57','9','1',NULL,'63','73',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"B\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:11:\"kelestarian\";i:519;s:10:\"pemanasan \";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"membela\";i:523;s:4:\"jauh\";i:524;s:4:\"helm\";i:525;s:11:\"zebra crozz\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,516,517,518,519,520,521,522,523,524,525,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, C, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, A, C\";i:53;s:10:\"B, A, D, C\";i:55;s:10:\"A, B, C, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('718','12','16','300','ASAG','2025-05-27 08:21:16','2025-05-27 08:47:55','2025-05-27 08:48:24','6','4',NULL,'42','46',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"B\";i:32;s:1:\"B\";i:34;s:1:\"C\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:26:\"lagu anak indonesia hebat \";i:517;s:49:\"lagu biar lebih menyenangkan atau lebih semangat \";i:518;s:23:\"biar sehat dan semangat\";i:519;s:10:\"pemanasan \";i:520;s:43:\"pacaran dan tidak boleh keluar tengah malam\";i:521;s:9:\"zebrakors\";i:522;s:41:\"jangan keluar kemalaman dan menjaga diri \";i:523;s:10:\"kebugaram \";i:524;s:5:\"helm \";i:525;s:18:\"melihat kiri kanan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,522,519,523,518,525,520,517,516,524,521,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','2','0','0','10','3','0','5','0','4','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"B, C, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, D\";i:46;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:51;s:10:\"C, A, D, B\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"A, B, C, D\";i:57;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('719','12','16','325','ASAG','2025-05-27 08:21:17','2025-05-27 08:46:54','2025-05-27 08:47:06','8','2',NULL,'56','72',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"D\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:23:\"senamanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:57:\"yaitumendirikandiriuntukdirumahsajadanpatuhikeduaorangtua\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:19:\"pemarahatauperlawan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracrocs\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('720','12','16','298','ASAG','2025-05-27 08:21:36','2025-05-27 08:53:57','2025-05-27 08:54:07','9','1',NULL,'63','73',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:18:\"ceria dan semangat\";i:518;s:28:\"kebugaran tubuh dan semangat\";i:519;s:30:\"pemanasan inti dan pendinginan\";i:520;s:33:\"mengakibatkan hamil di luar nikah\";i:521;s:26:\"dan tidak kepercayaan diri\";i:522;s:58:\"tidak berteman dengan orang yang mengikuti pergaulan bebas\";i:523;s:28:\"tidak sopan kepada orang tua\";i:524;s:4:\"helm\";i:525;s:52:\"menyebrang di zebra cross atau jembatan penyebrangan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','5','0','0','10','0','0','5','0','10','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"D, A, B, C\";i:56;s:10:\"B, C, D, A\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('721','12','16','308','ASAG','2025-05-27 08:21:46','2025-05-27 08:44:21','2025-05-27 08:44:42','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:13:\"melatih tubuh\";i:519;s:9:\"pemanasan\";i:520;s:19:\"hamil di luar nikah\";i:521;s:10:\"harga diri\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:14:\"di zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('722','12','16','317','ASAG','2025-05-27 08:22:05','2025-05-27 08:44:51','2025-05-27 08:45:27','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:9:\"kebugaran\";i:519;s:26:\"inti pemanasan pendinginan\";i:520;s:11:\"berpacaran \";i:521;s:15:\"tidak semangat \";i:522;s:8:\"menjaga \";i:523;s:12:\"lebih emosi \";i:524;s:4:\"helm\";i:525;s:11:\"bahu jalan \";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','1','4','0','3','9','1','0','2','1','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('723','12','16','318','ASAG','2025-05-27 08:22:09','2025-05-27 08:48:05','2025-05-27 08:48:39','8','2',NULL,'56','65',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:9:\"permainan\";i:518;s:10:\"keringanan\";i:519;s:10:\"permanasan\";i:520;s:10:\"menhidarin\";i:521;s:7:\"keingan\";i:522;s:7:\"menjaga\";i:523;s:4:\"diam\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','1','3','0','1','9','2','0','4','1','6','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, C, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, D, B, C\";i:53;s:10:\"B, C, D, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"D, C, A, B\";i:57;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('724','12','16','348','ASAG','2025-05-27 08:25:11','2025-05-27 08:44:13','2025-05-27 08:45:52','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"B\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"batasan\";i:523;s:7:\"pelawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','2','0','3','5','3','0','2','5','4','','6','a:5:{i:39;s:4:\"C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, C, D\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:7:\"B, A, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('725','12','16','297','ASAG','2025-05-27 08:26:02','2025-05-27 08:48:23','2025-05-27 08:54:36','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"pertahanan\";i:519;s:9:\"pemanasan\";i:520;s:4:\"diam\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:9:\"membantah\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, D, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('726','13','18','401','ASAG','2025-05-27 09:08:53','2025-05-27 09:46:36','2025-05-27 09:47:28','6','4',NULL,'42','53',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"C\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:24:\"tradisilisandanmanuskrip\";i:181;s:39:\"kesatuandanpersatuandalamaspekkehidupan\";i:182;s:24:\"untukmemajukandiribangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:15:\"nomor5tahun2017\";i:187;s:26:\"benuaasiadanbenuaaustralia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','2','0','1','5','3','0','4','5','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('727','13','18','390','ASAG','2025-05-27 09:08:55','2025-05-27 09:49:30','2025-05-27 09:49:35','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:8:\"kekuatan\";i:182;s:17:\"mempererat bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:8:\"literasi\";i:186;s:23:\"no 5 tahun 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','6','2','0','1','4','3','0','4','6','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:7:\"B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('728','13','18','400','ASAG','2025-05-27 09:08:56','2025-05-27 09:35:26','2025-05-27 09:48:11','5','5',NULL,'35','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"C\";i:161;s:1:\"C\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:39:\"pakaian adat dan alat musik tradisional\";i:181;s:16:\"persatuan bangsa\";i:182;s:33:\"agar budaya bangsanya tidak punah\";i:183;s:5:\"aceeh\";i:184;s:4:\"jawa\";i:185;s:13:\"cerita rakyat\";i:186;s:40:\"undang-undang nomor 5 tahun 2017 pasal 5\";i:187;s:35:\"benua indo australia dan benua asia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:1:\"A\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, D, C, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('729','13','18','356','ASAG','2025-05-27 09:09:00','2025-05-27 09:46:42','2025-05-27 09:46:46','7','3',NULL,'49','59',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:16:\"persatuan bangsa\";i:182;s:45:\"agar budaya yang ada di indonesia tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:24:\"undang undang no 5 2017 \";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,186,180,183,182,185,179,187,184,181,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','6','1','0','1','4','4','0','4','6','2','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('730','13','18','389','ASAG','2025-05-27 09:09:11','2025-05-27 09:46:28','2025-05-27 09:47:30','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"36\";i:180;s:10:\"tari music\";i:181;s:59:\"bangsa yang utuh seperti adat yang masi ada sampai sekarang\";i:182;s:18:\"supaya tidak pudar\";i:183;s:4:\"aceh\";i:184;s:5:\" aceh\";i:185;s:5:\"cagok\";i:186;s:15:\"pasal 33 ayat 1\";i:187;s:18:\"asia dan australia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('731','13','18','355','ASAG','2025-05-27 09:09:16','2025-05-27 09:36:23','2025-05-27 09:46:38','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:8:\"pandagan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:45:\"kesatuan dan persatuan dalam aspek kehidupan \";i:182;s:43:\"karena agar bisa memperkenalkan budaya kita\";i:183;s:5:\"aceh \";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:21:\"uu pasal 5 tahun 2017\";i:187;s:21:\"australia dan amerika\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:4:\"A, B\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, D\";i:176;s:10:\"D, A, C, B\";i:177;s:10:\"B, C, A, D\";}');
INSERT INTO `nilai` VALUES ('732','13','18','402','ASAG','2025-05-27 09:09:23','2025-05-27 09:48:32','2025-05-27 09:49:18','5','5',NULL,'35','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:12:\"cara pandang\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:62:\"keutuhan bangsa mempunyai maksud yaitu utuh dalam segala aspek\";i:182;s:90:\"karena jika tidak di lestarikan maka budaya tersebut akan hilang seiring berjalannya waktu\";i:183;s:4:\"aceh\";i:184;s:10:\"pulau jawa\";i:185;s:8:\"shalawat\";i:186;s:21:\"permainan tradisional\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','3','2','0','3','7','3','0','2','3','4','','6','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"D, B, A\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('733','13','18','377','ASAG','2025-05-27 09:09:26','2025-05-27 09:52:28','2025-05-27 09:52:34','6','4',NULL,'42','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:29:\"cara pandang dan sikap bangsa\";i:179;s:11:\"34 provinsi\";i:180;s:42:\"nasionalisme dan kesenjangan antar wilayah\";i:181;s:32:\"bangsa yang tidak terpecah belah\";i:182;s:24:\"agar budaya tidak hilang\";i:183;s:4:\"aceh\";i:184;s:4:\"bali\";i:185;s:5:\"cagok\";i:186;s:58:\"melestarikan budaya penting untuk menjaga jati diri bangsa\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,181,184,187,179,185,182,183,180,186,178,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:4:\"B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, B, D\";i:174;s:10:\"A, B, C, D\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, B, D, A\";}');
INSERT INTO `nilai` VALUES ('734','13','18','361','ASAG','2025-05-27 09:09:29','2025-05-27 09:45:39','2025-05-27 09:46:35','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:28:\"tradisi lisan dan manuskrip \";i:181;s:52:\"kesatuan dan persatuan dalam segala aspek kehidupan \";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:17:\"uu no5 tahun 2017\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','159,154,152,151,148,156,161,165,162,164,187,186,185,184,183,182,181,180,179,178,171,168,172,166,170,173,175,176,177,174,',NULL,NULL,'0','6','4','0','1','4','1','0','4','6','8','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"C, D, A, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('735','13','18','374','ASAG','2025-05-27 09:09:33','2025-05-27 09:49:04','2025-05-27 09:49:23','5','5',NULL,'35','42',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:18:\"tiga puluh delapan\";i:180;s:36:\"adat istiadat dan pelesterian budaya\";i:181;s:27:\"satu kesatuan sebuah bangsa\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"cagok\";i:186;s:17:\"uu no7 tahun 2017\";i:187;s:32:\"benua hindia dan benua australia\";}',NULL,'0','159,154,152,151,148,156,161,165,162,164,178,179,180,181,182,183,184,185,186,187,171,168,172,166,170,173,175,176,177,174,',NULL,NULL,'0','3','2','0','0','7','3','0','5','3','4','','0','a:5:{i:166;s:4:\"B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:1:\"A\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('736','13','18','368','ASAG','2025-05-27 09:09:37','2025-05-27 09:47:55','2025-05-27 09:47:32','5','5',NULL,'35','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:98:\"cara pandangan dan sikap bangsa indonesia terhadap diri dan lingkungan yang menunjuk satu kesatuan\";i:179;s:2:\"33\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:32:\"bangsa yang bersatu dan kesatuan\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"pasal 5 nomor 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,187,186,185,184,183,182,181,180,179,178,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','4','0','1','5','1','0','4','5','8','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, C, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('737','13','18','373','ASAG','2025-05-27 09:09:38','2025-05-27 09:53:28','2025-05-27 09:53:32','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:6:\"gk tau\";i:181;s:6:\"gk tau\";i:182;s:25:\"agar budaya tidak memudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:6:\"bahasa\";i:186;s:15:\"pasal 22 ayat 3\";i:187;s:22:\"benua india dan benua \";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','4','2','0','2','6','3','0','3','4','4','','4','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:1:\"A\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, C, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('738','13','18','398','ASAG','2025-05-27 09:09:40','2025-05-27 09:54:55','2025-05-27 09:55:04','0','10',NULL,'0','0',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"X\";i:151;s:1:\"X\";i:152;s:1:\"X\";i:154;s:1:\"X\";i:156;s:1:\"X\";i:159;s:1:\"X\";i:161;s:1:\"X\";i:162;s:1:\"X\";i:164;s:1:\"X\";i:165;s:1:\"X\";}','a:10:{i:178;s:11:\"Tidak Diisi\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;N;i:168;N;i:170;N;i:171;N;i:172;N;}','a:0:{}','a:5:{i:173;N;i:174;N;i:175;N;i:176;N;i:177;N;}');
INSERT INTO `nilai` VALUES ('739','13','18','381','ASAG','2025-05-27 09:09:41','2025-05-27 09:54:31','2025-05-27 09:54:34','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:18:\"tradisi lisan dan \";i:181;s:20:\"satu kesatuan bangsa\";i:182;s:17:\"agar tidak hilang\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:40:\"undang-undang nomor 5 tahun 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,187,186,185,184,183,182,181,180,179,178,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','6','3','0','0','4','2','0','5','6','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:4:\"C, A\";i:175;s:7:\"C, D, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('740','13','18','408','ASAG','2025-05-27 09:09:44','2025-05-27 09:33:03','2025-05-27 09:38:57','6','4',NULL,'42','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:32:\"persatuan aspek negara indonesia\";i:182;s:30:\"agar budaya bangsa tidak punah\";i:183;s:11:\"daerah aceh\";i:184;s:4:\"jawa\";i:185;s:8:\"literasi\";i:186;s:10:\"uu nomor 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"A, B, C\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, D, B, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('741','13','18','386','ASAG','2025-05-27 09:09:46','2025-05-27 09:51:21','2025-05-27 09:51:27','7','3',NULL,'49','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:12:\"pengentahuan\";i:179;s:11:\"kaliamantan\";i:180;s:42:\"nasionalisme dan kesenjangan antar wilayah\";i:181;s:9:\"persatuan\";i:182;s:24:\"agar tidal terpecah bela\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"cagok\";i:186;s:15:\"pasal 22 ayat 1\";i:187;s:24:\"benua australia dan asia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:7:\"A, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:4:\"A, B\";i:174;s:7:\"C, B, A\";i:175;s:4:\"C, B\";i:176;s:7:\"B, A, C\";i:177;s:7:\"C, D, A\";}');
INSERT INTO `nilai` VALUES ('742','13','18','357','ASAG','2025-05-27 09:09:47','2025-05-27 09:48:02','2025-05-27 09:48:06','7','3',NULL,'49','64',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:51:\"kesatuan dan persatuan bangsa dalam aspek kehidupan\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"nomor 5 tahun 2017\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,181,184,187,179,185,182,183,180,186,178,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','7','2','0','2','3','3','0','3','7','4','','4','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, D, A, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('743','13','18','363','ASAG','2025-05-27 09:09:47','2025-05-27 09:50:29','2025-05-27 09:50:35','6','4',NULL,'42','56',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:11:\"pengetahuan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:10:\"persatuan \";i:182;s:31:\"karena budaya merupakan warisan\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:15:\"pasal 32 ayat 1\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','6','3','0','1','4','2','0','4','6','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"D, A, C, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('744','13','18','362','ASAG','2025-05-27 09:09:48','2025-05-27 09:50:20','2025-05-27 09:50:29','8','2',NULL,'56','66',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"36\";i:180;s:17:\"bahasa dan tarian\";i:181;s:26:\"bangsa yang tidak berpecah\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"syair\";i:186;s:21:\"undang undang nomor 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,186,180,183,182,185,179,187,184,181,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','4','2','0','1','6','3','0','4','4','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('745','13','18','365','ASAG','2025-05-27 09:09:49','2025-05-27 09:46:25','2025-05-27 09:47:33','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:26:\"objek kebudayaan dan pudar\";i:181;s:17:\"saling menghargai\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:10:\"jawa barat\";i:185;s:6:\"pidato\";i:186;s:15:\"pasal 32 ayat 1\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, A, B, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('746','13','18','371','ASAG','2025-05-27 09:09:49','2025-05-27 09:48:17','2025-05-27 09:49:24','6','4',NULL,'42','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:18:\"kelestarian bangsa\";i:181;s:13:\"saling tolong\";i:182;s:17:\"agar bangsa hidup\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:6:\"bahasa\";i:186;s:13:\"mengembangkan\";i:187;s:19:\"afrika indoautralia\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,187,186,185,184,183,182,181,180,179,178,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','4','1','0','0','6','4','0','5','4','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"B, D, A, C\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, B, A\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('747','13','18','376','ASAG','2025-05-27 09:09:51','2025-05-27 09:47:37','2025-05-27 09:47:54','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:19:\"jangkauan yang luas\";i:179;s:2:\"38\";i:180;s:18:\"pelestarian budaya\";i:181;s:34:\"bangsa yang utuh tidak ada masalah\";i:182;s:39:\"agar tidak memudar dan terus berkembang\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:3:\"pki\";i:186;s:12:\"5 tahun 2017\";i:187;s:32:\"benua afrika dan benua australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:1:\"D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:173;s:7:\"B, A, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, D, B\";i:176;s:10:\"B, C, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('748','13','18','410','ASAG','2025-05-27 09:09:53','2025-05-27 09:49:33','2025-05-27 09:49:54','5','5',NULL,'35','35',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"A\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:44:\"wawasan artinya wawa/nusantara artinya nusan\";i:179;s:4:\"jawa\";i:180;s:21:\"undang undang pasal 1\";i:181;s:26:\"peraturan peraturan bangsa\";i:182;s:26:\"agar budaya baik dan indah\";i:183;s:11:\"budaya aceh\";i:184;s:15:\"masyarakat aceh\";i:185;s:11:\"bahasa aceh\";i:186;s:20:\"undang undang negara\";i:187;s:17:\"asia dan ostralia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:7:\"A, B, C\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:4:\"A, B\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:4:\"C, B\";i:176;s:4:\"A, D\";i:177;s:7:\"B, A, D\";}');
INSERT INTO `nilai` VALUES ('749','13','18','366','ASAG','2025-05-27 09:09:54','2025-05-27 09:20:20','2025-05-27 09:20:39','8','2',NULL,'56','56',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;N;i:168;N;i:170;N;i:171;N;i:172;N;}','a:0:{}','a:5:{i:173;N;i:174;N;i:175;N;i:176;N;i:177;N;}');
INSERT INTO `nilai` VALUES ('750','13','18','393','ASAG','2025-05-27 09:09:56','2025-05-27 09:47:57','2025-05-27 09:48:31','6','4',NULL,'42','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"32\";i:180;s:18:\"pelestarian budaya\";i:181;s:42:\"menjaga bangsa supaya tidak terpecah belah\";i:182;s:54:\"karena budaya merupakan warisan dari nenek moyang kita\";i:183;s:4:\"aceh\";i:184;s:11:\"jawa tengah\";i:185;s:8:\"mebuehak\";i:186;s:32:\"untuk memajukan budaya indonesia\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('751','13','18','399','ASAG','2025-05-27 09:09:56','2025-05-27 09:52:44','2025-05-27 09:52:54','8','2',NULL,'56','62',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"34\";i:180;s:22:\"manuskrip dan fotogrip\";i:181;s:7:\"sosial \";i:182;s:16:\"memajukan bangsa\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:6:\"bahasa\";i:186;s:7:\"pasal 5\";i:187;s:32:\"benua afrika dan benua asutralia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"B, A, C, D\";i:175;s:10:\"D, B, C, A\";i:176;s:10:\"B, D, A, C\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('752','13','18','382','ASAG','2025-05-27 09:09:58','2025-05-27 09:47:21','2025-05-27 09:47:37','8','2',NULL,'56','69',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:38:\"permainan tradisionaldan tarian daerah\";i:181;s:33:\"bangsa yang tidak terpecah belah \";i:182;s:44:\"karena bangsa ini warisan dari nenek moyang \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:23:\"no 5 tahun 2017 pasal 5\";i:187;s:19:\"asia dan australia \";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('753','13','18','372','ASAG','2025-05-27 09:09:59','2025-05-27 09:47:33','2025-05-27 09:47:52','7','3',NULL,'49','57',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:21:\"pandangan antar pulau\";i:179;s:2:\"32\";i:180;s:23:\"bahasa daerah dan batik\";i:181;s:9:\"persatuan\";i:182;s:25:\"agar tidak terancam punah\";i:183;s:4:\"aceh\";i:184;s:5:\"jawa \";i:185;s:6:\"cerpen\";i:186;s:13:\"bahasa daerah\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','2','2','0','1','8','3','0','4','2','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"B, A, C\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('754','13','18','375','ASAG','2025-05-27 09:10:00','2025-05-27 09:49:17','2025-05-27 09:49:41','8','2',NULL,'56','58',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:21:\"pengetahuan yang luas\";i:179;s:2:\"34\";i:180;s:40:\"tak tau bu saya lupa belajar tentang itu\";i:181;s:28:\"menjaga keutuhan bangsa kita\";i:182;s:79:\"karena jika warga tidak melestrikan budaya maka budaya akan punah kemakan waktu\";i:183;s:4:\"aceh\";i:184;s:4:\"bali\";i:185;s:5:\"cagok\";i:186;s:24:\"pasal 5 ayat 5tahun 2017\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"A, C, B\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('755','13','18','391','ASAG','2025-05-27 09:10:00','2025-05-27 09:39:31','2025-05-27 09:39:29','7','3',NULL,'49','63',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:88:\"kesatuan masyarakat indonesia dalam menjaga dan melestarikan budaya agar tetap satu padu\";i:182;s:35:\"karena merupakan identitas nasional\";i:183;s:4:\"aceh\";i:184;s:11:\"daerah jawa\";i:185;s:23:\"bersyair saat bercerita\";i:186;s:33:\"undang undang no 5 pasal 5 ayat 1\";i:187;s:20:\"afrika dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,181,184,187,179,185,182,183,180,186,178,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','4','4','0','1','6','1','0','4','4','8','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:0:\"\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('756','13','18','383','ASAG','2025-05-27 09:10:05','2025-05-27 09:46:27','2025-05-27 09:46:35','8','2',NULL,'56','69',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"D\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:7:\"menjaga\";i:181;s:9:\"persatuan\";i:182;s:12:\"tidakmemudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:7:\"32ayat2\";i:187;s:13:\"asiaaustralia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','5','4','0','0','5','1','0','5','5','8','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, C, D, B\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('757','13','18','358','ASAG','2025-05-27 09:10:07','2025-05-27 09:46:58','2025-05-27 09:47:27','8','2',NULL,'56','69',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:40:\"persatuan kesatuan dalam aspek kehidupan\";i:182;s:30:\" memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:7:\"1 dan 2\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,154,152,151,148,156,161,165,162,164,178,179,180,181,182,183,184,185,186,187,171,168,172,166,170,173,175,176,177,174,',NULL,NULL,'0','7','2','0','1','3','3','0','4','7','4','','2','a:5:{i:166;s:7:\"B, C, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, D, A\";i:176;s:10:\"A, C, B, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('758','13','18','384','ASAG','2025-05-27 09:10:08','2025-05-27 09:54:47','2025-05-27 09:54:51','4','6',NULL,'28','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"  \";i:180;s:28:\"tradisi linsan dan manuskrip\";i:181;s:1:\" \";i:182;s:18:\"agar tidak memudar\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:4:\"cago\";i:186;s:14:\"pasal 5 ayat 1\";i:187;s:20:\"afrika dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:7:\"C, B, A\";i:175;s:10:\"C, A, D, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('759','13','18','397','ASAG','2025-05-27 09:10:08','2025-05-27 09:47:27','2025-05-27 09:48:08','4','6',NULL,'28','31',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:15:\"kemajuan bangsa\";i:181;s:9:\"jati diri\";i:182;s:11:\"tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:4:\"lagu\";i:186;s:7:\"wawasan\";i:187;s:16:\"pasifik atlantik\";}',NULL,'0','164,162,165,161,156,148,151,152,154,159,178,179,180,181,182,183,184,185,186,187,170,166,172,168,171,174,177,176,175,173,',NULL,NULL,'0','3','0','0','0','7','5','0','5','3','0','','0','a:5:{i:166;s:1:\"A\";i:168;s:1:\"B\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"B, C, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('760','13','18','378','ASAG','2025-05-27 09:10:09','2025-05-27 09:47:49','2025-05-27 09:47:57','8','2',NULL,'56','66',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:22:\"persatuan dan kesatuan\";i:182;s:20:\"memberikan identitas\";i:183;s:4:\"aceh\";i:184;s:10:\"kalimantan\";i:185;s:1:\" \";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:18:\"australia dan asia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','4','3','0','0','6','2','0','5','4','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:7:\"A, B, C\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('761','13','18','370','ASAG','2025-05-27 09:10:13','2025-05-27 09:47:57','2025-05-27 09:48:11','8','2',NULL,'56','68',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:1:\" \";i:181;s:41:\"bangsa yang saling bersatu satu sama lain\";i:182;s:33:\"agar budaya bangsa tidak memudar \";i:183;s:4:\"aceh\";i:184;s:5:\"jawa \";i:185;s:5:\"cagok\";i:186;s:1:\" \";i:187;s:20:\"afrika dan australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:10:\"A, B, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"A, B, C\";i:175;s:7:\"C, D, B\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('762','13','18','388','ASAG','2025-05-27 09:10:18','2025-05-27 09:51:24','2025-05-27 09:51:30','7','3',NULL,'49','60',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:14:\"tari dan musik\";i:181;s:20:\"tidak terpecah belah\";i:182;s:41:\"supaya budaya bangsa tersebut tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"melestarikan budaya bangsa\";i:187;s:19:\"asia dan australia \";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','5','3','0','0','5','2','0','5','5','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('763','13','18','367','ASAG','2025-05-27 09:10:18','2025-05-27 09:48:46','2025-05-27 09:49:33','8','2',NULL,'56','71',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:32:\"negara yang tidak terpecah belah\";i:182;s:26:\"agar bisa menjadi warisan \";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:1:\"-\";i:186;s:0:\"\";i:187;s:18:\"asia dan australia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','5','3','0','2','5','2','0','3','5','6','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:7:\"B, C, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('764','13','18','394','ASAG','2025-05-27 09:10:19','2025-05-27 09:49:17','2025-05-27 09:50:08','4','6',NULL,'28','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:11:\"berhatihati\";i:179;s:10:\"38provinsi\";i:180;s:26:\"1pelestarian2kebijaksanaan\";i:181;s:20:\"memperdulikan bangsa\";i:182;s:63:\"karena melestarikan budaya bangsa tidak boleh sampai terlupakan\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:22:\"adatadatdanpakaianadat\";i:186;s:56:\"undang undang kebudayaan termasuk dari ke warga negaraan\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:4:\"A, D\";i:172;s:4:\"A, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:10:\"A, C, D, B\";i:176;s:10:\"C, A, B, D\";i:177;s:7:\"A, B, D\";}');
INSERT INTO `nilai` VALUES ('765','13','18','359','ASAG','2025-05-27 09:10:20','2025-05-27 09:50:36','2025-05-27 09:50:44','6','4',NULL,'42','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"D\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:39:\"kesatuan dan persatuan bangsa indonesia\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:20:\"pasal 22 ayat 1 2017\";i:187;s:31:\"benua india dan benua australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','7','2','0','1','3','3','0','4','7','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"B, C, D\";i:171;s:1:\"A\";i:172;s:1:\"C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('766','13','18','392','ASAG','2025-05-27 09:10:20','2025-05-27 09:48:42','2025-05-27 09:48:49','8','2',NULL,'56','70',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:20:\"masyarakat yang akur\";i:182;s:48:\"untuk mempelajari dan mengembangkan budaya lokal\";i:183;s:4:\"aceh\";i:184;s:11:\"jawa tengah\";i:185;s:13:\"tradisi lisan\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','4','5','0','0','6','0','0','5','4','10','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:7:\"B, A, C\";i:175;s:7:\"C, A, B\";i:176;s:10:\"D, A, C, B\";i:177;s:7:\"C, A, B\";}');
INSERT INTO `nilai` VALUES ('767','13','18','387','ASAG','2025-05-27 09:10:23','2025-05-27 09:46:46','2025-05-27 09:47:52','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:16:\"tigapuluhdelapan\";i:180;s:1:\" \";i:181;s:12:\"bertoleransi\";i:182;s:18:\"agar tidak memudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:1:\" \";i:186;s:43:\"undang-undang no lima tahun 2017 pasal lima\";i:187;s:15:\"asia dan afrika\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,181,184,187,179,185,182,183,180,186,178,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('768','13','18','354','ASAG','2025-05-27 09:10:27','2025-05-27 09:45:56','2025-05-27 09:46:38','6','4',NULL,'42','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:49:\"kesatuan dan kesatuan dalam suatu aspek kehidupan\";i:182;s:27:\"memperkuat jati diri bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:21:\"uu nomor 5 tahun 2017\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','6','3','0','0','4','2','0','5','6','6','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:4:\"A, B\";i:174;s:7:\"C, A, B\";i:175;s:4:\"B, C\";i:176;s:7:\"C, B, D\";i:177;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('769','13','18','360','ASAG','2025-05-27 09:10:27','2025-05-27 09:48:46','2025-05-27 09:49:34','6','4',NULL,'42','56',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:41:\"kesatuan dan persatuan dalam objek bangsa\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','8','3','0','0','2','2','0','5','8','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, C, A\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('770','13','18','380','ASAG','2025-05-27 09:10:27','2025-05-27 09:54:14','2025-05-27 09:54:18','4','6',NULL,'28','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:0:\"\";i:181;s:0:\"\";i:182;s:108:\"agar budaya kita tidak ketinggalan karena perkembangan zamandan akan tetap dilestarikan secara turun temurun\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:0:\"\";i:187;s:20:\"australia dan hindia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:7:\"A, B, C\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:7:\"A, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, A, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('771','13','18','395','ASAG','2025-05-27 09:10:28','2025-05-27 09:54:04','2025-05-27 09:54:18','6','4',NULL,'42','49',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:10:\"kebudayaan\";i:179;s:2:\"38\";i:180;s:14:\"parang rencong\";i:181;s:17:\"saling menghargai\";i:182;s:28:\"supaya suku dan adat tarjaga\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:7:\"pesijuk\";i:186;s:3:\"uud\";i:187;s:25:\"benua asia benua autralia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','1','0','1','7','4','0','4','3','2','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, A, D, B\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"C, A, D, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('772','13','18','409','ASAG','2025-05-27 09:10:34','2025-05-27 09:51:05','2025-05-27 09:51:09','3','7',NULL,'21','24',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"C\";i:161;s:1:\"D\";i:162;s:1:\"D\";i:164;s:1:\"D\";i:165;s:1:\"C\";}','a:10:{i:178;s:36:\"kesatuan bangsa dan kesatuan wilayah\";i:179;s:4:\"1600\";i:180;s:0:\"\";i:181;s:28:\"nelestarikan keutuhan bangsa\";i:182;s:35:\"karena untuk melestarikan budayanya\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:0:\"\";i:186;s:21:\"undang undang pasal 5\";i:187;s:32:\"benua afrika dan benua australia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"B, C, D\";i:170;s:1:\"C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"B, D, C, A\";i:174;s:7:\"C, B, A\";i:175;s:10:\"C, A, D, B\";i:176;s:10:\"B, D, C, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('773','13','18','396','ASAG','2025-05-27 09:10:36','2025-05-27 09:55:38','2025-05-27 09:55:41','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"C\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:6:\"gunung\";i:179;s:2:\"38\";i:180;s:6:\"ga tau\";i:181;s:17:\"saling menghargai\";i:182;s:43:\"agar tidak lupa dengan leluhur dan adat nya\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:6:\"pidato\";i:186;s:18:\"saling menghormati\";i:187;s:27:\"benua asia dan benua afrika\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','3','0','0','8','2','0','5','2','6','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:7:\"B, A, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, B, D, C\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('774','13','18','406','ASAG','2025-05-27 09:10:37','2025-05-27 09:53:51','2025-05-27 09:53:56','6','4',NULL,'42','54',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:1:\"c\";i:179;s:2:\"38\";i:180;s:1:\"c\";i:181;s:9:\"persatuan\";i:182;s:1:\"c\";i:183;s:4:\"aceh\";i:184;s:1:\"c\";i:185;s:1:\"c\";i:186;s:1:\"c\";i:187;s:17:\"asia indoaustrali\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:7:\"B, A, C\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('775','13','18','385','ASAG','2025-05-27 09:10:44','2025-05-27 09:50:20','2025-05-27 09:50:29','8','2',NULL,'56','67',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:58:\"cara pandang bangsa indonesia tentang diri dan lingkungan \";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:36:\"mengutamakan persatuan dan kesatuan \";i:182;s:56:\"sebagai pedoman dalam kehidupan berbangsa dan bernegara \";i:183;s:4:\"aceh\";i:184;s:12:\"jawa tengah \";i:185;s:11:\"berdongeng \";i:186;s:13:\"no 5 uud 1945\";i:187;s:19:\"australia dan asia \";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','3','3','0','1','7','2','0','4','3','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, A, B\";i:175;s:7:\"A, B, C\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('776','13','18','369','ASAG','2025-05-27 09:10:49','2025-05-27 09:48:57','2025-05-27 09:49:18','9','1',NULL,'63','73',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:22:\"pandangan hidup bangsa\";i:179;s:2:\"38\";i:180;s:32:\"adat istiadat pelestarian budaya\";i:181;s:51:\"keutuhan bangsa adalah satu ke satuan sebuah bangsa\";i:182;s:42:\"karna budaya bangsa adalah cerminan negara\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"menjaga pelestarian budaya\";i:187;s:15:\"india australia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','4','2','0','1','6','3','0','4','4','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('777','13','18','405','ASAG','2025-05-27 09:11:47','2025-05-27 09:47:00','2025-05-27 09:47:08','4','6',NULL,'28','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:1:\" \";i:181;s:1:\" \";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:1:\" \";i:187;s:18:\"australia dan asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','5','2','0','2','5','3','0','3','5','4','','4','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('778','13','18','411','ASAG','2025-05-27 09:11:53','2025-05-27 09:38:02','2025-05-27 09:38:14','6','4',NULL,'42','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:8:\"pemajuan\";i:181;s:8:\"keutuhan\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"syair\";i:186;s:15:\"keutuhan bangsa\";i:187;s:21:\"australia dan eurasia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','4','1','0','2','6','4','0','3','4','2','','4','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:4:\"A, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('779','13','18','379','ASAG','2025-05-27 09:11:53','2025-05-27 09:53:55','2025-05-27 09:54:25','6','4',NULL,'42','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:11:\"pengetahuan\";i:179;s:2:\"34\";i:180;s:19:\"kemajuan kebudayaan\";i:181;s:25:\"seperti persatuan bangsa \";i:182;s:41:\"agar budaya tersebut tidak tertelan zaman\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:10:\"peugahabah\";i:186;s:9:\"teknologi\";i:187;s:13:\"asia tenggara\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:7:\"A, B, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"B, C, D\";i:176;s:10:\"A, B, C, D\";i:177;s:7:\"A, B, C\";}');
INSERT INTO `nilai` VALUES ('780','13','18','403','ASAG','2025-05-27 09:12:16','2025-05-27 09:44:12','2025-05-27 09:44:44','6','4',NULL,'42','49',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:10:\"pandangan \";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:7:\"gak tau\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:5:\"hindu\";i:185;s:8:\"gak tau \";i:186;s:48:\"5 tahun 2017 pasal 5 menyebut 10 objek pemajuan \";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,181,184,187,179,185,182,183,180,186,178,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','3','2','0','0','7','3','0','5','3','4','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"B, A, C\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('781','13','18','407','ASAG','2025-05-27 09:15:54','2025-05-27 09:49:18','2025-05-27 09:50:28','9','1',NULL,'63','68',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:24:\"wawasan adalah kepulauan\";i:179;s:11:\"34 provinsi\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:29:\"bangsa yang saling melengkapi\";i:182;s:68:\"agar budaya tetap terjaga dan dikenal lebih banyak orang kedepan nya\";i:183;s:5:\"aceh \";i:184;s:9:\"indonesia\";i:185;s:14:\"bahasa senjata\";i:186;s:11:\"uud nomor 5\";i:187;s:20:\"australia dan afrika\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:166;s:7:\"A, B, C\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:7:\"B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:7:\"C, A, B\";i:174;s:1:\"A\";i:175;s:7:\"C, B, D\";i:176;s:7:\"B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('782','13','18','404','ASAG','2025-05-27 09:16:49','2025-05-27 09:52:47','2025-05-27 09:52:52','4','6',NULL,'28','31',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"C\";i:161;s:1:\"B\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:63:\"wawasan nusantara yaitu berati dari bahasa yunani adalah lautan\";i:179;s:11:\"38 provinsi\";i:180;s:60:\"menghormati budaya sendiri 2saling menghargai budaya sendiri\";i:181;s:39:\"saling menolong dan mempersatuan bangsa\";i:182;s:36:\"karena itu adat merekadari keturunan\";i:183;s:9:\"dari aceh\";i:184;s:22:\"jawa sama aceh sumatra\";i:185;s:24:\"tradisi aceh sudah pudar\";i:186;s:53:\"kita harus mengasih tau orang bahwa budaya kita bagus\";i:187;s:18:\"asia dan australia\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:0:\"\";i:175;s:10:\"B, C, A, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('783','13','18','364','ASAG','2025-05-27 09:41:29','2025-05-27 09:50:22','2025-05-27 09:50:41','8','2',NULL,'56','67',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:23:\"tradisi lisan manuskrip\";i:181;s:65:\"kesatuan dan kekompakan masyarakat bangsa dalam melindungi bangsa\";i:182;s:87:\"karena budaya bangsa telah diwariskan oleh nenek moyang kita dan mengandung nilai luhur\";i:183;s:4:\"aceh\";i:184;s:11:\"daerah jawa\";i:185;s:8:\"bersyair\";i:186;s:15:\"pasal 32 ayat 1\";i:187;s:24:\"benua asia dan australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','3','0','1','7','2','0','4','3','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, D\";i:171;s:10:\"A, B, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:7:\"C, B, A\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('784','14','16','411','ASAG','2025-05-27 09:46:39','2025-05-27 10:01:30','2025-05-27 10:02:12','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:10:\"kesehatan \";i:519;s:10:\"pemanasan \";i:520;s:7:\"pacaran\";i:521;s:10:\"kecerdasan\";i:522;s:7:\"menjaga\";i:523;s:5:\"buruk\";i:524;s:4:\"helm\";i:525;s:7:\"trotoar\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('785','14','16','408','ASAG','2025-05-27 09:46:41','2025-05-27 09:56:46','2025-05-27 09:57:16','10','0',NULL,'70','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:26:\"melakukan hubungan seksual\";i:521;s:9:\"nama baik\";i:522;s:10:\"pertahanan\";i:523;s:10:\"tidak baik\";i:524;s:4:\"helm\";i:525;s:10:\"bahu jalan\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:7:\"C, B, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('786','14','16','403','ASAG','2025-05-27 09:47:08','2025-05-27 10:15:27','2025-05-27 10:19:35','9','1',NULL,'63','76',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,516,517,518,519,520,521,522,523,524,525,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"A, D\";i:42;s:4:\"B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"B, C, A, D\";i:55;s:7:\"C, B, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('787','14','16','366','ASAG','2025-05-27 09:47:14','2025-05-27 10:23:35','2025-05-27 10:23:42','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:4:\"otot\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"pembelajaran\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','5','4','0','1','5','1','0','4','5','8','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"A, D, B, C\";i:53;s:10:\"B, C, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('788','14','16','356','ASAG','2025-05-27 09:47:35','2025-05-27 10:23:44','2025-05-27 10:23:49','9','1',NULL,'63','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:7:\"pikiran\";i:522;s:7:\"menjaga\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','5','4','0','5','5','1','0','0','5','8','','10','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('789','14','16','405','ASAG','2025-05-27 09:47:51','2025-05-27 10:02:03','2025-05-27 10:02:06','8','2',NULL,'56','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"B\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:4:\"bela\";i:523;s:5:\"jahat\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('790','14','16','383','ASAG','2025-05-27 09:48:00','2025-05-27 10:23:32','2025-05-27 10:23:37','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','6','4','0','2','4','1','0','3','6','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"C, A, B, D\";i:57;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('791','14','16','358','ASAG','2025-05-27 09:48:04','2025-05-27 10:23:29','2025-05-27 10:23:43','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"D\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:14:\"nilai akademik\";i:522;s:16:\"memiliki batasan\";i:523;s:7:\"pemarah\";i:524;s:4:\"helm\";i:525;s:28:\"menyeberang pada zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"B, C, A, D\";}');
INSERT INTO `nilai` VALUES ('792','14','16','382','ASAG','2025-05-27 09:48:05','2025-05-27 10:24:41','2025-05-27 10:23:41','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"aku anak indonesia\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,516,517,518,519,520,521,522,523,524,525,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('793','14','16','378','ASAG','2025-05-27 09:48:14','2025-05-27 10:13:40','2025-05-27 10:23:34','10','0',NULL,'70','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:13:\"kekuatan otot\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"percaya diri\";i:522;s:7:\"menahan\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,525,524,523,522,521,520,519,518,517,516,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:7:\"B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('794','14','16','389','ASAG','2025-05-27 09:48:16','2025-05-27 10:12:10','2025-05-27 10:17:47','9','1',NULL,'63','75',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"music\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"prioritas\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','4','2','0','2','6','3','0','3','4','4','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('795','14','16','370','ASAG','2025-05-27 09:48:29','2025-05-27 10:20:57','2025-05-27 10:23:36','7','3',NULL,'49','68',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"membangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','5','3','0','4','5','2','0','1','5','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('796','14','16','368','ASAG','2025-05-27 09:48:34','2025-05-27 10:23:32','2025-05-27 10:23:49','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:6:\"sosial\";i:522;s:9:\"manajemen\";i:523;s:6:\"bandal\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,521,524,516,517,520,525,518,523,519,522,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('797','14','16','357','ASAG','2025-05-27 09:48:38','2025-05-27 10:23:29','2025-05-27 10:23:36','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:13:\"hubungan seks\";i:521;s:5:\"fisik\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','3','0','4','5','2','0','1','5','6','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, C, D\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('798','14','16','376','ASAG','2025-05-27 09:48:41','2025-05-27 10:15:39','2025-05-27 10:23:39','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:13:\"hubungan seks\";i:521;s:8:\"semangat\";i:522;s:7:\"menjaga\";i:523;s:8:\"tertutup\";i:524;s:4:\"helm\";i:525;s:38:\"zebra cross atau jembatan penyebrangan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:0:\"\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('799','14','16','365','ASAG','2025-05-27 09:48:45','2025-05-27 10:14:24','2025-05-27 10:23:37','8','2',NULL,'56','72',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"kebugaran \";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:5:\"sikap\";i:523;s:5:\"keras\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('800','14','16','387','ASAG','2025-05-27 09:48:46','2025-05-27 10:01:43','2025-05-27 10:02:56','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"nama baik\";i:522;s:7:\"menjaga\";i:523;s:5:\"nakal\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','5','3','0','2','5','2','0','3','5','6','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, A, D\";i:56;s:7:\"C, A, B\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('801','14','16','397','ASAG','2025-05-27 09:48:49','2025-05-27 10:03:08','2025-05-27 10:05:52','9','1',NULL,'63','75',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"B\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:18:\"berpegangan tangan\";i:521;s:5:\"rajin\";i:522;s:12:\"menjaga diri\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:16:\"rambu lalulintas\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','0','6','1','0','5','4','8','','0','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, A, B\";i:53;s:10:\"B, D, A, C\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"A, B, D, C\";i:57;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('802','14','16','355','ASAG','2025-05-27 09:48:52','2025-05-27 10:08:06','2025-05-27 10:15:33','0','10',NULL,'0','0',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"X\";i:26;s:1:\"X\";i:27;s:1:\"X\";i:28;s:1:\"X\";i:30;s:1:\"X\";i:31;s:1:\"X\";i:32;s:1:\"X\";i:34;s:1:\"X\";i:35;s:1:\"X\";i:36;s:1:\"X\";}','a:10:{i:516;s:11:\"Tidak Diisi\";i:517;s:11:\"Tidak Diisi\";i:518;s:11:\"Tidak Diisi\";i:519;s:11:\"Tidak Diisi\";i:520;s:11:\"Tidak Diisi\";i:521;s:11:\"Tidak Diisi\";i:522;s:11:\"Tidak Diisi\";i:523;s:11:\"Tidak Diisi\";i:524;s:11:\"Tidak Diisi\";i:525;s:11:\"Tidak Diisi\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:39;N;i:41;N;i:42;N;i:44;N;i:46;N;}','a:0:{}','a:5:{i:51;N;i:53;N;i:55;N;i:56;N;i:57;N;}');
INSERT INTO `nilai` VALUES ('803','14','16','401','ASAG','2025-05-27 09:48:57','2025-05-27 10:19:41','2025-05-27 10:22:33','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:18:\"semangatkebangsaan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:11:\"merusaknama\";i:522;s:7:\"menjaga\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('804','14','16','400','ASAG','2025-05-27 09:48:59','2025-05-27 10:07:39','2025-05-27 10:21:37','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:19:\"semangat kebangsaan\";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:9:\"kemampuan\";i:522;s:7:\"menjaga\";i:523;s:9:\"pembantah\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('805','14','16','372','ASAG','2025-05-27 09:49:09','2025-05-27 10:11:07','2025-05-27 10:11:17','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"C\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:18:\"hamil diluar nikah\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','4','8','2','0','1','2','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('806','14','16','354','ASAG','2025-05-27 09:49:14','2025-05-27 10:13:19','2025-05-27 10:23:36','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidak baik\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('807','14','16','392','ASAG','2025-05-27 09:49:25','2025-05-27 10:16:37','2025-05-27 10:16:55','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:9:\"ketahanan\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:38:\"zebra cross dan jembatan penyeberangan\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"D, B, A, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('808','14','16','374','ASAG','2025-05-27 09:49:51','2025-05-27 10:14:06','2025-05-27 10:23:32','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"imun tubuh\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"pergaulan\";i:522;s:9:\"ketahanan\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:37:\"zebra chroz dan jembatan penyebrangan\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('809','14','16','369','ASAG','2025-05-27 09:49:55','2025-05-27 10:16:20','2025-05-27 10:23:35','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:11:\"konsentrasi\";i:522;s:11:\"  ketahanan\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:18:\"tidak tergesa gesa\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('810','14','16','390','ASAG','2025-05-27 09:49:57','2025-05-27 10:08:16','2025-05-27 10:23:40','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"reputasi\";i:522;s:9:\"kesadaran\";i:523;s:5:\"nakal\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('811','14','16','393','ASAG','2025-05-27 09:50:01','2025-05-27 10:20:41','2025-05-27 10:23:34','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:17:\"kebugaran jasmani\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:16:\"semangat belajar\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('812','14','16','360','ASAG','2025-05-27 09:50:01','2025-05-27 10:22:29','2025-05-27 10:23:40','9','1',NULL,'63','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:14:\"mencemari nama\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('813','14','16','367','ASAG','2025-05-27 09:50:04','2025-05-27 10:23:33','2025-05-27 10:23:39','9','1',NULL,'63','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:8:\"semangat\";i:518;s:15:\"kesehatan fisik\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:7:\"pendiam\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('814','14','16','391','ASAG','2025-05-27 09:50:10','2025-05-27 10:13:23','2025-05-27 10:23:52','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:14:\"kekuatan fisik\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:8:\"melawan \";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('815','14','16','402','ASAG','2025-05-27 09:50:13','2025-05-27 10:15:12','2025-05-27 10:19:36','9','1',NULL,'63','76',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:12:\"menjaga diri\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','5','4','0','0','5','1','0','5','5','8','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, D, A\";i:55;s:1:\"C\";i:56;s:7:\"B, A, D\";i:57;s:7:\"D, B, A\";}');
INSERT INTO `nilai` VALUES ('816','14','16','371','ASAG','2025-05-27 09:50:16','2025-05-27 10:17:51','2025-05-27 10:23:35','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:5:\"emosi\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','5','3','0','2','5','2','0','3','5','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('817','14','16','394','ASAG','2025-05-27 09:50:23','2025-05-27 10:22:18','2025-05-27 10:23:35','9','1',NULL,'63','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"ceria\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:48:\"hindari dari mereka agar tidak jadi permasalahan\";i:521;s:11:\"konsentrasi\";i:522;s:10:\"hawa nafsu\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:17:\"jalan zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','2','4','0','2','8','1','0','3','2','8','','4','a:5:{i:39;s:7:\"B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('818','14','16','375','ASAG','2025-05-27 09:50:25','2025-05-27 10:23:50','2025-05-27 10:23:55','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:7:\"stamina\";i:519;s:9:\"pemanasan\";i:520;s:16:\"hubungan seksual\";i:521;s:8:\"karakter\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','3','3','0','3','7','2','0','2','3','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('819','14','16','410','ASAG','2025-05-27 09:50:30','2025-05-27 10:20:20','2025-05-27 10:23:40','8','2',NULL,'56','60',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"B\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:45:\"lagu anak indonesia hebat agar lebih semangat\";i:518;s:15:\"kesehatan tubuh\";i:519;s:26:\"pemanasan terlebih dahulu \";i:520;s:9:\"sex bebas\";i:521;s:9:\"priolitas\";i:522;s:32:\"kemampuan diri sendiri yang baik\";i:523;s:21:\"tidak sopan dan etika\";i:524;s:4:\"hemp\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:39;s:4:\"C, D\";i:41;s:4:\"B, D\";i:42;s:4:\"A, B\";i:44;s:4:\"A, C\";i:46;s:4:\"A, B\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, A, D\";i:53;s:7:\"A, B, D\";i:55;s:10:\"C, B, A, D\";i:56;s:1:\"D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('820','14','16','407','ASAG','2025-05-27 09:50:47','2025-05-27 10:04:24','2025-05-27 10:23:31','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"suhu tubuh\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:11:\"pertemanan \";i:522;s:8:\"menjaga \";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:38:\"zebra cross atau jembatan penyebrangan\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,522,519,523,518,525,520,517,516,524,521,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('821','14','16','385','ASAG','2025-05-27 09:50:49','2025-05-27 10:19:39','2025-05-27 10:23:40','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:25:\"aku anak indonesia hebat \";i:517;s:8:\"intonasi\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:7:\"pendiam\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','3','0','2','7','2','0','3','3','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('822','14','16','364','ASAG','2025-05-27 09:51:00','2025-05-27 10:17:29','2025-05-27 10:23:40','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:37:\"hubungan asmara atau tindakan seksual\";i:521;s:6:\"mental\";i:522;s:7:\"menjaga\";i:523;s:26:\"malas abai dan mudah marah\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,516,517,518,519,520,521,522,523,524,525,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('823','14','16','363','ASAG','2025-05-27 09:51:24','2025-05-27 10:13:49','2025-05-27 10:23:41','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:9:\"kesadaran\";i:523;s:5:\"buruk\";i:524;s:4:\"helm\";i:525;s:10:\"zebra kros\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('824','14','16','409','ASAG','2025-05-27 09:51:25','2025-05-27 10:20:15','2025-05-27 10:23:40','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"C\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"music\";i:518;s:10:\"pernafasan\";i:519;s:10:\"pemanasan \";i:520;s:26:\"bisa meninbulkan kehamilan\";i:521;s:10:\"kemalasan \";i:522;s:8:\"menjaga \";i:523;s:5:\"malas\";i:524;s:4:\"helm\";i:525;s:10:\"zebrakros \";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','3','0','3','10','2','0','2','0','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, C, D\";i:46;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:51;s:7:\"B, C, D\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('825','14','16','362','ASAG','2025-05-27 09:51:30','2025-05-27 10:08:23','2025-05-27 10:23:37','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:8:\"tertutup\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','5','5','0','3','5','0','0','2','5','10','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('826','14','16','386','ASAG','2025-05-27 09:51:49','2025-05-27 10:22:54','2025-05-27 10:23:36','10','0',NULL,'70','84',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:7:\"stamina\";i:519;s:9:\"pemanasan\";i:520;s:16:\"hubungan seksual\";i:521;s:8:\"karakter\";i:522;s:8:\"menjaga \";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('827','14','16','359','ASAG','2025-05-27 09:52:37','2025-05-27 10:23:07','2025-05-27 10:23:38','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"seks bebas\";i:521;s:14:\"mencemari nama\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:4:\"C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('828','14','16','377','ASAG','2025-05-27 09:53:06','2025-05-27 10:21:42','2025-05-27 10:24:31','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:16:\"hubungan seksual\";i:521;s:8:\"karakter\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,521,524,516,517,520,525,518,523,519,522,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, D, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"A, C, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('829','14','16','388','ASAG','2025-05-27 09:53:22','2025-05-27 10:14:53','2025-05-27 10:19:09','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:6:\"musik \";i:518;s:10:\"kesehatan \";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:14:\"nilai akademik\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','3','0','3','7','2','0','2','3','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('830','14','16','399','ASAG','2025-05-27 09:53:38','2025-05-27 10:15:08','2025-05-27 10:17:05','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"semangat\";i:522;s:10:\"pertahanan\";i:523;s:10:\"tidak baik\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','5','4','0','1','5','1','0','4','5','8','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, C, D\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, D, C\";i:53;s:10:\"B, C, A, D\";i:55;s:10:\"B, C, A, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('831','14','16','373','ASAG','2025-05-27 09:54:20','2025-05-27 10:12:42','2025-05-27 10:23:35','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:15:\"kebugaran tubuh\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:17:\"merusak nama baik\";i:522;s:5:\"fisik\";i:523;s:11:\"pembangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','3','5','0','1','7','0','0','4','3','10','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:7:\"D, B, C\";}');
INSERT INTO `nilai` VALUES ('832','14','16','395','ASAG','2025-05-27 09:54:35','2025-05-27 10:25:31','2025-05-27 10:25:45','10','0',NULL,'70','92',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:10:\"masa depan\";i:522;s:10:\"hawa nafsu\";i:523;s:7:\"melawan\";i:524;s:5:\"helem\";i:525;s:16:\"jalan zebra kros\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','4','5','0','4','6','0','0','1','4','10','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('833','14','16','406','ASAG','2025-05-27 09:54:37','2025-05-27 10:04:42','2025-05-27 10:05:30','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:10:\"bahu jalan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, D, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:7:\"C, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('834','14','16','381','ASAG','2025-05-27 09:54:45','2025-05-27 10:24:01','2025-05-27 10:24:06','9','1',NULL,'63','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:4:\"suhu\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"sikap\";i:522;s:10:\"mengontrol\";i:523;s:11:\"membangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('835','14','16','380','ASAG','2025-05-27 09:54:48','2025-05-27 10:16:43','2025-05-27 10:17:59','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:11:\"membangkang\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','5','3','0','4','5','2','0','1','5','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('836','14','16','379','ASAG','2025-05-27 09:54:54','2025-05-27 10:17:21','2025-05-27 10:18:07','10','0',NULL,'70','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"kesehatan \";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"kefokusan\";i:522;s:7:\"menjaga\";i:523;s:7:\"berubah\";i:524;s:4:\"helm\";i:525;s:11:\"lampu merah\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','3','0','0','3','7','5','0','2','3','0','','6','a:5:{i:39;s:1:\"D\";i:41;s:1:\"B\";i:42;s:1:\"B\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, A, D, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"D, B, A, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('837','14','16','384','ASAG','2025-05-27 09:55:01','2025-05-27 10:19:33','2025-05-27 10:23:40','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:8:\"kekuatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"nilai \";i:522;s:7:\"menjaga\";i:523;s:10:\"tidak baik\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,516,517,518,519,520,521,522,523,524,525,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','3','3','0','4','7','2','0','1','3','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('838','14','16','398','ASAG','2025-05-27 09:55:22','2025-05-27 10:22:31','2025-05-27 10:22:46','5','5',NULL,'35','46',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"C\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"B\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:6:\"energi\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:10:\"masa depan\";i:522;s:9:\"jaga diri\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:10:\"ramburambu\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','3','3','0','1','7','2','0','4','3','6','','2','a:5:{i:39;s:7:\"A, B, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, A, B\";i:53;s:10:\"C, B, A, D\";i:55;s:7:\"C, B, D\";i:56;s:10:\"B, A, D, C\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('839','14','16','396','ASAG','2025-05-27 09:55:53','2025-05-27 10:12:50','2025-05-27 10:13:49','8','2',NULL,'56','68',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"B\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:10:\"pernapasan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:10:\"masa depan\";i:522;s:9:\"jaga diri\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:11:\"lampu merah\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:7:\"B, A, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('840','14','16','404','ASAG','2025-05-27 09:56:21','2025-05-27 10:19:11','2025-05-27 10:20:22','7','3',NULL,'49','60',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"D\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:26:\"senam anak indonesia hebat\";i:517;s:9:\"bernyanyi\";i:518;s:16:\"tubuh agar sehat\";i:519;s:9:\"pemanasan\";i:520;s:48:\"harus menjaga jarak supaya tidak terjadi apa apa\";i:521;s:29:\"bisa di keluarin dari sekolah\";i:522;s:8:\"beladiri\";i:523;s:48:\"melawan orang tua menjadi kasar sama semua orang\";i:524;s:5:\"helem\";i:525;s:19:\"sesudah lampu merah\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','1','3','0','2','9','2','0','3','1','6','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"A, C, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('841','14','16','361','ASAG','2025-05-27 09:57:34','2025-05-27 10:18:48','2025-05-27 10:23:39','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:16:\"kebugaranjasmani\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:17:\"mencorengnamabaik\";i:522;s:7:\"menjaga\";i:523;s:26:\"kasardantidakmemilikietika\";i:524;s:4:\"helm\";i:525;s:34:\"jembatanpenyeberangandanzebracross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('842','15','18','430','ASAG','2025-05-27 10:37:53','2025-05-27 11:16:33','2025-05-27 11:16:51','4','6',NULL,'28','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:8:\"kelautan\";i:179;s:2:\"39\";i:180;s:32:\"menlestarikan dan memperkenalkan\";i:181;s:15:\"kesatuan bangsa\";i:182;s:34:\"untuk memperkenalkan kepada global\";i:183;s:4:\"aceh\";i:184;s:6:\" sunda\";i:185;s:17:\"dalam bahasa aceh\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"C, B, A, D\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"C, A, B, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"A, D, B, C\";}');
INSERT INTO `nilai` VALUES ('843','15','18','439','ASAG','2025-05-27 10:38:18','2025-05-27 11:06:59','2025-05-27 11:08:34','7','3',NULL,'49','57',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:48:\"terwujudnya kesatuan bangsa dan kesatuan wilayah\";i:179;s:2:\"38\";i:180;s:11:\"lisankritik\";i:181;s:16:\"persatuan bangsa\";i:182;s:17:\"agar tidak punah \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:18:\"cagok dan peusijuk\";i:186;s:13:\"uu tahun 1945\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','4','2','0','0','6','3','0','5','4','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"B, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, B, D\";i:176;s:10:\"C, D, A, B\";i:177;s:0:\"\";}');
INSERT INTO `nilai` VALUES ('844','15','18','440','ASAG','2025-05-27 10:38:54','2025-05-27 11:23:27','2025-05-27 11:24:13','7','3',NULL,'49','60',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:11:\"Tidak Diisi\";i:182;s:65:\"agar budaya bangsa tetap terjaga dan bisa digunakan oleh generasi\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:35:\"cagok atau pidato dalam bahasa aceh\";i:186;s:26:\"nomor 5 pasal 5 tahun 2017\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','5','3','0','0','5','2','0','5','5','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;N;i:175;s:7:\"C, B, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('845','15','18','458','ASAG','2025-05-27 10:39:16','2025-05-27 11:24:30','2025-05-27 11:24:40','3','7',NULL,'21','21',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"A\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:6:\"sinyal\";i:179;s:55:\"provinsi kesatuan memiliki sebagai kepulauan indonesia \";i:180;s:9:\"profinsi \";i:181;s:17:\"bangsa indonesia \";i:182;s:48:\"melestarikan mengapa warna negara budaya bangsa \";i:183;s:12:\"jawa tengah \";i:184;s:32:\"masyarakat kehidupan khususnya  \";i:185;s:20:\"tari bungong jeumpa \";i:186;s:24:\"objek pemajuan kebudaya \";i:187;s:20:\"aceh dan jawa barat \";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;s:1:\"D\";i:168;s:1:\"B\";i:170;s:1:\"B\";i:171;s:1:\"C\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:1:\"D\";i:174;s:1:\"A\";i:175;s:1:\"C\";i:176;s:1:\"A\";i:177;s:1:\"C\";}');
INSERT INTO `nilai` VALUES ('846','15','18','422','ASAG','2025-05-27 10:39:20','2025-05-27 11:22:42','2025-05-27 11:23:01','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"B\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"manuskrip dan tradisi lisan\";i:181;s:32:\"bangsa yang tidak terpecah belah\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:9:\"cut mutia\";i:186;s:19:\"uud 1945 33 pasal 2\";i:187;s:17:\"pasifik dan india\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','3','0','0','3','7','5','0','2','3','0','','6','a:5:{i:166;s:1:\"B\";i:168;s:1:\"B\";i:170;s:1:\"C\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('847','15','18','438','ASAG','2025-05-27 10:39:22','2025-05-27 11:17:08','2025-05-27 11:17:16','5','5',NULL,'35','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:17:\"budaya mastarakat\";i:179;s:13:\"5 pulau besar\";i:180;s:17:\"transportasi umum\";i:181;s:46:\"menjaga kelestarian alam dan budaya masyarakat\";i:182;s:20:\"agar semakin terjaga\";i:183;s:22:\"salah satu budaya aceh\";i:184;s:9:\"indonesia\";i:185;s:5:\"puisi\";i:186;s:4:\"nkri\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','0','0','1','9','5','0','4','1','0','','2','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"B\";i:171;s:1:\"D\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, D, B, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('848','15','18','431','ASAG','2025-05-27 10:39:36','2025-05-27 11:24:50','2025-05-27 11:25:10','6','4',NULL,'42','46',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"D\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:4:\"aceh\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:166;s:7:\"A, B, C\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, B, C\";i:171;s:10:\"A, B, C, D\";i:172;N;}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"B, C, A, D\";i:175;s:10:\"D, A, C, B\";i:176;s:10:\"D, B, C, A\";i:177;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('849','15','18','450','ASAG','2025-05-27 10:39:38','2025-05-27 11:22:51','2025-05-27 11:23:39','4','6',NULL,'28','34',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:25:\"wawasan artinya pandangan\";i:179;s:2:\"38\";i:180;s:25:\"kebangsaan dan kebudayaan\";i:181;s:22:\"keutuhan bangsa adalah\";i:182;s:17:\"karena beda beda \";i:183;s:4:\"aceh\";i:184;s:15:\"masyarakat jawa\";i:185;s:46:\"sudah pudar karena banyak terjadi msalah hidup\";i:186;s:10:\"kebangsaan\";i:187;s:15:\"eropa australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:0:\"\";i:175;s:10:\"C, D, B, A\";i:176;s:10:\"B, C, D, A\";i:177;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('850','15','18','466','ASAG','2025-05-27 10:39:40','2025-05-27 11:16:13','2025-05-27 11:22:46','5','5',NULL,'35','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:13:\"tradisi lisan\";i:181;s:39:\"persatuan dan kesatuan bangsa indonesia\";i:182;s:49:\"agar tidak punah dan dilupakan oleh generasi emas\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','5','2','0','0','5','3','0','5','5','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, D, A, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('851','15','18','414','ASAG','2025-05-27 10:39:46','2025-05-27 11:24:54','2025-05-27 11:25:04','4','6',NULL,'28','34',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:30:\"kekuasaan bangsa masing masing\";i:179;s:2:\"38\";i:180;s:16:\"bergotong royong\";i:181;s:21:\"mempertahankan bangsa\";i:182;s:42:\"karena untuk mengingat arwah para pahlawan\";i:183;s:4:\"aceh\";i:184;s:15:\"masyarakat jawa\";i:185;s:7:\"sejarah\";i:186;s:14:\"mempertahankan\";i:187;s:30:\"benua hindia dan benua pasifik\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"D\";i:171;s:1:\"B\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;N;i:175;s:10:\"A, D, C, B\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"B, A, C, D\";}');
INSERT INTO `nilai` VALUES ('852','15','18','441','ASAG','2025-05-27 10:40:14','2025-05-27 11:25:03','2025-05-27 11:25:34','5','5',NULL,'35','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"D\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:11:\"carapandang\";i:179;s:2:\"38\";i:180;s:39:\"melestarikan kebudayaan keutuhan bangsa\";i:181;s:15:\"saling mengerti\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, C, D\";i:170;s:4:\"B, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"B, C, A, D\";i:175;s:10:\"B, A, C, D\";i:176;s:10:\"B, D, A, C\";i:177;s:7:\"B, A, D\";}');
INSERT INTO `nilai` VALUES ('853','15','18','469','ASAG','2025-05-27 10:40:17','2025-05-27 11:14:27','2025-05-27 11:22:39','5','5',NULL,'35','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:3:\"38 \";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:70:\"persatuan dan kesatuan bangsa indonesia dalam berbagai aspek kehidupan\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,186,180,183,182,185,179,187,184,181,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','7','0','0','1','3','5','0','4','7','0','','2','a:5:{i:166;s:1:\"A\";i:168;s:1:\"A\";i:170;s:1:\"B\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, B, C, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('854','15','18','425','ASAG','2025-05-27 10:40:30','2025-05-27 11:23:14','2025-05-27 11:23:20','7','3',NULL,'49','57',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:65:\"persatuan dan kesatuan bangsa indonesia dalam segala aspek bangsa\";i:182;s:85:\"karena budaya sangat penting karena bisa menunjukan ciri khas daerahnya masing-masing\";i:183;s:4:\"aceh\";i:184;s:4:\"bali\";i:185;s:14:\"doa tolak bala\";i:186;s:19:\"melestarikan budaya\";i:187;s:18:\"hindia dan pasifik\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','4','1','0','1','6','4','0','4','4','2','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('855','15','18','460','ASAG','2025-05-27 10:40:32','2025-05-27 11:22:52','2025-05-27 11:23:23','6','4',NULL,'42','48',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"38 provinsi\";i:180;s:5:\"objek\";i:181;s:23:\"utuhnya dalam berbangsa\";i:182;s:34:\"untuk memajukan kelestarian negara\";i:183;s:4:\"aceh\";i:184;s:19:\"masyarakaat bandung\";i:185;s:26:\"menulis dengan bahasa aceh\";i:186;s:22:\"undang undang pemajuan\";i:187;s:14:\"benua selartan\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','2','1','0','1','8','4','0','4','2','2','','2','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"C\";i:171;s:1:\"A\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:10:\"B, C, A, D\";i:175;s:10:\"B, C, D, A\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('856','15','18','415','ASAG','2025-05-27 10:40:33','2025-05-27 11:22:29','2025-05-27 11:22:44','8','2',NULL,'56','71',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:39:\"sesuatu yang dimiliki oleh suatu bangsa\";i:182;s:34:\"agar budaya tersebut tidak hilang \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:10:\"syair aceh\";i:186;s:14:\"pasal 1 ayat 2\";i:187;s:30:\"benua asia dan benua australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,181,184,187,179,185,182,183,180,186,178,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','2','0','3','5','3','0','2','5','4','','6','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('857','15','18','449','ASAG','2025-05-27 10:40:33','2025-05-27 11:25:22','2025-05-27 11:25:54','0','10',NULL,'0','0',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"X\";i:151;s:1:\"X\";i:152;s:1:\"X\";i:154;s:1:\"X\";i:156;s:1:\"X\";i:159;s:1:\"X\";i:161;s:1:\"X\";i:162;s:1:\"X\";i:164;s:1:\"X\";i:165;s:1:\"X\";}','a:10:{i:178;s:11:\"Tidak Diisi\";i:179;s:11:\"Tidak Diisi\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:11:\"Tidak Diisi\";i:183;s:11:\"Tidak Diisi\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:166;N;i:168;N;i:170;N;i:171;N;i:172;N;}','a:0:{}','a:5:{i:173;N;i:174;N;i:175;N;i:176;N;i:177;N;}');
INSERT INTO `nilai` VALUES ('858','15','18','459','ASAG','2025-05-27 10:40:33','2025-05-27 11:22:32','2025-05-27 11:23:07','4','6',NULL,'28','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"C\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:3:\"38 \";i:180;s:26:\"secara lisan dan manuskrip\";i:181;s:27:\"suatu yang lengkap dan utuh\";i:182;s:37:\"supaya bundaya tersebut tidak memudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:6:\"lisan \";i:187;s:32:\"benua australia dan benua afrika\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','4','3','0','0','6','2','0','5','4','6','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"D, C, B, A\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, B, C, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('859','15','18','435','ASAG','2025-05-27 10:40:34','2025-05-27 11:21:22','2025-05-27 11:22:59','3','7',NULL,'21','26',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:37:\"arti wawasan adalah pandagan nusantra\";i:179;s:12:\"jawasumatera\";i:180;s:37:\"tentang pemajuan kebudayaan indonesia\";i:181;s:62:\"bangsa yang tidak meyalahkan satu sama lain dan menjaga sesama\";i:182;s:83:\"karena budaya bangsa sangat penting bagi generasi yang akan datang dan harus dijaga\";i:183;s:4:\"aceh\";i:184;s:5:\" jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"nomor 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,181,184,187,179,185,182,183,180,186,178,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"A, B, C, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('860','15','18','423','ASAG','2025-05-27 10:40:35','2025-05-27 11:22:43','2025-05-27 11:23:02','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:23:\"1tradisi dan 2manuskrip\";i:181;s:30:\"bangsa yang tak terpecah belah\";i:182;s:36:\"agar tidak hilang dari lingkungannya\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:10:\"cut mutia \";i:186;s:19:\"uud 1945 33 pasal 2\";i:187;s:17:\"pasifik dan india\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','4','2','0','0','6','3','0','5','4','4','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, D, B, A\";i:175;s:10:\"C, D, A, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('861','15','18','421','ASAG','2025-05-27 10:40:36','2025-05-27 11:22:52','2025-05-27 11:23:01','5','5',NULL,'35','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"C\";i:164;s:1:\"C\";i:165;s:1:\"B\";}','a:10:{i:178;s:8:\"keutuhan\";i:179;s:2:\"38\";i:180;s:28:\"kearifan lokal dan monuskrip\";i:181;s:11:\"kelengkapan\";i:182;s:22:\"agar tidak tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"luar\";i:185;s:7:\"sejarah\";i:186;s:10:\"33 pasal 2\";i:187;s:17:\"pasifik dan india\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','2','5','0','2','8','0','0','3','2','10','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"A, C, B\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('862','15','18','443','ASAG','2025-05-27 10:40:36','2025-05-27 11:17:24','2025-05-27 11:22:52','5','5',NULL,'35','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:11:\"terwujudnya\";i:179;s:2:\"38\";i:180;s:26:\"menjaga kelestarian budaya\";i:181;s:15:\"cinta tanah air\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"tahun 2017 pasal 5\";i:187;s:12:\"asia pasifik\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','4','0','0','1','6','5','0','4','4','0','','2','a:5:{i:166;s:1:\"D\";i:168;s:7:\"A, B, C\";i:170;s:1:\"B\";i:171;s:4:\"A, B\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"A, C, B, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('863','15','18','424','ASAG','2025-05-27 10:40:42','2025-05-27 11:20:24','2025-05-27 11:20:39','6','4',NULL,'42','57',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:4:\"enam\";i:180;s:42:\"melestarikan budaya dan mempelajari budaya\";i:181;s:7:\"menjaga\";i:182;s:23:\"supaya tidak terlupakan\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:13:\"cerita rakyat\";i:186;s:40:\"undang-undang nomor 5 tahun 2017 pasal 5\";i:187;s:18:\"samudra dan hindia\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"C\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"C, D, B, A\";i:176;s:10:\"B, C, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('864','15','18','427','ASAG','2025-05-27 10:40:42','2025-05-27 11:24:14','2025-05-27 11:24:22','4','6',NULL,'28','37',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:49:\"terwujudnya persatuan bangsa dan kesatuan wilayah\";i:179;s:2:\"38\";i:180;s:22:\"persatuan dan kesatuan\";i:181;s:26:\"persatuan antar masyarakat\";i:182;s:46:\"agar terhindar dari kekacauan antar masyarakat\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:6:\"tarian\";i:186;s:8:\"kesatuan\";i:187;s:18:\"hindia dan pasifik\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,179,180,181,182,183,184,185,186,187,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, B, D\";i:171;s:7:\"A, B, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"B, C, D, A\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, D, B, A\";i:177;s:10:\"A, C, B, D\";}');
INSERT INTO `nilai` VALUES ('865','15','18','416','ASAG','2025-05-27 10:40:42','2025-05-27 11:23:27','2025-05-27 11:23:35','4','6',NULL,'28','32',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"C\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"kepulauan\";i:179;s:2:\"38\";i:180;s:29:\"objek bangsa dan objek negara\";i:181;s:21:\"bangsa yang tak punah\";i:182;s:30:\"karna untuk menjaga kebersihan\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:9:\"cut mutia\";i:186;s:19:\"uud 1945 33 pasal 2\";i:187;s:26:\"benua asia dan benua eropa\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, D\";i:170;s:4:\"B, C\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:7:\"A, C, B\";i:175;s:7:\"D, C, A\";i:176;s:10:\"D, C, A, B\";i:177;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('866','15','18','413','ASAG','2025-05-27 10:40:43','2025-05-27 11:24:18','2025-05-27 11:24:25','5','5',NULL,'35','43',NULL,'182.3.5.209','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:15:\"lisan manuskrip\";i:181;s:18:\"persatuan kesatuan\";i:182;s:18:\"budaya tidakhilang\";i:183;s:13:\"acehgayo aceh\";i:184;s:10:\"jawa barat\";i:185;s:7:\"nasihat\";i:186;s:15:\"lisan manuskrip\";i:187;s:14:\"asia australia\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','2','2','0','1','8','3','0','4','2','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"B, A, C\";i:175;s:7:\"A, B, C\";i:176;s:10:\"D, C, B, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('867','15','18','442','ASAG','2025-05-27 10:40:46','2025-05-27 11:13:03','2025-05-27 11:22:50','7','3',NULL,'49','61',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:3:\"38 \";i:180;s:59:\"1harus saling mendukung budaya2harus saling menjaga budaya \";i:181;s:26:\"bangsa yang tidak terpecah\";i:182;s:23:\"agar bangsa tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:19:\"australia dan eropa\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, D, A, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('868','15','18','448','ASAG','2025-05-27 10:41:14','2025-05-27 11:24:36','2025-05-27 11:25:04','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"kesatuan dan budaya\";i:181;s:6:\"budaya\";i:182;s:22:\"untuk memajukan bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:19:\"melestarikan budaya\";i:187;s:20:\"afrika dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','2','0','0','5','3','0','5','5','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"B, D, C, A\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('869','15','18','432','ASAG','2025-05-27 10:41:42','2025-05-27 11:22:26','2025-05-27 11:23:24','7','3',NULL,'49','55',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:47:\"melestarikan kebudayaan menjaga keutuhan bangsa\";i:181;s:15:\"saling mengerti\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:12:\"tulisan aceh\";i:186;s:13:\"pasal 05 2017\";i:187;s:14:\"asia australia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','4','1','0','0','6','4','0','5','4','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, C\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"B, D, C, A\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('870','15','18','433','ASAG','2025-05-27 10:42:05','2025-05-27 11:21:59','2025-05-27 11:22:49','2','8',NULL,'14','22',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"D\";i:154;s:1:\"D\";i:156;s:1:\"C\";i:159;s:1:\"D\";i:161;s:1:\"B\";i:162;s:1:\"D\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:12:\"cara pandang\";i:179;s:9:\"kegelapan\";i:180;s:47:\"melestarikan kebudayaan menjaga keutuhan bangsa\";i:181;s:15:\"saling mengerti\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:12:\"tulisan aceh\";i:186;s:13:\"pasal 05 2017\";i:187;s:14:\"asia australia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','2','1','0','2','8','4','0','3','2','2','','4','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"B, C, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"A, C, D, B\";i:175;s:10:\"A, D, B, C\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('871','15','18','451','ASAG','2025-05-27 10:42:27','2025-05-27 11:27:32','2025-05-27 11:27:46','5','5',NULL,'35','41',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:43:\"karena melestarikan budaya bangsa itu wajib\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:11:\"bakar mayat\";i:186;s:11:\"Tidak Diisi\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','4','1','0','0','6','4','0','5','4','2','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, C\";i:170;s:1:\"C\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:7:\"A, B, C\";i:174;s:4:\"B, A\";i:175;N;i:176;N;i:177;s:10:\"D, C, A, B\";}');
INSERT INTO `nilai` VALUES ('872','15','18','418','ASAG','2025-05-27 10:42:34','2025-05-27 11:22:32','2025-05-27 11:22:49','6','4',NULL,'42','44',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"C\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:10:\"4 provinsi\";i:180;s:56:\"ketuhanan yang maha esakemanusiaan yang adil dan beradap\";i:181;s:20:\"memperkuat toleransi\";i:182;s:28:\"agar tidak ada yang berdebat\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:10:\"cut mutia \";i:186;s:19:\"undang undang dasar\";i:187;s:25:\"benua pasifik dan samudra\";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:1:\"B\";i:168;s:1:\"A\";i:170;s:1:\"C\";i:171;s:1:\"B\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, C, B, D\";i:176;s:10:\"A, D, B, C\";i:177;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('873','15','18','464','ASAG','2025-05-27 10:44:10','2025-05-27 11:21:05','2025-05-27 11:22:38','6','4',NULL,'42','56',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:68:\"kesatuan dan persatuan bangsa indonesia dalam segala aspek kehidupan\";i:182;s:31:\"meningkatkan identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"uu no 5 pasal 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','8','3','0','0','2','2','0','5','8','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, D, A, B\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('874','15','18','461','ASAG','2025-05-27 10:44:10','2025-05-27 11:14:42','2025-05-27 11:19:58','4','6',NULL,'28','37',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:61:\"persatuan dan kesatuan bangsa indonesia dalam aspek kehidupan\";i:182;s:30:\"agar budaya bangsa tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"uu no 5 tahun 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','7','1','0','0','3','4','0','5','7','2','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:4:\"A, B\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"B, C, D, A\";i:174;s:10:\"C, B, A, D\";i:175;s:7:\"B, C, A\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('875','15','18','417','ASAG','2025-05-27 10:44:10','2025-05-27 11:21:49','2025-05-27 11:22:39','4','6',NULL,'28','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"83\";i:180;s:4:\"suku\";i:181;s:8:\"republik\";i:182;s:8:\"penting \";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:9:\"cut mutia\";i:186;s:24:\"uud 1945 pasal 33 ayat 2\";i:187;s:18:\"pasifik dan hindia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"A, B, C\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"C, A, B, D\";i:176;s:10:\"A, B, D, C\";i:177;s:10:\"C, A, D, B\";}');
INSERT INTO `nilai` VALUES ('876','15','18','452','ASAG','2025-05-27 10:44:12','2025-05-27 11:20:29','2025-05-27 11:21:29','7','3',NULL,'49','59',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"manuskrip dan tradisi lisan\";i:181;s:16:\"identitas bangsa\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:18:\"pelestarian budaya\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','6','2','0','0','4','3','0','5','6','4','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, B, C, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('877','15','18','428','ASAG','2025-05-27 10:44:12','2025-05-27 11:29:11','2025-05-27 11:29:31','5','5',NULL,'35','40',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"D\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"lisan dan manuskrip\";i:181;s:19:\"persatuan indonesia\";i:182;s:21:\"agar dapat berkembang\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:32:\"seni bercerita dalam bahasa aceh\";i:186;s:36:\"melestarikan budaya dari globalisasi\";i:187;s:17:\"asia dan autralia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','0','0','1','7','5','0','4','3','0','','2','a:5:{i:166;N;i:168;N;i:170;s:1:\"C\";i:171;N;i:172;N;}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, B, C, D\";i:176;s:10:\"A, C, D, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('878','15','18','436','ASAG','2025-05-27 10:44:12','2025-05-27 11:17:19','2025-05-27 11:22:35','8','2',NULL,'56','64',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:16:\"lisan dan budaya\";i:181;s:19:\"persatuan indonesia\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:13:\"cerita rakyat\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:14:\"eropa dan asia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,187,186,185,184,183,182,181,180,179,178,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','4','1','0','1','6','4','0','4','4','2','','2','a:5:{i:166;s:4:\"B, C\";i:168;s:7:\"A, B, D\";i:170;s:7:\"A, C, D\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('879','15','18','419','ASAG','2025-05-27 10:44:13','2025-05-27 11:29:10','2025-05-27 11:29:30','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:22:\"manuskrip dan keutuhan\";i:181;s:44:\"kesatuan dan kesatuan dalam aspek lingkungan\";i:182;s:37:\"agar terhindar dari globalisasi zaman\";i:183;s:14:\"aceh atau gayo\";i:184;s:4:\"bali\";i:185;s:31:\"cagok dan gaca(gerakan membaca)\";i:186;s:36:\"melestarikan budaya dari globalisasi\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','3','1','0','2','7','4','0','3','3','2','','4','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:10:\"A, B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('880','15','18','468','ASAG','2025-05-27 10:44:13','2025-05-27 11:20:21','2025-05-27 11:22:47','5','5',NULL,'35','43',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:18:\"tradisi dan budaya\";i:181;s:35:\"bangsa yang bersatu adil dan makmur\";i:182;s:29:\"agar tidak hilang dan memudar\";i:183;s:4:\"aceh\";i:184;s:5:\"jawa \";i:185;s:5:\"cagok\";i:186;s:37:\"undang undang no 5 tahun 2017 pasal 5\";i:187;s:14:\"asia dan eropa\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','4','0','0','2','6','5','0','3','4','0','','4','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('881','15','18','462','ASAG','2025-05-27 10:44:13','2025-05-27 11:20:34','2025-05-27 11:22:45','5','5',NULL,'35','39',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:22:\"wawasan adalah warisan\";i:179;s:7:\"sumatra\";i:180;s:18:\"tradisi dan budaya\";i:181;s:56:\"keutuhan bangsa adalah keutuhan yang di sukai masyarakat\";i:182;s:55:\"karena kita semua harus melestarikan budaya lokal kita \";i:183;s:13:\"provinsi aceh\";i:184;s:32:\"bali aceh dan provinsi lain lain\";i:185;s:21:\"pidato berbahasa aceh\";i:186;s:56:\"pemajuan adalah tentang kebudayaan yang ada di indonesia\";i:187;s:30:\"benua pasifik dan benua hindia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','0','0','0','2','10','5','0','3','0','0','','4','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"B\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"B, C, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"D, C, A, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('882','15','18','467','ASAG','2025-05-27 10:44:14','2025-05-27 11:21:56','2025-05-27 11:23:02','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:13:\"tradisi lisan\";i:181;s:19:\"kehidupan yang satu\";i:182;s:20:\"karna supaya menarik\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:20:\"nomor 5 2017 pasal 5\";i:187;s:18:\"asia dan australia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','6','1','0','0','4','4','0','5','6','2','','0','a:5:{i:166;s:4:\"A, C\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, B, C\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"B, A, C, D\";i:176;s:10:\"A, D, B, C\";i:177;s:10:\"C, B, A, D\";}');
INSERT INTO `nilai` VALUES ('883','15','18','444','ASAG','2025-05-27 10:44:14','2025-05-27 11:09:56','2025-05-27 11:11:43','7','3',NULL,'49','60',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"C\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:25:\"tradisiseni dan manuskrip\";i:181;s:63:\"paersatuan dan kesatuan bangsa indonesia konsep dalam kehidupan\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:16:\"identitas budaya\";i:187;s:18:\"asia dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','7','1','0','1','3','4','0','4','7','2','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:1:\"B\";i:170;s:1:\"B\";i:171;s:1:\"D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:7:\"B, C, A\";i:175;s:7:\"B, C, D\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"B, D, A, C\";}');
INSERT INTO `nilai` VALUES ('884','15','18','426','ASAG','2025-05-27 10:44:15','2025-05-27 11:28:42','2025-05-27 11:29:35','4','6',NULL,'28','30',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"A\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"geografis\";i:179;s:2:\"15\";i:180;s:25:\"ketuhanan dan kemanusiaan\";i:181;s:42:\"keutuhan bangsa adalah yang dimaksud mega \";i:182;s:15:\"keutuhan bangsa\";i:183;s:17:\"pasifik dan india\";i:184;s:9:\"indonesia\";i:185;s:9:\"cut mutia\";i:186;s:25:\"uud 1945 passal 33 ayat 2\";i:187;s:17:\"pasifik dan india\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','0','0','0','1','10','5','0','4','0','0','','2','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"B, C, D\";i:170;s:4:\"A, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"A, B, D, C\";i:176;s:10:\"B, A, C, D\";i:177;s:7:\"A, B, D\";}');
INSERT INTO `nilai` VALUES ('885','15','18','446','ASAG','2025-05-27 10:44:15','2025-05-27 11:22:25','2025-05-27 11:22:33','5','5',NULL,'35','40',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"B\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"A\";}','a:10:{i:178;s:5:\"pulau\";i:179;s:10:\"kalimantan\";i:180;s:58:\"1ketuhanan yang maha esa 2kemanusian yang adil dan beradap\";i:181;s:35:\"membuat bangsa indonesia tetap utuh\";i:182;s:30:\"untuk menjaga negara indonesia\";i:183;s:4:\"jawa\";i:184;s:4:\"jawa\";i:185;s:11:\"cerita lama\";i:186;s:2:\"10\";i:187;s:21:\"samudra dan australia\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','1','1','0','1','9','4','0','4','1','2','','2','a:5:{i:166;s:4:\"C, D\";i:168;s:4:\"B, C\";i:170;s:7:\"B, C, D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"B, D, C, A\";i:174;s:10:\"A, B, D, C\";i:175;s:10:\"C, A, D, B\";i:176;s:10:\"D, C, A, B\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('886','15','18','429','ASAG','2025-05-27 10:44:15','2025-05-27 11:19:13','2025-05-27 11:20:10','4','6',NULL,'28','40',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"B\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"D\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:44:\"suatu bangsa yang menjaga keutuhan bangsanya\";i:182;s:53:\"agar tetap terjaga budaya bangsanya dari bangsa asing\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:11:\"bahasa aceh\";i:186;s:8:\"pasal 5 \";i:187;s:18:\"australia dan asia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,181,184,187,179,185,182,183,180,186,178,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','4','3','0','1','6','2','0','4','4','6','','2','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"A, D, C, B\";i:177;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('887','15','18','454','ASAG','2025-05-27 10:44:16','2025-05-27 11:21:44','2025-05-27 11:21:56','4','6',NULL,'28','38',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:4:\"nkri\";i:181;s:19:\"persatuan indonesia\";i:182;s:21:\"kelebihan negara kita\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"syair\";i:186;s:7:\"5 dan 6\";i:187;s:15:\"asia dan hindia\";}',NULL,'0','156,159,161,152,154,162,164,165,148,151,178,179,180,181,182,183,184,185,186,187,168,170,171,166,172,173,176,174,175,177,',NULL,NULL,'0','4','2','0','1','6','3','0','4','4','4','','2','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:4:\"B, C\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, D, A\";i:176;s:10:\"D, B, A, C\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('888','15','18','445','ASAG','2025-05-27 10:44:16','2025-05-27 11:22:59','2025-05-27 11:23:06','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"lisan dan manuskrip\";i:181;s:19:\"persatuan indonesia\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:13:\"cerita rakyat\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:15:\"asia dan hindia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','4','2','0','0','6','3','0','5','4','4','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:4:\"A, B\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"B, A, C\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('889','15','18','447','ASAG','2025-05-27 10:44:17','2025-05-27 11:23:49','2025-05-27 11:25:15','6','4',NULL,'42','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:4:\"lupa\";i:181;s:22:\"utuh dengan kebudayaan\";i:182;s:16:\"agar tidak punah\";i:183;s:4:\"aceh\";i:184;s:11:\"jawa tengah\";i:185;s:25:\"menulis dengan huruf aceh\";i:186;s:19:\"melastarikan budaya\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,154,151,164,148,165,162,156,152,161,178,179,180,181,182,183,184,185,186,187,171,172,168,170,166,176,174,175,177,173,',NULL,NULL,'0','4','2','0','1','6','3','0','4','4','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:7:\"A, B, C\";i:172;s:4:\"A, B\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"B, D, C, A\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, A, B, D\";}');
INSERT INTO `nilai` VALUES ('890','15','18','456','ASAG','2025-05-27 10:44:17','2025-05-27 11:23:50','2025-05-27 11:23:58','4','6',NULL,'28','42',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:29:\"tradisi lisan dan manuskripsi\";i:181;s:19:\"persatuan indonesia\";i:182;s:22:\"agar budaya tetap maju\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:7:\"hikayat\";i:186;s:26:\"nomor 5 tahun 2017 pasal 5\";i:187;s:20:\"austria dan astralia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','4','2','0','3','6','3','0','2','4','4','','6','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, B\";i:172;s:4:\"A, B\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, D, C\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('891','15','18','453','ASAG','2025-05-27 10:44:17','2025-05-27 11:23:36','2025-05-27 11:24:10','4','6',NULL,'28','35',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"C\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:19:\"pemajuan kebangsaan\";i:181;s:19:\"persatuan indonesia\";i:182;s:15:\"kemajuan bangsa\";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:11:\"pantun aceh\";i:186;s:7:\"5 dan 6\";i:187;s:15:\"asia dan hindia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','1','0','1','7','4','0','4','3','2','','2','a:5:{i:166;s:7:\"A, C, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:7:\"B, A, C\";i:175;s:7:\"B, C, D\";i:176;s:10:\"C, B, D, A\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('892','15','18','455','ASAG','2025-05-27 10:44:17','2025-05-27 11:24:14','2025-05-27 11:26:21','6','4',NULL,'42','53',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"A\";i:159;s:1:\"D\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"38 provinsi\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:19:\"persatuan indonesia\";i:182;s:27:\"agar bisa dijadikan tradisi\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:26:\"tradisi lisandan manuskrip\";i:187;s:29:\"benua asia dan benua astralia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,186,180,183,182,185,179,187,184,181,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','5','3','0','0','5','2','0','5','5','6','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, B\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, C, B, D\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('893','15','18','465','ASAG','2025-05-27 10:44:18','2025-05-27 11:27:29','2025-05-27 11:28:34','7','3',NULL,'49','52',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"B\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"B\";i:165;s:1:\"B\";}','a:10:{i:178;s:10:\"pandangan \";i:179;s:2:\"38\";i:180;s:24:\"tradisi lisan manuskrip \";i:181;s:19:\"kehidupan yang satu\";i:182;s:26:\"untuk mengawet kan budaya \";i:183;s:5:\"aceh \";i:184;s:5:\"jawa \";i:185;s:6:\"cagok \";i:186;s:20:\"nomor 5 2017 pasal 5\";i:187;s:24:\"benua asia benua osralia\";}',NULL,'0','161,152,156,162,165,148,164,151,154,159,178,179,180,181,182,183,184,185,186,187,166,170,168,172,171,173,177,175,174,176,',NULL,NULL,'0','1','1','0','0','9','4','0','5','1','2','','0','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, D\";i:170;s:4:\"A, D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"D, B, A, C\";i:176;s:10:\"C, A, D, B\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('894','15','18','463','ASAG','2025-05-27 10:44:18','2025-05-27 11:22:41','2025-05-27 11:22:56','4','6',NULL,'28','37',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"B\";i:159;s:1:\"C\";i:161;s:1:\"C\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:23:\"tradisi lisan manuskrip\";i:181;s:28:\"kehidupan yang satu kesatuan\";i:182;s:49:\"untuk mengawetkan atau untuk menetapkan budayanya\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:20:\"nomor 5 2017 pasal 5\";i:187;s:25:\"benua asiabenua australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','5','1','0','1','5','4','0','4','5','2','','2','a:5:{i:166;s:4:\"A, B\";i:168;s:4:\"A, D\";i:170;s:4:\"A, D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:7:\"C, B, A\";i:175;s:10:\"C, A, D, B\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('895','15','18','437','ASAG','2025-05-27 10:44:20','2025-05-27 11:15:17','2025-05-27 11:16:09','4','6',NULL,'28','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:18:\"lisa dan denokatif\";i:181;s:20:\"persatuan indonesia \";i:182;s:27:\"karna untuk keutuhan bangsa\";i:183;s:19:\"jawa dan yogyakarta\";i:184;s:4:\"jawa\";i:185;s:9:\"bahasanya\";i:186;s:8:\"kesatuan\";i:187;s:15:\"asia dan hindia\";}',NULL,'0','159,165,164,161,156,152,148,151,162,154,178,179,180,181,182,183,184,185,186,187,166,171,172,168,170,174,175,173,176,177,',NULL,NULL,'0','3','1','0','0','7','4','0','5','3','2','','0','a:5:{i:166;s:7:\"A, C, D\";i:168;s:7:\"B, C, D\";i:170;s:7:\"A, B, C\";i:171;s:7:\"A, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, B, D\";i:174;s:10:\"C, A, B, D\";i:175;s:10:\"A, C, D, B\";i:176;s:10:\"A, D, B, C\";i:177;s:10:\"A, D, C, B\";}');
INSERT INTO `nilai` VALUES ('896','15','18','457','ASAG','2025-05-27 10:44:23','2025-05-27 11:26:56','2025-05-27 11:27:04','6','4',NULL,'42','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"A\";i:161;s:1:\"D\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"14\";i:180;s:9:\"persatuan\";i:181;s:43:\"bangsa yang tidak terpisah saling mencukupi\";i:182;s:70:\"karena bisa mempertahankan budaya kita dan tidak menghilang budaya nya\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:7:\"hikayat\";i:186;s:62:\"mengembangkan nilai nilai bangsa mempertenguh jati diri bangsa\";i:187;s:18:\"hindia dan pasifik\";}',NULL,'0','154,161,165,156,148,152,164,162,159,151,178,179,180,181,182,183,184,185,186,187,166,168,172,171,170,177,175,176,173,174,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, B, C, D\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"B, A, C, D\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('897','15','18','412','ASAG','2025-05-27 10:44:24','2025-05-27 11:29:06','2025-05-27 11:29:43','4','6',NULL,'28','37',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"C\";i:161;s:1:\"B\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:11:\"Tidak Diisi\";i:181;s:11:\"Tidak Diisi\";i:182;s:30:\"supaya budaya nya tidak hilang\";i:183;s:4:\"aceh\";i:184;s:20:\"acehjawabali dan dll\";i:185;s:5:\"puisi\";i:186;s:11:\"Tidak Diisi\";i:187;s:31:\"benua ausralia dan benua hindia\";}',NULL,'0','165,164,162,161,159,156,154,152,151,148,178,179,180,181,182,183,184,185,186,187,172,171,170,168,166,177,176,175,174,173,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:7:\"A, B, D\";i:170;s:0:\"\";i:171;s:7:\"A, B, C\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"A, D, B, C\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('898','15','18','420','ASAG','2025-05-27 10:44:24','2025-05-27 11:29:25','2025-05-27 11:29:46','5','5',NULL,'35','39',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"C\";i:162;s:1:\"C\";i:164;s:1:\"B\";i:165;s:1:\"C\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:11:\"Tidak Diisi\";i:180;s:22:\"menuskrip dan keutuhan\";i:181;s:21:\"kesatuan dan kesatuan\";i:182;s:32:\"agar tehindari globalisasi zaman\";i:183;s:13:\"aceh dan gayo\";i:184;s:11:\"Tidak Diisi\";i:185;s:11:\"Tidak Diisi\";i:186;s:31:\"melestarikan budaya globalisasi\";i:187;s:18:\"asia dan australia\";}',NULL,'0','159,162,148,156,161,165,152,164,151,154,178,179,180,181,182,183,184,185,186,187,170,166,171,168,172,177,176,174,175,173,',NULL,NULL,'0','2','1','0','0','8','4','0','5','2','2','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"A, C\";i:171;s:10:\"A, B, C, D\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;N;i:174;N;i:175;N;i:176;s:10:\"C, A, D, B\";i:177;s:0:\"\";}');
INSERT INTO `nilai` VALUES ('899','15','18','434','ASAG','2025-05-27 10:49:15','2025-05-27 11:26:13','2025-05-27 11:26:20','2','8',NULL,'14','18',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"C\";i:159;s:1:\"C\";i:161;s:1:\"B\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:9:\"nusantara\";i:179;s:1:\"6\";i:180;s:6:\"ga tau\";i:181;s:23:\"keutuhan bangsa adalah \";i:182;s:27:\"mengembangkan seni tradisi \";i:183;s:11:\"budaya aceh\";i:184;s:24:\"masyarakat jawa dan aceh\";i:185;s:28:\"berpidato dengan bahasa aceh\";i:186;s:0:\"\";i:187;s:6:\"ga isi\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,187,186,185,184,183,182,181,180,179,178,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','0','1','0','1','10','4','0','4','0','2','','2','a:5:{i:166;s:1:\"A\";i:168;s:1:\"A\";i:170;s:4:\"A, C\";i:171;s:7:\"A, C, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"D, B, C, A\";i:174;s:10:\"B, A, C, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"C, A, D, B\";i:177;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('900','16','16','438','ASAG','2025-05-27 11:17:33','2025-05-27 11:48:07','2025-05-27 11:48:16','9','1',NULL,'63','69',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:12:\"iringanmusik\";i:518;s:7:\"jasmani\";i:519;s:9:\"pemanasan\";i:520;s:22:\"menjauhidanmengigatkan\";i:521;s:17:\"penurunanprestasi\";i:522;s:8:\"beladiri\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:8:\"zebrakos\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','2','0','0','2','8','5','0','3','2','0','','4','a:5:{i:39;s:1:\"D\";i:41;s:1:\"D\";i:42;s:1:\"A\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"A, B, C, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('901','16','16','461','ASAG','2025-05-27 11:22:50','2025-05-27 11:42:40','2025-05-27 11:54:55','9','1',NULL,'63','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"suhutubuh\";i:519;s:9:\"pemanasan\";i:520;s:4:\"seks\";i:521;s:6:\"mental\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('902','16','16','446','ASAG','2025-05-27 11:22:57','2025-05-27 11:46:21','2025-05-27 11:55:03','6','4',NULL,'42','54',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"B\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"music\";i:518;s:14:\"dayatahantubuh\";i:519;s:9:\"pemanasan\";i:520;s:16:\"hamildiluarnikah\";i:521;s:8:\"namabaik\";i:522;s:11:\"menahandiri\";i:523;s:28:\"lebihjahatdaripadasebelumnya\";i:524;s:5:\"helem\";i:525;s:15:\"lempulalulintas\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','2','0','3','8','3','0','2','2','4','','6','a:5:{i:39;s:4:\"A, D\";i:41;s:4:\"B, D\";i:42;s:10:\"A, B, C, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, C, D\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, D, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('903','16','16','417','ASAG','2025-05-27 11:22:57','2025-05-27 11:43:30','2025-05-27 11:54:55','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"kesadaran\";i:522;s:7:\"menjaga\";i:523;s:9:\"membantah\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('904','16','16','454','ASAG','2025-05-27 11:22:57','2025-05-27 11:53:55','2025-05-27 11:54:59','8','2',NULL,'56','66',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:22:\"akuanakindonesia hebat\";i:517;s:5:\"musik\";i:518;s:15:\"memperkuattubuh\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubunganintim\";i:521;s:7:\"prilaku\";i:522;s:13:\"dayatahandiri\";i:523;s:7:\"pemarah\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','2','3','0','1','8','2','0','4','2','6','','2','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"A, B, D, C\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('905','16','16','424','ASAG','2025-05-27 11:22:59','2025-05-27 11:55:01','2025-05-27 11:55:24','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"irama\";i:518;s:10:\"kelenturan\";i:519;s:9:\"pemanasan\";i:520;s:22:\"terkenapenyakitkelamin\";i:521;s:15:\"merusaknamabaik\";i:522;s:24:\"meningkatkanimandantakwa\";i:523;s:5:\"ganas\";i:524;s:5:\"helem\";i:525;s:34:\"zebracrossataujembatanpenyebrangan\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','2','4','0','4','8','1','0','1','2','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('906','16','16','469','ASAG','2025-05-27 11:22:59','2025-05-27 11:45:50','2025-05-27 11:54:55','9','1',NULL,'63','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:12:\"zina/pacaran\";i:521;s:5:\"sikap\";i:522;s:7:\"menjaga\";i:523;s:11:\"tidak sopan\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,525,524,523,522,521,520,519,518,517,516,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','4','2','0','3','6','3','0','2','4','4','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('907','16','16','452','ASAG','2025-05-27 11:23:00','2025-05-27 11:48:16','2025-05-27 11:55:11','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:5:\"bakat\";i:522;s:7:\"menjaga\";i:523;s:9:\"tidakbaik\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,525,524,523,522,521,520,519,518,517,516,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','4','4','0','2','6','1','0','3','4','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('908','16','16','430','ASAG','2025-05-27 11:23:00','2025-05-27 11:46:46','2025-05-27 11:55:18','10','0',NULL,'70','85',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:14:\"kesehatanfisik\";i:519;s:9:\"pemanasan\";i:520;s:24:\"meningkatkanimandantakwa\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:5:\"nakal\";i:524;s:4:\"helm\";i:525;s:16:\"jembatannyebrang\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,521,524,516,517,520,525,518,523,519,522,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','2','7','1','0','3','3','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, D, C, B\";i:53;s:10:\"D, A, B, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, D, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('909','16','16','436','ASAG','2025-05-27 11:23:00','2025-05-27 11:56:17','2025-05-27 11:55:19','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berhubunganintim\";i:521;s:5:\"nilai\";i:522;s:12:\"pengendalian\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:34:\"zebracrossdanjembatanpenyeberangan\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('910','16','16','418','ASAG','2025-05-27 11:23:02','2025-05-27 11:49:13','2025-05-27 11:54:56','10','0',NULL,'70','90',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:10:\"kebugaran \";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:9:\"pemahaman\";i:522;s:7:\"menjaga\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:29:\"zebracrosjembatanpenyebrangan\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','4','4','0','4','6','1','0','1','4','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, A, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('911','16','16','442','ASAG','2025-05-27 11:23:03','2025-05-27 11:53:13','2025-05-27 11:54:55','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:7:\"mental \";i:519;s:9:\"pemanasan\";i:520;s:5:\"seks \";i:521;s:8:\"namabaik\";i:522;s:8:\"menjaga \";i:523;s:6:\"kasar \";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('912','16','16','435','ASAG','2025-05-27 11:23:12','2025-05-27 11:41:34','2025-05-27 11:55:02','9','1',NULL,'63','79',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:12:\"selasa sabtu\";i:517;s:4:\"lagu\";i:518;s:5:\"nilai\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:31:\"zebracrosataujembatanpyebrangan\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, B, A\";i:53;s:10:\"A, B, D, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('913','16','16','464','ASAG','2025-05-27 11:23:19','2025-05-27 11:44:50','2025-05-27 11:54:58','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:32:\"tujuhkebiasaananakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:9:\"emosional\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('914','16','16','443','ASAG','2025-05-27 11:23:20','2025-05-27 11:48:37','2025-05-27 11:55:00','8','2',NULL,'56','69',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:11:\"selasasabtu\";i:517;s:4:\"lagu\";i:518;s:5:\"nilai\";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:8:\"akademik\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:35:\"zebracrossataujembatanpenyeberangan\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','1','2','0','4','9','3','0','1','1','4','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:4:\"A, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('915','16','16','439','ASAG','2025-05-27 11:23:27','2025-05-27 11:54:02','2025-05-27 11:55:21','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"berzina\";i:521;s:5:\"nilai\";i:522;s:8:\"menjaga \";i:523;s:7:\"agresif\";i:524;s:4:\"helm\";i:525;s:10:\"zebracroos\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','4','7','1','0','1','3','8','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('916','16','16','415','ASAG','2025-05-27 11:23:29','2025-05-27 11:55:14','2025-05-27 11:55:20','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:15:\"semangatbelajar\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidakpatuh\";i:524;s:4:\"helm\";i:525;s:7:\"trotoar\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('917','16','16','444','ASAG','2025-05-27 11:23:32','2025-05-27 11:49:25','2025-05-27 11:55:20','9','1',NULL,'63','81',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:16:\"anaindonesihebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:13:\"melakukanseks\";i:521;s:5:\"nilai\";i:522;s:12:\"pengendalian\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:7:\"trotoar\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('918','16','16','433','ASAG','2025-05-27 11:23:37','2025-05-27 11:53:43','2025-05-27 11:55:02','9','1',NULL,'63','84',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"music\";i:518;s:6:\"mental\";i:519;s:9:\"pemanasan\";i:520;s:22:\"mengakibatkansexsbebas\";i:521;s:8:\"namabaik\";i:522;s:7:\"menjaga\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','36,32,27,30,31,35,28,24,34,26,516,517,518,519,520,521,522,523,524,525,46,39,42,44,41,55,56,51,57,53,',NULL,NULL,'0','3','5','0','4','7','0','0','1','3','10','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('919','16','16','466','ASAG','2025-05-27 11:23:38','2025-05-27 11:45:35','2025-05-27 11:54:56','8','2',NULL,'56','74',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:16:\"kebugaranjasmani\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"sikap\";i:522;s:7:\"menjaga\";i:523;s:9:\"emosional\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','4','3','0','4','6','2','0','1','4','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('920','16','16','463','ASAG','2025-05-27 11:23:41','2025-05-27 11:49:58','2025-05-27 11:55:32','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:16:\"berdekat dekatan\";i:521;s:10:\"memalukan \";i:522;s:8:\"menjaga \";i:523;s:22:\"durhaka / membangkang \";i:524;s:4:\"helm\";i:525;s:13:\"pinggir jalan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','3','0','4','7','2','0','1','3','6','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:4:\"A, B\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('921','16','16','467','ASAG','2025-05-27 11:23:43','2025-05-27 11:48:42','2025-05-27 11:55:22','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:26:\"senam anak indonesia hebat\";i:517;s:4:\"lagu\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:20:\"menghindarberpacaran\";i:521;s:8:\"rengking\";i:522;s:7:\"menjaga\";i:523;s:9:\"memalukan\";i:524;s:4:\"helm\";i:525;s:14:\"di lampu merah\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','4','0','3','8','1','0','2','2','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, D, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('922','16','16','422','ASAG','2025-05-27 11:23:49','2025-05-27 11:58:01','2025-05-27 11:58:05','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"ketahanan\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:15:\"semangatbelajar\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracrost\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,516,517,518,519,520,521,522,523,524,525,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('923','16','16','421','ASAG','2025-05-27 11:23:51','2025-05-27 11:51:38','2025-05-27 11:54:59','8','2',NULL,'56','70',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:24:\"aku anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"ketahanan\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:15:\"merusaknamabaik\";i:522;s:4:\"bela\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','2','4','0','2','8','1','0','3','2','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, C, A, D\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, D, A\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('924','16','16','425','ASAG','2025-05-27 11:23:53','2025-05-27 11:54:52','2025-05-27 11:55:17','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"semangat\";i:522;s:7:\"menjaga\";i:523;s:7:\"durhaka\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('925','16','16','423','ASAG','2025-05-27 11:23:53','2025-05-27 11:45:01','2025-05-27 11:55:19','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:14:\"ketahanantubuh\";i:519;s:9:\"pemanasan\";i:520;s:9:\"seksbebas\";i:521;s:9:\"semangat \";i:522;s:8:\"menjaga \";i:523;s:10:\"tidaksopan\";i:524;s:11:\"memakaihelm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','4','0','3','7','1','0','2','3','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:7:\"C, B, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('926','16','16','416','ASAG','2025-05-27 11:24:00','2025-05-27 11:42:40','2025-05-27 11:55:19','9','1',NULL,'63','76',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:10:\"kesehatan \";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:9:\"kesadaran\";i:522;s:7:\"menjaga\";i:523;s:9:\"tidakbaik\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','3','3','0','2','7','2','0','3','3','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, B, A, D\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('927','16','16','445','ASAG','2025-05-27 11:24:10','2025-05-27 11:49:48','2025-05-27 11:55:20','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:4:\"bela\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:4:\"C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('928','16','16','460','ASAG','2025-05-27 11:24:13','2025-05-27 11:48:02','2025-05-27 11:55:22','9','1',NULL,'63','71',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:37:\"lagusenamankindonesiadanindonesiaraya\";i:517;s:5:\"musik\";i:518;s:4:\"otot\";i:519;s:9:\"pemanasan\";i:520;s:17:\"sepertiberpacaran\";i:521;s:6:\"mental\";i:522;s:5:\"fisik\";i:523;s:7:\"berubah\";i:524;s:4:\"helm\";i:525;s:10:\"lampumerah\";}',NULL,'0','26,35,28,32,30,27,36,34,24,31,522,519,523,518,525,520,517,516,524,521,41,46,39,44,42,53,56,57,51,55,',NULL,NULL,'0','2','0','0','3','8','5','0','2','2','0','','6','a:5:{i:39;s:4:\"B, D\";i:41;s:4:\"B, D\";i:42;s:4:\"A, B\";i:44;s:1:\"A\";i:46;s:4:\"B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, A, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('929','16','16','450','ASAG','2025-05-27 11:24:17','2025-05-27 11:52:15','2025-05-27 11:55:18','7','3',NULL,'49','59',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"A\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:6:\"mental\";i:519;s:9:\"pemanasan\";i:520;s:8:\"cwokcwek\";i:521;s:8:\"namabaik\";i:522;s:11:\"kepercayaan\";i:523;s:5:\"kasar\";i:524;s:4:\"helm\";i:525;s:15:\"lampulalulintas\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','4','3','0','0','6','2','0','5','4','6','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"B, C, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, C, D\";i:53;s:10:\"B, A, C, D\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('930','16','16','437','ASAG','2025-05-27 11:24:20','2025-05-27 11:49:11','2025-05-27 11:55:25','9','1',NULL,'63','75',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"music\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:6:\"mental\";i:522;s:9:\"pendirian\";i:523;s:12:\"tidaktaudiri\";i:524;s:5:\"helem\";i:525;s:9:\"zebrakros\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, C\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"A, B, D, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, C, D, A\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('931','16','16','429','ASAG','2025-05-27 11:24:29','2025-05-27 11:51:55','2025-05-27 11:55:18','9','1',NULL,'63','77',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:15:\"semangatbelajar\";i:522;s:9:\"pendirian\";i:523;s:12:\"tempramental\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','4','3','0','2','6','2','0','3','4','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, A, C, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"B, A, D, C\";}');
INSERT INTO `nilai` VALUES ('932','16','16','413','ASAG','2025-05-27 11:24:34','2025-05-27 11:53:02','2025-05-27 11:55:19','10','0',NULL,'70','80',NULL,'182.3.5.209','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:14:\"musikiramalagu\";i:518;s:16:\"kebugaranjasmani\";i:519;s:10:\"pemanasan \";i:520;s:16:\"hamildiluarnikah\";i:521;s:18:\"pikirantidaklancar\";i:522;s:22:\"menajagapikirandaniman\";i:523;s:23:\"pemarahmembantahomongan\";i:524;s:5:\"helem\";i:525;s:20:\"zebracrosdanjembatan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','4','0','1','10','1','0','4','0','8','','2','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:4:\"C, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"B, A, C, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, A, B, C\";}');
INSERT INTO `nilai` VALUES ('933','16','16','453','ASAG','2025-05-27 11:24:34','2025-05-27 11:51:48','2025-05-27 11:55:26','10','0',NULL,'70','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:9:\"pemanasan\";i:518;s:13:\"kekuatantubuh\";i:519;s:9:\"pemanasan\";i:520;s:16:\"hamildiluarnikah\";i:521;s:4:\"niai\";i:522;s:9:\"mengenali\";i:523;s:9:\"emosional\";i:524;s:4:\"helm\";i:525;s:17:\"zebracrossjikaada\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','2','2','0','2','8','3','0','3','2','4','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('934','16','16','459','ASAG','2025-05-27 11:24:35','2025-05-27 11:55:17','2025-05-27 11:55:23','10','0',NULL,'70','87',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:12:\"sexbebaszina\";i:521;s:18:\"dansemangatbelajar\";i:522;s:24:\"meningkatkanimandantakwa\";i:523;s:7:\"emosian\";i:524;s:4:\"helm\";i:525;s:11:\"zebra cross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','5','4','0','2','5','1','0','3','5','8','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"D, A, C, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, D, B, A\";i:56;s:10:\"C, A, D, B\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('935','16','16','427','ASAG','2025-05-27 11:24:46','2025-05-27 11:54:55','2025-05-27 11:55:22','10','0',NULL,'70','88',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"semangat\";i:522;s:8:\"beladiri\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:9:\"zebracros\";}',NULL,'0','30,34,24,26,28,32,31,27,36,35,516,517,518,519,520,521,522,523,524,525,39,44,46,41,42,53,56,57,51,55,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"A, C\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('936','16','16','468','ASAG','2025-05-27 11:24:54','2025-05-27 11:50:14','2025-05-27 11:55:18','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:4:\"lagu\";i:518;s:16:\"kebugaranjasmani\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:5:\"emosi\";i:524;s:4:\"helm\";i:525;s:34:\"zebracrossdanjembatanpenyeberangan\";}',NULL,'0','30,27,36,26,28,24,31,34,35,32,516,517,518,519,520,521,522,523,524,525,39,46,44,42,41,55,51,56,53,57,',NULL,NULL,'0','3','3','0','2','7','2','0','3','3','6','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, D, A\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('937','16','16','462','ASAG','2025-05-27 11:24:54','2025-05-27 11:51:06','2025-05-27 11:55:21','10','0',NULL,'70','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:5:\"organ\";i:519;s:24:\"pemanasanintipendinginan\";i:520;s:7:\"pacaran\";i:521;s:24:\"lingkunganbebasdisekolah\";i:522;s:12:\"kuatdansopan\";i:523;s:10:\"tidaksopan\";i:524;s:5:\"helem\";i:525;s:24:\"tidakmeneroboslampumerah\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,522,519,523,518,525,520,517,516,524,521,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','2','8','2','0','3','2','6','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, B, D, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('938','16','16','456','ASAG','2025-05-27 11:25:03','2025-05-27 11:49:55','2025-05-27 11:54:58','10','0',NULL,'70','89',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"perilaku\";i:522;s:7:\"menjaga\";i:523;s:7:\"durhaka\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','5','4','0','3','5','1','0','2','5','8','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('939','16','16','440','ASAG','2025-05-27 11:25:31','2025-05-27 11:55:11','2025-05-27 11:55:18','10','0',NULL,'70','86',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:19:\"terjadinyaseksbebas\";i:521;s:5:\"nilai\";i:522;s:7:\"menjaga\";i:523;s:5:\"buruk\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','35,36,27,31,32,28,26,24,34,30,516,517,518,519,520,521,522,523,524,525,42,41,46,44,39,55,51,57,56,53,',NULL,NULL,'0','4','3','0','3','6','2','0','2','4','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('940','16','16','447','ASAG','2025-05-27 11:25:37','2025-05-27 11:53:57','2025-05-27 11:55:23','9','1',NULL,'63','80',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:4:\"imun\";i:519;s:9:\"pemanasan\";i:520;s:7:\"berzina\";i:521;s:5:\"nilai\";i:522;s:6:\"mejaga\";i:523;s:10:\"mudahmarah\";i:524;s:5:\"helem\";i:525;s:9:\"zebrakros\";}',NULL,'0','32,35,34,31,24,28,26,36,27,30,516,517,518,519,520,521,522,523,524,525,41,42,44,46,39,57,53,56,51,55,',NULL,NULL,'0','3','3','0','4','7','2','0','1','3','6','','8','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"A, B, C, D\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('941','16','16','448','ASAG','2025-05-27 11:25:45','2025-05-27 11:51:28','2025-05-27 11:55:17','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"ngentod\";i:521;s:8:\"perilaku\";i:522;s:11:\"menjagadiri\";i:523;s:7:\"durhaka\";i:524;s:4:\"helm\";i:525;s:10:\"zebrakross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','3','0','4','5','2','0','1','5','6','','8','a:5:{i:39;s:4:\"C, D\";i:41;s:4:\"A, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, C, B, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('942','16','16','431','ASAG','2025-05-27 11:25:46','2025-05-27 11:57:09','2025-05-27 11:57:29','7','3',NULL,'49','55',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"C\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"C\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:4:\"lagu\";i:518;s:4:\"otot\";i:519;s:9:\"pemanasan\";i:520;s:7:\"seksual\";i:521;s:12:\"minatbelajar\";i:522;s:5:\"fisik\";i:523;s:4:\"gila\";i:524;s:5:\"helem\";i:525;s:10:\"lampumerah\";}',NULL,'0','31,24,34,36,27,30,32,28,35,26,516,517,518,519,520,521,522,523,524,525,42,44,39,46,41,55,51,57,56,53,',NULL,NULL,'0','2','2','0','0','8','3','0','5','2','4','','0','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:10:\"A, B, C, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, C\";}','a:0:{}','a:5:{i:51;s:10:\"A, D, B, C\";i:53;s:10:\"C, D, B, A\";i:55;s:10:\"B, A, D, C\";i:56;s:10:\"A, B, D, C\";i:57;s:7:\"B, C, A\";}');
INSERT INTO `nilai` VALUES ('943','16','16','441','ASAG','2025-05-27 11:25:56','2025-05-27 11:55:46','2025-05-27 11:56:32','8','2',NULL,'56','70',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:14:\"nilaiseksbebas\";i:521;s:12:\"tidakbelajar\";i:522;s:7:\"menjaga\";i:523;s:10:\"sangatbaik\";i:524;s:4:\"helm\";i:525;s:10:\"lampumerah\";}',NULL,'0','36,35,34,32,31,30,28,27,26,24,516,517,518,519,520,521,522,523,524,525,46,44,42,41,39,57,56,55,53,51,',NULL,NULL,'0','4','3','0','2','6','2','0','3','4','6','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"B, C, D\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:7:\"C, B, D\";i:56;s:7:\"C, B, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('944','16','16','414','ASAG','2025-05-27 11:26:13','2025-05-27 11:55:00','2025-05-27 11:55:36','8','2',NULL,'56','66',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"D\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:23:\"senamanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:36:\"meningkatkanotottubuhmenurunkanlemak\";i:519;s:9:\"pemanasan\";i:520;s:8:\"sekbebas\";i:521;s:12:\"malasbelajar\";i:522;s:14:\"mempertahankan\";i:523;s:36:\"melawanorangtuabikinkecanduannarkoba\";i:524;s:5:\"helem\";i:525;s:15:\"lampulalulintas\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,521,524,516,517,520,525,518,523,519,522,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','2','4','0','0','8','1','0','5','2','8','','0','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"B, C, D, A\";i:55;s:10:\"B, A, D, C\";i:56;s:10:\"A, C, B, D\";i:57;s:7:\"D, B, C\";}');
INSERT INTO `nilai` VALUES ('945','16','16','449','ASAG','2025-05-27 11:26:17','2025-05-27 11:59:05','2025-05-27 11:59:11','6','4',NULL,'42','50',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"B\";i:32;s:1:\"A\";i:34;s:1:\"D\";i:35;s:1:\"C\";i:36;s:1:\"A\";}','a:10:{i:516;s:18:\"senamidoneaiaheban\";i:517;s:5:\"musin\";i:518;s:14:\"dayatahantubuh\";i:519;s:10:\"pemanassan\";i:520;s:1:\"p\";i:521;s:1:\"p\";i:522;s:7:\"menjaga\";i:523;s:1:\"p\";i:524;s:5:\"helem\";i:525;s:1:\"p\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','0','2','0','2','10','3','0','3','0','4','','4','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"B, C, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"B, D, C, A\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"C, A, B, D\";i:57;s:7:\"D, A, B\";}');
INSERT INTO `nilai` VALUES ('946','16','16','458','ASAG','2025-05-27 11:26:32','2025-05-27 12:00:18','2025-05-27 12:00:26','3','7',NULL,'21','21',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"A\";i:30;s:1:\"B\";i:31;s:1:\"D\";i:32;s:1:\"A\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"C\";}','a:10:{i:516;s:21:\"anak indonesia hebat \";i:517;s:27:\"kita harus kuwat dan ceria \";i:518;s:16:\"badan dan tubuh \";i:519;s:6:\"sakit \";i:520;s:6:\"badan \";i:521;s:20:\"tidak boleh merokok \";i:522;s:15:\"mencegah badan \";i:523;s:21:\"tanda pengaruh bebas \";i:524;s:6:\"helem \";i:525;s:17:\"tidak kecelakaan \";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','0','0','0','0','10','5','0','5','0','0','','0','a:5:{i:39;s:1:\"C\";i:41;s:1:\"D\";i:42;s:1:\"D\";i:44;s:1:\"A\";i:46;s:1:\"D\";}','a:0:{}','a:5:{i:51;s:10:\"C, B, A, D\";i:53;s:10:\"B, A, D, C\";i:55;s:10:\"C, A, D, B\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('947','16','16','434','ASAG','2025-05-27 11:26:39','2025-05-27 11:55:26','2025-05-27 11:55:30','7','3',NULL,'49','58',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"B\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:16:\"musik saat mulai\";i:518;s:12:\"meningkatkan\";i:519;s:25:\"pemanasan terlebih dahulu\";i:520;s:10:\"berpacaran\";i:521;s:58:\"akan terjadinya malas belajar dan saat belajar tidak fokus\";i:522;s:36:\"hindari ajakan temen yang tidak baik\";i:523;s:30:\"sering melawan orang tua/ guru\";i:524;s:4:\"helm\";i:525;s:47:\"menyebrang di zebra cross jembatan penyebrangan\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,516,517,518,519,520,521,522,523,524,525,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','1','2','0','2','9','3','0','3','1','4','','4','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:4:\"A, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:10:\"A, B, C, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, A, C, D\";i:53;s:10:\"A, D, B, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('948','16','16','455','ASAG','2025-05-27 11:26:46','2025-05-27 11:51:57','2025-05-27 11:55:19','9','1',NULL,'63','78',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:23:\"senamanakindonesiahebat\";i:517;s:5:\"music\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:17:\"janganbersentuhan\";i:521;s:9:\"masadepan\";i:522;s:7:\"menjaga\";i:523;s:10:\"tidaksopan\";i:524;s:4:\"helm\";i:525;s:16:\"melihatkirikanan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,521,524,516,517,520,525,518,523,519,522,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','1','3','0','4','9','2','0','1','1','6','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:4:\"B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:4:\"B, C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('949','16','16','457','ASAG','2025-05-27 11:27:19','2025-05-27 11:54:46','2025-05-27 11:55:30','10','0',NULL,'70','91',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:10:\"berpacaran\";i:521;s:8:\"perilaku\";i:522;s:7:\"menjaga\";i:523;s:7:\"durhaka\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','5','4','0','4','5','1','0','1','5','8','','8','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('950','16','16','432','ASAG','2025-05-27 11:27:27','2025-05-27 11:53:57','2025-05-27 11:54:58','10','0',NULL,'70','83',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:34:\"akuanakindonesiahebatindonesiaraya\";i:517;s:4:\"lagu\";i:518;s:9:\"kesehatan\";i:519;s:9:\"pemanasan\";i:520;s:10:\"sekssesual\";i:521;s:12:\"minatbelajar\";i:522;s:10:\"pertahanan\";i:523;s:7:\"melawan\";i:524;s:4:\"helm\";i:525;s:9:\"zebrakros\";}',NULL,'0','35,31,36,24,26,28,30,32,34,27,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,56,57,53,51,55,',NULL,NULL,'0','1','3','0','3','9','2','0','2','1','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:7:\"A, B, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"D, B, C, A\";i:53;s:10:\"C, A, B, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, A, C\";}');
INSERT INTO `nilai` VALUES ('951','16','16','451','ASAG','2025-05-27 11:28:49','2025-05-27 11:56:47','2025-05-27 11:57:46','9','1',NULL,'63','74',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:8:\"namabaik\";i:522;s:4:\"bela\";i:523;s:9:\"membantah\";i:524;s:4:\"helm\";i:525;s:11:\"zembracross\";}',NULL,'0','27,34,32,30,28,26,24,36,31,35,516,517,518,519,520,521,522,523,524,525,39,44,46,42,41,55,51,53,57,56,',NULL,NULL,'0','5','3','0','0','5','2','0','5','5','6','','0','a:5:{i:39;s:7:\"A, B, C\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"C, A, B, D\";i:53;s:10:\"C, D, A, B\";i:55;s:10:\"D, B, C, A\";i:56;s:10:\"A, C, D, B\";i:57;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('952','16','16','465','ASAG','2025-05-27 11:29:18','2025-05-27 11:53:30','2025-05-27 11:54:59','9','1',NULL,'63','74',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"B\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:26:\"senam ank indonesia hebat \";i:517;s:5:\"musik\";i:518;s:10:\"kemalasan \";i:519;s:11:\"pendinginan\";i:520;s:26:\"menghindandari tempat sepi\";i:521;s:10:\"memalukan \";i:522;s:8:\"berpikir\";i:523;s:5:\"jahat\";i:524;s:4:\"helm\";i:525;s:10:\"zebracross\";}',NULL,'0','26,36,24,28,30,35,27,32,31,34,525,524,523,522,521,520,519,518,517,516,39,44,41,42,46,51,57,53,55,56,',NULL,NULL,'0','1','2','0','3','9','3','0','2','1','4','','6','a:5:{i:39;s:4:\"A, D\";i:41;s:4:\"C, D\";i:42;s:4:\"A, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"A, D, C, B\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, B, A, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('953','16','16','412','ASAG','2025-05-27 11:30:23','2025-05-27 11:54:55','2025-05-27 11:55:36','9','1',NULL,'63','72',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:20:\"anak indonesia hebat\";i:517;s:5:\"musik\";i:518;s:9:\"kebugaran\";i:519;s:10:\"peregangan\";i:520;s:7:\"pacaran\";i:521;s:15:\"penurunan nilai\";i:522;s:9:\"pendirian\";i:523;s:11:\"tidak sopan\";i:524;s:14:\"helm dan jaket\";i:525;s:23:\"rambu rambu lalu lintas\";}',NULL,'0','31,34,27,32,24,28,30,35,26,36,516,517,518,519,520,521,522,523,524,525,41,42,46,44,39,55,56,53,51,57,',NULL,NULL,'0','3','2','0','1','7','3','0','4','3','4','','2','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:1:\"A\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"D, B, A, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"A, B, C, D\";}');
INSERT INTO `nilai` VALUES ('954','16','16','426','ASAG','2025-05-27 11:30:27','2025-05-27 11:52:43','2025-05-27 11:54:56','8','2',NULL,'56','74',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"D\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"A\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"keyakinan\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:12:\"kesadarannya\";i:522;s:7:\"menjaga\";i:523;s:7:\"emosian\";i:524;s:4:\"helm\";i:525;s:11:\"zebrakcroos\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','4','4','0','3','6','1','0','2','4','8','','6','a:5:{i:39;s:7:\"A, B, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, A, C, D\";i:53;s:10:\"B, A, D, C\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"C, A, B, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('955','16','16','419','ASAG','2025-05-27 11:31:10','2025-05-27 11:54:26','2025-05-27 11:55:43','10','0',NULL,'70','84',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:9:\"kesehatan\";i:519;s:23:\"pemanasandanpendinginan\";i:520;s:16:\"berhubungantubuh\";i:521;s:9:\"kemalasan\";i:522;s:9:\"pendirian\";i:523;s:11:\"membangkang\";i:524;s:4:\"helm\";i:525;s:35:\"zebracrossataujembatanpenyeberangan\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('956','16','16','428','ASAG','2025-05-27 11:31:11','2025-05-27 11:54:21','2025-05-27 11:55:21','9','1',NULL,'63','82',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"C\";i:26;s:1:\"D\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"D\";i:36;s:1:\"D\";}','a:10:{i:516;s:18:\"anakindonesiahebat\";i:517;s:5:\"music\";i:518;s:9:\"kebugaran\";i:519;s:9:\"pemanasan\";i:520;s:7:\"pacaran\";i:521;s:14:\"penurunannilai\";i:522;s:9:\"pendirian\";i:523;s:9:\"membangka\";i:524;s:4:\"helm\";i:525;s:33:\"zebrakrosataujembatanpenyebrangan\";}',NULL,'0','26,34,24,28,35,31,30,27,32,36,516,517,518,519,520,521,522,523,524,525,41,44,42,39,46,53,57,51,56,55,',NULL,NULL,'0','3','5','0','3','7','0','0','2','3','10','','6','a:5:{i:39;s:7:\"A, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:7:\"A, B, D\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, C, A\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, D, C\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('957','16','16','420','ASAG','2025-05-27 11:31:18','2025-05-27 11:56:20','2025-05-27 11:56:44','8','2',NULL,'56','70',NULL,'180.242.31.254','0','a:10:{i:24;s:1:\"B\";i:26;s:1:\"A\";i:27;s:1:\"B\";i:28;s:1:\"C\";i:30;s:1:\"C\";i:31;s:1:\"A\";i:32;s:1:\"B\";i:34;s:1:\"A\";i:35;s:1:\"C\";i:36;s:1:\"D\";}','a:10:{i:516;s:21:\"akuanakindonesiahebat\";i:517;s:5:\"musik\";i:518;s:21:\"kesehatandankebugaran\";i:519;s:23:\"pemanasandanpendinginan\";i:520;s:16:\"berhubungantubuh\";i:521;s:15:\"semangatbelajar\";i:522;s:7:\"menjaga\";i:523;s:9:\"pemanasan\";i:524;s:4:\"helm\";i:525;s:9:\"zebrakros\";}',NULL,'0','24,26,27,28,30,31,32,34,35,36,516,517,518,519,520,521,522,523,524,525,39,41,42,44,46,51,53,55,56,57,',NULL,NULL,'0','2','3','0','3','8','2','0','2','2','6','','6','a:5:{i:39;s:10:\"A, B, C, D\";i:41;s:7:\"A, B, D\";i:42;s:7:\"A, B, D\";i:44;s:4:\"A, C\";i:46;s:1:\"C\";}','a:0:{}','a:5:{i:51;s:10:\"B, D, A, C\";i:53;s:10:\"C, B, A, D\";i:55;s:10:\"C, A, B, D\";i:56;s:10:\"B, A, C, D\";i:57;s:10:\"D, B, C, A\";}');
INSERT INTO `nilai` VALUES ('958','17','18','520','ASAG','2025-05-27 12:09:40','2025-05-27 12:49:15','2025-05-27 12:49:27','4','6',NULL,'28','29',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"D\";i:159;s:1:\"A\";i:161;s:1:\"B\";i:162;s:1:\"D\";i:164;s:1:\"C\";i:165;s:1:\"A\";}','a:10:{i:178;s:22:\"wawasan arti pandangan\";i:179;s:23:\"balijawajakartasulawesi\";i:180;s:34:\"objek objek tradisi dari indonesia\";i:181;s:73:\"keutuhan bangsa adalah bangsa yg salimg membutuh kan antar sesama bangsa \";i:182;s:51:\"karna supaya tidak punah dengan budaya budaya barat\";i:183;s:20:\"tarian kas adat aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"syair\";i:186;s:13:\" batik sarung\";i:187;s:30:\"benua bermuda dan benua malaka\";}',NULL,'0','154,151,164,152,165,161,156,148,162,159,178,179,180,181,182,183,184,185,186,187,172,168,171,166,170,173,175,174,176,177,',NULL,NULL,'0','1','0','0','0','9','5','0','5','1','0','','0','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:1:\"C\";i:171;s:1:\"B\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"A, C, D, B\";i:175;s:10:\"B, C, A, D\";i:176;s:10:\"A, C, D, B\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('959','17','18','498','ASAG','2025-05-27 12:15:12','2025-05-27 12:56:12','2025-05-27 12:57:13','8','2',NULL,'56','65',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"D\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:23:\"seni tari dan manuskrip\";i:181;s:73:\"masyarakatpulaubudayaagamapemerintahtidak terpecah dan tetap menjadi satu\";i:182;s:68:\"karna budaya harus di lestarikankarena itu merupakan keunikan bangsa\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:6:\"bakaba\";i:186;s:20:\"uu no 5 pasal 5 2017\";i:187;s:18:\"asia dan australia\";}',NULL,'0','154,161,165,156,148,152,164,162,159,151,178,179,180,181,182,183,184,185,186,187,166,168,172,171,170,177,175,176,173,174,',NULL,NULL,'0','5','2','0','0','5','3','0','5','5','4','','0','a:5:{i:166;s:4:\"B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"B\";i:171;s:1:\"D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"B, D, A, C\";i:176;s:10:\"A, B, C, D\";i:177;s:10:\"A, D, C, B\";}');
INSERT INTO `nilai` VALUES ('960','17','18','508','ASAG','2025-05-27 12:15:16','2025-05-27 12:52:23','2025-05-27 12:52:34','7','3',NULL,'49','64',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"A\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:25:\"wawasan berarti pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrip\";i:181;s:68:\"persatuan dan kesatuan bangsa indonesia dalam segala aspek kehidupan\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:31:\"udang undang nomor 5 tahun 2017\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','5','2','0','3','5','3','0','2','5','4','','6','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:7:\"A, C, D\";i:171;s:4:\"A, B\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:10:\"A, B, C, D\";i:175;s:10:\"C, B, A, D\";i:176;s:10:\"B, A, C, D\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('961','17','18','526','ASAG','2025-05-27 12:15:18','2025-05-27 12:54:50','2025-05-27 12:55:28','7','3',NULL,'49','51',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"D\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"C\";i:161;s:1:\"B\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:20:\"kebudayaan indonesia\";i:179;s:2:\"38\";i:180;s:0:\"\";i:181;s:47:\"kelengkapan sesama rakyat dan saling melengkapi\";i:182;s:45:\"agar tidak punah budaya yang ada diindonesia \";i:183;s:4:\"aceh\";i:184;s:9:\"indonesia\";i:185;s:8:\"peusijuk\";i:186;s:24:\"undang-undang dasar 1945\";i:187;s:31:\"benua asia dan benua australia \";}',NULL,'0','154,162,151,148,152,156,161,164,165,159,178,179,180,181,182,183,184,185,186,187,170,168,172,171,166,177,176,173,175,174,',NULL,NULL,'0','2','0','0','0','8','5','0','5','2','0','','0','a:5:{i:166;s:1:\"D\";i:168;s:1:\"A\";i:170;s:7:\"A, C, D\";i:171;s:1:\"A\";i:172;s:1:\"A\";}','a:0:{}','a:5:{i:173;s:7:\"A, D, B\";i:174;s:7:\"A, B, C\";i:175;s:4:\"C, B\";i:176;s:10:\"D, C, B, A\";i:177;s:10:\"C, D, B, A\";}');
INSERT INTO `nilai` VALUES ('962','17','18','492','ASAG','2025-05-27 12:15:18','2025-05-27 12:56:10','2025-05-27 12:58:15','4','6',NULL,'28','33',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"C\";i:159;s:1:\"B\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"B\";i:165;s:1:\"A\";}','a:10:{i:178;s:13:\"satu kesatuan\";i:179;s:1:\"3\";i:180;s:48:\"1 mengenal adat istiadat 2 mengenal makanan khas\";i:181;s:42:\"bangsa yang masih bertahan sampai sekarang\";i:182;s:72:\"karena kalau kita tidak melestarikan budaya bisa menjadi asing bagi kita\";i:183;s:4:\"aceh\";i:184;s:4:\"aceh\";i:185;s:18:\"mainan tradisional\";i:186;s:41:\"objek merupakan budaya yang sangat luhur \";i:187;s:28:\"benua asia dan benua selatan\";}',NULL,'0','151,159,162,164,152,148,156,165,161,154,178,186,180,183,182,185,179,187,184,181,170,171,172,168,166,174,173,176,175,177,',NULL,NULL,'0','1','2','0','0','9','3','0','5','1','4','','0','a:5:{i:166;s:4:\"A, D\";i:168;s:4:\"A, B\";i:170;s:4:\"C, D\";i:171;s:4:\"A, D\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"B, A, C, D\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, A, D\";i:176;s:10:\"D, C, A, B\";i:177;s:10:\"B, D, C, A\";}');
INSERT INTO `nilai` VALUES ('963','17','18','509','ASAG','2025-05-27 12:15:18','2025-05-27 12:47:39','2025-05-27 12:49:15','8','2',NULL,'56','69',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"B\";i:156;s:1:\"A\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"B\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:37:\"interaksi budayapesatuan dan kesatuan\";i:181;s:39:\"bangsa persatuan dan kesatuan yang utuh\";i:182;s:16:\"agar tidak pudar\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:25:\"pasal 5 ayat 5 tahun 2017\";i:187;s:15:\"australia india\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,179,180,181,182,183,184,185,186,187,166,168,170,171,172,173,174,175,176,177,',NULL,NULL,'0','5','3','0','1','5','2','0','4','5','6','','2','a:5:{i:166;s:7:\"A, B, D\";i:168;s:4:\"A, B\";i:170;s:1:\"A\";i:171;s:4:\"B, C\";i:172;s:4:\"A, C\";}','a:0:{}','a:5:{i:173;s:10:\"A, D, C, B\";i:174;s:10:\"C, B, A, D\";i:175;s:10:\"C, D, A, B\";i:176;s:10:\"A, B, D, C\";i:177;s:10:\"C, D, A, B\";}');
INSERT INTO `nilai` VALUES ('964','17','18','522','ASAG','2025-05-27 12:15:19','2025-05-27 12:53:19','2025-05-27 12:55:15','5','5',NULL,'35','43',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"A\";i:152;s:1:\"B\";i:154;s:1:\"D\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"D\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:9:\"pandangan\";i:179;s:2:\"38\";i:180;s:27:\"tradisi lisan dan manuskrib\";i:181;s:68:\"persatuan dan kesatuan bangsa indonesia dalam segala aspek kehidupan\";i:182;s:29:\"memperkuat identitas nasional\";i:183;s:4:\"aceh\";i:184;s:4:\"jawa\";i:185;s:5:\"cagok\";i:186;s:32:\"undang undang nomor 5 tahun 2017\";i:187;s:30:\"benua australia dan benua asia\";}',NULL,'0','151,148,152,154,162,164,165,156,159,161,178,179,180,181,182,183,184,185,186,187,172,166,170,171,168,177,175,174,176,173,',NULL,NULL,'0','6','1','0','0','4','4','0','5','6','2','','0','a:5:{i:166;s:7:\"A, B, D\";i:168;s:1:\"A\";i:170;s:1:\"A\";i:171;s:1:\"A\";i:172;s:7:\"A, C, D\";}','a:0:{}','a:5:{i:173;s:10:\"A, C, D, B\";i:174;s:7:\"C, A, B\";i:175;s:7:\"C, B, A\";i:176;s:10:\"C, B, A, D\";i:177;s:10:\"B, C, D, A\";}');
INSERT INTO `nilai` VALUES ('965','17','18','519','ASAG','2025-05-27 12:15:19','2025-05-27 13:00:36','2025-05-27 13:00:42','5','5',NULL,'35','36',NULL,'180.242.31.254','0','a:10:{i:148;s:1:\"C\";i:151;s:1:\"C\";i:152;s:1:\"B\";i:154;s:1:\"C\";i:156;s:1:\"B\";i:159;s:1:\"A\";i:161;s:1:\"A\";i:162;s:1:\"C\";i:164;s:1:\"A\";i:165;s:1:\"B\";}','a:10:{i:178;s:11:\"Tidak Diisi\";i:179;s:2:\"38\";i:180;s:11:\"Tidak Diisi\";i:181;s:21:\"mempertahankan bangsa\";i:182;s:53:\"karena salah satu kewajiban untuk melestarikan budaya\";i:183;s:11:\"Tidak Diisi\";i:184;s:9:\"indonesia\";i:185;s:11:\"Tidak Diisi\";i:186;s:40:\"undang undang nomor 5 tahun 2017 pasal 5\";i:187;s:11:\"Tidak Diisi\";}',NULL,'0','148,151,152,154,156,159,161,162,164,165,178,1